/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Constants;
import de.dal33t.powerfolder.Feature;
import de.dal33t.powerfolder.Housekeeping;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.NetworkingMode;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.PowerFolder;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.RemoteCommandManager;
import de.dal33t.powerfolder.WebClientLogin;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.FolderRepository;
import de.dal33t.powerfolder.disk.SyncProfile;
import de.dal33t.powerfolder.distribution.Distribution;
import de.dal33t.powerfolder.distribution.PowerFolderBasic;
import de.dal33t.powerfolder.distribution.PowerFolderPro;
import de.dal33t.powerfolder.event.InvitationHandler;
import de.dal33t.powerfolder.event.LimitedConnectivityEvent;
import de.dal33t.powerfolder.event.LimitedConnectivityListener;
import de.dal33t.powerfolder.event.ListenerSupportFactory;
import de.dal33t.powerfolder.event.NetworkingModeEvent;
import de.dal33t.powerfolder.event.NetworkingModeListener;
import de.dal33t.powerfolder.event.PausedModeEvent;
import de.dal33t.powerfolder.event.PausedModeListener;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.message.FolderList;
import de.dal33t.powerfolder.message.Invitation;
import de.dal33t.powerfolder.message.SettingsChange;
import de.dal33t.powerfolder.net.BroadcastMananger;
import de.dal33t.powerfolder.net.ConnectionException;
import de.dal33t.powerfolder.net.ConnectionHandler;
import de.dal33t.powerfolder.net.ConnectionListener;
import de.dal33t.powerfolder.net.DynDnsManager;
import de.dal33t.powerfolder.net.HTTPProxySettings;
import de.dal33t.powerfolder.net.IOProvider;
import de.dal33t.powerfolder.net.NodeManager;
import de.dal33t.powerfolder.net.ReconnectManager;
import de.dal33t.powerfolder.plugin.PluginManager;
import de.dal33t.powerfolder.security.SecurityManager;
import de.dal33t.powerfolder.security.SecurityManagerClient;
import de.dal33t.powerfolder.task.PersistentTaskManager;
import de.dal33t.powerfolder.transfer.TransferManager;
import de.dal33t.powerfolder.ui.FileBrowserIntegration;
import de.dal33t.powerfolder.ui.LookAndFeelSupport;
import de.dal33t.powerfolder.ui.UIController;
import de.dal33t.powerfolder.ui.dialog.SyncFolderDialog;
import de.dal33t.powerfolder.ui.dialog.UIUnLockDialog;
import de.dal33t.powerfolder.ui.model.ApplicationModel;
import de.dal33t.powerfolder.ui.notices.Notice;
import de.dal33t.powerfolder.ui.util.LimitedConnectivityChecker;
import de.dal33t.powerfolder.util.AntiSerializationVulnerability;
import de.dal33t.powerfolder.util.ByteSerializer;
import de.dal33t.powerfolder.util.ConfigurationLoader;
import de.dal33t.powerfolder.util.Debug;
import de.dal33t.powerfolder.util.ForcedLanguageFileResourceBundle;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.JavaVersion;
import de.dal33t.powerfolder.util.LoginUtil;
import de.dal33t.powerfolder.util.NamedThreadFactory;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.ProUtil;
import de.dal33t.powerfolder.util.Profiling;
import de.dal33t.powerfolder.util.PropertiesUtil;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.SplitConfig;
import de.dal33t.powerfolder.util.StackDump;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.Waiter;
import de.dal33t.powerfolder.util.WrappedScheduledThreadPoolExecutor;
import de.dal33t.powerfolder.util.logging.LoggingManager;
import de.dal33t.powerfolder.util.net.NetworkUtil;
import de.dal33t.powerfolder.util.os.OSUtil;
import de.dal33t.powerfolder.util.os.SystemUtil;
import de.dal33t.powerfolder.util.os.Win32.WinUtils;
import de.dal33t.powerfolder.util.os.mac.MacUtils;
import de.dal33t.powerfolder.util.update.UpdateSetting;
import java.awt.Desktop;
import java.awt.GraphicsEnvironment;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.Security;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.StringTokenizer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.commons.cli.CommandLine;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class Controller
extends PFComponent {
    private static final Logger log = Logger.getLogger(Controller.class.getName());
    private static final int MAJOR_VERSION = 23;
    private static final int MINOR_VERSION = 4;
    private static final int REVISION_VERSION = 100;
    private static final int SPRINT_NUMBER = 62;
    public static final String PROGRAM_VERSION = "23.4.100";
    public static final String FEDERATION_VERSION = "23.4";
    public static final String INCREMENT_VERSION = "23.4.100.62";
    private static String miscFilesLocationDirName = Constants.MISC_DIR_NAME;
    private CommandLine commandLine;
    private String configFilename;
    private Path configFile;
    private Path configFolderFile;
    private Path sslTrustStoreFile;
    private SplitConfig config;
    private Preferences preferences;
    private Distribution distribution;
    private Date startTime;
    private volatile boolean started;
    private volatile boolean shuttingDown;
    private boolean restartRequested;
    private boolean verbose;
    private boolean debugReports;
    private volatile boolean paused;
    private NetworkingMode networkingMode;
    private NodeManager nodeManager;
    private ReconnectManager reconnectManager;
    private FolderRepository folderRepository;
    private ConnectionListener connectionListener;
    private IOProvider ioProvider;
    private FileBrowserIntegration fbIntegration;
    private List<ConnectionListener> additionalConnectionListeners;
    private final List<InvitationHandler> invitationHandlers;
    private BroadcastMananger broadcastManager;
    private DynDnsManager dyndnsManager;
    private PersistentTaskManager taskManager;
    private Callable<TransferManager> transferManagerFactory = new Callable<TransferManager>(){

        @Override
        public TransferManager call() {
            return new TransferManager(Controller.this);
        }
    };
    private TransferManager transferManager;
    private RemoteCommandManager rconManager;
    private WebClientLogin webClientLogin;
    private UIController uiController;
    private PluginManager pluginManager;
    private SecurityManager securityManager;
    private ServerClient osClient;
    private ScheduledExecutorService threadPool;
    private final boolean portWasOpened = false;
    private boolean limitedConnectivity;
    private final PausedModeListener pausedModeListenerSupport;
    private final NetworkingModeListener networkingModeListenerSupport;
    private final LimitedConnectivityListener limitedConnectivityListenerSupport;
    private ScheduledFuture<?> pauseResumeFuture;

    public Controller() {
        Security.setProperty("networkaddress.cache.ttl", "0");
        Security.setProperty("networkaddress.cache.negative.ttl", "0");
        System.setProperty("sun.net.inetaddr.ttl", "0");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "PowerFolder");
        System.setProperty("illegal-access", "deny");
        OSUtil.configureTruststore();
        this.invitationHandlers = new CopyOnWriteArrayList<InvitationHandler>();
        this.pausedModeListenerSupport = ListenerSupportFactory.createListenerSupport(PausedModeListener.class);
        this.networkingModeListenerSupport = ListenerSupportFactory.createListenerSupport(NetworkingModeListener.class);
        this.limitedConnectivityListenerSupport = ListenerSupportFactory.createListenerSupport(LimitedConnectivityListener.class);
        AntiSerializationVulnerability.checkClasspath();
    }

    @Override
    public Controller getController() {
        return this;
    }

    public static Controller createController() {
        return new Controller();
    }

    public void startDefaultConfig() {
        this.startConfig(Constants.DEFAULT_CONFIG_FILE);
    }

    void startConfig(CommandLine commandLine) {
        String string;
        Object object;
        this.commandLine = commandLine;
        Object object2 = Constants.DEFAULT_CONFIG_FILE;
        if (((String)object2).contains(".config")) {
            object2 = ((String)object2).replace(".config", "");
        }
        if (commandLine.hasOption("c") && StringUtils.isNotBlank((String)(object = commandLine.getOptionValue("c")))) {
            object2 = object;
        }
        object = null;
        try {
            object = ConfigurationLoader.loadPreConfigFromClasspath("Default.config");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string2 = string = object != null && ((Properties)object).containsKey("dist.name") ? ((Properties)object).getProperty("dist.name") : "";
        if (StringUtils.isNotBlank(string)) {
            boolean bl;
            boolean bl2 = bl = !string.contains("PowerFolder Server");
            if (bl) {
                miscFilesLocationDirName = string.trim();
                this.migrateConfigFileIfNecessary((String)object2);
            }
        }
        this.startConfig((String)object2);
    }

    private void migrateConfigFileIfNecessary(String string) {
        Object object;
        Path path = Controller.getMiscFilesLocation(false);
        Path path2 = path.resolve(string + ".config");
        if (Files.exists(path2, new LinkOption[0])) {
            log.fine("Using my configuration at " + path2.toString());
            return;
        }
        log.fine("No existing configuration found");
        Object object2 = "";
        object2 = OSUtil.isWindowsSystem() ? Constants.MISC_DIR_NAME : "." + Constants.MISC_DIR_NAME;
        Path path3 = path.getParent().resolve((String)object2);
        Path path4 = path3.resolve(string + ".config");
        if (Files.notExists(path4, new LinkOption[0])) {
            log.fine("Also no previous configuration found-> Creating new configuration");
            return;
        }
        log.fine("Found previous configuration at " + path4.toString());
        Properties properties = new Properties();
        try {
            object = Files.newInputStream(path4, new OpenOption[0]);
            try {
                properties.load((InputStream)object);
            }
            finally {
                if (object != null) {
                    ((InputStream)object).close();
                }
            }
        }
        catch (IOException iOException) {
            log.warning("Could not read " + path4.toString() + ". Creating new configuration at " + path2.toString() + ". " + iOException.getMessage());
            return;
        }
        object = properties.getProperty("dist.name");
        if (StringUtils.isBlank((String)object) || !((String)object).equalsIgnoreCase(miscFilesLocationDirName)) {
            log.fine("Not moving an empty or different branding " + (String)object + " than mine " + miscFilesLocationDirName);
            return;
        }
        log.info("Trying to move " + path4.toString() + " to " + path2.toString());
        try {
            Files.move(path4, path2, new CopyOption[0]);
        }
        catch (IOException iOException) {
            log.warning("Could not move " + path4.toString() + " to " + path2.toString() + ". " + iOException.getMessage());
        }
    }

    public void initTranslation() {
        if (this.commandLine != null && this.commandLine.hasOption("f")) {
            String string = this.commandLine.getOptionValue("f");
            try {
                ForcedLanguageFileResourceBundle forcedLanguageFileResourceBundle = new ForcedLanguageFileResourceBundle(string);
                Translation.setResourceBundle(forcedLanguageFileResourceBundle);
                this.logInfo("Loading language bundle from file " + string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.logSevere("forced language file (" + string + ") not found: " + fileNotFoundException.getMessage());
                this.logSevere("using setup language");
                Translation.resetResourceBundle();
            }
            catch (IOException iOException) {
                this.logSevere("forced language file io error: " + iOException.getMessage());
                this.logSevere("using setup language");
                Translation.resetResourceBundle();
            }
        } else {
            Translation.resetResourceBundle();
        }
        Translation.getResourceBundle();
    }

    public void startConfig(String string) {
        if (this.started) {
            throw new IllegalStateException("Configuration already started, shutdown controller first");
        }
        this.initTranslation();
        if (!this.loadConfigFile(string)) {
            return;
        }
        this.start();
    }

    public void start() {
        InetSocketAddress inetSocketAddress;
        Object object;
        this.preferences = Preferences.userNodeForPackage(PowerFolder.class);
        if (!miscFilesLocationDirName.equals(Constants.MISC_DIR_NAME)) {
            this.preferences = this.preferences.node(miscFilesLocationDirName.toLowerCase());
        }
        if (!Constants.DEFAULT_CONFIG_FILE.startsWith(this.getConfigName())) {
            this.preferences = this.preferences.node(this.getConfigName().toLowerCase());
        }
        if (ConfigurationEntry.SECURITY_SSL_TRUST_ANY.getValueBoolean(this.getController()).booleanValue()) {
            NetworkUtil.installAllTrustingSSLManager();
        }
        this.verbose = ConfigurationEntry.VERBOSE.getValueBoolean(this);
        this.initLogger();
        if (ConfigurationEntry.PROFILING.getValueBoolean(this).booleanValue()) {
            ByteSerializer.BENCHMARK = true;
            this.scheduleAndRepeat(() -> ByteSerializer.printStats(), 600000L, 600000L);
            Profiling.setEnabled(true);
            Profiling.reset();
            this.scheduleAndRepeat(() -> this.logInfo(Profiling.dumpStats()), 60000L, 3600000L);
        }
        String string = OSUtil.is64BitPlatform() ? "64bit" : "32bit";
        this.logInfo("OS: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + string + ")");
        this.logInfo("Java: " + JavaVersion.systemVersion().toString() + " (" + System.getProperty("java.vendor") + ")");
        this.logInfo("Current time: " + new Date());
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.maxMemory();
        long l2 = runtime.totalMemory();
        this.logInfo("Max Memory: " + Format.formatBytesShort(l) + ", Total Memory: " + Format.formatBytesShort(l2));
        if (this.isUIEnabled()) {
            LookAndFeelSupport.setSyntheticaLicense();
            if (!Desktop.isDesktopSupported()) {
                this.logWarning("Desktop utility not supported");
            }
        }
        this.clearPreferencesOnConfigSwitch();
        HTTPProxySettings.loadFromConfig(this);
        boolean bl = false;
        if (ConfigurationEntry.SECURITY_SSL_TRUST_ANY.getValueBoolean(this.getController()).booleanValue()) {
            bl = true;
            NetworkUtil.installAllTrustingSSLManager();
        }
        ConfigurationLoader.loadAndMergeCLI(this);
        ConfigurationLoader.loadAndMergeConfigURL(this);
        ConfigurationLoader.loadAndMergePList(this);
        ConfigurationLoader.loadAndMergeFromInstaller(this);
        if (this.verbose != ConfigurationEntry.VERBOSE.getValueBoolean(this)) {
            this.verbose = ConfigurationEntry.VERBOSE.getValueBoolean(this);
            this.initLogger();
        }
        if (ConfigurationEntry.SECURITY_SSL_TRUST_ANY.getValueBoolean(this.getController()).booleanValue()) {
            NetworkUtil.installAllTrustingSSLManager();
        } else if (bl) {
            this.logWarning("Security break protection: Trust any SSL certificate was turned on, but is disallowed by server profile. Please restart the client");
            this.exit(66);
        }
        int n = ConfigurationEntry.PAUSE_RESUME_SECONDS.getValueInt(this.getController());
        this.paused = PreferencesEntry.PAUSED.getValueBoolean(this) != false && (n == Integer.MAX_VALUE || n == 0);
        PreferencesEntry.PAUSED.setValue(this, this.paused);
        HTTPProxySettings.loadFromConfig(this);
        this.initDistribution();
        this.logFine("Build time: " + this.getBuildTime());
        this.logInfo("Program version 23.4.100.62");
        if (this.getDistribution().getBinaryName().toLowerCase().contains("powerfolder")) {
            Debug.writeSystemProperties();
        }
        if (ConfigurationEntry.KILL_RUNNING_INSTANCE.getValueBoolean(this).booleanValue()) {
            this.killRunningInstance();
        }
        FolderList.removeMemberFiles(this);
        this.setupProPlugins();
        this.pluginManager = new PluginManager(this);
        this.pluginManager.init();
        this.nodeManager = new NodeManager(this);
        this.taskManager = new PersistentTaskManager(this);
        this.folderRepository = new FolderRepository(this);
        this.setLoadingCompletion(0, 10);
        try {
            this.transferManager = this.transferManagerFactory.call();
        }
        catch (Exception exception) {
            this.logSevere("Exception", exception);
        }
        this.reconnectManager = new ReconnectManager(this);
        this.osClient = new ServerClient(this);
        if (this.isUIEnabled()) {
            this.uiController = new UIController(this);
            if (ConfigurationEntry.USER_INTERFACE_LOCKED.getValueBoolean(this).booleanValue() && !ConfigurationEntry.SERVER_IDP_DISCO_FEED_URL.hasValue(this)) {
                new UIUnLockDialog(this).openAndWait();
            }
        }
        this.setLoadingCompletion(10, 20);
        this.ioProvider = new IOProvider(this);
        this.ioProvider.start();
        if (this.commandLine != null && this.commandLine.hasOption('d') && StringUtils.isNotBlank((String)(object = this.commandLine.getOptionValue("d"))) && (inetSocketAddress = Util.parseConnectionString((String)object)) != null) {
            ConfigurationEntry.HOSTNAME.setValue(this, inetSocketAddress.getHostName());
            ConfigurationEntry.NET_PORT.setValue(this, inetSocketAddress.getPort());
        }
        this.dyndnsManager = new DynDnsManager(this);
        this.setLoadingCompletion(20, 30);
        if (!this.initializeListenerOnLocalPort()) {
            return;
        }
        if (!this.isUIEnabled()) {
            this.paused = false;
        }
        this.setLoadingCompletion(30, 35);
        this.nodeManager.init();
        if (!ProUtil.isRunningProVersion()) {
            this.nodeManager.start();
        }
        this.setLoadingCompletion(35, 60);
        this.securityManager = new SecurityManagerClient(this, this.osClient);
        this.folderRepository.init();
        this.logInfo("Dataitems: " + Debug.countDataitems(this));
        this.setLoadingCompletion(60, 65);
        this.folderRepository.start();
        this.setLoadingCompletion(65, 70);
        this.transferManager.start();
        this.setLoadingCompletion(70, 75);
        this.startRConManager();
        this.startWebClientLogin();
        this.setLoadingCompletion(75, 80);
        this.startConfiguredListener();
        this.setLoadingCompletion(80, 85);
        if (ConfigurationEntry.NET_BROADCAST.getValueBoolean(this).booleanValue()) {
            this.openBroadcastManager();
        } else {
            this.logInfo("Auto client discovery in LAN via broadcast disabled");
        }
        this.setLoadingCompletion(85, 90);
        this.started = true;
        this.startTime = new Date();
        this.taskManager.start();
        this.logInfo("Controller started");
        this.dyndnsManager.updateIfNessesary();
        this.setLoadingCompletion(90, 100);
        if (Feature.OS_CLIENT.isEnabled()) {
            try {
                this.osClient.loginWithLastKnown();
            }
            catch (Exception exception) {
                this.logWarning("Unable to login with last known username. " + exception);
                this.logFiner(exception);
            }
        }
        this.pluginManager.start();
        if (this.isConsoleMode()) {
            this.logFine("Running in console");
        } else {
            this.logFine("Opening UI");
            this.openUI();
        }
        if (!this.getMySelf().isServer() && Feature.FILEBROWSER_INTEGRATION.isEnabled() && this.isUIEnabled()) {
            this.enableFileBrowserIntegration();
        }
        this.loadPersistentObjects();
        this.setLoadingCompletion(100, 100);
        if (!this.isConsoleMode()) {
            this.uiController.hideSplash();
        }
        if (ConfigurationEntry.AUTO_CONNECT.getValueBoolean(this).booleanValue()) {
            this.reconnectManager.start();
        } else {
            this.logFine("Not starting reconnection process. Config auto.connect set to false");
        }
        if (Feature.OS_CLIENT.isEnabled() && ConfigurationEntry.SERVER_CONNECT.getValueBoolean(this).booleanValue()) {
            this.osClient.start();
        } else {
            this.logInfo("Not connecting to server (" + this.osClient.getServerString() + "): Disabled");
        }
        this.setupPeriodicalTasks();
        if (MacUtils.isSupported() && !this.getMySelf().isServer() && (object = MacUtils.getInstance()) != null) {
            if (this.isFirstStart()) {
                ((MacUtils)object).setPFStartup(true, this);
            }
            ((MacUtils)object).setAppReOpenedListener(this);
        }
        if (n == 0) {
            this.setPaused(this.paused);
        }
    }

    private void enableFileBrowserIntegration() {
        try {
            this.fbIntegration = new FileBrowserIntegration(this.getController());
            this.fbIntegration.start();
        }
        catch (Throwable throwable) {
            this.logWarning("Unable to start filebrowser integration: " + throwable, throwable);
        }
    }

    private void clearPreferencesOnConfigSwitch() {
        String string = PreferencesEntry.LAST_NODE_ID.getValueString(this);
        String string2 = ConfigurationEntry.NODE_ID.getValue(this);
        try {
            if (StringUtils.isNotBlank(string) && !LoginUtil.matches(Util.toCharArray(string2), string)) {
                int n = 0;
                for (String string3 : this.preferences.keys()) {
                    this.preferences.remove(string3);
                    ++n;
                }
                this.logInfo("Cleared " + n + " preferences, new config/nodeid found");
            }
        }
        catch (BackingStoreException backingStoreException) {
            this.logWarning("Unable to clear preferences. " + backingStoreException);
        }
    }

    public void performFullSync() {
        this.folderRepository.broadcastScanCommandOnAllFolders();
        Collection<Folder> collection = this.folderRepository.getFolders();
        for (Folder folder : collection) {
            if (Util.isAwtAvailable() && folder.getSyncProfile().equals(SyncProfile.MANUAL_SYNCHRONIZATION)) {
                new SyncFolderDialog(this, folder).open();
                continue;
            }
            folder.recommendScanOnNextMaintenance();
        }
        this.setPaused(false);
        this.folderRepository.triggerMaintenance();
        this.folderRepository.getFileRequestor().triggerFileRequesting();
        this.reconnectManager.buildReconnectionQueue();
    }

    public void addInvitationHandler(InvitationHandler invitationHandler) {
        this.invitationHandlers.add(invitationHandler);
    }

    public void removeInvitationHandler(InvitationHandler invitationHandler) {
        this.invitationHandlers.remove(invitationHandler);
    }

    private void setupProPlugins() {
        boolean bl;
        String string = ConfigurationEntry.PLUGINS.getValue(this);
        boolean bl2 = bl = StringUtils.isEmpty(string) || !string.contains("CD");
        if (ProUtil.isRunningProVersion() && bl) {
            this.logFine("Setting up pro loader");
            Object object = "CD";
            if (!StringUtils.isBlank(string)) {
                object = (String)object + "," + string;
            }
            ConfigurationEntry.PLUGINS.setValue(this, (String)object);
        }
    }

    private void initLogger() {
        Level level;
        String string;
        String string2 = this.getConfigName();
        if (string2 != null) {
            LoggingManager.setPrefix(string2);
        }
        if (this.verbose) {
            Level level2;
            string = ConfigurationEntry.LOG_LEVEL_CONSOLE.getValue(this);
            level = LoggingManager.levelForName(string);
            LoggingManager.setConsoleLogging(level != null ? level : Level.WARNING);
            string = ConfigurationEntry.LOG_LEVEL_FILE.getValue(this);
            boolean bl = ConfigurationEntry.LOG_FILE_ROTATE.getValueBoolean(this);
            Level level3 = LoggingManager.levelForName(string);
            LoggingManager.setFileLogging(level3 != null ? level3 : Level.FINE, bl);
            if (this.isUIEnabled()) {
                string = PreferencesEntry.DOCUMENT_LOGGING.getValueString(this);
                level2 = LoggingManager.levelForName(string);
                LoggingManager.setDocumentLogging(level2 != null ? level2 : Level.WARNING, this);
            }
            if (LoggingManager.isLogToFile()) {
                this.logFine("Logging to file '" + LoggingManager.getLoggingFileName() + "'");
            } else {
                this.logInfo("No logging to file");
            }
            if (ConfigurationEntry.LOG_SYSLOG_HOST.hasNonBlankValue(this)) {
                string = ConfigurationEntry.LOG_LEVEL_SYSLOG.getValue(this);
                level2 = LoggingManager.levelForName(string);
                LoggingManager.setSyslogLogging(level2 != null ? level2 : Level.WARNING, this);
            }
        }
        if (this.commandLine != null && this.commandLine.hasOption('l') && (level = LoggingManager.levelForName(string = this.commandLine.getOptionValue('l'))) != null) {
            LoggingManager.setConsoleLogging(level);
        }
        this.debugReports = ConfigurationEntry.DEBUG_REPORTS.getValueBoolean(this);
        LoggingManager.clearBuffer();
        int n = ConfigurationEntry.LOG_FILE_DELETE_DAYS.getValueInt(this.getController());
        if (n >= 0) {
            LoggingManager.removeOldLogs(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadConfigFile(String string) {
        this.additionalConnectionListeners = Collections.synchronizedList(new ArrayList());
        this.started = false;
        this.shuttingDown = false;
        this.threadPool = new WrappedScheduledThreadPoolExecutor(Constants.CONTROLLER_MIN_THREADS_IN_THREADPOOL, new NamedThreadFactory("Controller-Thread-"));
        PathUtils.setIOExceptionListener(exception -> {
            if (exception instanceof FileSystemException && exception.toString().toLowerCase().contains("too many open files")) {
                this.logSevere("Detected I/O Exception: " + exception.getMessage());
                this.logSevere("Please adjust limits for open file handles on this server");
                this.exit(1);
            }
        });
        Object object = string;
        if (object == null) {
            object = Constants.DEFAULT_CONFIG_FILE;
        }
        if (((String)object).indexOf(46) < 0) {
            object = (String)object + ".config";
        }
        this.configFilename = null;
        this.config = new SplitConfig();
        this.configFilename = object;
        this.configFile = this.getConfigLocationBase();
        this.configFile = this.configFile == null ? Paths.get((String)object, new String[0]).toAbsolutePath() : this.configFile.resolve((String)object);
        BufferedInputStream bufferedInputStream = null;
        try {
            if (!Files.exists(this.configFile, new LinkOption[0])) {
                this.logFine("Config file does not exist. " + this.configFile.toString());
                throw new FileNotFoundException();
            }
            this.logFine("Loading configfile " + this.configFile.toString());
            if (OSUtil.isWebStart()) {
                this.logFine("WebStart, config file location: " + this.configFile.toString());
            }
            bufferedInputStream = new BufferedInputStream(Files.newInputStream(this.configFile, new OpenOption[0]));
            this.config.load(bufferedInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logWarning("Unable to start config, file '" + (String)object + "' not found, using defaults");
        }
        catch (IOException iOException) {
            this.logSevere("Unable to start config from file '" + (String)object + "'");
            this.config = null;
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (Exception exception2) {}
        }
        String string2 = ((String)object).replace(".config", "-Folder.config");
        this.configFolderFile = this.getConfigLocationBase();
        this.configFolderFile = this.configFolderFile == null ? Paths.get(string2, new String[0]).toAbsolutePath() : this.configFolderFile.resolve(string2);
        String string3 = ((String)object).replace(".config", ".ssl.jks");
        this.sslTrustStoreFile = this.getConfigLocationBase();
        this.sslTrustStoreFile = this.sslTrustStoreFile == null ? Paths.get(string3, new String[0]).toAbsolutePath() : this.sslTrustStoreFile.resolve(string3);
        if (Files.exists(this.configFolderFile, new LinkOption[0])) {
            try {
                this.logInfo("Loading folder configfile " + this.configFolderFile.toString());
                bufferedInputStream = new BufferedInputStream(Files.newInputStream(this.configFolderFile, new OpenOption[0]));
                this.config.load(bufferedInputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.logWarning("Unable to start config, file '" + string2 + "' not found, using defaults");
            }
            catch (IOException iOException) {
                this.logSevere("Unable to start config from file '" + string2 + "'");
                this.configFolderFile = null;
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (bufferedInputStream != null) {
                        bufferedInputStream.close();
                    }
                }
                catch (Exception exception3) {}
            }
        } else {
            this.logFine("Folder config file does not exist. " + this.configFolderFile.toString());
        }
        return true;
    }

    public void reloadConfigFile() {
        if (!Files.exists(this.configFile, new LinkOption[0])) {
            this.logWarning("Config file does not exist. " + this.configFile.toString());
            return;
        }
        this.logInfo("Reloading configfile " + this.configFile.toString());
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(Files.newInputStream(this.configFile, new OpenOption[0]));){
            this.config.load(bufferedInputStream);
        }
        catch (IOException iOException) {
            this.logWarning("Unable to reload config file " + this.configFile + ". " + iOException);
        }
    }

    public ScheduledFuture<?> scheduleAndRepeat(Runnable runnable, long l) {
        if (!this.shuttingDown && !this.threadPool.isShutdown()) {
            return this.threadPool.scheduleWithFixedDelay(runnable, 0L, l, TimeUnit.MILLISECONDS);
        }
        return null;
    }

    public ScheduledFuture<?> scheduleAndRepeat(Runnable runnable, long l, long l2) {
        if (!this.shuttingDown && !this.threadPool.isShutdown()) {
            return this.threadPool.scheduleWithFixedDelay(runnable, l, l2, TimeUnit.MILLISECONDS);
        }
        return null;
    }

    public ScheduledFuture<?> schedule(Runnable runnable, long l) {
        if (!this.shuttingDown && !this.threadPool.isShutdown()) {
            return this.threadPool.schedule(runnable, l, TimeUnit.MILLISECONDS);
        }
        return null;
    }

    public void removeScheduled(Runnable runnable) {
        if (!this.shuttingDown && !this.threadPool.isShutdown()) {
            if (this.threadPool instanceof ScheduledThreadPoolExecutor) {
                ((ScheduledThreadPoolExecutor)this.threadPool).remove(runnable);
                ((ScheduledThreadPoolExecutor)this.threadPool).purge();
            } else {
                this.logSevere("Unable to remove scheduled task. Wrong threadpool. " + runnable);
            }
        }
    }

    public boolean removeScheduled(ScheduledFuture<?> scheduledFuture) {
        if (!this.shuttingDown && !this.threadPool.isShutdown()) {
            if (this.threadPool instanceof ScheduledThreadPoolExecutor) {
                return ((ScheduledThreadPoolExecutor)this.threadPool).remove((Runnable)((Object)scheduledFuture));
            }
            this.logSevere("Unable to remove scheduled task. Wrong threadpool. " + scheduledFuture);
        }
        return false;
    }

    private void setupPeriodicalTasks() {
        LimitedConnectivityChecker.install(this);
        JobDetail jobDetail = JobBuilder.newJob(Housekeeping.class).withIdentity("midnight", "housekeeping").build();
        CronTrigger cronTrigger = TriggerBuilder.newTrigger().withIdentity("trigger", "housekeeping").forJob(jobDetail).withSchedule(CronScheduleBuilder.dailyAtHourAndMinute(0, 0)).build();
        try {
            Scheduler scheduler = new StdSchedulerFactory().getScheduler();
            scheduler.scheduleJob(jobDetail, cronTrigger);
            scheduler.getContext().put("controller", (Object)this);
            scheduler.start();
        }
        catch (SchedulerException schedulerException) {
            this.logFine("Could not initiate housekeeping: " + schedulerException.getMessage());
        }
        this.threadPool.schedule(() -> this.performHousekeeping(false), 1L, TimeUnit.MINUTES);
        if (Profiling.ENABLED) {
            this.threadPool.scheduleWithFixedDelay(new TimerTask(){

                @Override
                public void run() {
                    Controller.this.logFine(Profiling.dumpStats());
                }
            }, 1L, 10L, TimeUnit.MINUTES);
        }
        boolean bl = ConfigurationEntry.TRANSFER_LIMIT_AUTODETECT.getValueBoolean(this) != false && ConfigurationEntry.UPLOAD_LIMIT_WAN.getValueInt(this) > 0;
        long l = bl ? 600L : 5L;
        this.threadPool.scheduleWithFixedDelay(new TimerTask(){

            @Override
            public void run() {
                Controller.this.performHourly();
            }
        }, l, 3600L, TimeUnit.SECONDS);
        this.threadPool.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                String string;
                if (!Controller.this.verbose) {
                    return;
                }
                if (Controller.this.isFine()) {
                    Controller.this.logFine("Dataitems: " + Debug.countDataitems(Controller.this));
                }
                if (StringUtils.isNotBlank(string = Debug.dumpCurrentStacktraces(false)) && Controller.this.isFine() && ConfigurationEntry.LOG_ACTIVE_THREADS.getValueBoolean(Controller.this.getController()).booleanValue()) {
                    Controller.this.logFine("Active threads:\n\n" + string);
                } else {
                    Controller.this.logFine("No active threads");
                }
            }
        }, 1L, 5L, TimeUnit.MINUTES);
    }

    private void performHourly() {
        if (ConfigurationEntry.TRANSFER_LIMIT_AUTODETECT.getValueBoolean(this).booleanValue()) {
            FutureTask<Object> futureTask = this.transferManager.getRecalculateAutomaticRate();
            this.threadPool.execute(futureTask);
        }
    }

    public void openBroadcastManager() {
        Reject.ifFalse(this.broadcastManager == null, "Broadcast manager already open");
        try {
            this.broadcastManager = new BroadcastMananger(this, ConfigurationEntry.NET_PORT_D2D.getValueInt(this) > 0);
            this.broadcastManager.start();
        }
        catch (ConnectionException connectionException) {
            this.logWarning("Unable to open broadcast manager, you wont automatically connect to clients on LAN: " + connectionException.getMessage());
        }
    }

    void performHousekeeping(boolean bl) {
        log.fine("Performing housekeeping " + bl);
        if (bl) {
            Date date = new Date();
            this.logFine("Reconfiguring logs for new day: " + date);
            this.initLogger();
            LoggingManager.resetFileLogging();
            int n = ConfigurationEntry.LOG_FILE_DELETE_DAYS.getValueInt(this.getController());
            if (n >= 0) {
                LoggingManager.removeOldLogs(n);
            }
            this.logFine("Reconfigured logs for new day: " + date);
            this.backupConfigAssets();
            this.folderRepository.cleanupOldFiles();
        }
        this.transferManager.pruneStats();
    }

    private void backupConfigAssets() {
        Path path;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd");
        Path path2 = Controller.getMiscFilesLocation().resolve("backups/" + simpleDateFormat.format(new Date()));
        if (Files.notExists(path2, new LinkOption[0])) {
            try {
                Files.createDirectories(path2, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                this.logInfo("Could not create directory '" + path2.toAbsolutePath().toString() + "'");
            }
        }
        Path path3 = path2.resolve(this.configFile.getFileName());
        try {
            PathUtils.copyFile(this.configFile, path3);
        }
        catch (IOException iOException) {
            this.logWarning("Unable to backup file " + this.configFile + ". " + iOException);
        }
        if (Files.exists(this.configFolderFile, new LinkOption[0])) {
            path = path2.resolve(this.configFolderFile.getFileName());
            try {
                PathUtils.copyFile(this.configFolderFile, path);
            }
            catch (IOException iOException) {
                this.logWarning("Unable to backup file " + this.configFolderFile + ". " + iOException);
            }
        }
        path = Controller.getMiscFilesLocation().resolve(this.getConfigName() + ".mykey");
        Path path4 = path2.resolve(path.getFileName());
        if (Files.exists(path, new LinkOption[0])) {
            try {
                PathUtils.copyFile(path, path4);
            }
            catch (IOException iOException) {
                this.logWarning("Unable to backup file " + path + ". " + iOException);
            }
        }
        Path path5 = Controller.getMiscFilesLocation().resolve("Accounts.h2.db");
        Path path6 = path2.resolve(path5.getFileName());
        if (Files.exists(path5, new LinkOption[0])) {
            try {
                PathUtils.copyFile(path5, path6);
            }
            catch (IOException iOException) {
                this.logWarning("Unable to backup file " + path5 + ". " + iOException);
            }
        }
    }

    public RemoteCommandManager getRconManager() {
        return this.rconManager;
    }

    private void startRConManager() {
        if (RemoteCommandManager.hasRunningInstance()) {
            this.alreadyRunningCheck();
        }
        if (!ConfigurationEntry.NET_RCON_MANAGER.getValueBoolean(this).booleanValue()) {
            this.logWarning("Not starting RemoteCommandManager");
            return;
        }
        this.rconManager = new RemoteCommandManager(this);
        this.rconManager.start();
    }

    private void startWebClientLogin() {
        if (WebClientLogin.hasRunningInstance()) {
            this.alreadyRunningCheck();
        }
        if (ConfigurationEntry.WEB_CLIENT_PORT.hasNonBlankValue(this) && ConfigurationEntry.WEB_CLIENT_PORT.getValueInt(this) > 0) {
            this.webClientLogin = new WebClientLogin(this);
            this.webClientLogin.start();
        }
    }

    private boolean initializeListenerOnLocalPort() {
        if (ConfigurationEntry.NET_BIND_RANDOM_PORT.getValueBoolean(this).booleanValue()) {
            this.bindRandomPort();
        } else {
            String string = ConfigurationEntry.NET_PORT.getValue(this);
            if ("0".equals(string)) {
                this.logWarning("Not opening connection listener. (port=0)");
            } else {
                if (string == null) {
                    string = String.valueOf(1337);
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreElements()) {
                    String string2 = stringTokenizer.nextToken();
                    try {
                        int n = Integer.parseInt(string2);
                        for (String string3 : ConfigurationEntry.NET_BIND_ADDRESS.getValueArray(this)) {
                            boolean bl = this.openListener(string3, n, false);
                            if (bl && this.connectionListener != null) {
                                this.nodeManager.getMySelf().getInfo().setConnectAddress(this.connectionListener.getAddress());
                            }
                            if (bl || this.isUIOpen()) continue;
                            this.logSevere("Couldn't bind to port " + n);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.logFine("Unable to read listener port ('" + string2 + "') from config");
                    }
                }
                if (this.connectionListener == null) {
                    this.portBindFailureProblem(string);
                }
            }
        }
        return true;
    }

    public void initializeListenerOnLocalPortD2D() {
        int n = ConfigurationEntry.NET_PORT_D2D.getValueInt(this);
        if (n <= 0) {
            return;
        }
        for (String string : ConfigurationEntry.NET_BIND_ADDRESS.getValueArray(this)) {
            boolean bl = this.openListener(string, n, true);
            if (!bl) {
                this.logSevere("Couldn't bind to iOS port " + n);
                continue;
            }
            this.logInfo("Listening for iOS on port " + n);
            this.nodeManager.getMySelf().getInfo().setD2dPort(n);
        }
        for (ConnectionListener connectionListener : this.additionalConnectionListeners) {
            if (!connectionListener.useD2D) continue;
            try {
                connectionListener.start();
            }
            catch (ConnectionException connectionException) {
                this.logSevere("Problems starting listener " + connectionListener, connectionException);
            }
        }
    }

    public void initializeListenerOnLoopbackInterfaceD2D() {
        this.logFine("D2D is enabled on loopback interface");
        String string = NetworkUtil.LOOPBACK_LOCALHOST_IPv4;
        int n = 0;
        boolean bl = this.openListener(string, n, true);
        if (!bl) {
            this.logSevere("Couldn't bind to D2D port " + n);
        }
        for (ConnectionListener connectionListener : this.additionalConnectionListeners) {
            if (!connectionListener.useD2D) continue;
            try {
                connectionListener.start();
                this.logFine("Listening for iOS on port " + connectionListener.getLocalAddress().getPort());
            }
            catch (ConnectionException connectionException) {
                this.logSevere("Problems starting listener " + connectionListener, connectionException);
            }
        }
    }

    private void portBindFailureProblem(String string) {
        if (!this.isUIEnabled()) {
            this.logSevere("Unable to open incoming port from the portlist: " + string);
            this.exit(1);
            return;
        }
        int n = JOptionPane.showOptionDialog(null, Translation.get("dialog.bind_error.option.text"), Translation.get("dialog.bind_error.option.title"), 0, 2, null, new String[]{Translation.get("dialog.bind_error.option.ignore"), Translation.get("dialog.bind_error.option.exit")}, 0);
        switch (n) {
            case 1: {
                this.exit(0);
                break;
            }
            default: {
                this.bindRandomPort();
            }
        }
    }

    private void bindRandomPort() {
        for (String string : ConfigurationEntry.NET_BIND_ADDRESS.getValueArray(this)) {
            if ((this.openListener(string, 1337, false) || this.openListener(string, 0, false)) && this.connectionListener != null) {
                this.nodeManager.getMySelf().getInfo().setConnectAddress(this.connectionListener.getAddress());
                continue;
            }
            this.logSevere("failed to open random port!!!");
            this.fatalStartError(Translation.get("dialog.bind_error"));
        }
    }

    private void startConfiguredListener() {
        if (this.connectionListener != null) {
            try {
                this.connectionListener.start();
            }
            catch (ConnectionException connectionException) {
                this.logSevere("Problems starting listener " + this.connectionListener, connectionException);
            }
            for (ConnectionListener connectionListener : this.additionalConnectionListeners) {
                try {
                    connectionListener.start();
                }
                catch (ConnectionException connectionException) {
                    this.logSevere("Problems starting listener " + this.connectionListener, connectionException);
                }
            }
        }
    }

    public synchronized void saveConfig() {
        Object object;
        Path path;
        Path path2;
        Path path3;
        Path path4;
        Path path5;
        if (!this.started) {
            return;
        }
        this.logFine("Saving config (" + this.getConfigName() + ".config)");
        this.config.remove("removed.folder.files");
        if (this.getConfigLocationBase() == null) {
            path5 = Paths.get(this.getConfigName() + ".config", new String[0]).toAbsolutePath();
            path4 = Paths.get(this.getConfigName() + ".writing.config", new String[0]).toAbsolutePath();
            path3 = Paths.get(this.getConfigName() + "-Folder.config", new String[0]).toAbsolutePath();
            path2 = Paths.get(this.getConfigName() + "-Folder.writing.config", new String[0]).toAbsolutePath();
            path = Paths.get(this.getConfigName() + ".config.backup", new String[0]).toAbsolutePath();
        } else {
            path5 = this.getConfigLocationBase().resolve(this.getConfigName() + ".config");
            path4 = this.getConfigLocationBase().resolve(this.getConfigName() + ".writing.config").toAbsolutePath();
            path = this.getConfigLocationBase().resolve(this.getConfigName() + ".config.backup");
            path3 = this.getConfigLocationBase().resolve(this.getConfigName() + "-Folder.config");
            path2 = this.getConfigLocationBase().resolve(this.getConfigName() + "-Folder.writing.config").toAbsolutePath();
        }
        try {
            object = Files.getFileStore(path5);
            if (((FileStore)object).getUsableSpace() < 0xA00000L) {
                this.logSevere("Unable to store configuration file. Disk space insufficient: " + Format.formatBytesShort(((FileStore)object).getUsableSpace()));
                return;
            }
        }
        catch (IOException iOException) {
            this.logFine(iOException);
        }
        try {
            Object object2;
            Files.deleteIfExists(path);
            object = "PowerFolder";
            if (this.distribution != null && StringUtils.isNotBlank(this.distribution.getName())) {
                object = this.distribution.getName();
            }
            Properties properties = new Properties();
            if (Files.exists(path5, new LinkOption[0])) {
                object2 = new BufferedInputStream(Files.newInputStream(path5, new OpenOption[0]));
                try {
                    properties.load((InputStream)object2);
                }
                finally {
                    ((BufferedInputStream)object2).close();
                }
            }
            if (!properties.equals(this.config.getRegular())) {
                PropertiesUtil.saveConfig(path4, this.config.getRegular(), (String)object + " config file (v23.4.100)");
                Files.deleteIfExists(path5);
                try {
                    Files.move(path4, path5, new CopyOption[0]);
                }
                catch (IOException iOException) {
                    Files.copy(path4, path5, new CopyOption[0]);
                    Files.delete(path4);
                }
            } else if (this.isFine()) {
                this.logFine("Not storing config to " + path5 + ". Base config remains unchanged");
            }
            object2 = new Properties();
            if (Files.exists(path3, new LinkOption[0])) {
                try (BufferedInputStream bufferedInputStream = new BufferedInputStream(Files.newInputStream(path3, new OpenOption[0]));){
                    ((Properties)object2).load(bufferedInputStream);
                }
            }
            if (!((Properties)object2).equals(this.config.getFolders())) {
                PropertiesUtil.saveConfig(path2, this.config.getFolders(), (String)object + " folders config file (v23.4.100)");
                Files.deleteIfExists(path3);
                try {
                    Files.move(path2, path3, new CopyOption[0]);
                }
                catch (IOException iOException) {
                    Files.copy(path2, path3, new CopyOption[0]);
                    Files.delete(path2);
                }
            }
        }
        catch (IOException iOException) {
            this.logSevere("Unable to save config. " + iOException, iOException);
            this.exit(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logSevere("major problem , setting code is wrong", exception);
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    public long getUptime() {
        if (this.startTime == null) {
            return -1L;
        }
        return System.currentTimeMillis() - this.startTime.getTime();
    }

    public String getJARName() {
        if (this.distribution != null && this.distribution.getBinaryName() != null) {
            return this.distribution.getBinaryName() + ".jar";
        }
        this.logSevere("Unable to get JAR name for distribution: " + this.distribution, new RuntimeException());
        return "PowerFolder.jar";
    }

    public String getL4JININame() {
        if (this.distribution != null && this.distribution.getBinaryName() != null) {
            return this.distribution.getBinaryName() + ".l4j.ini";
        }
        this.logSevere("Unable to get l4j.ini name for distribution: " + this.distribution);
        return "PowerFolder.l4j.ini";
    }

    public void setPaused(boolean bl) {
        this.setPaused0(bl, false);
    }

    private synchronized void setPaused0(boolean bl, boolean bl2) {
        boolean bl3 = this.paused;
        this.paused = bl;
        if (this.paused != bl3) {
            this.logInfo("Set paused=" + this.paused + ". wasPaused=" + bl3);
        }
        if (bl) {
            this.folderRepository.getFolderScanner().abortScan();
            this.transferManager.abortAllDownloads();
            this.transferManager.abortAllUploads();
        } else {
            this.folderRepository.triggerMaintenance();
            this.folderRepository.getFileRequestor().triggerFileRequesting();
            for (Folder folder : this.folderRepository.getFolders()) {
                folder.broadcastFileRequestCommand();
            }
        }
        if (bl3 != bl) {
            this.transferManager.updateSpeedLimits();
        }
        PreferencesEntry.PAUSED.setValue(this, bl);
        this.pausedModeListenerSupport.setPausedMode(new PausedModeEvent(bl));
        if (this.pauseResumeFuture != null) {
            try {
                this.pauseResumeFuture.cancel(true);
                if (!this.removeScheduled(this.pauseResumeFuture)) {
                    this.logSevere("Unable to remove pause task: " + this.pauseResumeFuture, new RuntimeException("Unable to remove pause task: " + this.pauseResumeFuture));
                }
                this.logFine("Cancelled resume task");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.logSevere(exception);
            }
        }
        int n = ConfigurationEntry.PAUSE_RESUME_SECONDS.getValueInt(this);
        if (bl) {
            if (n == 0) {
                this.pauseResumeFuture = this.scheduleAndRepeat(new PauseResumeTask(true), 1000L);
            } else if (n < Integer.MAX_VALUE) {
                this.pauseResumeFuture = this.schedule(new PauseResumeTask(false), n * 1000);
                this.logFine("Scheduled resume task in " + n + " seconds.");
            }
        } else {
            this.pauseResumeFuture = n == 0 && bl2 ? this.scheduleAndRepeat(new PauseResumeTask(true), 1000L) : null;
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isLanOnly() {
        return this.getNetworkingMode() == NetworkingMode.LANONLYMODE;
    }

    public boolean isBackupOnly() {
        return false;
    }

    public NetworkingMode getNetworkingMode() {
        if (this.networkingMode == null) {
            if (this.isBackupOnly()) {
                this.networkingMode = NetworkingMode.SERVERONLYMODE;
                return this.networkingMode;
            }
            String string = ConfigurationEntry.NETWORKING_MODE.getValue(this);
            try {
                this.networkingMode = NetworkingMode.valueOf(string);
            }
            catch (Exception exception) {
                this.logSevere("Unable to read networking mode, reverting to PRIVATE_ONLY_MODE: " + exception.toString(), exception);
                this.networkingMode = NetworkingMode.PRIVATEMODE;
            }
        }
        return this.networkingMode;
    }

    public void addPausedModeListener(PausedModeListener pausedModeListener) {
        ListenerSupportFactory.addListener(this.pausedModeListenerSupport, pausedModeListener);
    }

    public void removePausedModeListener(PausedModeListener pausedModeListener) {
        ListenerSupportFactory.removeListener(this.pausedModeListenerSupport, pausedModeListener);
    }

    public void addNetworkingModeListener(NetworkingModeListener networkingModeListener) {
        ListenerSupportFactory.addListener(this.networkingModeListenerSupport, networkingModeListener);
    }

    public void removeNetworkingModeListener(NetworkingModeListener networkingModeListener) {
        ListenerSupportFactory.removeListener(this.networkingModeListenerSupport, networkingModeListener);
    }

    public void addLimitedConnectivityListener(LimitedConnectivityListener limitedConnectivityListener) {
        ListenerSupportFactory.addListener(this.limitedConnectivityListenerSupport, limitedConnectivityListener);
    }

    public void removeLimitedConnectivityListener(LimitedConnectivityListener limitedConnectivityListener) {
        ListenerSupportFactory.removeListener(this.limitedConnectivityListenerSupport, limitedConnectivityListener);
    }

    public void setNetworkingMode(NetworkingMode networkingMode) {
        this.setNetworkingMode(networkingMode, true);
    }

    public void setNetworkingMode(NetworkingMode networkingMode, boolean bl) {
        if (this.isBackupOnly() && networkingMode != NetworkingMode.SERVERONLYMODE) {
            networkingMode = NetworkingMode.SERVERONLYMODE;
            this.logWarning("Backup only client. Only supports server only networking mode");
        }
        this.logFine("setNetworkingMode: " + networkingMode);
        NetworkingMode networkingMode2 = this.getNetworkingMode();
        if (networkingMode != networkingMode2) {
            ConfigurationEntry.NETWORKING_MODE.setValue(this, networkingMode.name());
            this.networkingMode = networkingMode;
            this.networkingModeListenerSupport.setNetworkingMode(new NetworkingModeEvent(networkingMode2, networkingMode));
            if (bl) {
                this.nodeManager.shutdown();
                this.nodeManager.start();
            }
            this.reconnectManager.buildReconnectionQueue();
        }
    }

    public boolean isLimitedConnectivity() {
        return this.limitedConnectivity;
    }

    public void setLimitedConnectivity(boolean bl) {
        boolean bl2 = this.limitedConnectivity;
        this.limitedConnectivity = bl;
        LimitedConnectivityEvent limitedConnectivityEvent = new LimitedConnectivityEvent(bl2, bl);
        this.limitedConnectivityListenerSupport.setLimitedConnectivity(limitedConnectivityEvent);
    }

    public void exit(int n) {
        if (Feature.EXIT_ON_SHUTDOWN.isDisabled()) {
            System.err.println("Running in JUnit testmode, no system.exit(" + n + ") called");
            new StackDump().printStackTrace();
            return;
        }
        this.shutdown();
        System.exit(n);
    }

    public void shutdownAndRequestRestart() {
        this.restartRequested = true;
        this.shutdown();
    }

    public boolean isRestartRequested() {
        return this.restartRequested;
    }

    public synchronized void shutdown() {
        if (this.shuttingDown || !this.started) {
            return;
        }
        PathUtils.setIOExceptionListener(null);
        this.shuttingDown = true;
        this.logInfo("Shutting down...");
        this.setFirstStart(false);
        if (Profiling.isEnabled()) {
            this.logFine(Profiling.dumpStats());
        }
        this.savePersistentObjects();
        boolean bl = this.started;
        this.started = false;
        this.startTime = null;
        PreferencesEntry.LAST_NODE_ID.setValue(this, LoginUtil.hashAndSalt(this.getMySelf().getId()));
        if (this.taskManager != null) {
            this.logFine("Shutting down task manager");
            this.taskManager.shutdown();
        }
        if (this.threadPool != null) {
            this.logFine("Shutting down global threadpool");
            this.threadPool.shutdownNow();
        }
        if (this.fbIntegration != null) {
            this.fbIntegration.shutdown();
        }
        if (this.isUIOpen()) {
            this.logFine("Shutting down UI");
            this.uiController.shutdown();
        }
        if (this.rconManager != null) {
            this.logFine("Shutting down RConManager");
            this.rconManager.shutdown();
        }
        this.logFine("Shutting down connection listener(s)");
        if (this.connectionListener != null) {
            this.connectionListener.shutdown();
        }
        for (ConnectionListener connectionListener : this.additionalConnectionListeners) {
            connectionListener.shutdown();
        }
        this.additionalConnectionListeners.clear();
        if (this.broadcastManager != null) {
            this.logFine("Shutting down broadcast manager");
            this.broadcastManager.shutdown();
        }
        if (this.transferManager != null) {
            this.logFine("Shutting down transfer manager");
            this.transferManager.shutdown();
        }
        if (this.nodeManager != null) {
            this.logFine("Shutting down node manager");
            this.nodeManager.shutdown();
        }
        if (this.ioProvider != null) {
            this.logFine("Shutting down io provider");
            this.ioProvider.shutdown();
        }
        if (this.folderRepository != null) {
            this.logFine("Shutting down folder repository");
            this.folderRepository.shutdown();
        }
        if (this.reconnectManager != null) {
            this.logFine("Shutting down reconnect manager");
            this.reconnectManager.shutdown();
        }
        if (this.pluginManager != null) {
            this.logFine("Shutting down plugin manager");
            this.pluginManager.shutdown();
        }
        if (MacUtils.isSupported()) {
            MacUtils.getInstance().removeAppReOpenedListener();
        }
        if (this.webClientLogin != null) {
            this.webClientLogin.stop();
        }
        this.shuttingDown = false;
        this.logInfo("Shutting down done");
        LoggingManager.closeFileLogging();
        this.backupConfigAssets();
    }

    public ScheduledExecutorService getThreadPool() {
        return this.threadPool;
    }

    public String getDebugReport() {
        return Debug.buildDebugReport(this);
    }

    public void writeDebugReport() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.getConfigName() + ".report.txt");
            String string = this.getDebugReport();
            fileOutputStream.write(string.getBytes());
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logSevere("FileNotFoundException", fileNotFoundException);
        }
        catch (IOException iOException) {
            this.logSevere("IOException", iOException);
        }
    }

    public String getConfigName() {
        if (this.configFilename == null) {
            return null;
        }
        String string = this.configFilename;
        int n = string.indexOf(46);
        if (n > 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    public Path getConfigFile() {
        return this.configFile;
    }

    public String getConfigFilename() {
        return this.configFilename;
    }

    public Path getConfigFolderFile() {
        return this.configFolderFile;
    }

    public Path getSslTrustStoreFile() {
        return this.sslTrustStoreFile;
    }

    public Properties getConfig() {
        return this.config;
    }

    public CommandLine getCommandLine() {
        return this.commandLine;
    }

    public String getCLIUsername() {
        return this.commandLine != null ? this.commandLine.getOptionValue("u") : null;
    }

    public String getCLIPassword() {
        return this.commandLine != null ? this.commandLine.getOptionValue("p") : null;
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public boolean isFirstStart() {
        return this.preferences.getBoolean("openwizard2", true);
    }

    public void setFirstStart(boolean bl) {
        this.preferences.putBoolean("openwizard2", bl);
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public UpdateSetting getUpdateSettings() {
        return UpdateSetting.create(this);
    }

    @Override
    public Member getMySelf() {
        return this.nodeManager != null ? this.nodeManager.getMySelf() : null;
    }

    public void changeNick(String string, boolean bl) {
        this.getMySelf().setNick(string);
        ConfigurationEntry.NICK.setValue(this, this.getMySelf().getNick());
        if (bl) {
            this.saveConfig();
        }
        this.nodeManager.broadcastMessage(new SettingsChange(this.getMySelf()));
        if (this.isUIOpen()) {
            this.uiController.getMainFrame().updateTitle();
        }
    }

    public IOProvider getIOProvider() {
        return this.ioProvider;
    }

    public ServerClient getOSClient() {
        return this.osClient;
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public DynDnsManager getDynDnsManager() {
        return this.dyndnsManager;
    }

    public BroadcastMananger getBroadcastManager() {
        return this.broadcastManager;
    }

    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    public ReconnectManager getReconnectManager() {
        return this.reconnectManager;
    }

    public PersistentTaskManager getTaskManager() {
        return this.taskManager;
    }

    public FolderRepository getFolderRepository() {
        return this.folderRepository;
    }

    public TransferManager getTransferManager() {
        return this.transferManager;
    }

    public void setTransferManagerFactory(Callable<TransferManager> callable) {
        Reject.ifNull(callable, "TransferManager factory is null");
        if (this.transferManager != null) {
            throw new IllegalStateException("TransferManager was already set!");
        }
        this.transferManagerFactory = callable;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public void setSecurityManager(SecurityManager securityManager) {
        this.logFiner("Security manager set: " + securityManager);
        this.securityManager = securityManager;
    }

    public Member connect(InetSocketAddress inetSocketAddress) throws ConnectionException {
        return this.connect(inetSocketAddress, false);
    }

    public Member connect(InetSocketAddress inetSocketAddress, boolean bl) throws ConnectionException {
        if (!this.started) {
            this.logInfo("NOT Connecting to " + inetSocketAddress + ". Controller not started");
            throw new ConnectionException("NOT Connecting to " + inetSocketAddress + ". Controller not started");
        }
        if (0 >= inetSocketAddress.getPort()) {
            this.logWarning("Unable to connect, port illegal " + inetSocketAddress.getPort());
        }
        this.logFine("Connecting to " + inetSocketAddress + (bl ? "via D2D" : "") + "...");
        ConnectionHandler connectionHandler = this.ioProvider.getConnectionHandlerFactory().tryToConnect(inetSocketAddress, bl);
        return this.nodeManager.acceptConnection(connectionHandler);
    }

    public Member connect(String string) throws ConnectionException {
        return this.connect(Util.parseConnectionString(string));
    }

    public boolean isConsoleMode() {
        if (this.commandLine != null && this.commandLine.hasOption('s')) {
            return true;
        }
        if (this.config != null && ConfigurationEntry.DISABLE_GUI.getValueBoolean(this).booleanValue()) {
            return true;
        }
        if (Feature.UI_ENABLED.isDisabled()) {
            return true;
        }
        return GraphicsEnvironment.isHeadless();
    }

    public boolean isNotifyLeft() {
        return this.commandLine != null && this.commandLine.hasOption('y');
    }

    private void openUI() {
        this.uiController.start();
    }

    public boolean isUIEnabled() {
        return !this.isConsoleMode();
    }

    public boolean isUIOpen() {
        return this.uiController != null && this.uiController.isStarted();
    }

    public UIController getUIController() {
        return this.uiController;
    }

    public void waitForUIOpen() {
        if (!this.isUIEnabled()) {
            throw new IllegalStateException("Unable to ui to open, ui is not enabled");
        }
        while (!this.isUIOpen()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                this.logFiner("InterruptedException", interruptedException);
                break;
            }
        }
    }

    private boolean openListener(String string, int n, boolean bl) {
        this.logFine("Opening incoming connection listener on port " + n + " on interface " + (string != null ? string : "(all)"));
        while (true) {
            try {
                ConnectionListener connectionListener = new ConnectionListener(this, n, string, bl);
                if (this.connectionListener == null || !this.connectionListener.isServerSocketOpen() && !bl) {
                    this.connectionListener = connectionListener;
                } else {
                    this.additionalConnectionListeners.add(connectionListener);
                }
                return true;
            }
            catch (ConnectionException connectionException) {
                this.logWarning("Unable to bind to port " + n);
                this.logFiner("ConnectionException", connectionException);
                if (string != null) {
                    this.logSevere("This could've been caused by a binding error on the interface... Retrying without binding");
                    string = null;
                    continue;
                }
                return false;
            }
            break;
        }
    }

    public boolean hasConnectionListener() {
        return this.connectionListener != null;
    }

    public ConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    public List<ConnectionListener> getAdditionalConnectionListeners() {
        return this.additionalConnectionListeners;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isDebugReports() {
        return this.debugReports && this.verbose;
    }

    public Date getBuildTime() {
        Path path = Paths.get(this.getJARName(), new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                return new Date(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis());
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }

    private void setLoadingCompletion(int n, int n2) {
        if (this.uiController != null) {
            this.uiController.setLoadingCompletion(n, n2);
        }
    }

    public boolean isStartMinimized() {
        return this.commandLine != null && this.commandLine.hasOption('m');
    }

    private Path getConfigLocationBase() {
        Path path = Paths.get(this.getConfigName() + ".config", new String[0]).toAbsolutePath();
        if (OSUtil.isWebStart() || Files.notExists(path, new LinkOption[0])) {
            if (this.isFiner()) {
                this.logFiner("Config location base: " + Controller.getMiscFilesLocation().toString());
            }
            return Controller.getMiscFilesLocation();
        }
        return null;
    }

    public static Path getMiscFilesLocation() {
        return Controller.getMiscFilesLocation(true);
    }

    public static Path getMiscFilesLocation(boolean bl) {
        Path path;
        Path path2 = path = Paths.get(System.getProperty("user.home"), "." + miscFilesLocationDirName).toAbsolutePath();
        if (OSUtil.isWindowsSystem() && Feature.WINDOWS_MISC_DIR_USE_APP_DATA.isEnabled()) {
            Path path3;
            String string = WinUtils.getAppDataCurrentUser();
            if (Feature.CONFIGURATION_ALL_USERS.isEnabled()) {
                string = WinUtils.getAppDataAllUsers();
            }
            if (StringUtils.isBlank(string)) {
                return path;
            }
            path2 = path3 = Paths.get(string, miscFilesLocationDirName).toAbsolutePath();
            if (Files.exists(path, new LinkOption[0])) {
                boolean bl2;
                boolean bl3;
                if (Files.exists(path3, new LinkOption[0])) {
                    try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path3, "*.config");){
                        bl3 = !directoryStream.iterator().hasNext();
                    }
                    catch (IOException iOException) {
                        log.info(iOException.getMessage());
                        bl3 = true;
                    }
                } else {
                    bl3 = true;
                }
                if (bl3 && !(bl2 = Controller.migrateWindowsMiscLocation(path, path3))) {
                    path2 = path;
                }
            }
        }
        if (bl && Files.notExists(path2, new LinkOption[0])) {
            try {
                Files.createDirectories(path2, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                log.severe("Failed to create " + path2.toAbsolutePath().toString() + ". " + iOException);
            }
        }
        return path2;
    }

    private static boolean migrateWindowsMiscLocation(Path path, Path path2) {
        if (Files.notExists(path2, new LinkOption[0])) {
            try {
                Files.createDirectories(path2, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                log.severe("Failed to create " + path2.toAbsolutePath().toString() + ". " + iOException);
            }
        }
        try {
            PathUtils.recursiveMove(path, path2);
            log.warning("Migrated config from " + path + " to " + path2);
            return true;
        }
        catch (IOException iOException) {
            log.warning("Failed to migrate config from " + path + " to " + path2 + ". " + iOException);
            return false;
        }
    }

    public static Path getTempFilesLocation() {
        Path path = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
        if (Files.notExists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                log.warning("Could not create temp files location '" + path.toAbsolutePath().toString() + "'. " + iOException);
            }
        }
        return path;
    }

    private void killRunningInstance() {
        if (RemoteCommandManager.hasRunningInstance()) {
            this.logWarning("Found a running instance. Trying to shut it down...");
            RemoteCommandManager.sendCommand("QUIT");
            Waiter waiter = new Waiter(10000L);
            while (RemoteCommandManager.hasRunningInstance() && !waiter.isTimeout()) {
                waiter.waitABit();
            }
            if (!RemoteCommandManager.hasRunningInstance()) {
                this.logInfo("Was able to shut down running instance. Continue normal");
                return;
            }
            this.logWarning("Was NOT able to shut down running instance.");
        }
    }

    private void alreadyRunningCheck() {
        JFrame jFrame = null;
        if (this.isUIOpen()) {
            jFrame = this.uiController.getMainFrame().getUIComponent();
        }
        if (!this.isStartMinimized() && this.isUIEnabled() && !this.commandLine.hasOption('z')) {
            Object[] objectArray = new Object[]{Translation.get("dialog.already_running.show_button")};
            int n = 0;
            objectArray = new Object[]{Translation.get("dialog.already_running.start_button"), Translation.get("dialog.already_running.exit_button")};
            n = 1;
            if (JOptionPane.showOptionDialog(jFrame, Translation.get("dialog.already_running.warning"), Translation.get("dialog.already_running.title"), -1, 1, null, objectArray, objectArray[0]) == n) {
                RemoteCommandManager.sendCommand("SHOWUI;");
                this.exit(1);
            }
        } else {
            this.logWarning("PowerFolder already running");
        }
    }

    private void fatalStartError(String string) {
        JFrame jFrame = null;
        if (this.isUIOpen()) {
            jFrame = this.uiController.getMainFrame().getUIComponent();
        }
        if (this.isUIEnabled()) {
            Object[] objectArray = new Object[]{Translation.get("dialog.already_running.exit_button")};
            JOptionPane.showOptionDialog(jFrame, string, Translation.get("dialog.fatal_error.title"), -1, 0, null, objectArray, objectArray[0]);
        } else {
            this.logSevere(string);
        }
        this.exit(1);
    }

    private void initDistribution() {
        try {
            Object object;
            if (ConfigurationEntry.DIST_CLASSNAME.hasNonBlankValue(this.getController())) {
                object = Class.forName(ConfigurationEntry.DIST_CLASSNAME.getValue(this.getController()));
                this.distribution = (Distribution)((Class)object).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            if (this.distribution == null) {
                object = ServiceLoader.load(Distribution.class);
                Iterator iterator = ((ServiceLoader)object).iterator();
                while (iterator.hasNext()) {
                    Distribution distribution = (Distribution)iterator.next();
                    if (this.distribution != null) {
                        this.logWarning("Found multiple distribution classes: " + distribution.getName() + ", already using " + this.distribution.getName());
                        break;
                    }
                    this.distribution = distribution;
                }
            }
            if (this.distribution == null) {
                this.distribution = ProUtil.isRunningProVersion() ? new PowerFolderPro() : new PowerFolderBasic();
                this.logFine("Distributon not found. Falling back to " + this.distribution.getName());
            }
            this.distribution.init(this);
            this.logInfo("Running distribution: " + this.distribution.getName());
        }
        catch (Exception exception) {
            this.logSevere("Failed to initialize distribution " + (this.distribution == null ? "null" : this.distribution.getName()), exception);
            try {
                if (this.distribution == null) {
                    this.distribution = ProUtil.isRunningProVersion() ? new PowerFolderPro() : new PowerFolderBasic();
                }
                this.logInfo("Running distribution: " + this.distribution.getName());
                this.distribution.init(this);
            }
            catch (Exception exception2) {
                this.logSevere("Failed to initialize fallback distribution", exception2);
            }
        }
    }

    public String toString() {
        return "Controller '" + this.getMySelf() + "'";
    }

    public void makeFriendship(MemberInfo memberInfo) {
        if (this.networkingMode == NetworkingMode.SERVERONLYMODE) {
            this.logFine("Ignoring ask for friendship from client " + memberInfo + ". Running in server only mode");
            return;
        }
        Member member = memberInfo.getNode(this, false);
        if (member != null) {
            boolean bl;
            if (member.isFriend()) {
                log.fine("Ignoring ask for friendship from " + memberInfo.getNick() + ". Already friend.");
                return;
            }
            if (member.isServer()) {
                log.fine("Ignoring ask for friendship from " + memberInfo.getNick() + ". is a server.");
                return;
            }
            String string = member.getNick().toLowerCase();
            boolean bl2 = bl = string.contains("powerfolder") && string.contains("cloud");
            if (bl) {
                log.fine("Ignoring ask for friendship from " + memberInfo.getNick() + ". is a pf server.");
                return;
            }
            member.setFriend(true, null);
        }
    }

    public void invitationReceived(Invitation invitation) {
        for (InvitationHandler invitationHandler : this.invitationHandlers) {
            invitationHandler.gotInvitation(invitation);
        }
    }

    private void savePersistentObjects() {
        if (this.started && this.isUIEnabled()) {
            ArrayList<Notice> arrayList = new ArrayList<Notice>();
            for (Notice object : this.uiController.getApplicationModel().getNoticesModel().getAllNotices()) {
                if (!object.isPersistable()) continue;
                arrayList.add(object);
            }
            Path path = Controller.getMiscFilesLocation().resolve(this.getConfigName() + ".notices");
            try (ObjectOutputStream fileNotFoundException = new ObjectOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
                this.logInfo("There are " + arrayList.size() + " notices to persist.");
                fileNotFoundException.writeUnshared(arrayList);
            }
            catch (FileNotFoundException iOException) {
                this.logSevere("FileNotFoundException", iOException);
            }
            catch (IOException iOException) {
                this.logSevere("IOException", iOException);
            }
        }
    }

    private void loadPersistentObjects() {
        if (this.isUIEnabled()) {
            Path path = Controller.getMiscFilesLocation().resolve(this.getConfigName() + ".notices");
            if (Files.exists(path, new LinkOption[0])) {
                this.logFine("Loading notices from " + path);
                try (ObjectInputStream objectInputStream = new ObjectInputStream(Files.newInputStream(path, new OpenOption[0]));){
                    List list = (List)objectInputStream.readObject();
                    objectInputStream.close();
                    for (Notice notice : list) {
                        this.uiController.getApplicationModel().getNoticesModel().handleSystemNotice(notice, true);
                    }
                    this.logFine("Loaded " + list.size() + " notices.");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.logSevere("FileNotFoundException", fileNotFoundException);
                }
                catch (IOException iOException) {
                    this.logSevere("IOException", iOException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.logSevere("ClassNotFoundException", classNotFoundException);
                }
                catch (ClassCastException classCastException) {
                    this.logSevere("ClassCastException", classCastException);
                }
            } else {
                this.logInfo("No notices found - probably first start of PF.");
            }
        }
    }

    public void shutdownAfterSync(final String string) {
        final AtomicBoolean atomicBoolean = new AtomicBoolean(true);
        this.scheduleAndRepeat(new Runnable(){

            @Override
            public void run() {
                if (atomicBoolean.get() && Controller.this.folderRepository.isInSync()) {
                    atomicBoolean.set(false);
                    log.info("Sync and shutdown in sync.");
                    if (SystemUtil.shutdown(string)) {
                        log.info("Shutdown command issued.");
                        Controller.this.exit(0);
                    } else {
                        log.warning("Shutdown command failed.");
                    }
                }
            }
        }, 10000L, 10000L);
    }

    public void exitAfterSync(int n) {
        this.logInfo("Sync and exit initiated. Begin check in " + n + "s");
        final AtomicBoolean atomicBoolean = new AtomicBoolean(true);
        this.scheduleAndRepeat(new Runnable(){

            @Override
            public void run() {
                if (atomicBoolean.get() && Controller.this.folderRepository.isInSync()) {
                    atomicBoolean.set(false);
                    log.info("I'm in sync - exit now. Sync and exit was triggered.");
                    Controller.this.exit(0);
                }
            }
        }, 1000L * (long)n, 10000L);
    }

    private class PauseResumeTask
    extends TimerTask {
        private final boolean userAdaptive;

        public PauseResumeTask(boolean bl) {
            this.userAdaptive = bl;
        }

        @Override
        public void run() {
            if (this.userAdaptive && Controller.this.isUIOpen()) {
                ApplicationModel applicationModel = Controller.this.uiController.getApplicationModel();
                if (applicationModel.isUserActive()) {
                    if (!Controller.this.isPaused()) {
                        Controller.this.getController().schedule(new Runnable(){

                            @Override
                            public void run() {
                                Controller.this.setPaused0(true, true);
                                log.info("User active. Executed pause task.");
                            }
                        }, 50L);
                    }
                } else if (Controller.this.isPaused()) {
                    Controller.this.getController().schedule(new Resumer(), 50L);
                }
            } else {
                Controller.this.setPaused0(false, true);
                log.info("Executed resume task.");
            }
        }
    }

    private class Resumer
    implements Runnable {
        private Resumer() {
        }

        @Override
        public void run() {
            Controller.this.setPaused0(false, true);
            log.info("User inactive. Executed resume task.");
        }
    }
}

