/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import dagger.producers.Producer;
import dagger.producers.internal.AbstractProducer;
import dagger.producers.internal.Producers;
import java.util.Map;
import javax.inject.Provider;

public final class MapOfProducerProducer<K, V>
extends AbstractProducer<Map<K, Producer<V>>> {
    private static final MapOfProducerProducer<Object, Object> EMPTY = new MapOfProducerProducer(ImmutableMap.of());
    private final ImmutableMap<K, Producer<V>> contributingMap;

    public static <K, V> Builder<K, V> builder(int n) {
        return new Builder(n);
    }

    public static <K, V> MapOfProducerProducer<K, V> empty() {
        return EMPTY;
    }

    private MapOfProducerProducer(ImmutableMap<K, Producer<V>> immutableMap) {
        this.contributingMap = immutableMap;
    }

    @Override
    public ListenableFuture<Map<K, Producer<V>>> compute() {
        return Futures.immediateFuture(this.contributingMap);
    }

    public static final class Builder<K, V> {
        private final Map<K, Producer<V>> mapBuilder;

        private Builder(int n) {
            this.mapBuilder = Maps.newLinkedHashMapWithExpectedSize(n);
        }

        public MapOfProducerProducer<K, V> build() {
            return new MapOfProducerProducer(ImmutableMap.copyOf(this.mapBuilder));
        }

        public Builder<K, V> put(K k, Producer<V> producer) {
            Preconditions.checkNotNull(k, "key");
            Preconditions.checkNotNull(producer, "producer of value");
            this.mapBuilder.put(k, producer);
            return this;
        }

        public Builder<K, V> put(K k, Provider<V> provider) {
            Preconditions.checkNotNull(k, "key");
            Preconditions.checkNotNull(provider, "provider of value");
            this.mapBuilder.put(k, Producers.producerFromProvider(provider));
            return this;
        }
    }
}

