/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal;

import dagger.internal.GwtIncompatible;
import dagger.internal.Preconditions;
import dagger.internal.ReferenceReleasingProviderManager;
import java.lang.ref.WeakReference;
import javax.inject.Provider;

@GwtIncompatible
public final class ReferenceReleasingProvider<T>
implements Provider<T> {
    private static final Object NULL = new Object();
    private final Provider<T> provider;
    private volatile Object strongReference;
    private volatile WeakReference<T> weakReference;

    private ReferenceReleasingProvider(Provider<T> provider) {
        assert (provider != null);
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseStrongReference() {
        Object object = this.strongReference;
        if (object != null && object != NULL) {
            ReferenceReleasingProvider referenceReleasingProvider = this;
            synchronized (referenceReleasingProvider) {
                Object object2 = object;
                this.weakReference = new WeakReference<Object>(object2);
                this.strongReference = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreStrongReference() {
        Object object = this.strongReference;
        if (this.weakReference != null && object == null) {
            ReferenceReleasingProvider referenceReleasingProvider = this;
            synchronized (referenceReleasingProvider) {
                object = this.strongReference;
                if (this.weakReference != null && object == null && (object = this.weakReference.get()) != null) {
                    this.strongReference = object;
                    this.weakReference = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        Object object = this.currentValue();
        if (object == null) {
            ReferenceReleasingProvider referenceReleasingProvider = this;
            synchronized (referenceReleasingProvider) {
                object = this.currentValue();
                if (object == null) {
                    object = this.provider.get();
                    if (object == null) {
                        object = NULL;
                    }
                    this.strongReference = object;
                }
            }
        }
        return (T)(object == NULL ? null : object);
    }

    private Object currentValue() {
        Object object = this.strongReference;
        if (object != null) {
            return object;
        }
        if (this.weakReference != null) {
            return this.weakReference.get();
        }
        return null;
    }

    public static <T> ReferenceReleasingProvider<T> create(Provider<T> provider, ReferenceReleasingProviderManager referenceReleasingProviderManager) {
        ReferenceReleasingProvider<T> referenceReleasingProvider = new ReferenceReleasingProvider<T>(Preconditions.checkNotNull(provider));
        referenceReleasingProviderManager.addProvider(referenceReleasingProvider);
        return referenceReleasingProvider;
    }
}

