/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal;

import dagger.Lazy;
import dagger.internal.Factory;
import dagger.internal.Preconditions;

public final class InstanceFactory<T>
implements Factory<T>,
Lazy<T> {
    private static final InstanceFactory<Object> NULL_INSTANCE_FACTORY = new InstanceFactory<Object>(null);
    private final T instance;

    public static <T> Factory<T> create(T t) {
        return new InstanceFactory<T>(Preconditions.checkNotNull(t, "instance cannot be null"));
    }

    public static <T> Factory<T> createNullable(T t) {
        return t == null ? InstanceFactory.nullInstanceFactory() : new InstanceFactory<T>(t);
    }

    private static <T> InstanceFactory<T> nullInstanceFactory() {
        return NULL_INSTANCE_FACTORY;
    }

    private InstanceFactory(T t) {
        this.instance = t;
    }

    @Override
    public T get() {
        return this.instance;
    }
}

