/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.nativity.modules.contextmenu;

import com.liferay.nativity.control.NativityControl;
import com.liferay.nativity.modules.contextmenu.ContextMenuControl;
import com.liferay.nativity.modules.contextmenu.ContextMenuControlCallback;
import com.liferay.nativity.modules.contextmenu.fs.FSContextMenuControlImpl;
import com.liferay.nativity.modules.contextmenu.unix.AppleContextMenuControlImpl;
import com.liferay.nativity.modules.contextmenu.unix.LinuxContextMenuControlImpl;
import com.liferay.nativity.modules.contextmenu.win.WindowsContextMenuControlImpl;
import com.liferay.nativity.util.OSDetector;

public class ContextMenuControlUtil {
    private ContextMenuControlCallback _contextMenuControlCallback;
    private NativityControl _nativityControl;

    public static ContextMenuControl getContextMenuControl(NativityControl nativityControl, ContextMenuControlCallback contextMenuControlCallback) {
        ContextMenuControlUtil contextMenuControlUtil = new ContextMenuControlUtil(nativityControl, contextMenuControlCallback);
        if (OSDetector.isApple()) {
            if (OSDetector.isMinimumAppleVersion("10.10")) {
                return contextMenuControlUtil.createFSContextMenuControl();
            }
            return contextMenuControlUtil.createAppleContextMenuControl();
        }
        if (OSDetector.isWindows()) {
            return contextMenuControlUtil.createWindowsContextMenuControl();
        }
        if (OSDetector.isLinux()) {
            return contextMenuControlUtil.createLinuxContextMenuControl();
        }
        return null;
    }

    protected ContextMenuControl createAppleContextMenuControl() {
        return new AppleContextMenuControlImpl(this._nativityControl, this._contextMenuControlCallback);
    }

    protected ContextMenuControl createFSContextMenuControl() {
        return new FSContextMenuControlImpl(this._nativityControl, this._contextMenuControlCallback);
    }

    protected ContextMenuControl createLinuxContextMenuControl() {
        return new LinuxContextMenuControlImpl(this._nativityControl, this._contextMenuControlCallback);
    }

    protected ContextMenuControl createWindowsContextMenuControl() {
        return new WindowsContextMenuControlImpl(this._nativityControl, this._contextMenuControlCallback);
    }

    private ContextMenuControlUtil(NativityControl nativityControl, ContextMenuControlCallback contextMenuControlCallback) {
        this._nativityControl = nativityControl;
        this._contextMenuControlCallback = contextMenuControlCallback;
    }
}

