/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.nativity.control.win;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.nativity.control.NativityControl;
import com.liferay.nativity.control.NativityMessage;
import com.liferay.nativity.control.win.MessageProcessor;
import com.liferay.nativity.control.win.WindowsNativityUtil;
import com.liferay.nativity.util.win.RegistryUtil;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsNativityControlImpl
extends NativityControl {
    private static Logger _logger = LoggerFactory.getLogger(WindowsNativityControlImpl.class.getName());
    private static ObjectMapper _objectMapper = new ObjectMapper().configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
    private static int _port = 33001;
    private boolean _connected = false;
    private Executor _executor = Executors.newCachedThreadPool();
    private ServerSocket _serverSocket;

    @Override
    public void addFavoritesPath(String string) {
        WindowsNativityUtil.addFavoritesPath(string);
    }

    @Override
    public boolean connect() {
        if (this._connected) {
            return true;
        }
        boolean bl = WindowsNativityUtil.load();
        if (!bl) {
            _logger.debug("WindowsNativityUtil failed to load");
            return false;
        }
        if (this._serverSocket == null) {
            try {
                this._serverSocket = new ServerSocket(_port);
                this._connected = true;
            }
            catch (IOException iOException) {
                _logger.error(iOException.getMessage(), iOException);
                return false;
            }
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                WindowsNativityControlImpl.this.fireSocketOpenListeners();
                while (WindowsNativityControlImpl.this._connected) {
                    WindowsNativityControlImpl.this.handleConnection();
                }
            }
        };
        this._executor.execute(runnable);
        return true;
    }

    @Override
    public boolean disconnect() {
        if (!this._connected) {
            return true;
        }
        try {
            this._serverSocket.close();
        }
        catch (IOException iOException) {
            _logger.error(iOException.getMessage(), iOException);
        }
        this._connected = false;
        return true;
    }

    @Override
    public Set<String> getAllObservedFolders() {
        return null;
    }

    @Override
    public boolean load() throws Exception {
        return true;
    }

    @Override
    public boolean loaded() {
        return true;
    }

    @Override
    public void refreshFiles(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        if (!WindowsNativityUtil.loaded()) {
            return;
        }
        try {
            for (String string : stringArray) {
                WindowsNativityUtil.updateExplorer(string);
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            _logger.error(unsatisfiedLinkError.getMessage(), unsatisfiedLinkError);
        }
    }

    @Override
    public void removeFavoritesPath(String string) {
        WindowsNativityUtil.removeFavoritesPath(string);
    }

    @Override
    public String sendMessage(NativityMessage nativityMessage) {
        return "";
    }

    @Override
    public void setFilterFolder(String string) {
        this.setFilterFolders(new String[]{string});
    }

    @Override
    public void setFilterFolders(String[] stringArray) {
        try {
            String[] stringArray2 = _objectMapper.writeValueAsString(stringArray);
            RegistryUtil.writeRegistry("SOFTWARE\\Liferay Inc\\Liferay Nativity", "FilterFolders", (String)stringArray2);
        }
        catch (JsonProcessingException jsonProcessingException) {
            _logger.error(jsonProcessingException.getMessage(), jsonProcessingException);
        }
        for (String string : stringArray) {
            WindowsNativityUtil.refreshExplorer(string);
        }
    }

    @Override
    public void setPortFilePath(String string) {
    }

    @Override
    public void setSystemFolder(String string) {
        if (!WindowsNativityUtil.loaded()) {
            return;
        }
        try {
            WindowsNativityUtil.setSystemFolder(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            _logger.error(unsatisfiedLinkError.getMessage(), unsatisfiedLinkError);
        }
    }

    @Override
    public boolean unload() throws Exception {
        return true;
    }

    protected void handleConnection() {
        try {
            Socket socket = this._serverSocket.accept();
            this._executor.execute(new MessageProcessor(socket, this));
        }
        catch (SocketException socketException) {
            this.fireSocketCloseListeners();
        }
        catch (IOException iOException) {
            _logger.error(iOException.getMessage(), iOException);
            this.fireSocketCloseListeners();
        }
    }
}

