/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks;

import com.jgoodies.looks.FontSet;
import java.awt.Font;
import javax.swing.plaf.FontUIResource;

public final class FontSets {
    private static FontSet logicalFontSet;

    private FontSets() {
    }

    public static FontSet createDefaultFontSet(Font font) {
        return FontSets.createDefaultFontSet(font, null);
    }

    public static FontSet createDefaultFontSet(Font font, Font font2) {
        return FontSets.createDefaultFontSet(font, font2, null, null, null, null);
    }

    public static FontSet createDefaultFontSet(Font font, Font font2, Font font3) {
        return FontSets.createDefaultFontSet(font, font2, font3, null, null, null);
    }

    public static FontSet createDefaultFontSet(Font font, Font font2, Font font3, Font font4, Font font5, Font font6) {
        return new DefaultFontSet(font, font2, font3, font4, font5, font6);
    }

    public static FontSet getLogicalFontSet() {
        if (logicalFontSet == null) {
            logicalFontSet = new LogicalFontSet();
        }
        return logicalFontSet;
    }

    private static final class LogicalFontSet
    implements FontSet {
        private FontUIResource controlFont;
        private FontUIResource titleFont;
        private FontUIResource systemFont;
        private FontUIResource smallFont;

        private LogicalFontSet() {
        }

        public FontUIResource getControlFont() {
            if (this.controlFont == null) {
                this.controlFont = new FontUIResource(Font.getFont("swing.plaf.metal.controlFont", new Font("Dialog", 0, 12)));
            }
            return this.controlFont;
        }

        public FontUIResource getMenuFont() {
            return this.getControlFont();
        }

        public FontUIResource getTitleFont() {
            if (this.titleFont == null) {
                this.titleFont = new FontUIResource(this.getControlFont().deriveFont(1));
            }
            return this.titleFont;
        }

        public FontUIResource getSmallFont() {
            if (this.smallFont == null) {
                this.smallFont = new FontUIResource(Font.getFont("swing.plaf.metal.smallFont", new Font("Dialog", 0, 10)));
            }
            return this.smallFont;
        }

        public FontUIResource getMessageFont() {
            if (this.systemFont == null) {
                this.systemFont = new FontUIResource(Font.getFont("swing.plaf.metal.systemFont", new Font("Dialog", 0, 12)));
            }
            return this.systemFont;
        }

        public FontUIResource getWindowTitleFont() {
            return this.getTitleFont();
        }
    }

    private static final class DefaultFontSet
    implements FontSet {
        private final FontUIResource controlFont;
        private final FontUIResource menuFont;
        private final FontUIResource titleFont;
        private final FontUIResource messageFont;
        private final FontUIResource smallFont;
        private final FontUIResource windowTitleFont;

        public DefaultFontSet(Font font, Font font2, Font font3, Font font4, Font font5, Font font6) {
            this.controlFont = new FontUIResource(font);
            this.menuFont = font2 != null ? new FontUIResource(font2) : this.controlFont;
            this.titleFont = font3 != null ? new FontUIResource(font3) : this.controlFont;
            this.messageFont = font4 != null ? new FontUIResource(font4) : this.controlFont;
            this.smallFont = new FontUIResource(font5 != null ? font5 : font.deriveFont(font.getSize2D() - 2.0f));
            this.windowTitleFont = font6 != null ? new FontUIResource(font6) : this.titleFont;
        }

        public FontUIResource getControlFont() {
            return this.controlFont;
        }

        public FontUIResource getMenuFont() {
            return this.menuFont;
        }

        public FontUIResource getTitleFont() {
            return this.titleFont;
        }

        public FontUIResource getWindowTitleFont() {
            return this.windowTitleFont;
        }

        public FontUIResource getSmallFont() {
            return this.smallFont;
        }

        public FontUIResource getMessageFont() {
            return this.messageFont;
        }
    }
}

