/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.layout;

import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.Container;
import java.io.Serializable;
import java.util.List;

public final class ConstantSize
implements Size,
Serializable {
    public static final Unit PIXEL = new Unit("Pixel", "px", null, true);
    public static final Unit POINT = new Unit("Point", "pt", null, true);
    public static final Unit DIALOG_UNITS_X = new Unit("Dialog units X", "dluX", "dlu", true);
    public static final Unit DIALOG_UNITS_Y = new Unit("Dialog units Y", "dluY", "dlu", true);
    public static final Unit MILLIMETER = new Unit("Millimeter", "mm", null, false);
    public static final Unit CENTIMETER = new Unit("Centimeter", "cm", null, false);
    public static final Unit INCH = new Unit("Inch", "in", null, false);
    public static final Unit PX = PIXEL;
    public static final Unit PT = POINT;
    public static final Unit DLUX = DIALOG_UNITS_X;
    public static final Unit DLUY = DIALOG_UNITS_Y;
    public static final Unit MM = MILLIMETER;
    public static final Unit CM = CENTIMETER;
    public static final Unit IN = INCH;
    private static final Unit[] VALUES = new Unit[]{PIXEL, POINT, DIALOG_UNITS_X, DIALOG_UNITS_Y, MILLIMETER, CENTIMETER, INCH};
    private final double value;
    private final Unit unit;

    public ConstantSize(int n, Unit unit) {
        this.value = n;
        this.unit = unit;
    }

    public ConstantSize(double d, Unit unit) {
        this.value = d;
        this.unit = unit;
    }

    static ConstantSize valueOf(String string, boolean bl) {
        String[] stringArray = ConstantSize.splitValueAndUnit(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        Unit unit = Unit.valueOf(string3, bl);
        double d = Double.parseDouble(string2);
        if (unit.requiresIntegers && d != (double)((int)d)) {
            throw new IllegalArgumentException(unit.toString() + " value " + string2 + " must be an integer.");
        }
        return new ConstantSize(d, unit);
    }

    static ConstantSize dluX(int n) {
        return new ConstantSize(n, DLUX);
    }

    static ConstantSize dluY(int n) {
        return new ConstantSize(n, DLUY);
    }

    public double getValue() {
        return this.value;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public int getPixelSize(Component component) {
        if (this.unit == PIXEL) {
            return this.intValue();
        }
        if (this.unit == POINT) {
            return Sizes.pointAsPixel(this.intValue(), component);
        }
        if (this.unit == INCH) {
            return Sizes.inchAsPixel(this.value, component);
        }
        if (this.unit == MILLIMETER) {
            return Sizes.millimeterAsPixel(this.value, component);
        }
        if (this.unit == CENTIMETER) {
            return Sizes.centimeterAsPixel(this.value, component);
        }
        if (this.unit == DIALOG_UNITS_X) {
            return Sizes.dialogUnitXAsPixel(this.intValue(), component);
        }
        if (this.unit == DIALOG_UNITS_Y) {
            return Sizes.dialogUnitYAsPixel(this.intValue(), component);
        }
        throw new IllegalStateException("Invalid unit " + this.unit);
    }

    public int maximumSize(Container container, List list, FormLayout.Measure measure, FormLayout.Measure measure2, FormLayout.Measure measure3) {
        return this.getPixelSize(container);
    }

    public boolean compressible() {
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ConstantSize)) {
            return false;
        }
        ConstantSize constantSize = (ConstantSize)object;
        return this.value == constantSize.value && this.unit == constantSize.unit;
    }

    public int hashCode() {
        return new Double(this.value).hashCode() + 37 * this.unit.hashCode();
    }

    public String toString() {
        return this.value == (double)this.intValue() ? Integer.toString(this.intValue()) + this.unit.abbreviation() : Double.toString(this.value) + this.unit.abbreviation();
    }

    public String encode() {
        return this.value == (double)this.intValue() ? Integer.toString(this.intValue()) + this.unit.encode() : Double.toString(this.value) + this.unit.encode();
    }

    private int intValue() {
        return (int)Math.round(this.value);
    }

    private static String[] splitValueAndUnit(String string) {
        int n;
        int n2;
        String[] stringArray = new String[2];
        for (n2 = n = string.length(); n2 > 0 && Character.isLetter(string.charAt(n2 - 1)); --n2) {
        }
        stringArray[0] = string.substring(0, n2);
        stringArray[1] = string.substring(n2);
        return stringArray;
    }

    public static final class Unit
    implements Serializable {
        private final transient String name;
        private final transient String abbreviation;
        private final transient String parseAbbreviation;
        final transient boolean requiresIntegers;
        private static int nextOrdinal = 0;
        private final int ordinal = nextOrdinal++;

        private Unit(String string, String string2, String string3, boolean bl) {
            this.name = string;
            this.abbreviation = string2;
            this.parseAbbreviation = string3;
            this.requiresIntegers = bl;
        }

        static Unit valueOf(String string, boolean bl) {
            if (string.length() == 0) {
                Unit unit = Sizes.getDefaultUnit();
                if (unit != null) {
                    return unit;
                }
                return bl ? DIALOG_UNITS_X : DIALOG_UNITS_Y;
            }
            if (string.equals("px")) {
                return PIXEL;
            }
            if (string.equals("dlu")) {
                return bl ? DIALOG_UNITS_X : DIALOG_UNITS_Y;
            }
            if (string.equals("pt")) {
                return POINT;
            }
            if (string.equals("in")) {
                return INCH;
            }
            if (string.equals("mm")) {
                return MILLIMETER;
            }
            if (string.equals("cm")) {
                return CENTIMETER;
            }
            throw new IllegalArgumentException("Invalid unit name '" + string + "'. Must be one of: " + "px, dlu, pt, mm, cm, in");
        }

        public String toString() {
            return this.name;
        }

        public String encode() {
            return this.parseAbbreviation != null ? this.parseAbbreviation : this.abbreviation;
        }

        public String abbreviation() {
            return this.abbreviation;
        }

        private Object readResolve() {
            return VALUES[this.ordinal];
        }
    }
}

