/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.beans;

import com.jgoodies.binding.beans.BeanUtils;
import com.jgoodies.binding.beans.IndirectPropertyChangeSupport;
import com.jgoodies.binding.beans.Model;
import com.jgoodies.binding.beans.PropertyUnboundException;
import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyVetoException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanAdapter<B>
extends Model {
    public static final String PROPERTYNAME_BEFORE_BEAN = "beforeBean";
    public static final String PROPERTYNAME_BEAN = "bean";
    public static final String PROPERTYNAME_AFTER_BEAN = "afterBean";
    public static final String PROPERTYNAME_CHANGED = "changed";
    private final ValueModel beanChannel;
    private final boolean observeChanges;
    private final Map<String, SimplePropertyAdapter> propertyAdapters;
    private IndirectPropertyChangeSupport indirectChangeSupport;
    B storedOldBean;
    private boolean changed = false;
    private PropertyChangeListener propertyChangeHandler;

    public BeanAdapter(B b) {
        this(b, false);
    }

    public BeanAdapter(B b, boolean bl) {
        this(new ValueHolder(b, true), bl);
    }

    public BeanAdapter(ValueModel valueModel) {
        this(valueModel, false);
    }

    public BeanAdapter(ValueModel valueModel, boolean bl) {
        this.beanChannel = valueModel != null ? valueModel : new ValueHolder(null, true);
        this.checkBeanChannelIdentityCheck(valueModel);
        this.observeChanges = bl;
        this.propertyAdapters = new HashMap<String, SimplePropertyAdapter>();
        this.beanChannel.addValueChangeListener(new BeanChangeHandler());
        B b = this.getBean();
        if (b != null) {
            if (bl && !BeanUtils.supportsBoundProperties(this.getBeanClass(b))) {
                throw new PropertyUnboundException("The bean must provide support for listening on property changes as described in section 7.4.5 of the Java Bean Specification.");
            }
            this.addChangeHandlerTo(b);
        }
        this.storedOldBean = b;
    }

    public ValueModel getBeanChannel() {
        return this.beanChannel;
    }

    public B getBean() {
        return (B)this.beanChannel.getValue();
    }

    public void setBean(B b) {
        this.beanChannel.setValue(b);
        this.resetChanged();
    }

    public boolean getObserveChanges() {
        return this.observeChanges;
    }

    public Object getValue(String string) {
        return this.getValueModel(string).getValue();
    }

    public void setValue(String string, Object object) {
        this.getValueModel(string).setValue(object);
    }

    public void setVetoableValue(String string, Object object) throws PropertyVetoException {
        this.getValueModel(string).setVetoableValue(object);
    }

    public SimplePropertyAdapter getValueModel(String string) {
        return this.getValueModel(string, null, null);
    }

    public SimplePropertyAdapter getValueModel(String string, String string2, String string3) {
        if (string == null) {
            throw new NullPointerException("The property name must not be null.");
        }
        SimplePropertyAdapter simplePropertyAdapter = this.getPropertyAdapter(string);
        if (simplePropertyAdapter == null) {
            simplePropertyAdapter = this.createPropertyAdapter(string, string2, string3);
            this.propertyAdapters.put(string, simplePropertyAdapter);
        } else if (!this.equals(string2, simplePropertyAdapter.getterName) || !this.equals(string3, simplePropertyAdapter.setterName)) {
            throw new IllegalArgumentException("You must not invoke this method twice with different getter and/or setter names.");
        }
        return simplePropertyAdapter;
    }

    SimplePropertyAdapter getPropertyAdapter(String string) {
        return this.propertyAdapters.get(string);
    }

    protected SimplePropertyAdapter createPropertyAdapter(String string, String string2, String string3) {
        return new SimplePropertyAdapter(string, string2, string3);
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void resetChanged() {
        this.setChanged(false);
    }

    private void setChanged(boolean bl) {
        boolean bl2 = this.isChanged();
        this.changed = bl;
        this.firePropertyChange(PROPERTYNAME_CHANGED, bl2, bl);
    }

    public synchronized void addBeanPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.indirectChangeSupport == null) {
            this.indirectChangeSupport = new IndirectPropertyChangeSupport(this.beanChannel);
        }
        this.indirectChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removeBeanPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || this.indirectChangeSupport == null) {
            return;
        }
        this.indirectChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addBeanPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.indirectChangeSupport == null) {
            this.indirectChangeSupport = new IndirectPropertyChangeSupport(this.beanChannel);
        }
        this.indirectChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removeBeanPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || this.indirectChangeSupport == null) {
            return;
        }
        this.indirectChangeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getBeanPropertyChangeListeners() {
        if (this.indirectChangeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.indirectChangeSupport.getPropertyChangeListeners();
    }

    public synchronized PropertyChangeListener[] getBeanPropertyChangeListeners(String string) {
        if (this.indirectChangeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.indirectChangeSupport.getPropertyChangeListeners(string);
    }

    public synchronized void release() {
        this.removeChangeHandlerFrom(this.getBean());
        if (this.indirectChangeSupport != null) {
            this.indirectChangeSupport.removeAll();
        }
    }

    private void setBean0(B b, B b2) {
        this.firePropertyChange(PROPERTYNAME_BEFORE_BEAN, b, b2, true);
        this.removeChangeHandlerFrom(b);
        this.forwardAllAdaptedValuesChanged(b, b2);
        this.resetChanged();
        this.addChangeHandlerTo(b2);
        this.firePropertyChange(PROPERTYNAME_BEAN, b, b2, true);
        this.firePropertyChange(PROPERTYNAME_AFTER_BEAN, b, b2, true);
    }

    private void forwardAllAdaptedValuesChanged(B b, B b2) {
        Object[] objectArray;
        for (Object object : objectArray = this.propertyAdapters.values().toArray()) {
            ((SimplePropertyAdapter)object).setBean0(b, b2);
        }
    }

    private void forwardAllAdaptedValuesChanged() {
        Object[] objectArray;
        B b = this.getBean();
        for (Object object : objectArray = this.propertyAdapters.values().toArray()) {
            ((SimplePropertyAdapter)object).fireChange(b);
        }
    }

    private void addChangeHandlerTo(B b) {
        if (!this.observeChanges || b == null) {
            return;
        }
        this.propertyChangeHandler = new PropertyChangeHandler();
        BeanUtils.addPropertyChangeListener(b, this.getBeanClass(b), this.propertyChangeHandler);
    }

    private void removeChangeHandlerFrom(B b) {
        if (!this.observeChanges || b == null || this.propertyChangeHandler == null) {
            return;
        }
        BeanUtils.removePropertyChangeListener(b, this.getBeanClass(b), this.propertyChangeHandler);
        this.propertyChangeHandler = null;
    }

    private Class<?> getBeanClass(B b) {
        return b.getClass();
    }

    private Object getValue0(B b, PropertyDescriptor propertyDescriptor) {
        return b == null ? null : BeanUtils.getValue(b, propertyDescriptor);
    }

    private void setValue0(B b, PropertyDescriptor propertyDescriptor, Object object) throws PropertyVetoException {
        BeanUtils.setValue(b, propertyDescriptor, object);
    }

    private void checkBeanChannelIdentityCheck(ValueModel valueModel) {
        if (!(valueModel instanceof ValueHolder)) {
            return;
        }
        ValueHolder valueHolder = (ValueHolder)valueModel;
        if (!valueHolder.isIdentityCheckEnabled()) {
            throw new IllegalArgumentException("The bean channel must have the identity check enabled.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SimplePropertyAdapter
    extends AbstractValueModel {
        private final String propertyName;
        final String getterName;
        final String setterName;
        private PropertyDescriptor cachedPropertyDescriptor;
        private Class<?> cachedBeanClass;

        protected SimplePropertyAdapter(String string, String string2, String string3) {
            this.propertyName = string;
            this.getterName = string2;
            this.setterName = string3;
            Object b = BeanAdapter.this.getBean();
            if (b != null) {
                this.getPropertyDescriptor(b);
            }
        }

        @Override
        public Object getValue() {
            Object b = BeanAdapter.this.getBean();
            return b == null ? null : BeanAdapter.this.getValue0(b, this.getPropertyDescriptor(b));
        }

        @Override
        public void setValue(Object object) {
            Object b = BeanAdapter.this.getBean();
            if (b == null) {
                return;
            }
            try {
                BeanAdapter.this.setValue0(b, this.getPropertyDescriptor(b), object);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        public void setVetoableValue(Object object) throws PropertyVetoException {
            Object b = BeanAdapter.this.getBean();
            if (b == null) {
                return;
            }
            BeanAdapter.this.setValue0(b, this.getPropertyDescriptor(b), object);
        }

        private PropertyDescriptor getPropertyDescriptor(B b) {
            Class clazz = BeanAdapter.this.getBeanClass(b);
            if (this.cachedPropertyDescriptor == null || clazz != this.cachedBeanClass) {
                this.cachedPropertyDescriptor = BeanUtils.getPropertyDescriptor(clazz, this.propertyName, this.getterName, this.setterName);
                this.cachedBeanClass = clazz;
            }
            return this.cachedPropertyDescriptor;
        }

        protected void fireChange(B b) {
            Object object;
            if (b == null) {
                object = null;
            } else {
                PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(b);
                boolean bl = null == propertyDescriptor.getReadMethod();
                object = bl ? null : BeanAdapter.this.getValue0(b, propertyDescriptor);
            }
            this.fireValueChange(null, object);
        }

        protected void setBean0(B b, B b2) {
            Object object;
            boolean bl;
            PropertyDescriptor propertyDescriptor;
            Object object2;
            if (b == null) {
                object2 = null;
            } else {
                propertyDescriptor = this.getPropertyDescriptor(b);
                bl = null == propertyDescriptor.getReadMethod();
                Object object3 = object2 = bl ? null : BeanAdapter.this.getValue0(b, propertyDescriptor);
            }
            if (b2 == null) {
                object = null;
            } else {
                propertyDescriptor = this.getPropertyDescriptor(b2);
                bl = null == propertyDescriptor.getReadMethod();
                Object object4 = object = bl ? null : BeanAdapter.this.getValue0(b2, propertyDescriptor);
            }
            if (object2 != null || object != null) {
                this.fireValueChange(object2, object, true);
            }
        }

        @Override
        protected String paramString() {
            Object b = BeanAdapter.this.getBean();
            String string = null;
            Object object = this.getValue();
            String string2 = null;
            String string3 = null;
            String string4 = null;
            Method method = null;
            if (b != null) {
                string = b.getClass().getName();
                string2 = object == null ? null : object.getClass().getName();
                PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(b);
                string3 = propertyDescriptor.getName();
                string4 = propertyDescriptor.getPropertyType().getName();
                method = propertyDescriptor.getWriteMethod();
            }
            return "bean=" + b + "; bean type=" + string + "; value=" + object + "; value type=" + string2 + "; property name=" + string3 + "; property type=" + string4 + "; property setter=" + method;
        }
    }

    private final class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            BeanAdapter.this.setChanged(true);
            String string = propertyChangeEvent.getPropertyName();
            if (string == null) {
                BeanAdapter.this.forwardAllAdaptedValuesChanged();
            } else {
                SimplePropertyAdapter simplePropertyAdapter = BeanAdapter.this.getPropertyAdapter(string);
                if (simplePropertyAdapter != null) {
                    simplePropertyAdapter.fireValueChange(propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue(), true);
                }
            }
        }
    }

    private final class BeanChangeHandler
    implements PropertyChangeListener {
        private BeanChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getNewValue() != null ? propertyChangeEvent.getNewValue() : BeanAdapter.this.getBean();
            BeanAdapter.this.setBean0(BeanAdapter.this.storedOldBean, object);
            BeanAdapter.this.storedOldBean = object;
        }
    }
}

