/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractHashFunction;
import com.google.common.hash.AbstractHasher;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedBytes;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import javax.annotation.Nullable;

final class Murmur3_32HashFunction
extends AbstractHashFunction
implements Serializable {
    static final HashFunction MURMUR3_32 = new Murmur3_32HashFunction(0);
    static final HashFunction GOOD_FAST_HASH_32 = new Murmur3_32HashFunction(Hashing.GOOD_FAST_HASH_SEED);
    private static final int CHUNK_SIZE = 4;
    private static final int C1 = -862048943;
    private static final int C2 = 461845907;
    private final int seed;
    private static final long serialVersionUID = 0L;

    Murmur3_32HashFunction(int n) {
        this.seed = n;
    }

    @Override
    public int bits() {
        return 32;
    }

    @Override
    public Hasher newHasher() {
        return new Murmur3_32Hasher(this.seed);
    }

    public String toString() {
        return "Hashing.murmur3_32(" + this.seed + ")";
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof Murmur3_32HashFunction) {
            Murmur3_32HashFunction murmur3_32HashFunction = (Murmur3_32HashFunction)object;
            return this.seed == murmur3_32HashFunction.seed;
        }
        return false;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.seed;
    }

    @Override
    public HashCode hashInt(int n) {
        int n2 = Murmur3_32HashFunction.mixK1(n);
        int n3 = Murmur3_32HashFunction.mixH1(this.seed, n2);
        return Murmur3_32HashFunction.fmix(n3, 4);
    }

    @Override
    public HashCode hashLong(long l) {
        int n = (int)l;
        int n2 = (int)(l >>> 32);
        int n3 = Murmur3_32HashFunction.mixK1(n);
        int n4 = Murmur3_32HashFunction.mixH1(this.seed, n3);
        n3 = Murmur3_32HashFunction.mixK1(n2);
        n4 = Murmur3_32HashFunction.mixH1(n4, n3);
        return Murmur3_32HashFunction.fmix(n4, 8);
    }

    @Override
    public HashCode hashUnencodedChars(CharSequence charSequence) {
        int n;
        int n2 = this.seed;
        for (n = 1; n < charSequence.length(); n += 2) {
            int n3 = charSequence.charAt(n - 1) | charSequence.charAt(n) << 16;
            n3 = Murmur3_32HashFunction.mixK1(n3);
            n2 = Murmur3_32HashFunction.mixH1(n2, n3);
        }
        if ((charSequence.length() & 1) == 1) {
            n = charSequence.charAt(charSequence.length() - 1);
            n = Murmur3_32HashFunction.mixK1(n);
            n2 ^= n;
        }
        return Murmur3_32HashFunction.fmix(n2, 2 * charSequence.length());
    }

    @Override
    public HashCode hashString(CharSequence charSequence, Charset charset) {
        if (Charsets.UTF_8.equals(charset)) {
            int n;
            int n2;
            int n3 = charSequence.length();
            int n4 = this.seed;
            int n5 = 0;
            int n6 = 0;
            while (n5 + 4 <= n3) {
                char c2 = charSequence.charAt(n5);
                char c3 = charSequence.charAt(n5 + 1);
                n2 = charSequence.charAt(n5 + 2);
                char c = charSequence.charAt(n5 + 3);
                if (c2 >= '\u0080' || c3 >= '\u0080' || n2 >= 128 || c >= '\u0080') break;
                n = c2 | c3 << 8 | n2 << 16 | c << 24;
                n = Murmur3_32HashFunction.mixK1(n);
                n4 = Murmur3_32HashFunction.mixH1(n4, n);
                n5 += 4;
                n6 += 4;
            }
            long l = 0L;
            n2 = 0;
            while (n5 < n3) {
                char c = charSequence.charAt(n5);
                if (c < '\u0080') {
                    l |= (long)c << n2;
                    n2 += 8;
                    ++n6;
                } else if (c < '\u0800') {
                    l |= Murmur3_32HashFunction.charToTwoUtf8Bytes(c) << n2;
                    n2 += 16;
                    n6 += 2;
                } else if (c < '\ud800' || c > '\udfff') {
                    l |= Murmur3_32HashFunction.charToThreeUtf8Bytes(c) << n2;
                    n2 += 24;
                    n6 += 3;
                } else {
                    n = Character.codePointAt(charSequence, n5);
                    if (n == c) {
                        return this.hashBytes(charSequence.toString().getBytes(charset));
                    }
                    ++n5;
                    l |= Murmur3_32HashFunction.codePointToFourUtf8Bytes(n) << n2;
                    n6 += 4;
                }
                if (n2 >= 32) {
                    n = Murmur3_32HashFunction.mixK1((int)l);
                    n4 = Murmur3_32HashFunction.mixH1(n4, n);
                    l >>>= 32;
                    n2 -= 32;
                }
                ++n5;
            }
            int n7 = Murmur3_32HashFunction.mixK1((int)l);
            return Murmur3_32HashFunction.fmix(n4 ^= n7, n6);
        }
        return this.hashBytes(charSequence.toString().getBytes(charset));
    }

    @Override
    public HashCode hashBytes(byte[] byArray, int n, int n2) {
        int n3;
        Preconditions.checkPositionIndexes(n, n + n2, byArray.length);
        int n4 = this.seed;
        int n5 = 0;
        while (n5 + 4 <= n2) {
            n3 = Murmur3_32HashFunction.mixK1(Murmur3_32HashFunction.getIntLittleEndian(byArray, n + n5));
            n4 = Murmur3_32HashFunction.mixH1(n4, n3);
            n5 += 4;
        }
        n3 = 0;
        int n6 = 0;
        while (n5 < n2) {
            n3 ^= UnsignedBytes.toInt(byArray[n + n5]) << n6;
            ++n5;
            n6 += 8;
        }
        return Murmur3_32HashFunction.fmix(n4 ^= Murmur3_32HashFunction.mixK1(n3), n2);
    }

    private static int getIntLittleEndian(byte[] byArray, int n) {
        return Ints.fromBytes(byArray[n + 3], byArray[n + 2], byArray[n + 1], byArray[n]);
    }

    private static int mixK1(int n) {
        n *= -862048943;
        n = Integer.rotateLeft(n, 15);
        return n *= 461845907;
    }

    private static int mixH1(int n, int n2) {
        n ^= n2;
        n = Integer.rotateLeft(n, 13);
        n = n * 5 + -430675100;
        return n;
    }

    private static HashCode fmix(int n, int n2) {
        n ^= n2;
        n ^= n >>> 16;
        n *= -2048144789;
        n ^= n >>> 13;
        n *= -1028477387;
        n ^= n >>> 16;
        return HashCode.fromInt(n);
    }

    private static long codePointToFourUtf8Bytes(int n) {
        return (0xF0L | (long)(n >>> 18)) & 0xFFL | (0x80L | (long)(0x3F & n >>> 12)) << 8 | (0x80L | (long)(0x3F & n >>> 6)) << 16 | (0x80L | (long)(0x3F & n)) << 24;
    }

    private static long charToThreeUtf8Bytes(char c) {
        return (0x1E0 | c >>> 12) & 0xFF | (0x80 | 0x3F & c >>> 6) << 8 | (0x80 | 0x3F & c) << 16;
    }

    private static long charToTwoUtf8Bytes(char c) {
        return (0x3C0 | c >>> 6) & 0xFF | (0x80 | 0x3F & c) << 8;
    }

    @CanIgnoreReturnValue
    private static final class Murmur3_32Hasher
    extends AbstractHasher {
        private int h1;
        private long buffer;
        private int shift;
        private int length;
        private boolean isDone;

        Murmur3_32Hasher(int n) {
            this.h1 = n;
            this.length = 0;
            this.isDone = false;
        }

        private void update(int n, long l) {
            this.buffer |= (l & 0xFFFFFFFFL) << this.shift;
            this.shift += n * 8;
            this.length += n;
            if (this.shift >= 32) {
                this.h1 = Murmur3_32HashFunction.mixH1(this.h1, Murmur3_32HashFunction.mixK1((int)this.buffer));
                this.buffer >>>= 32;
                this.shift -= 32;
            }
        }

        @Override
        public Hasher putByte(byte by) {
            this.update(1, by & 0xFF);
            return this;
        }

        @Override
        public Hasher putBytes(byte[] byArray, int n, int n2) {
            Preconditions.checkPositionIndexes(n, n + n2, byArray.length);
            int n3 = 0;
            while (n3 + 4 <= n2) {
                this.update(4, Murmur3_32HashFunction.getIntLittleEndian(byArray, n + n3));
                n3 += 4;
            }
            while (n3 < n2) {
                this.putByte(byArray[n + n3]);
                ++n3;
            }
            return this;
        }

        @Override
        public Hasher putBytes(ByteBuffer byteBuffer) {
            ByteOrder byteOrder = byteBuffer.order();
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            while (byteBuffer.remaining() >= 4) {
                this.putInt(byteBuffer.getInt());
            }
            while (byteBuffer.hasRemaining()) {
                this.putByte(byteBuffer.get());
            }
            byteBuffer.order(byteOrder);
            return this;
        }

        @Override
        public Hasher putInt(int n) {
            this.update(4, n);
            return this;
        }

        @Override
        public Hasher putLong(long l) {
            this.update(4, (int)l);
            this.update(4, l >>> 32);
            return this;
        }

        @Override
        public Hasher putChar(char c) {
            this.update(2, c);
            return this;
        }

        @Override
        public Hasher putString(CharSequence charSequence, Charset charset) {
            if (Charsets.UTF_8.equals(charset)) {
                int n;
                char c;
                int n2 = charSequence.length();
                int n3 = 0;
                while (n3 + 4 <= n2) {
                    c = charSequence.charAt(n3);
                    n = charSequence.charAt(n3 + 1);
                    char c2 = charSequence.charAt(n3 + 2);
                    char c3 = charSequence.charAt(n3 + 3);
                    if (c >= '\u0080' || n >= 128 || c2 >= '\u0080' || c3 >= '\u0080') break;
                    this.update(4, c | n << 8 | c2 << 16 | c3 << 24);
                    n3 += 4;
                }
                while (n3 < n2) {
                    c = charSequence.charAt(n3);
                    if (c < '\u0080') {
                        this.update(1, c);
                    } else if (c < '\u0800') {
                        this.update(2, Murmur3_32HashFunction.charToTwoUtf8Bytes(c));
                    } else if (c < '\ud800' || c > '\udfff') {
                        this.update(3, Murmur3_32HashFunction.charToThreeUtf8Bytes(c));
                    } else {
                        n = Character.codePointAt(charSequence, n3);
                        if (n == c) {
                            this.putBytes(charSequence.subSequence(n3, n2).toString().getBytes(charset));
                            return this;
                        }
                        ++n3;
                        this.update(4, Murmur3_32HashFunction.codePointToFourUtf8Bytes(n));
                    }
                    ++n3;
                }
                return this;
            }
            return super.putString(charSequence, charset);
        }

        @Override
        public HashCode hash() {
            Preconditions.checkState(!this.isDone);
            this.isDone = true;
            this.h1 ^= Murmur3_32HashFunction.mixK1((int)this.buffer);
            return Murmur3_32HashFunction.fmix(this.h1, this.length);
        }
    }
}

