/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractHasher;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@CanIgnoreReturnValue
abstract class AbstractStreamingHasher
extends AbstractHasher {
    private final ByteBuffer buffer;
    private final int bufferSize;
    private final int chunkSize;

    protected AbstractStreamingHasher(int n) {
        this(n, n);
    }

    protected AbstractStreamingHasher(int n, int n2) {
        Preconditions.checkArgument(n2 % n == 0);
        this.buffer = ByteBuffer.allocate(n2 + 7).order(ByteOrder.LITTLE_ENDIAN);
        this.bufferSize = n2;
        this.chunkSize = n;
    }

    protected abstract void process(ByteBuffer var1);

    protected void processRemaining(ByteBuffer byteBuffer) {
        byteBuffer.position(byteBuffer.limit());
        byteBuffer.limit(this.chunkSize + 7);
        while (byteBuffer.position() < this.chunkSize) {
            byteBuffer.putLong(0L);
        }
        byteBuffer.limit(this.chunkSize);
        byteBuffer.flip();
        this.process(byteBuffer);
    }

    @Override
    public final Hasher putBytes(byte[] byArray, int n, int n2) {
        return this.putBytesInternal(ByteBuffer.wrap(byArray, n, n2).order(ByteOrder.LITTLE_ENDIAN));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Hasher putBytes(ByteBuffer byteBuffer) {
        ByteOrder byteOrder = byteBuffer.order();
        try {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            Hasher hasher = this.putBytesInternal(byteBuffer);
            return hasher;
        }
        finally {
            byteBuffer.order(byteOrder);
        }
    }

    private Hasher putBytesInternal(ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() <= this.buffer.remaining()) {
            this.buffer.put(byteBuffer);
            this.munchIfFull();
            return this;
        }
        int n = this.bufferSize - this.buffer.position();
        for (int i = 0; i < n; ++i) {
            this.buffer.put(byteBuffer.get());
        }
        this.munch();
        while (byteBuffer.remaining() >= this.chunkSize) {
            this.process(byteBuffer);
        }
        this.buffer.put(byteBuffer);
        return this;
    }

    @Override
    public final Hasher putByte(byte by) {
        this.buffer.put(by);
        this.munchIfFull();
        return this;
    }

    @Override
    public final Hasher putShort(short s) {
        this.buffer.putShort(s);
        this.munchIfFull();
        return this;
    }

    @Override
    public final Hasher putChar(char c) {
        this.buffer.putChar(c);
        this.munchIfFull();
        return this;
    }

    @Override
    public final Hasher putInt(int n) {
        this.buffer.putInt(n);
        this.munchIfFull();
        return this;
    }

    @Override
    public final Hasher putLong(long l) {
        this.buffer.putLong(l);
        this.munchIfFull();
        return this;
    }

    @Override
    public final HashCode hash() {
        this.munch();
        this.buffer.flip();
        if (this.buffer.remaining() > 0) {
            this.processRemaining(this.buffer);
            this.buffer.position(this.buffer.limit());
        }
        return this.makeHash();
    }

    protected abstract HashCode makeHash();

    private void munchIfFull() {
        if (this.buffer.remaining() < 8) {
            this.munch();
        }
    }

    private void munch() {
        this.buffer.flip();
        while (this.buffer.remaining() >= this.chunkSize) {
            this.process(this.buffer);
        }
        this.buffer.compact();
    }
}

