/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.LexicographicalOrdering;
import com.google.common.collect.TopKSelector;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collector;

@Beta
@GwtCompatible
public final class Comparators {
    private Comparators() {
    }

    public static <T, S extends T> Comparator<Iterable<S>> lexicographical(Comparator<T> comparator) {
        return new LexicographicalOrdering<T>(Preconditions.checkNotNull(comparator));
    }

    public static <T> boolean isInOrder(Iterable<? extends T> iterable, Comparator<T> comparator) {
        Preconditions.checkNotNull(comparator);
        Iterator<T> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            T t = iterator.next();
            while (iterator.hasNext()) {
                T t2 = iterator.next();
                if (comparator.compare(t, t2) > 0) {
                    return false;
                }
                t = t2;
            }
        }
        return true;
    }

    public static <T> boolean isInStrictOrder(Iterable<? extends T> iterable, Comparator<T> comparator) {
        Preconditions.checkNotNull(comparator);
        Iterator<T> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            T t = iterator.next();
            while (iterator.hasNext()) {
                T t2 = iterator.next();
                if (comparator.compare(t, t2) >= 0) {
                    return false;
                }
                t = t2;
            }
        }
        return true;
    }

    public static <T> Collector<T, ?, List<T>> least(int n, Comparator<? super T> comparator) {
        CollectPreconditions.checkNonnegative(n, "k");
        Preconditions.checkNotNull(comparator);
        return Collector.of(() -> TopKSelector.least(n, comparator), TopKSelector::offer, TopKSelector::combine, TopKSelector::topK, Collector.Characteristics.UNORDERED);
    }

    public static <T> Collector<T, ?, List<T>> greatest(int n, Comparator<? super T> comparator) {
        return Comparators.least(n, comparator.reversed());
    }

    @Beta
    public static <T> Comparator<Optional<T>> emptiesFirst(Comparator<T> comparator) {
        Preconditions.checkNotNull(comparator);
        return Comparator.comparing(optional -> optional.orElse(null), Comparator.nullsFirst(comparator));
    }

    @Beta
    public static <T> Comparator<Optional<T>> emptiesLast(Comparator<T> comparator) {
        Preconditions.checkNotNull(comparator);
        return Comparator.comparing(optional -> optional.orElse(null), Comparator.nullsLast(comparator));
    }
}

