/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserMinimalBase;
import com.fasterxml.jackson.core.json.JsonReadContext;
import com.fasterxml.jackson.core.json.JsonWriteContext;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import com.fasterxml.jackson.databind.util.RawValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.TreeMap;

public class TokenBuffer
extends JsonGenerator {
    protected static final int DEFAULT_GENERATOR_FEATURES = JsonGenerator.Feature.collectDefaults();
    protected ObjectCodec _objectCodec;
    protected int _generatorFeatures;
    protected boolean _closed;
    protected boolean _hasNativeTypeIds;
    protected boolean _hasNativeObjectIds;
    protected boolean _mayHaveNativeIds;
    protected boolean _forceBigDecimal;
    protected Segment _first;
    protected Segment _last;
    protected int _appendAt;
    protected Object _typeId;
    protected Object _objectId;
    protected boolean _hasNativeId = false;
    protected JsonWriteContext _writeContext;

    @Deprecated
    public TokenBuffer(ObjectCodec objectCodec) {
        this(objectCodec, false);
    }

    public TokenBuffer(ObjectCodec objectCodec, boolean bl) {
        this._objectCodec = objectCodec;
        this._generatorFeatures = DEFAULT_GENERATOR_FEATURES;
        this._writeContext = JsonWriteContext.createRootContext(null);
        this._first = this._last = new Segment();
        this._appendAt = 0;
        this._hasNativeTypeIds = bl;
        this._hasNativeObjectIds = bl;
        this._mayHaveNativeIds = this._hasNativeTypeIds | this._hasNativeObjectIds;
    }

    public TokenBuffer(JsonParser jsonParser) {
        this(jsonParser, null);
    }

    public TokenBuffer(JsonParser jsonParser, DeserializationContext deserializationContext) {
        this._objectCodec = jsonParser.getCodec();
        this._generatorFeatures = DEFAULT_GENERATOR_FEATURES;
        this._writeContext = JsonWriteContext.createRootContext(null);
        this._first = this._last = new Segment();
        this._appendAt = 0;
        this._hasNativeTypeIds = jsonParser.canReadTypeId();
        this._hasNativeObjectIds = jsonParser.canReadObjectId();
        this._mayHaveNativeIds = this._hasNativeTypeIds | this._hasNativeObjectIds;
        this._forceBigDecimal = deserializationContext == null ? false : deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
    }

    public TokenBuffer forceUseOfBigDecimal(boolean bl) {
        this._forceBigDecimal = bl;
        return this;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    public JsonParser asParser() {
        return this.asParser(this._objectCodec);
    }

    public JsonParser asParser(ObjectCodec objectCodec) {
        return new Parser(this._first, objectCodec, this._hasNativeTypeIds, this._hasNativeObjectIds);
    }

    public JsonParser asParser(JsonParser jsonParser) {
        Parser parser = new Parser(this._first, jsonParser.getCodec(), this._hasNativeTypeIds, this._hasNativeObjectIds);
        parser.setLocation(jsonParser.getTokenLocation());
        return parser;
    }

    public JsonToken firstToken() {
        if (this._first != null) {
            return this._first.type(0);
        }
        return null;
    }

    public TokenBuffer append(TokenBuffer tokenBuffer) throws IOException {
        if (!this._hasNativeTypeIds) {
            this._hasNativeTypeIds = tokenBuffer.canWriteTypeId();
        }
        if (!this._hasNativeObjectIds) {
            this._hasNativeObjectIds = tokenBuffer.canWriteObjectId();
        }
        this._mayHaveNativeIds = this._hasNativeTypeIds | this._hasNativeObjectIds;
        JsonParser jsonParser = tokenBuffer.asParser();
        while (jsonParser.nextToken() != null) {
            this.copyCurrentStructure(jsonParser);
        }
        return this;
    }

    public void serialize(JsonGenerator jsonGenerator) throws IOException {
        boolean bl;
        Segment segment = this._first;
        int n = -1;
        boolean bl2 = this._mayHaveNativeIds;
        boolean bl3 = bl = bl2 && segment.hasIds();
        while (true) {
            Object object;
            JsonToken jsonToken;
            if (++n >= 16) {
                n = 0;
                if ((segment = segment.next()) == null) break;
                boolean bl4 = bl = bl2 && segment.hasIds();
            }
            if ((jsonToken = segment.type(n)) == null) break;
            if (bl) {
                object = segment.findObjectId(n);
                if (object != null) {
                    jsonGenerator.writeObjectId(object);
                }
                if ((object = segment.findTypeId(n)) != null) {
                    jsonGenerator.writeTypeId(object);
                }
            }
            switch (jsonToken) {
                case START_OBJECT: {
                    jsonGenerator.writeStartObject();
                    break;
                }
                case END_OBJECT: {
                    jsonGenerator.writeEndObject();
                    break;
                }
                case START_ARRAY: {
                    jsonGenerator.writeStartArray();
                    break;
                }
                case END_ARRAY: {
                    jsonGenerator.writeEndArray();
                    break;
                }
                case FIELD_NAME: {
                    object = segment.get(n);
                    if (object instanceof SerializableString) {
                        jsonGenerator.writeFieldName((SerializableString)object);
                        break;
                    }
                    jsonGenerator.writeFieldName((String)object);
                    break;
                }
                case VALUE_STRING: {
                    object = segment.get(n);
                    if (object instanceof SerializableString) {
                        jsonGenerator.writeString((SerializableString)object);
                        break;
                    }
                    jsonGenerator.writeString((String)object);
                    break;
                }
                case VALUE_NUMBER_INT: {
                    object = segment.get(n);
                    if (object instanceof Integer) {
                        jsonGenerator.writeNumber((Integer)object);
                        break;
                    }
                    if (object instanceof BigInteger) {
                        jsonGenerator.writeNumber((BigInteger)object);
                        break;
                    }
                    if (object instanceof Long) {
                        jsonGenerator.writeNumber((Long)object);
                        break;
                    }
                    if (object instanceof Short) {
                        jsonGenerator.writeNumber((Short)object);
                        break;
                    }
                    jsonGenerator.writeNumber(((Number)object).intValue());
                    break;
                }
                case VALUE_NUMBER_FLOAT: {
                    object = segment.get(n);
                    if (object instanceof Double) {
                        jsonGenerator.writeNumber((Double)object);
                        break;
                    }
                    if (object instanceof BigDecimal) {
                        jsonGenerator.writeNumber((BigDecimal)object);
                        break;
                    }
                    if (object instanceof Float) {
                        jsonGenerator.writeNumber(((Float)object).floatValue());
                        break;
                    }
                    if (object == null) {
                        jsonGenerator.writeNull();
                        break;
                    }
                    if (object instanceof String) {
                        jsonGenerator.writeNumber((String)object);
                        break;
                    }
                    throw new JsonGenerationException(String.format("Unrecognized value type for VALUE_NUMBER_FLOAT: %s, can not serialize", object.getClass().getName()), jsonGenerator);
                }
                case VALUE_TRUE: {
                    jsonGenerator.writeBoolean(true);
                    break;
                }
                case VALUE_FALSE: {
                    jsonGenerator.writeBoolean(false);
                    break;
                }
                case VALUE_NULL: {
                    jsonGenerator.writeNull();
                    break;
                }
                case VALUE_EMBEDDED_OBJECT: {
                    object = segment.get(n);
                    if (object instanceof RawValue) {
                        ((RawValue)object).serialize(jsonGenerator);
                        break;
                    }
                    jsonGenerator.writeObject(object);
                    break;
                }
                default: {
                    throw new RuntimeException("Internal error: should never end up through this code path");
                }
            }
        }
    }

    public TokenBuffer deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonToken jsonToken;
        if (jsonParser.getCurrentTokenId() != JsonToken.FIELD_NAME.id()) {
            this.copyCurrentStructure(jsonParser);
            return this;
        }
        this.writeStartObject();
        do {
            this.copyCurrentStructure(jsonParser);
        } while ((jsonToken = jsonParser.nextToken()) == JsonToken.FIELD_NAME);
        if (jsonToken != JsonToken.END_OBJECT) {
            deserializationContext.reportWrongTokenException(jsonParser, JsonToken.END_OBJECT, "Expected END_OBJECT after copying contents of a JsonParser into TokenBuffer, got " + (Object)((Object)jsonToken), new Object[0]);
        }
        this.writeEndObject();
        return this;
    }

    public String toString() {
        int n = 100;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[TokenBuffer: ");
        JsonParser jsonParser = this.asParser();
        int n2 = 0;
        boolean bl = this._hasNativeTypeIds || this._hasNativeObjectIds;
        while (true) {
            try {
                JsonToken jsonToken = jsonParser.nextToken();
                if (jsonToken == null) break;
                if (bl) {
                    this._appendNativeIds(stringBuilder);
                }
                if (n2 < 100) {
                    if (n2 > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(jsonToken.toString());
                    if (jsonToken == JsonToken.FIELD_NAME) {
                        stringBuilder.append('(');
                        stringBuilder.append(jsonParser.getCurrentName());
                        stringBuilder.append(')');
                    }
                }
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
            ++n2;
        }
        if (n2 >= 100) {
            stringBuilder.append(" ... (truncated ").append(n2 - 100).append(" entries)");
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private final void _appendNativeIds(StringBuilder stringBuilder) {
        Object object;
        Object object2 = this._last.findObjectId(this._appendAt - 1);
        if (object2 != null) {
            stringBuilder.append("[objectId=").append(String.valueOf(object2)).append(']');
        }
        if ((object = this._last.findTypeId(this._appendAt - 1)) != null) {
            stringBuilder.append("[typeId=").append(String.valueOf(object)).append(']');
        }
    }

    @Override
    public JsonGenerator enable(JsonGenerator.Feature feature) {
        this._generatorFeatures |= feature.getMask();
        return this;
    }

    @Override
    public JsonGenerator disable(JsonGenerator.Feature feature) {
        this._generatorFeatures &= ~feature.getMask();
        return this;
    }

    @Override
    public boolean isEnabled(JsonGenerator.Feature feature) {
        return (this._generatorFeatures & feature.getMask()) != 0;
    }

    @Override
    public int getFeatureMask() {
        return this._generatorFeatures;
    }

    @Override
    @Deprecated
    public JsonGenerator setFeatureMask(int n) {
        this._generatorFeatures = n;
        return this;
    }

    @Override
    public JsonGenerator overrideStdFeatures(int n, int n2) {
        int n3 = this.getFeatureMask();
        this._generatorFeatures = n3 & ~n2 | n & n2;
        return this;
    }

    @Override
    public JsonGenerator useDefaultPrettyPrinter() {
        return this;
    }

    @Override
    public JsonGenerator setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
        return this;
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public final JsonWriteContext getOutputContext() {
        return this._writeContext;
    }

    @Override
    public boolean canWriteBinaryNatively() {
        return true;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this._closed = true;
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public final void writeStartArray() throws IOException {
        this._writeContext.writeValue();
        this._append(JsonToken.START_ARRAY);
        this._writeContext = this._writeContext.createChildArrayContext();
    }

    @Override
    public final void writeEndArray() throws IOException {
        this._append(JsonToken.END_ARRAY);
        JsonWriteContext jsonWriteContext = this._writeContext.getParent();
        if (jsonWriteContext != null) {
            this._writeContext = jsonWriteContext;
        }
    }

    @Override
    public final void writeStartObject() throws IOException {
        this._writeContext.writeValue();
        this._append(JsonToken.START_OBJECT);
        this._writeContext = this._writeContext.createChildObjectContext();
    }

    @Override
    public void writeStartObject(Object object) throws IOException {
        JsonWriteContext jsonWriteContext;
        this._writeContext.writeValue();
        this._append(JsonToken.START_OBJECT);
        this._writeContext = jsonWriteContext = this._writeContext.createChildObjectContext();
        if (object != null) {
            jsonWriteContext.setCurrentValue(object);
        }
    }

    @Override
    public final void writeEndObject() throws IOException {
        this._append(JsonToken.END_OBJECT);
        JsonWriteContext jsonWriteContext = this._writeContext.getParent();
        if (jsonWriteContext != null) {
            this._writeContext = jsonWriteContext;
        }
    }

    @Override
    public final void writeFieldName(String string) throws IOException {
        this._writeContext.writeFieldName(string);
        this._append(JsonToken.FIELD_NAME, string);
    }

    @Override
    public void writeFieldName(SerializableString serializableString) throws IOException {
        this._writeContext.writeFieldName(serializableString.getValue());
        this._append(JsonToken.FIELD_NAME, serializableString);
    }

    @Override
    public void writeString(String string) throws IOException {
        if (string == null) {
            this.writeNull();
        } else {
            this._appendValue(JsonToken.VALUE_STRING, string);
        }
    }

    @Override
    public void writeString(char[] cArray, int n, int n2) throws IOException {
        this.writeString(new String(cArray, n, n2));
    }

    @Override
    public void writeString(SerializableString serializableString) throws IOException {
        if (serializableString == null) {
            this.writeNull();
        } else {
            this._appendValue(JsonToken.VALUE_STRING, serializableString);
        }
    }

    @Override
    public void writeRawUTF8String(byte[] byArray, int n, int n2) throws IOException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeUTF8String(byte[] byArray, int n, int n2) throws IOException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(String string) throws IOException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(String string, int n, int n2) throws IOException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(SerializableString serializableString) throws IOException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(char[] cArray, int n, int n2) throws IOException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(char c) throws IOException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRawValue(String string) throws IOException {
        this._appendValue(JsonToken.VALUE_EMBEDDED_OBJECT, new RawValue(string));
    }

    @Override
    public void writeRawValue(String string, int n, int n2) throws IOException {
        if (n > 0 || n2 != string.length()) {
            string = string.substring(n, n + n2);
        }
        this._appendValue(JsonToken.VALUE_EMBEDDED_OBJECT, new RawValue(string));
    }

    @Override
    public void writeRawValue(char[] cArray, int n, int n2) throws IOException {
        this._appendValue(JsonToken.VALUE_EMBEDDED_OBJECT, new String(cArray, n, n2));
    }

    @Override
    public void writeNumber(short s) throws IOException {
        this._appendValue(JsonToken.VALUE_NUMBER_INT, s);
    }

    @Override
    public void writeNumber(int n) throws IOException {
        this._appendValue(JsonToken.VALUE_NUMBER_INT, n);
    }

    @Override
    public void writeNumber(long l) throws IOException {
        this._appendValue(JsonToken.VALUE_NUMBER_INT, l);
    }

    @Override
    public void writeNumber(double d) throws IOException {
        this._appendValue(JsonToken.VALUE_NUMBER_FLOAT, d);
    }

    @Override
    public void writeNumber(float f) throws IOException {
        this._appendValue(JsonToken.VALUE_NUMBER_FLOAT, Float.valueOf(f));
    }

    @Override
    public void writeNumber(BigDecimal bigDecimal) throws IOException {
        if (bigDecimal == null) {
            this.writeNull();
        } else {
            this._appendValue(JsonToken.VALUE_NUMBER_FLOAT, bigDecimal);
        }
    }

    @Override
    public void writeNumber(BigInteger bigInteger) throws IOException {
        if (bigInteger == null) {
            this.writeNull();
        } else {
            this._appendValue(JsonToken.VALUE_NUMBER_INT, bigInteger);
        }
    }

    @Override
    public void writeNumber(String string) throws IOException {
        this._appendValue(JsonToken.VALUE_NUMBER_FLOAT, string);
    }

    @Override
    public void writeBoolean(boolean bl) throws IOException {
        this._appendValue(bl ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE);
    }

    @Override
    public void writeNull() throws IOException {
        this._appendValue(JsonToken.VALUE_NULL);
    }

    @Override
    public void writeObject(Object object) throws IOException {
        if (object == null) {
            this.writeNull();
            return;
        }
        Class<?> clazz = object.getClass();
        if (clazz == byte[].class || object instanceof RawValue) {
            this._appendValue(JsonToken.VALUE_EMBEDDED_OBJECT, object);
            return;
        }
        if (this._objectCodec == null) {
            this._appendValue(JsonToken.VALUE_EMBEDDED_OBJECT, object);
        } else {
            this._objectCodec.writeValue(this, object);
        }
    }

    @Override
    public void writeTree(TreeNode treeNode) throws IOException {
        if (treeNode == null) {
            this.writeNull();
            return;
        }
        if (this._objectCodec == null) {
            this._appendValue(JsonToken.VALUE_EMBEDDED_OBJECT, treeNode);
        } else {
            this._objectCodec.writeTree(this, treeNode);
        }
    }

    @Override
    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.writeObject(byArray2);
    }

    @Override
    public int writeBinary(Base64Variant base64Variant, InputStream inputStream, int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canWriteTypeId() {
        return this._hasNativeTypeIds;
    }

    @Override
    public boolean canWriteObjectId() {
        return this._hasNativeObjectIds;
    }

    @Override
    public void writeTypeId(Object object) {
        this._typeId = object;
        this._hasNativeId = true;
    }

    @Override
    public void writeObjectId(Object object) {
        this._objectId = object;
        this._hasNativeId = true;
    }

    @Override
    public void writeEmbeddedObject(Object object) throws IOException {
        this._appendValue(JsonToken.VALUE_EMBEDDED_OBJECT, object);
    }

    @Override
    public void copyCurrentEvent(JsonParser jsonParser) throws IOException {
        if (this._mayHaveNativeIds) {
            this._checkNativeIds(jsonParser);
        }
        block0 : switch (jsonParser.getCurrentToken()) {
            case START_OBJECT: {
                this.writeStartObject();
                break;
            }
            case END_OBJECT: {
                this.writeEndObject();
                break;
            }
            case START_ARRAY: {
                this.writeStartArray();
                break;
            }
            case END_ARRAY: {
                this.writeEndArray();
                break;
            }
            case FIELD_NAME: {
                this.writeFieldName(jsonParser.getCurrentName());
                break;
            }
            case VALUE_STRING: {
                if (jsonParser.hasTextCharacters()) {
                    this.writeString(jsonParser.getTextCharacters(), jsonParser.getTextOffset(), jsonParser.getTextLength());
                    break;
                }
                this.writeString(jsonParser.getText());
                break;
            }
            case VALUE_NUMBER_INT: {
                switch (jsonParser.getNumberType()) {
                    case INT: {
                        this.writeNumber(jsonParser.getIntValue());
                        break block0;
                    }
                    case BIG_INTEGER: {
                        this.writeNumber(jsonParser.getBigIntegerValue());
                        break block0;
                    }
                }
                this.writeNumber(jsonParser.getLongValue());
                break;
            }
            case VALUE_NUMBER_FLOAT: {
                if (this._forceBigDecimal) {
                    this.writeNumber(jsonParser.getDecimalValue());
                    break;
                }
                switch (jsonParser.getNumberType()) {
                    case BIG_DECIMAL: {
                        this.writeNumber(jsonParser.getDecimalValue());
                        break block0;
                    }
                    case FLOAT: {
                        this.writeNumber(jsonParser.getFloatValue());
                        break block0;
                    }
                }
                this.writeNumber(jsonParser.getDoubleValue());
                break;
            }
            case VALUE_TRUE: {
                this.writeBoolean(true);
                break;
            }
            case VALUE_FALSE: {
                this.writeBoolean(false);
                break;
            }
            case VALUE_NULL: {
                this.writeNull();
                break;
            }
            case VALUE_EMBEDDED_OBJECT: {
                this.writeObject(jsonParser.getEmbeddedObject());
                break;
            }
            default: {
                throw new RuntimeException("Internal error: should never end up through this code path");
            }
        }
    }

    @Override
    public void copyCurrentStructure(JsonParser jsonParser) throws IOException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.FIELD_NAME) {
            if (this._mayHaveNativeIds) {
                this._checkNativeIds(jsonParser);
            }
            this.writeFieldName(jsonParser.getCurrentName());
            jsonToken = jsonParser.nextToken();
        }
        if (this._mayHaveNativeIds) {
            this._checkNativeIds(jsonParser);
        }
        switch (jsonToken) {
            case START_ARRAY: {
                this.writeStartArray();
                while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    this.copyCurrentStructure(jsonParser);
                }
                this.writeEndArray();
                break;
            }
            case START_OBJECT: {
                this.writeStartObject();
                while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                    this.copyCurrentStructure(jsonParser);
                }
                this.writeEndObject();
                break;
            }
            default: {
                this.copyCurrentEvent(jsonParser);
            }
        }
    }

    private final void _checkNativeIds(JsonParser jsonParser) throws IOException {
        this._typeId = jsonParser.getTypeId();
        if (this._typeId != null) {
            this._hasNativeId = true;
        }
        if ((this._objectId = jsonParser.getObjectId()) != null) {
            this._hasNativeId = true;
        }
    }

    protected final void _append(JsonToken jsonToken) {
        Segment segment;
        Segment segment2 = segment = this._hasNativeId ? this._last.append(this._appendAt, jsonToken, this._objectId, this._typeId) : this._last.append(this._appendAt, jsonToken);
        if (segment == null) {
            ++this._appendAt;
        } else {
            this._last = segment;
            this._appendAt = 1;
        }
    }

    protected final void _append(JsonToken jsonToken, Object object) {
        Segment segment;
        Segment segment2 = segment = this._hasNativeId ? this._last.append(this._appendAt, jsonToken, object, this._objectId, this._typeId) : this._last.append(this._appendAt, jsonToken, object);
        if (segment == null) {
            ++this._appendAt;
        } else {
            this._last = segment;
            this._appendAt = 1;
        }
    }

    protected final void _appendValue(JsonToken jsonToken) {
        Segment segment;
        this._writeContext.writeValue();
        Segment segment2 = segment = this._hasNativeId ? this._last.append(this._appendAt, jsonToken, this._objectId, this._typeId) : this._last.append(this._appendAt, jsonToken);
        if (segment == null) {
            ++this._appendAt;
        } else {
            this._last = segment;
            this._appendAt = 1;
        }
    }

    protected final void _appendValue(JsonToken jsonToken, Object object) {
        Segment segment;
        this._writeContext.writeValue();
        Segment segment2 = segment = this._hasNativeId ? this._last.append(this._appendAt, jsonToken, object, this._objectId, this._typeId) : this._last.append(this._appendAt, jsonToken, object);
        if (segment == null) {
            ++this._appendAt;
        } else {
            this._last = segment;
            this._appendAt = 1;
        }
    }

    protected final void _appendRaw(int n, Object object) {
        Segment segment;
        Segment segment2 = segment = this._hasNativeId ? this._last.appendRaw(this._appendAt, n, object, this._objectId, this._typeId) : this._last.appendRaw(this._appendAt, n, object);
        if (segment == null) {
            ++this._appendAt;
        } else {
            this._last = segment;
            this._appendAt = 1;
        }
    }

    @Override
    protected void _reportUnsupportedOperation() {
        throw new UnsupportedOperationException("Called operation not supported for TokenBuffer");
    }

    protected static final class Segment {
        public static final int TOKENS_PER_SEGMENT = 16;
        private static final JsonToken[] TOKEN_TYPES_BY_INDEX = new JsonToken[16];
        protected Segment _next;
        protected long _tokenTypes;
        protected final Object[] _tokens = new Object[16];
        protected TreeMap<Integer, Object> _nativeIds;

        public JsonToken type(int n) {
            long l = this._tokenTypes;
            if (n > 0) {
                l >>= n << 2;
            }
            int n2 = (int)l & 0xF;
            return TOKEN_TYPES_BY_INDEX[n2];
        }

        public int rawType(int n) {
            long l = this._tokenTypes;
            if (n > 0) {
                l >>= n << 2;
            }
            int n2 = (int)l & 0xF;
            return n2;
        }

        public Object get(int n) {
            return this._tokens[n];
        }

        public Segment next() {
            return this._next;
        }

        public boolean hasIds() {
            return this._nativeIds != null;
        }

        public Segment append(int n, JsonToken jsonToken) {
            if (n < 16) {
                this.set(n, jsonToken);
                return null;
            }
            this._next = new Segment();
            this._next.set(0, jsonToken);
            return this._next;
        }

        public Segment append(int n, JsonToken jsonToken, Object object, Object object2) {
            if (n < 16) {
                this.set(n, jsonToken, object, object2);
                return null;
            }
            this._next = new Segment();
            this._next.set(0, jsonToken, object, object2);
            return this._next;
        }

        public Segment append(int n, JsonToken jsonToken, Object object) {
            if (n < 16) {
                this.set(n, jsonToken, object);
                return null;
            }
            this._next = new Segment();
            this._next.set(0, jsonToken, object);
            return this._next;
        }

        public Segment append(int n, JsonToken jsonToken, Object object, Object object2, Object object3) {
            if (n < 16) {
                this.set(n, jsonToken, object, object2, object3);
                return null;
            }
            this._next = new Segment();
            this._next.set(0, jsonToken, object, object2, object3);
            return this._next;
        }

        public Segment appendRaw(int n, int n2, Object object) {
            if (n < 16) {
                this.set(n, n2, object);
                return null;
            }
            this._next = new Segment();
            this._next.set(0, n2, object);
            return this._next;
        }

        public Segment appendRaw(int n, int n2, Object object, Object object2, Object object3) {
            if (n < 16) {
                this.set(n, n2, object, object2, object3);
                return null;
            }
            this._next = new Segment();
            this._next.set(0, n2, object, object2, object3);
            return this._next;
        }

        private void set(int n, JsonToken jsonToken) {
            long l = jsonToken.ordinal();
            if (n > 0) {
                l <<= n << 2;
            }
            this._tokenTypes |= l;
        }

        private void set(int n, JsonToken jsonToken, Object object, Object object2) {
            long l = jsonToken.ordinal();
            if (n > 0) {
                l <<= n << 2;
            }
            this._tokenTypes |= l;
            this.assignNativeIds(n, object, object2);
        }

        private void set(int n, JsonToken jsonToken, Object object) {
            this._tokens[n] = object;
            long l = jsonToken.ordinal();
            if (n > 0) {
                l <<= n << 2;
            }
            this._tokenTypes |= l;
        }

        private void set(int n, JsonToken jsonToken, Object object, Object object2, Object object3) {
            this._tokens[n] = object;
            long l = jsonToken.ordinal();
            if (n > 0) {
                l <<= n << 2;
            }
            this._tokenTypes |= l;
            this.assignNativeIds(n, object2, object3);
        }

        private void set(int n, int n2, Object object) {
            this._tokens[n] = object;
            long l = n2;
            if (n > 0) {
                l <<= n << 2;
            }
            this._tokenTypes |= l;
        }

        private void set(int n, int n2, Object object, Object object2, Object object3) {
            this._tokens[n] = object;
            long l = n2;
            if (n > 0) {
                l <<= n << 2;
            }
            this._tokenTypes |= l;
            this.assignNativeIds(n, object2, object3);
        }

        private final void assignNativeIds(int n, Object object, Object object2) {
            if (this._nativeIds == null) {
                this._nativeIds = new TreeMap();
            }
            if (object != null) {
                this._nativeIds.put(this._objectIdIndex(n), object);
            }
            if (object2 != null) {
                this._nativeIds.put(this._typeIdIndex(n), object2);
            }
        }

        public Object findObjectId(int n) {
            return this._nativeIds == null ? null : this._nativeIds.get(this._objectIdIndex(n));
        }

        public Object findTypeId(int n) {
            return this._nativeIds == null ? null : this._nativeIds.get(this._typeIdIndex(n));
        }

        private final int _typeIdIndex(int n) {
            return n + n;
        }

        private final int _objectIdIndex(int n) {
            return n + n + 1;
        }

        static {
            JsonToken[] jsonTokenArray = JsonToken.values();
            System.arraycopy(jsonTokenArray, 1, TOKEN_TYPES_BY_INDEX, 1, Math.min(15, jsonTokenArray.length - 1));
        }
    }

    protected static final class Parser
    extends ParserMinimalBase {
        protected ObjectCodec _codec;
        protected final boolean _hasNativeTypeIds;
        protected final boolean _hasNativeObjectIds;
        protected final boolean _hasNativeIds;
        protected Segment _segment;
        protected int _segmentPtr;
        protected JsonReadContext _parsingContext;
        protected boolean _closed;
        protected transient ByteArrayBuilder _byteBuilder;
        protected JsonLocation _location = null;

        public Parser(Segment segment, ObjectCodec objectCodec, boolean bl, boolean bl2) {
            super(0);
            this._segment = segment;
            this._segmentPtr = -1;
            this._codec = objectCodec;
            this._parsingContext = JsonReadContext.createRootContext(null);
            this._hasNativeTypeIds = bl;
            this._hasNativeObjectIds = bl2;
            this._hasNativeIds = bl | bl2;
        }

        public void setLocation(JsonLocation jsonLocation) {
            this._location = jsonLocation;
        }

        @Override
        public ObjectCodec getCodec() {
            return this._codec;
        }

        @Override
        public void setCodec(ObjectCodec objectCodec) {
            this._codec = objectCodec;
        }

        @Override
        public Version version() {
            return PackageVersion.VERSION;
        }

        public JsonToken peekNextToken() throws IOException {
            if (this._closed) {
                return null;
            }
            Segment segment = this._segment;
            int n = this._segmentPtr + 1;
            if (n >= 16) {
                n = 0;
                segment = segment == null ? null : segment.next();
            }
            return segment == null ? null : segment.type(n);
        }

        @Override
        public void close() throws IOException {
            if (!this._closed) {
                this._closed = true;
            }
        }

        @Override
        public JsonToken nextToken() throws IOException {
            if (this._closed || this._segment == null) {
                return null;
            }
            if (++this._segmentPtr >= 16) {
                this._segmentPtr = 0;
                this._segment = this._segment.next();
                if (this._segment == null) {
                    return null;
                }
            }
            this._currToken = this._segment.type(this._segmentPtr);
            if (this._currToken == JsonToken.FIELD_NAME) {
                Object object = this._currentObject();
                String string = object instanceof String ? (String)object : object.toString();
                this._parsingContext.setCurrentName(string);
            } else if (this._currToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(-1, -1);
            } else if (this._currToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(-1, -1);
            } else if (this._currToken == JsonToken.END_OBJECT || this._currToken == JsonToken.END_ARRAY) {
                this._parsingContext = this._parsingContext.getParent();
                if (this._parsingContext == null) {
                    this._parsingContext = JsonReadContext.createRootContext(null);
                }
            }
            return this._currToken;
        }

        @Override
        public String nextFieldName() throws IOException {
            if (this._closed || this._segment == null) {
                return null;
            }
            int n = this._segmentPtr + 1;
            if (n < 16 && this._segment.type(n) == JsonToken.FIELD_NAME) {
                this._segmentPtr = n;
                Object object = this._segment.get(n);
                String string = object instanceof String ? (String)object : object.toString();
                this._parsingContext.setCurrentName(string);
                return string;
            }
            return this.nextToken() == JsonToken.FIELD_NAME ? this.getCurrentName() : null;
        }

        @Override
        public boolean isClosed() {
            return this._closed;
        }

        @Override
        public JsonStreamContext getParsingContext() {
            return this._parsingContext;
        }

        @Override
        public JsonLocation getTokenLocation() {
            return this.getCurrentLocation();
        }

        @Override
        public JsonLocation getCurrentLocation() {
            return this._location == null ? JsonLocation.NA : this._location;
        }

        @Override
        public String getCurrentName() {
            if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
                JsonReadContext jsonReadContext = this._parsingContext.getParent();
                return jsonReadContext.getCurrentName();
            }
            return this._parsingContext.getCurrentName();
        }

        @Override
        public void overrideCurrentName(String string) {
            JsonReadContext jsonReadContext = this._parsingContext;
            if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
                jsonReadContext = jsonReadContext.getParent();
            }
            try {
                jsonReadContext.setCurrentName(string);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        @Override
        public String getText() {
            if (this._currToken == JsonToken.VALUE_STRING || this._currToken == JsonToken.FIELD_NAME) {
                Object object = this._currentObject();
                if (object instanceof String) {
                    return (String)object;
                }
                return object == null ? null : object.toString();
            }
            if (this._currToken == null) {
                return null;
            }
            switch (this._currToken) {
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    Object object = this._currentObject();
                    return object == null ? null : object.toString();
                }
            }
            return this._currToken.asString();
        }

        @Override
        public char[] getTextCharacters() {
            String string = this.getText();
            return string == null ? null : string.toCharArray();
        }

        @Override
        public int getTextLength() {
            String string = this.getText();
            return string == null ? 0 : string.length();
        }

        @Override
        public int getTextOffset() {
            return 0;
        }

        @Override
        public boolean hasTextCharacters() {
            return false;
        }

        @Override
        public BigInteger getBigIntegerValue() throws IOException {
            Number number = this.getNumberValue();
            if (number instanceof BigInteger) {
                return (BigInteger)number;
            }
            if (this.getNumberType() == JsonParser.NumberType.BIG_DECIMAL) {
                return ((BigDecimal)number).toBigInteger();
            }
            return BigInteger.valueOf(number.longValue());
        }

        @Override
        public BigDecimal getDecimalValue() throws IOException {
            Number number = this.getNumberValue();
            if (number instanceof BigDecimal) {
                return (BigDecimal)number;
            }
            switch (this.getNumberType()) {
                case INT: 
                case LONG: {
                    return BigDecimal.valueOf(number.longValue());
                }
                case BIG_INTEGER: {
                    return new BigDecimal((BigInteger)number);
                }
            }
            return BigDecimal.valueOf(number.doubleValue());
        }

        @Override
        public double getDoubleValue() throws IOException {
            return this.getNumberValue().doubleValue();
        }

        @Override
        public float getFloatValue() throws IOException {
            return this.getNumberValue().floatValue();
        }

        @Override
        public int getIntValue() throws IOException {
            if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
                return ((Number)this._currentObject()).intValue();
            }
            return this.getNumberValue().intValue();
        }

        @Override
        public long getLongValue() throws IOException {
            return this.getNumberValue().longValue();
        }

        @Override
        public JsonParser.NumberType getNumberType() throws IOException {
            Number number = this.getNumberValue();
            if (number instanceof Integer) {
                return JsonParser.NumberType.INT;
            }
            if (number instanceof Long) {
                return JsonParser.NumberType.LONG;
            }
            if (number instanceof Double) {
                return JsonParser.NumberType.DOUBLE;
            }
            if (number instanceof BigDecimal) {
                return JsonParser.NumberType.BIG_DECIMAL;
            }
            if (number instanceof BigInteger) {
                return JsonParser.NumberType.BIG_INTEGER;
            }
            if (number instanceof Float) {
                return JsonParser.NumberType.FLOAT;
            }
            if (number instanceof Short) {
                return JsonParser.NumberType.INT;
            }
            return null;
        }

        @Override
        public final Number getNumberValue() throws IOException {
            this._checkIsNumber();
            Object object = this._currentObject();
            if (object instanceof Number) {
                return (Number)object;
            }
            if (object instanceof String) {
                String string = (String)object;
                if (string.indexOf(46) >= 0) {
                    return Double.parseDouble(string);
                }
                return Long.parseLong(string);
            }
            if (object == null) {
                return null;
            }
            throw new IllegalStateException("Internal error: entry should be a Number, but is of type " + object.getClass().getName());
        }

        @Override
        public Object getEmbeddedObject() {
            if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
                return this._currentObject();
            }
            return null;
        }

        @Override
        public byte[] getBinaryValue(Base64Variant base64Variant) throws IOException, JsonParseException {
            Object object;
            if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT && (object = this._currentObject()) instanceof byte[]) {
                return (byte[])object;
            }
            if (this._currToken != JsonToken.VALUE_STRING) {
                throw this._constructError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING (or VALUE_EMBEDDED_OBJECT with byte[]), can not access as binary");
            }
            object = this.getText();
            if (object == null) {
                return null;
            }
            ByteArrayBuilder byteArrayBuilder = this._byteBuilder;
            if (byteArrayBuilder == null) {
                this._byteBuilder = byteArrayBuilder = new ByteArrayBuilder(100);
            } else {
                this._byteBuilder.reset();
            }
            this._decodeBase64((String)object, byteArrayBuilder, base64Variant);
            return byteArrayBuilder.toByteArray();
        }

        @Override
        public int readBinaryValue(Base64Variant base64Variant, OutputStream outputStream) throws IOException {
            byte[] byArray = this.getBinaryValue(base64Variant);
            if (byArray != null) {
                outputStream.write(byArray, 0, byArray.length);
                return byArray.length;
            }
            return 0;
        }

        @Override
        public boolean canReadObjectId() {
            return this._hasNativeObjectIds;
        }

        @Override
        public boolean canReadTypeId() {
            return this._hasNativeTypeIds;
        }

        @Override
        public Object getTypeId() {
            return this._segment.findTypeId(this._segmentPtr);
        }

        @Override
        public Object getObjectId() {
            return this._segment.findObjectId(this._segmentPtr);
        }

        protected final Object _currentObject() {
            return this._segment.get(this._segmentPtr);
        }

        protected final void _checkIsNumber() throws JsonParseException {
            if (this._currToken == null || !this._currToken.isNumeric()) {
                throw this._constructError("Current token (" + (Object)((Object)this._currToken) + ") not numeric, can not use numeric value accessors");
            }
        }

        @Override
        protected void _handleEOF() throws JsonParseException {
            this._throwInternal();
        }
    }
}

