/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.util.ClassUtil;

public class BeanUtil {
    public static String okNameForGetter(AnnotatedMethod annotatedMethod, boolean bl) {
        String string = annotatedMethod.getName();
        String string2 = BeanUtil.okNameForIsGetter(annotatedMethod, string, bl);
        if (string2 == null) {
            string2 = BeanUtil.okNameForRegularGetter(annotatedMethod, string, bl);
        }
        return string2;
    }

    public static String okNameForRegularGetter(AnnotatedMethod annotatedMethod, String string, boolean bl) {
        if (string.startsWith("get")) {
            if ("getCallbacks".equals(string) ? BeanUtil.isCglibGetCallbacks(annotatedMethod) : "getMetaClass".equals(string) && BeanUtil.isGroovyMetaClassGetter(annotatedMethod)) {
                return null;
            }
            return bl ? BeanUtil.stdManglePropertyName(string, 3) : BeanUtil.legacyManglePropertyName(string, 3);
        }
        return null;
    }

    public static String okNameForIsGetter(AnnotatedMethod annotatedMethod, String string, boolean bl) {
        Class<?> clazz;
        if (string.startsWith("is") && ((clazz = annotatedMethod.getRawType()) == Boolean.class || clazz == Boolean.TYPE)) {
            return bl ? BeanUtil.stdManglePropertyName(string, 2) : BeanUtil.legacyManglePropertyName(string, 2);
        }
        return null;
    }

    public static String okNameForSetter(AnnotatedMethod annotatedMethod, boolean bl) {
        String string = BeanUtil.okNameForMutator(annotatedMethod, "set", bl);
        if (!(string == null || "metaClass".equals(string) && BeanUtil.isGroovyMetaClassSetter(annotatedMethod))) {
            return string;
        }
        return null;
    }

    public static String okNameForMutator(AnnotatedMethod annotatedMethod, String string, boolean bl) {
        String string2 = annotatedMethod.getName();
        if (string2.startsWith(string)) {
            return bl ? BeanUtil.stdManglePropertyName(string2, string.length()) : BeanUtil.legacyManglePropertyName(string2, string.length());
        }
        return null;
    }

    @Deprecated
    public static String okNameForGetter(AnnotatedMethod annotatedMethod) {
        return BeanUtil.okNameForGetter(annotatedMethod, false);
    }

    @Deprecated
    public static String okNameForRegularGetter(AnnotatedMethod annotatedMethod, String string) {
        return BeanUtil.okNameForRegularGetter(annotatedMethod, string, false);
    }

    @Deprecated
    public static String okNameForIsGetter(AnnotatedMethod annotatedMethod, String string) {
        return BeanUtil.okNameForIsGetter(annotatedMethod, string, false);
    }

    @Deprecated
    public static String okNameForSetter(AnnotatedMethod annotatedMethod) {
        return BeanUtil.okNameForSetter(annotatedMethod, false);
    }

    @Deprecated
    public static String okNameForMutator(AnnotatedMethod annotatedMethod, String string) {
        return BeanUtil.okNameForMutator(annotatedMethod, string, false);
    }

    protected static boolean isCglibGetCallbacks(AnnotatedMethod annotatedMethod) {
        Class<?> clazz = annotatedMethod.getRawType();
        if (clazz == null || !clazz.isArray()) {
            return false;
        }
        Class<?> clazz2 = clazz.getComponentType();
        String string = ClassUtil.getPackageName(clazz2);
        return string != null && string.contains(".cglib") && (string.startsWith("net.sf.cglib") || string.startsWith("org.hibernate.repackage.cglib") || string.startsWith("org.springframework.cglib"));
    }

    protected static boolean isGroovyMetaClassSetter(AnnotatedMethod annotatedMethod) {
        Class<?> clazz = annotatedMethod.getRawParameterType(0);
        String string = ClassUtil.getPackageName(clazz);
        return string != null && string.startsWith("groovy.lang");
    }

    protected static boolean isGroovyMetaClassGetter(AnnotatedMethod annotatedMethod) {
        Class<?> clazz = annotatedMethod.getRawType();
        if (clazz == null || clazz.isArray()) {
            return false;
        }
        String string = ClassUtil.getPackageName(clazz);
        return string != null && string.startsWith("groovy.lang");
    }

    protected static String legacyManglePropertyName(String string, int n) {
        char c;
        int n2 = string.length();
        if (n2 == n) {
            return null;
        }
        char c2 = string.charAt(n);
        if (c2 == (c = Character.toLowerCase(c2))) {
            return string.substring(n);
        }
        StringBuilder stringBuilder = new StringBuilder(n2 - n);
        stringBuilder.append(c);
        for (int i = n + 1; i < n2; ++i) {
            c2 = string.charAt(i);
            if (c2 == (c = Character.toLowerCase(c2))) {
                stringBuilder.append(string, i, n2);
                break;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    protected static String stdManglePropertyName(String string, int n) {
        char c;
        int n2 = string.length();
        if (n2 == n) {
            return null;
        }
        char c2 = string.charAt(n);
        if (c2 == (c = Character.toLowerCase(c2))) {
            return string.substring(n);
        }
        if (n + 1 < n2 && Character.isUpperCase(string.charAt(n + 1))) {
            return string.substring(n);
        }
        StringBuilder stringBuilder = new StringBuilder(n2 - n);
        stringBuilder.append(c);
        stringBuilder.append(string, n + 1, n2);
        return stringBuilder.toString();
    }
}

