/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializable;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class TypeBase
extends JavaType
implements JsonSerializable {
    private static final long serialVersionUID = 1L;
    private static final TypeBindings NO_BINDINGS = TypeBindings.emptyBindings();
    private static final JavaType[] NO_TYPES = new JavaType[0];
    protected final JavaType _superClass;
    protected final JavaType[] _superInterfaces;
    protected final TypeBindings _bindings;
    volatile transient String _canonicalName;

    protected TypeBase(Class<?> clazz, TypeBindings typeBindings, JavaType javaType, JavaType[] javaTypeArray, int n, Object object, Object object2, boolean bl) {
        super(clazz, n, object, object2, bl);
        this._bindings = typeBindings == null ? NO_BINDINGS : typeBindings;
        this._superClass = javaType;
        this._superInterfaces = javaTypeArray;
    }

    protected TypeBase(TypeBase typeBase) {
        super(typeBase);
        this._superClass = typeBase._superClass;
        this._superInterfaces = typeBase._superInterfaces;
        this._bindings = typeBase._bindings;
    }

    @Override
    public String toCanonical() {
        String string = this._canonicalName;
        if (string == null) {
            string = this.buildCanonicalName();
        }
        return string;
    }

    protected String buildCanonicalName() {
        return this._class.getName();
    }

    @Override
    public abstract StringBuilder getGenericSignature(StringBuilder var1);

    @Override
    public abstract StringBuilder getErasedSignature(StringBuilder var1);

    @Override
    public TypeBindings getBindings() {
        return this._bindings;
    }

    @Override
    public int containedTypeCount() {
        return this._bindings.size();
    }

    @Override
    public JavaType containedType(int n) {
        return this._bindings.getBoundType(n);
    }

    @Override
    @Deprecated
    public String containedTypeName(int n) {
        return this._bindings.getBoundName(n);
    }

    @Override
    public JavaType getSuperClass() {
        return this._superClass;
    }

    @Override
    public List<JavaType> getInterfaces() {
        if (this._superInterfaces == null) {
            return Collections.emptyList();
        }
        switch (this._superInterfaces.length) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(this._superInterfaces[0]);
            }
        }
        return Arrays.asList(this._superInterfaces);
    }

    @Override
    public final JavaType findSuperType(Class<?> clazz) {
        JavaType javaType;
        if (clazz == this._class) {
            return this;
        }
        if (clazz.isInterface() && this._superInterfaces != null) {
            int n = this._superInterfaces.length;
            for (int i = 0; i < n; ++i) {
                JavaType javaType2 = this._superInterfaces[i].findSuperType(clazz);
                if (javaType2 == null) continue;
                return javaType2;
            }
        }
        if (this._superClass != null && (javaType = this._superClass.findSuperType(clazz)) != null) {
            return javaType;
        }
        return null;
    }

    @Override
    public JavaType[] findTypeParameters(Class<?> clazz) {
        JavaType javaType = this.findSuperType(clazz);
        if (javaType == null) {
            return NO_TYPES;
        }
        return javaType.getBindings().typeParameterArray();
    }

    @Override
    public void serializeWithType(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonProcessingException {
        typeSerializer.writeTypePrefixForScalar(this, jsonGenerator);
        this.serialize(jsonGenerator, serializerProvider);
        typeSerializer.writeTypeSuffixForScalar(this, jsonGenerator);
    }

    @Override
    public void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        jsonGenerator.writeString(this.toCanonical());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static StringBuilder _classSignature(Class<?> clazz, StringBuilder stringBuilder, boolean bl) {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                stringBuilder.append('Z');
                return stringBuilder;
            } else if (clazz == Byte.TYPE) {
                stringBuilder.append('B');
                return stringBuilder;
            } else if (clazz == Short.TYPE) {
                stringBuilder.append('S');
                return stringBuilder;
            } else if (clazz == Character.TYPE) {
                stringBuilder.append('C');
                return stringBuilder;
            } else if (clazz == Integer.TYPE) {
                stringBuilder.append('I');
                return stringBuilder;
            } else if (clazz == Long.TYPE) {
                stringBuilder.append('J');
                return stringBuilder;
            } else if (clazz == Float.TYPE) {
                stringBuilder.append('F');
                return stringBuilder;
            } else if (clazz == Double.TYPE) {
                stringBuilder.append('D');
                return stringBuilder;
            } else {
                if (clazz != Void.TYPE) throw new IllegalStateException("Unrecognized primitive type: " + clazz.getName());
                stringBuilder.append('V');
            }
            return stringBuilder;
        } else {
            stringBuilder.append('L');
            String string = clazz.getName();
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == '.') {
                    c = '/';
                }
                stringBuilder.append(c);
            }
            if (!bl) return stringBuilder;
            stringBuilder.append(';');
        }
        return stringBuilder;
    }

    protected static JavaType _bogusSuperClass(Class<?> clazz) {
        Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2 == null) {
            return null;
        }
        return TypeFactory.unknownType();
    }
}

