/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.ser.std.StdKeySerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;

public class StdKeySerializers {
    protected static final JsonSerializer<Object> DEFAULT_KEY_SERIALIZER = new StdKeySerializer();
    protected static final JsonSerializer<Object> DEFAULT_STRING_SERIALIZER = new StringKeySerializer();

    private StdKeySerializers() {
    }

    public static JsonSerializer<Object> getStdKeySerializer(SerializationConfig serializationConfig, Class<?> clazz, boolean bl) {
        if (clazz == null || clazz == Object.class) {
            return new Dynamic();
        }
        if (clazz == String.class) {
            return DEFAULT_STRING_SERIALIZER;
        }
        if (clazz.isPrimitive() || Number.class.isAssignableFrom(clazz)) {
            return new Default(5, clazz);
        }
        if (clazz == Class.class) {
            return new Default(3, clazz);
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return new Default(1, clazz);
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            return new Default(2, clazz);
        }
        if (clazz == UUID.class) {
            return new Default(5, clazz);
        }
        if (bl) {
            return DEFAULT_KEY_SERIALIZER;
        }
        return null;
    }

    public static JsonSerializer<Object> getFallbackKeySerializer(SerializationConfig serializationConfig, Class<?> clazz) {
        if (clazz != null) {
            if (clazz == Enum.class) {
                return new Dynamic();
            }
            if (clazz.isEnum()) {
                return new Default(4, clazz);
            }
        }
        return DEFAULT_KEY_SERIALIZER;
    }

    @Deprecated
    public static JsonSerializer<Object> getDefault() {
        return DEFAULT_KEY_SERIALIZER;
    }

    public static class StringKeySerializer
    extends StdSerializer<Object> {
        public StringKeySerializer() {
            super(String.class, false);
        }

        @Override
        public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeFieldName((String)object);
        }
    }

    public static class Dynamic
    extends StdSerializer<Object> {
        protected transient PropertySerializerMap _dynamicSerializers = PropertySerializerMap.emptyForProperties();

        public Dynamic() {
            super(String.class, false);
        }

        Object readResolve() {
            this._dynamicSerializers = PropertySerializerMap.emptyForProperties();
            return this;
        }

        @Override
        public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            PropertySerializerMap propertySerializerMap = this._dynamicSerializers;
            Class<?> clazz = object.getClass();
            JsonSerializer<Object> jsonSerializer = propertySerializerMap.serializerFor(clazz);
            if (jsonSerializer == null) {
                jsonSerializer = this._findAndAddDynamic(propertySerializerMap, clazz, serializerProvider);
            }
            jsonSerializer.serialize(object, jsonGenerator, serializerProvider);
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
            this.visitStringFormat(jsonFormatVisitorWrapper, javaType);
        }

        protected JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap propertySerializerMap, Class<?> clazz, SerializerProvider serializerProvider) throws JsonMappingException {
            PropertySerializerMap.SerializerAndMapResult serializerAndMapResult = propertySerializerMap.findAndAddKeySerializer(clazz, serializerProvider, null);
            if (propertySerializerMap != serializerAndMapResult.map) {
                this._dynamicSerializers = serializerAndMapResult.map;
            }
            return serializerAndMapResult.serializer;
        }
    }

    public static class Default
    extends StdSerializer<Object> {
        static final int TYPE_DATE = 1;
        static final int TYPE_CALENDAR = 2;
        static final int TYPE_CLASS = 3;
        static final int TYPE_ENUM = 4;
        static final int TYPE_TO_STRING = 5;
        protected final int _typeId;

        public Default(int n, Class<?> clazz) {
            super(clazz, false);
            this._typeId = n;
        }

        @Override
        public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            switch (this._typeId) {
                case 1: {
                    serializerProvider.defaultSerializeDateKey((Date)object, jsonGenerator);
                    break;
                }
                case 2: {
                    serializerProvider.defaultSerializeDateKey(((Calendar)object).getTimeInMillis(), jsonGenerator);
                    break;
                }
                case 3: {
                    jsonGenerator.writeFieldName(((Class)object).getName());
                    break;
                }
                case 4: {
                    String string = serializerProvider.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING) ? object.toString() : ((Enum)object).name();
                    jsonGenerator.writeFieldName(string);
                    break;
                }
                default: {
                    jsonGenerator.writeFieldName(object.toString());
                }
            }
        }
    }
}

