/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.node;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BaseJsonNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.util.RawValue;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ObjectNode
extends ContainerNode<ObjectNode> {
    protected final Map<String, JsonNode> _children;

    public ObjectNode(JsonNodeFactory jsonNodeFactory) {
        super(jsonNodeFactory);
        this._children = new LinkedHashMap<String, JsonNode>();
    }

    public ObjectNode(JsonNodeFactory jsonNodeFactory, Map<String, JsonNode> map) {
        super(jsonNodeFactory);
        this._children = map;
    }

    @Override
    protected JsonNode _at(JsonPointer jsonPointer) {
        return this.get(jsonPointer.getMatchingProperty());
    }

    public ObjectNode deepCopy() {
        ObjectNode objectNode = new ObjectNode(this._nodeFactory);
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            objectNode._children.put(entry.getKey(), (JsonNode)entry.getValue().deepCopy());
        }
        return objectNode;
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider) {
        return this._children.isEmpty();
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.OBJECT;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.START_OBJECT;
    }

    @Override
    public int size() {
        return this._children.size();
    }

    @Override
    public Iterator<JsonNode> elements() {
        return this._children.values().iterator();
    }

    @Override
    public JsonNode get(int n) {
        return null;
    }

    @Override
    public JsonNode get(String string) {
        return this._children.get(string);
    }

    @Override
    public Iterator<String> fieldNames() {
        return this._children.keySet().iterator();
    }

    @Override
    public JsonNode path(int n) {
        return MissingNode.getInstance();
    }

    @Override
    public JsonNode path(String string) {
        JsonNode jsonNode = this._children.get(string);
        if (jsonNode != null) {
            return jsonNode;
        }
        return MissingNode.getInstance();
    }

    @Override
    public Iterator<Map.Entry<String, JsonNode>> fields() {
        return this._children.entrySet().iterator();
    }

    @Override
    public ObjectNode with(String string) {
        JsonNode jsonNode = this._children.get(string);
        if (jsonNode != null) {
            if (jsonNode instanceof ObjectNode) {
                return (ObjectNode)jsonNode;
            }
            throw new UnsupportedOperationException("Property '" + string + "' has value that is not of type ObjectNode (but " + jsonNode.getClass().getName() + ")");
        }
        ObjectNode objectNode = this.objectNode();
        this._children.put(string, objectNode);
        return objectNode;
    }

    @Override
    public ArrayNode withArray(String string) {
        JsonNode jsonNode = this._children.get(string);
        if (jsonNode != null) {
            if (jsonNode instanceof ArrayNode) {
                return (ArrayNode)jsonNode;
            }
            throw new UnsupportedOperationException("Property '" + string + "' has value that is not of type ArrayNode (but " + jsonNode.getClass().getName() + ")");
        }
        ArrayNode arrayNode = this.arrayNode();
        this._children.put(string, arrayNode);
        return arrayNode;
    }

    @Override
    public boolean equals(Comparator<JsonNode> comparator, JsonNode jsonNode) {
        if (!(jsonNode instanceof ObjectNode)) {
            return false;
        }
        ObjectNode objectNode = (ObjectNode)jsonNode;
        Map<String, JsonNode> map = this._children;
        Map<String, JsonNode> map2 = objectNode._children;
        int n = map.size();
        if (map2.size() != n) {
            return false;
        }
        for (Map.Entry<String, JsonNode> entry : map.entrySet()) {
            JsonNode jsonNode2 = map2.get(entry.getKey());
            if (jsonNode2 != null && entry.getValue().equals(comparator, jsonNode2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public JsonNode findValue(String string) {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (string.equals(entry.getKey())) {
                return entry.getValue();
            }
            JsonNode jsonNode = entry.getValue().findValue(string);
            if (jsonNode == null) continue;
            return jsonNode;
        }
        return null;
    }

    @Override
    public List<JsonNode> findValues(String string, List<JsonNode> list) {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (string.equals(entry.getKey())) {
                if (list == null) {
                    list = new ArrayList<JsonNode>();
                }
                list.add(entry.getValue());
                continue;
            }
            list = entry.getValue().findValues(string, list);
        }
        return list;
    }

    @Override
    public List<String> findValuesAsText(String string, List<String> list) {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (string.equals(entry.getKey())) {
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(entry.getValue().asText());
                continue;
            }
            list = entry.getValue().findValuesAsText(string, list);
        }
        return list;
    }

    @Override
    public ObjectNode findParent(String string) {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (string.equals(entry.getKey())) {
                return this;
            }
            JsonNode jsonNode = entry.getValue().findParent(string);
            if (jsonNode == null) continue;
            return (ObjectNode)jsonNode;
        }
        return null;
    }

    @Override
    public List<JsonNode> findParents(String string, List<JsonNode> list) {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (string.equals(entry.getKey())) {
                if (list == null) {
                    list = new ArrayList<JsonNode>();
                }
                list.add(this);
                continue;
            }
            list = entry.getValue().findParents(string, list);
        }
        return list;
    }

    @Override
    public void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        boolean bl = serializerProvider != null && !serializerProvider.isEnabled(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS);
        jsonGenerator.writeStartObject(this);
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            BaseJsonNode baseJsonNode = (BaseJsonNode)entry.getValue();
            if (bl && baseJsonNode.isArray() && baseJsonNode.isEmpty(serializerProvider)) continue;
            jsonGenerator.writeFieldName(entry.getKey());
            baseJsonNode.serialize(jsonGenerator, serializerProvider);
        }
        jsonGenerator.writeEndObject();
    }

    @Override
    public void serializeWithType(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        boolean bl = serializerProvider != null && !serializerProvider.isEnabled(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS);
        typeSerializer.writeTypePrefixForObject(this, jsonGenerator);
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            BaseJsonNode baseJsonNode = (BaseJsonNode)entry.getValue();
            if (bl && baseJsonNode.isArray() && baseJsonNode.isEmpty(serializerProvider)) continue;
            jsonGenerator.writeFieldName(entry.getKey());
            baseJsonNode.serialize(jsonGenerator, serializerProvider);
        }
        typeSerializer.writeTypeSuffixForObject(this, jsonGenerator);
    }

    public JsonNode set(String string, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        this._children.put(string, jsonNode);
        return this;
    }

    public JsonNode setAll(Map<String, ? extends JsonNode> map) {
        for (Map.Entry<String, ? extends JsonNode> entry : map.entrySet()) {
            JsonNode jsonNode = entry.getValue();
            if (jsonNode == null) {
                jsonNode = this.nullNode();
            }
            this._children.put(entry.getKey(), jsonNode);
        }
        return this;
    }

    public JsonNode setAll(ObjectNode objectNode) {
        this._children.putAll(objectNode._children);
        return this;
    }

    public JsonNode replace(String string, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        return this._children.put(string, jsonNode);
    }

    public JsonNode without(String string) {
        this._children.remove(string);
        return this;
    }

    public ObjectNode without(Collection<String> collection) {
        this._children.keySet().removeAll(collection);
        return this;
    }

    @Deprecated
    public JsonNode put(String string, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        return this._children.put(string, jsonNode);
    }

    public JsonNode remove(String string) {
        return this._children.remove(string);
    }

    public ObjectNode remove(Collection<String> collection) {
        this._children.keySet().removeAll(collection);
        return this;
    }

    @Override
    public ObjectNode removeAll() {
        this._children.clear();
        return this;
    }

    @Deprecated
    public JsonNode putAll(Map<String, ? extends JsonNode> map) {
        return this.setAll(map);
    }

    @Deprecated
    public JsonNode putAll(ObjectNode objectNode) {
        return this.setAll(objectNode);
    }

    public ObjectNode retain(Collection<String> collection) {
        this._children.keySet().retainAll(collection);
        return this;
    }

    public ObjectNode retain(String ... stringArray) {
        return this.retain(Arrays.asList(stringArray));
    }

    public ArrayNode putArray(String string) {
        ArrayNode arrayNode = this.arrayNode();
        this._put(string, arrayNode);
        return arrayNode;
    }

    public ObjectNode putObject(String string) {
        ObjectNode objectNode = this.objectNode();
        this._put(string, objectNode);
        return objectNode;
    }

    public ObjectNode putPOJO(String string, Object object) {
        return this._put(string, this.pojoNode(object));
    }

    public ObjectNode putRawValue(String string, RawValue rawValue) {
        return this._put(string, this.rawValueNode(rawValue));
    }

    public ObjectNode putNull(String string) {
        this._children.put(string, this.nullNode());
        return this;
    }

    public ObjectNode put(String string, short s) {
        return this._put(string, this.numberNode(s));
    }

    public ObjectNode put(String string, Short s) {
        return this._put(string, s == null ? this.nullNode() : this.numberNode((short)s));
    }

    public ObjectNode put(String string, int n) {
        return this._put(string, this.numberNode(n));
    }

    public ObjectNode put(String string, Integer n) {
        return this._put(string, n == null ? this.nullNode() : this.numberNode((int)n));
    }

    public ObjectNode put(String string, long l) {
        return this._put(string, this.numberNode(l));
    }

    public ObjectNode put(String string, Long l) {
        return this._put(string, l == null ? this.nullNode() : this.numberNode((long)l));
    }

    public ObjectNode put(String string, float f) {
        return this._put(string, this.numberNode(f));
    }

    public ObjectNode put(String string, Float f) {
        return this._put(string, f == null ? this.nullNode() : this.numberNode(f.floatValue()));
    }

    public ObjectNode put(String string, double d) {
        return this._put(string, this.numberNode(d));
    }

    public ObjectNode put(String string, Double d) {
        return this._put(string, d == null ? this.nullNode() : this.numberNode((double)d));
    }

    public ObjectNode put(String string, BigDecimal bigDecimal) {
        return this._put(string, bigDecimal == null ? this.nullNode() : this.numberNode(bigDecimal));
    }

    public ObjectNode put(String string, String string2) {
        return this._put(string, string2 == null ? this.nullNode() : this.textNode(string2));
    }

    public ObjectNode put(String string, boolean bl) {
        return this._put(string, this.booleanNode(bl));
    }

    public ObjectNode put(String string, Boolean bl) {
        return this._put(string, bl == null ? this.nullNode() : this.booleanNode(bl));
    }

    public ObjectNode put(String string, byte[] byArray) {
        return this._put(string, byArray == null ? this.nullNode() : this.binaryNode(byArray));
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof ObjectNode) {
            return this._childrenEqual((ObjectNode)object);
        }
        return false;
    }

    protected boolean _childrenEqual(ObjectNode objectNode) {
        return this._children.equals(objectNode._children);
    }

    @Override
    public int hashCode() {
        return this._children.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32 + (this.size() << 4));
        stringBuilder.append("{");
        int n = 0;
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (n > 0) {
                stringBuilder.append(",");
            }
            ++n;
            TextNode.appendQuoted(stringBuilder, entry.getKey());
            stringBuilder.append(':');
            stringBuilder.append(entry.getValue().toString());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    protected ObjectNode _put(String string, JsonNode jsonNode) {
        this._children.put(string, jsonNode);
        return this;
    }
}

