/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class TypeNameIdResolver
extends TypeIdResolverBase {
    protected final MapperConfig<?> _config;
    protected final Map<String, String> _typeToId;
    protected final Map<String, JavaType> _idToType;

    protected TypeNameIdResolver(MapperConfig<?> mapperConfig, JavaType javaType, Map<String, String> map, Map<String, JavaType> map2) {
        super(javaType, mapperConfig.getTypeFactory());
        this._config = mapperConfig;
        this._typeToId = map;
        this._idToType = map2;
    }

    public static TypeNameIdResolver construct(MapperConfig<?> mapperConfig, JavaType javaType, Collection<NamedType> collection, boolean bl, boolean bl2) {
        if (bl == bl2) {
            throw new IllegalArgumentException();
        }
        AbstractMap abstractMap = null;
        HashMap<String, JavaType> hashMap = null;
        if (bl) {
            abstractMap = new HashMap<String, String>();
        }
        if (bl2) {
            hashMap = new HashMap<String, JavaType>();
            abstractMap = new TreeMap();
        }
        if (collection != null) {
            for (NamedType namedType : collection) {
                JavaType javaType2;
                String string;
                Class<?> clazz = namedType.getType();
                String string2 = string = namedType.hasName() ? namedType.getName() : TypeNameIdResolver._defaultTypeId(clazz);
                if (bl) {
                    abstractMap.put((String)clazz.getName(), (String)string);
                }
                if (!bl2 || (javaType2 = (JavaType)hashMap.get(string)) != null && clazz.isAssignableFrom(javaType2.getRawClass())) continue;
                hashMap.put(string, mapperConfig.constructType(clazz));
            }
        }
        return new TypeNameIdResolver(mapperConfig, javaType, abstractMap, hashMap);
    }

    @Override
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.NAME;
    }

    @Override
    public String idFromValue(Object object) {
        return this.idFromClass(object.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String idFromClass(Class<?> clazz) {
        String string;
        if (clazz == null) {
            return null;
        }
        Class<?> clazz2 = this._typeFactory.constructType(clazz).getRawClass();
        String string2 = clazz2.getName();
        Map<String, String> map = this._typeToId;
        synchronized (map) {
            string = this._typeToId.get(string2);
            if (string == null) {
                if (this._config.isAnnotationProcessingEnabled()) {
                    BeanDescription beanDescription = this._config.introspectClassAnnotations(clazz2);
                    string = this._config.getAnnotationIntrospector().findTypeName(beanDescription.getClassInfo());
                }
                if (string == null) {
                    string = TypeNameIdResolver._defaultTypeId(clazz2);
                }
                this._typeToId.put(string2, string);
            }
        }
        return string;
    }

    @Override
    public String idFromValueAndType(Object object, Class<?> clazz) {
        if (object == null) {
            return this.idFromClass(clazz);
        }
        return this.idFromValue(object);
    }

    @Override
    public JavaType typeFromId(DatabindContext databindContext, String string) {
        return this._typeFromId(string);
    }

    protected JavaType _typeFromId(String string) {
        return this._idToType.get(string);
    }

    @Override
    public String getDescForKnownTypeIds() {
        return new TreeSet<String>(this._idToType.keySet()).toString();
    }

    public String toString() {
        return String.format("[%s; id-to-type=%s]", this.getClass().getName(), this._idToType);
    }

    protected static String _defaultTypeId(Class<?> clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        return n < 0 ? string : string.substring(n + 1);
    }
}

