/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Locale;
import java.util.TimeZone;

public class DateDeserializers {
    private static final HashSet<String> _classNames;

    public static JsonDeserializer<?> find(Class<?> clazz, String string) {
        if (_classNames.contains(string)) {
            if (clazz == Calendar.class) {
                return new CalendarDeserializer();
            }
            if (clazz == java.util.Date.class) {
                return DateDeserializer.instance;
            }
            if (clazz == Date.class) {
                return new SqlDateDeserializer();
            }
            if (clazz == Timestamp.class) {
                return new TimestampDeserializer();
            }
            if (clazz == GregorianCalendar.class) {
                return new CalendarDeserializer((Class<? extends Calendar>)GregorianCalendar.class);
            }
        }
        return null;
    }

    static {
        Class[] classArray;
        _classNames = new HashSet();
        for (Class clazz : classArray = new Class[]{Calendar.class, GregorianCalendar.class, Date.class, java.util.Date.class, Timestamp.class}) {
            _classNames.add(clazz.getName());
        }
    }

    public static class TimestampDeserializer
    extends DateBasedDeserializer<Timestamp> {
        public TimestampDeserializer() {
            super(Timestamp.class);
        }

        public TimestampDeserializer(TimestampDeserializer timestampDeserializer, DateFormat dateFormat, String string) {
            super(timestampDeserializer, dateFormat, string);
        }

        protected TimestampDeserializer withDateFormat(DateFormat dateFormat, String string) {
            return new TimestampDeserializer(this, dateFormat, string);
        }

        @Override
        public Timestamp deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return new Timestamp(this._parseDate(jsonParser, deserializationContext).getTime());
        }
    }

    public static class SqlDateDeserializer
    extends DateBasedDeserializer<Date> {
        public SqlDateDeserializer() {
            super(Date.class);
        }

        public SqlDateDeserializer(SqlDateDeserializer sqlDateDeserializer, DateFormat dateFormat, String string) {
            super(sqlDateDeserializer, dateFormat, string);
        }

        protected SqlDateDeserializer withDateFormat(DateFormat dateFormat, String string) {
            return new SqlDateDeserializer(this, dateFormat, string);
        }

        @Override
        public Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            java.util.Date date = this._parseDate(jsonParser, deserializationContext);
            return date == null ? null : new Date(date.getTime());
        }
    }

    @JacksonStdImpl
    public static class DateDeserializer
    extends DateBasedDeserializer<java.util.Date> {
        public static final DateDeserializer instance = new DateDeserializer();

        public DateDeserializer() {
            super(java.util.Date.class);
        }

        public DateDeserializer(DateDeserializer dateDeserializer, DateFormat dateFormat, String string) {
            super(dateDeserializer, dateFormat, string);
        }

        protected DateDeserializer withDateFormat(DateFormat dateFormat, String string) {
            return new DateDeserializer(this, dateFormat, string);
        }

        @Override
        public java.util.Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return this._parseDate(jsonParser, deserializationContext);
        }
    }

    @JacksonStdImpl
    public static class CalendarDeserializer
    extends DateBasedDeserializer<Calendar> {
        protected final Class<? extends Calendar> _calendarClass;

        public CalendarDeserializer() {
            super(Calendar.class);
            this._calendarClass = null;
        }

        public CalendarDeserializer(Class<? extends Calendar> clazz) {
            super(clazz);
            this._calendarClass = clazz;
        }

        public CalendarDeserializer(CalendarDeserializer calendarDeserializer, DateFormat dateFormat, String string) {
            super(calendarDeserializer, dateFormat, string);
            this._calendarClass = calendarDeserializer._calendarClass;
        }

        protected CalendarDeserializer withDateFormat(DateFormat dateFormat, String string) {
            return new CalendarDeserializer(this, dateFormat, string);
        }

        @Override
        public Calendar deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            java.util.Date date = this._parseDate(jsonParser, deserializationContext);
            if (date == null) {
                return null;
            }
            if (this._calendarClass == null) {
                return deserializationContext.constructCalendar(date);
            }
            try {
                Calendar calendar = this._calendarClass.newInstance();
                calendar.setTimeInMillis(date.getTime());
                TimeZone timeZone = deserializationContext.getTimeZone();
                if (timeZone != null) {
                    calendar.setTimeZone(timeZone);
                }
                return calendar;
            }
            catch (Exception exception) {
                return (Calendar)deserializationContext.handleInstantiationProblem(this._calendarClass, date, exception);
            }
        }
    }

    protected static abstract class DateBasedDeserializer<T>
    extends StdScalarDeserializer<T>
    implements ContextualDeserializer {
        protected final DateFormat _customFormat;
        protected final String _formatString;

        protected DateBasedDeserializer(Class<?> clazz) {
            super(clazz);
            this._customFormat = null;
            this._formatString = null;
        }

        protected DateBasedDeserializer(DateBasedDeserializer<T> dateBasedDeserializer, DateFormat dateFormat, String string) {
            super(dateBasedDeserializer._valueClass);
            this._customFormat = dateFormat;
            this._formatString = string;
        }

        protected abstract DateBasedDeserializer<T> withDateFormat(DateFormat var1, String var2);

        @Override
        public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
            JsonFormat.Value value;
            if (beanProperty != null && (value = this.findFormatOverrides(deserializationContext, beanProperty, this.handledType())) != null) {
                TimeZone timeZone = value.getTimeZone();
                if (value.hasPattern()) {
                    String string = value.getPattern();
                    Locale locale = value.hasLocale() ? value.getLocale() : deserializationContext.getLocale();
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, locale);
                    if (timeZone == null) {
                        timeZone = deserializationContext.getTimeZone();
                    }
                    simpleDateFormat.setTimeZone(timeZone);
                    return this.withDateFormat(simpleDateFormat, string);
                }
                if (timeZone != null) {
                    DateFormat dateFormat = deserializationContext.getConfig().getDateFormat();
                    if (dateFormat.getClass() == StdDateFormat.class) {
                        Locale locale = value.hasLocale() ? value.getLocale() : deserializationContext.getLocale();
                        StdDateFormat stdDateFormat = (StdDateFormat)dateFormat;
                        stdDateFormat = stdDateFormat.withTimeZone(timeZone);
                        stdDateFormat = stdDateFormat.withLocale(locale);
                        dateFormat = stdDateFormat;
                    } else {
                        dateFormat = (DateFormat)dateFormat.clone();
                        dateFormat.setTimeZone(timeZone);
                    }
                    return this.withDateFormat(dateFormat, this._formatString);
                }
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected java.util.Date _parseDate(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (this._customFormat != null) {
                JsonToken jsonToken = jsonParser.getCurrentToken();
                if (jsonToken == JsonToken.VALUE_STRING) {
                    String string = jsonParser.getText().trim();
                    if (string.length() == 0) {
                        return (java.util.Date)this.getEmptyValue(deserializationContext);
                    }
                    DateFormat dateFormat = this._customFormat;
                    synchronized (dateFormat) {
                        try {
                            return this._customFormat.parse(string);
                        }
                        catch (ParseException parseException) {
                            return (java.util.Date)deserializationContext.handleWeirdStringValue(this.handledType(), string, "expected format \"%s\"", this._formatString);
                        }
                    }
                }
                if (jsonToken == JsonToken.START_ARRAY && deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                    jsonParser.nextToken();
                    java.util.Date date = this._parseDate(jsonParser, deserializationContext);
                    jsonToken = jsonParser.nextToken();
                    if (jsonToken != JsonToken.END_ARRAY) {
                        this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
                    }
                    return date;
                }
            }
            return super._parseDate(jsonParser, deserializationContext);
        }
    }
}

