/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.ByteOrderMarkFilterInputStream;
import com.dd.plist.NSArray;
import com.dd.plist.NSData;
import com.dd.plist.NSDate;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSNumber;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import com.dd.plist.PropertyListFormatException;
import com.dd.plist.XMLLocationFilter;
import com.dd.plist.XMLLocationInformation;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLPropertyListParser {
    private static final DocumentBuilderFactory FACTORY = DocumentBuilderFactory.newInstance();

    public static DocumentBuilder getDocBuilder() throws ParserConfigurationException {
        DocumentBuilder documentBuilder = FACTORY.newDocumentBuilder();
        documentBuilder.setEntityResolver(new PlistDtdResolver());
        return documentBuilder;
    }

    public static NSObject parse(File file) throws ParserConfigurationException, IOException, SAXException, PropertyListFormatException {
        return XMLPropertyListParser.parse(file.toPath());
    }

    public static NSObject parse(Path path) throws ParserConfigurationException, IOException, SAXException, PropertyListFormatException {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            NSObject nSObject = XMLPropertyListParser.parse(inputStream);
            return nSObject;
        }
    }

    public static NSObject parse(byte[] byArray) throws ParserConfigurationException, SAXException, PropertyListFormatException, IOException {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
            NSObject nSObject = XMLPropertyListParser.parse(byteArrayInputStream);
            return nSObject;
        }
    }

    public static NSObject parse(InputStream inputStream) throws ParserConfigurationException, IOException, SAXException, PropertyListFormatException {
        ByteOrderMarkFilterInputStream byteOrderMarkFilterInputStream = new ByteOrderMarkFilterInputStream(inputStream, false);
        return XMLPropertyListParser.parse(XMLPropertyListParser.parseXml(new InputSource(byteOrderMarkFilterInputStream), false));
    }

    public static NSObject parse(Reader reader) throws ParserConfigurationException, IOException, SAXException, PropertyListFormatException {
        return XMLPropertyListParser.parse(XMLPropertyListParser.parseXml(new InputSource(reader), false));
    }

    public static NSObject parse(File file, boolean bl) throws ParserConfigurationException, IOException, SAXException, PropertyListFormatException {
        return XMLPropertyListParser.parse(file.toPath(), bl);
    }

    public static NSObject parse(Path path, boolean bl) throws ParserConfigurationException, IOException, SAXException, PropertyListFormatException {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            NSObject nSObject = XMLPropertyListParser.parse(inputStream, bl);
            return nSObject;
        }
    }

    public static NSObject parse(byte[] byArray, boolean bl) throws ParserConfigurationException, SAXException, PropertyListFormatException, IOException {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
            NSObject nSObject = XMLPropertyListParser.parse(byteArrayInputStream, bl);
            return nSObject;
        }
    }

    public static NSObject parse(InputStream inputStream, boolean bl) throws ParserConfigurationException, IOException, SAXException, PropertyListFormatException {
        ByteOrderMarkFilterInputStream byteOrderMarkFilterInputStream = new ByteOrderMarkFilterInputStream(inputStream, false);
        return XMLPropertyListParser.parse(XMLPropertyListParser.parseXml(new InputSource(byteOrderMarkFilterInputStream), bl));
    }

    public static NSObject parse(Reader reader, boolean bl) throws ParserConfigurationException, IOException, SAXException, PropertyListFormatException {
        return XMLPropertyListParser.parse(XMLPropertyListParser.parseXml(new InputSource(reader), bl));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NSObject parse(Document document) throws PropertyListFormatException, IOException {
        void var3_6;
        String string;
        DocumentType documentType = document.getDoctype();
        if (documentType == null ? !document.getDocumentElement().getNodeName().equals("plist") : !documentType.getName().equals("plist")) {
            throw new PropertyListFormatException("The given XML document is not a property list.");
        }
        if (document.getDocumentElement().getNodeName().equals("plist")) {
            string = "/plist";
            List<Node> list = XMLPropertyListParser.filterElementNodes(document.getDocumentElement().getChildNodes());
            if (list.isEmpty()) {
                throw new PropertyListFormatException("The given XML property list has no root element!");
            }
            if (list.size() != 1) throw new PropertyListFormatException("The given XML property list has more than one root element!");
            Node node = list.get(0);
            return XMLPropertyListParser.parseObject((Node)var3_6, string + "/" + var3_6.getNodeName());
        } else {
            Element element = document.getDocumentElement();
            string = "";
        }
        return XMLPropertyListParser.parseObject((Node)var3_6, string + "/" + var3_6.getNodeName());
    }

    private static Document parseXml(InputSource inputSource, boolean bl) throws IOException, SAXException, ParserConfigurationException {
        if (bl) {
            XMLReader xMLReader = XMLPropertyListParser.createSafeXmlReader();
            XMLLocationFilter xMLLocationFilter = new XMLLocationFilter(xMLReader);
            SAXSource sAXSource = new SAXSource(xMLLocationFilter, inputSource);
            DOMResult dOMResult = new DOMResult();
            try {
                Transformer transformer = XMLPropertyListParser.createSafeTransformer();
                transformer.transform(sAXSource, dOMResult);
            }
            catch (TransformerException transformerException) {
                throw new IOException(transformerException.getMessage(), transformerException);
            }
            return (Document)dOMResult.getNode();
        }
        return XMLPropertyListParser.getDocBuilder().parse(inputSource);
    }

    private static XMLReader createSafeXmlReader() throws SAXException, ParserConfigurationException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        sAXParserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        sAXParserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        sAXParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        sAXParserFactory.setXIncludeAware(false);
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        return sAXParser.getXMLReader();
    }

    private static Transformer createSafeTransformer() throws TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        return transformerFactory.newTransformer();
    }

    private static NSObject parseObject(Node node, String string) throws PropertyListFormatException {
        String string2 = node.getNodeName();
        XMLLocationInformation xMLLocationInformation = new XMLLocationInformation(node, string);
        NSObject nSObject = null;
        try {
            switch (string2) {
                case "dict": {
                    NSDictionary nSDictionary = new NSDictionary();
                    nSObject = nSDictionary;
                    List<Node> list = XMLPropertyListParser.filterElementNodes(node.getChildNodes());
                    for (int i = 0; i < list.size(); i += 2) {
                        Node node2 = list.get(i);
                        String string3 = XMLPropertyListParser.getNodeTextContents(node2);
                        Node node3 = list.get(i + 1);
                        String string4 = string + "/*[" + (1 + i + 1) + "]";
                        nSDictionary.put(string3, XMLPropertyListParser.parseObject(node3, string4));
                    }
                    break;
                }
                case "array": {
                    List<Node> list = XMLPropertyListParser.filterElementNodes(node.getChildNodes());
                    NSArray nSArray = new NSArray(list.size());
                    nSObject = nSArray;
                    for (int i = 0; i < list.size(); ++i) {
                        String string5 = string + "/*[" + (i + 1) + "]";
                        nSArray.setValue(i, XMLPropertyListParser.parseObject(list.get(i), string5));
                    }
                    break;
                }
                case "true": {
                    nSObject = new NSNumber(true);
                    break;
                }
                case "false": {
                    nSObject = new NSNumber(false);
                    break;
                }
                case "integer": 
                case "real": {
                    nSObject = new NSNumber(XMLPropertyListParser.getNodeTextContents(node));
                    break;
                }
                case "string": {
                    nSObject = new NSString(XMLPropertyListParser.getNodeTextContents(node));
                    break;
                }
                case "data": {
                    nSObject = new NSData(XMLPropertyListParser.getNodeTextContents(node));
                    break;
                }
                case "date": {
                    nSObject = new NSDate(XMLPropertyListParser.getNodeTextContents(node));
                }
            }
        }
        catch (PropertyListFormatException propertyListFormatException) {
            throw propertyListFormatException;
        }
        catch (Exception exception) {
            throw new PropertyListFormatException(xMLLocationInformation.hasLineInformation() ? "The " + node.getNodeName() + " node at line " + xMLLocationInformation.getLineNumber() + " and column " + xMLLocationInformation.getColumnNumber() + " could not be parsed." : "The " + node.getNodeName() + " node at " + string + " could not be parsed.", xMLLocationInformation, exception);
        }
        if (nSObject != null) {
            nSObject.setLocationInformation(xMLLocationInformation);
        }
        return nSObject;
    }

    private static List<Node> filterElementNodes(NodeList nodeList) {
        ArrayList<Node> arrayList = new ArrayList<Node>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            arrayList.add(nodeList.item(i));
        }
        return arrayList;
    }

    private static String getNodeTextContents(Node node) {
        if (node.getNodeType() == 3 || node.getNodeType() == 4) {
            Text text = (Text)node;
            String string = text.getWholeText();
            if (string == null) {
                return "";
            }
            return string;
        }
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 3 && node2.getNodeType() != 4) continue;
                Text text = (Text)node2;
                String string = text.getWholeText();
                if (string == null) {
                    return "";
                }
                return string;
            }
        }
        return "";
    }

    static {
        try {
            FACTORY.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        try {
            FACTORY.setFeature("http://xml.org/sax/features/external-general-entities", false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        try {
            FACTORY.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        try {
            FACTORY.setXIncludeAware(false);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        FACTORY.setExpandEntityReferences(false);
        FACTORY.setNamespaceAware(false);
        FACTORY.setIgnoringComments(true);
        FACTORY.setCoalescing(true);
        FACTORY.setValidating(false);
    }

    private static class PlistDtdResolver
    implements EntityResolver {
        private static final String PLIST_PUBLIC_ID_1 = "-//Apple Computer//DTD PLIST 1.0//EN";
        private static final String PLIST_PUBLIC_ID_2 = "-//Apple//DTD PLIST 1.0//EN";

        PlistDtdResolver() {
        }

        @Override
        public InputSource resolveEntity(String string, String string2) {
            if (PLIST_PUBLIC_ID_1.equals(string) || PLIST_PUBLIC_ID_2.equals(string)) {
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
            return null;
        }
    }
}

