/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSNumber;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Objects;

public class UID
extends NSObject {
    private final BigInteger uid;
    private final String name;

    public UID(String string, BigInteger bigInteger) {
        this.name = string;
        this.uid = Objects.requireNonNull(bigInteger);
        if (this.uid.bitLength() > 128) {
            throw new IllegalArgumentException("The specified UID exceeds the maximum length of 128-bit.");
        }
        if (this.uid.signum() < 0) {
            throw new IllegalArgumentException("The specified value is negative.");
        }
    }

    public UID(String string, byte[] byArray) {
        this(string, new BigInteger(1, Objects.requireNonNull(byArray)));
    }

    public byte[] getBytes() {
        byte[] byArray = this.uid.toByteArray();
        if (byArray.length == 3) {
            byte[] byArray2 = new byte[4];
            System.arraycopy(byArray, 0, byArray2, 1, 3);
            byArray = byArray2;
        } else if (byArray.length > 4 && byArray.length < 8) {
            byte[] byArray3 = new byte[8];
            System.arraycopy(byArray, 0, byArray3, 8 - byArray.length, byArray.length);
            byArray = byArray3;
        } else if (byArray.length > 8 && byArray.length < 16) {
            byte[] byArray4 = new byte[16];
            System.arraycopy(byArray, 0, byArray4, 16 - byArray.length, byArray.length);
            byArray = byArray4;
        }
        return byArray;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public UID clone() {
        return new UID(this.name, this.uid.toByteArray());
    }

    @Override
    public Object toJavaObject() {
        return this.getBytes();
    }

    @Override
    void toXML(StringBuilder stringBuilder, int n) {
        NSDictionary nSDictionary = new NSDictionary();
        nSDictionary.put("CF$UID", new NSNumber(this.uid.longValue()));
        nSDictionary.toXML(stringBuilder, n);
    }

    @Override
    void toBinary(BinaryPropertyListWriter binaryPropertyListWriter) throws IOException {
        byte[] byArray = this.getBytes();
        binaryPropertyListWriter.write(128 + byArray.length - 1);
        binaryPropertyListWriter.write(byArray);
    }

    @Override
    protected void toASCII(StringBuilder stringBuilder, int n) {
        new NSString(this.uid.toString(16)).toASCII(stringBuilder, n);
    }

    @Override
    protected void toASCIIGnuStep(StringBuilder stringBuilder, int n) {
        new NSString(this.uid.toString(16)).toASCIIGnuStep(stringBuilder, n);
    }

    @Override
    public int compareTo(NSObject nSObject) {
        Objects.requireNonNull(nSObject);
        if (nSObject == this) {
            return 0;
        }
        if (nSObject instanceof UID) {
            UID uID = (UID)nSObject;
            int n = this.uid.compareTo(uID.uid);
            if (n == 0) {
                if (this.name == null) {
                    return uID.name != null ? 1 : 0;
                }
                if (uID.name == null) {
                    return -1;
                }
                return this.name.compareTo(uID.name);
            }
            return n;
        }
        return this.getClass().getName().compareTo(nSObject.getClass().getName());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        UID uID = (UID)object;
        return this.uid.equals(((UID)object).uid) && Objects.equals(this.name, uID.name);
    }

    public int hashCode() {
        int n = Objects.hash(this.name);
        n = 31 * n + this.uid.hashCode();
        return n;
    }

    public String toString() {
        return this.uid.toString(16) + (this.name != null ? " (" + this.name + ")" : "");
    }
}

