/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.NSObject;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;
import java.util.Scanner;

public class NSString
extends NSObject {
    private static CharsetEncoder asciiEncoder;
    private static CharsetEncoder utf16beEncoder;
    private static CharsetEncoder utf8Encoder;
    private String content;

    public NSString(byte[] byArray, String string) throws UnsupportedEncodingException {
        this(byArray, 0, byArray.length, string);
    }

    public NSString(byte[] byArray, int n, int n2, String string) throws UnsupportedEncodingException {
        this.content = new String(byArray, n, n2 - n, string);
    }

    public NSString(String string) {
        this.content = string;
    }

    public int intValue() {
        double d = this.doubleValue();
        if (d > 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        if (d < -2.147483648E9) {
            return Integer.MIN_VALUE;
        }
        return (int)d;
    }

    public float floatValue() {
        double d = this.doubleValue();
        if (d > 3.4028234663852886E38) {
            return Float.MAX_VALUE;
        }
        if (d < -3.4028234663852886E38) {
            return -3.4028235E38f;
        }
        return (float)d;
    }

    public double doubleValue() {
        Scanner scanner = new Scanner(this.content.trim()).useLocale(Locale.ROOT).useDelimiter("[^\\d.+-]+");
        if (scanner.hasNextDouble()) {
            return scanner.nextDouble();
        }
        return 0.0;
    }

    public boolean boolValue() {
        Scanner scanner = new Scanner(this.content.trim()).useLocale(Locale.ROOT);
        return scanner.hasNext("([+-]?0*)?[YyTt1-9].*");
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String string) {
        this.content = string;
    }

    public void append(NSString nSString) {
        this.append(nSString.getContent());
    }

    public void append(String string) {
        this.content = this.content + string;
    }

    public void prepend(String string) {
        this.content = string + this.content;
    }

    public void prepend(NSString nSString) {
        this.prepend(nSString.getContent());
    }

    public boolean equals(Object object) {
        return object != null && this.getClass() == object.getClass() && this.content.equals(((NSString)object).content);
    }

    public int hashCode() {
        return this.content.hashCode();
    }

    @Override
    public NSString clone() {
        return new NSString(this.content);
    }

    public String toString() {
        return this.content;
    }

    @Override
    public Object toJavaObject() {
        return this.content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void toXML(StringBuilder stringBuilder, int n) {
        this.indent(stringBuilder, n);
        stringBuilder.append("<string>");
        Object object = NSString.class;
        synchronized (NSString.class) {
            if (utf8Encoder == null) {
                utf8Encoder = StandardCharsets.UTF_8.newEncoder();
            } else {
                utf8Encoder.reset();
            }
            try {
                ByteBuffer byteBuffer = utf8Encoder.encode(CharBuffer.wrap(this.content));
                byte[] byArray = new byte[byteBuffer.remaining()];
                byteBuffer.get(byArray);
                this.content = new String(byArray, StandardCharsets.UTF_8);
            }
            catch (Exception exception) {
                throw new RuntimeException("Could not encode the NSString into UTF-8: " + exception.getMessage());
            }
            object = NSString.escapeStringForXml(this.content);
            if (((String)object).contains("&") || ((String)object).contains("<") || ((String)object).contains(">")) {
                stringBuilder.append("<![CDATA[");
                stringBuilder.append(((String)object).replaceAll("]]>", "]]]]><![CDATA[>"));
                stringBuilder.append("]]>");
            } else {
                stringBuilder.append((String)object);
            }
            stringBuilder.append("</string>");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void toBinary(BinaryPropertyListWriter binaryPropertyListWriter) throws IOException {
        CharBuffer charBuffer = CharBuffer.wrap(this.content);
        Object object = NSString.class;
        synchronized (NSString.class) {
            ByteBuffer byteBuffer;
            int n;
            if (asciiEncoder == null) {
                asciiEncoder = StandardCharsets.US_ASCII.newEncoder();
            } else {
                asciiEncoder.reset();
            }
            if (asciiEncoder.canEncode((CharSequence)charBuffer)) {
                n = 5;
                byteBuffer = asciiEncoder.encode(charBuffer);
            } else {
                if (utf16beEncoder == null) {
                    utf16beEncoder = StandardCharsets.UTF_16BE.newEncoder();
                } else {
                    utf16beEncoder.reset();
                }
                n = 6;
                byteBuffer = utf16beEncoder.encode(charBuffer);
            }
            // ** MonitorExit[var5_3] (shouldn't be in output)
            object = new byte[byteBuffer.remaining()];
            byteBuffer.get((byte[])object);
            binaryPropertyListWriter.writeIntHeader(n, this.content.length());
            binaryPropertyListWriter.write((byte[])object);
            return;
        }
    }

    @Override
    protected void toASCII(StringBuilder stringBuilder, int n) {
        this.indent(stringBuilder, n);
        stringBuilder.append("\"");
        stringBuilder.append(NSString.escapeStringForASCII(this.content));
        stringBuilder.append("\"");
    }

    @Override
    protected void toASCIIGnuStep(StringBuilder stringBuilder, int n) {
        this.indent(stringBuilder, n);
        stringBuilder.append("\"");
        stringBuilder.append(NSString.escapeStringForASCII(this.content));
        stringBuilder.append("\"");
    }

    @Override
    public int compareTo(NSObject nSObject) {
        Objects.requireNonNull(nSObject);
        if (nSObject == this) {
            return 0;
        }
        if (nSObject instanceof NSString) {
            return this.getContent().compareTo(((NSString)nSObject).getContent());
        }
        return this.getClass().getName().compareTo(nSObject.getClass().getName());
    }

    static String escapeStringForASCII(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (c > '\u007f') {
                stringBuilder.append("\\U");
                String string2 = Integer.toHexString(c);
                while (string2.length() < 4) {
                    string2 = "0" + string2;
                }
                stringBuilder.append(string2);
                continue;
            }
            if (c == '\\') {
                stringBuilder.append("\\\\");
                continue;
            }
            if (c == '\"') {
                stringBuilder.append("\\\"");
                continue;
            }
            if (c == '\b') {
                stringBuilder.append("\\b");
                continue;
            }
            if (c == '\n') {
                stringBuilder.append("\\n");
                continue;
            }
            if (c == '\r') {
                stringBuilder.append("\\r");
                continue;
            }
            if (c == '\t') {
                stringBuilder.append("\\t");
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    static String escapeStringForXml(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            int n = string.codePointAt(i);
            if (n > 65535) {
                ++i;
            }
            if (!(n == 9 || n == 10 || n == 13 || n >= 32 && n <= 55295 || n >= 57344 && n <= 65533) && (n < 65536 || n > 0x10FFFF)) continue;
            stringBuilder.appendCodePoint(n);
        }
        return stringBuilder.toString();
    }
}

