/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.NSArray;
import com.dd.plist.NSNull;
import com.dd.plist.NSObject;
import java.io.IOException;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class NSSet
extends NSObject {
    private final Set<NSObject> set;
    private boolean ordered = false;

    public NSSet() {
        this.set = new LinkedHashSet<NSObject>();
    }

    public NSSet(boolean bl) {
        this.ordered = bl;
        this.set = bl ? new TreeSet() : new LinkedHashSet();
    }

    public NSSet(NSObject ... nSObjectArray) {
        this.set = new LinkedHashSet<NSObject>();
        this.set.addAll(Arrays.asList(nSObjectArray));
    }

    public NSSet(boolean bl, NSObject ... nSObjectArray) {
        this(bl);
        this.set.addAll(Arrays.stream(nSObjectArray).map(NSNull::wrap).collect(Collectors.toCollection(ArrayList::new)));
    }

    public synchronized void addObject(NSObject nSObject) {
        this.set.add(NSNull.wrap(nSObject));
    }

    public synchronized void removeObject(NSObject nSObject) {
        this.set.remove(NSNull.wrap(nSObject));
    }

    public synchronized NSObject[] allObjects() {
        return (NSObject[])this.set.stream().map(NSNull::unwrap).toArray(NSObject[]::new);
    }

    public synchronized NSObject anyObject() {
        if (this.set.isEmpty()) {
            return null;
        }
        return NSNull.unwrap(this.set.iterator().next());
    }

    public boolean containsObject(NSObject nSObject) {
        return this.set.contains(NSNull.wrap(nSObject));
    }

    public synchronized NSObject member(NSObject nSObject) {
        for (NSObject nSObject2 : this.set) {
            if (!nSObject2.equals(NSNull.wrap(nSObject))) continue;
            return nSObject2;
        }
        return null;
    }

    public synchronized boolean intersectsSet(NSSet nSSet) {
        for (NSObject nSObject : this.set) {
            if (!nSSet.containsObject(nSObject)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isSubsetOfSet(NSSet nSSet) {
        for (NSObject nSObject : this.set) {
            if (nSSet.containsObject(nSObject)) continue;
            return false;
        }
        return true;
    }

    public synchronized Iterator<NSObject> objectIterator() {
        return this.set.stream().map(NSNull::unwrap).iterator();
    }

    public int hashCode() {
        int n = 7;
        n = 29 * n + (this.set != null ? this.set.hashCode() : 0);
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.compareTo((NSObject)object) == 0;
    }

    @Override
    public int compareTo(NSObject nSObject) {
        Objects.requireNonNull(nSObject);
        if (nSObject == this) {
            return 0;
        }
        if (nSObject instanceof NSSet) {
            NSSet nSSet = (NSSet)nSObject;
            if (nSSet.count() != this.count()) {
                return Integer.compare(this.count(), nSSet.count());
            }
            NSObject[] nSObjectArray = this.allObjects();
            NSObject[] nSObjectArray2 = nSSet.allObjects();
            for (int i = 0; i < this.count(); ++i) {
                int n = NSNull.wrap(nSObjectArray[i]).compareTo(NSNull.wrap(nSObjectArray2[i]));
                if (n == 0) continue;
                return n;
            }
            return 0;
        }
        return this.getClass().getName().compareTo(nSObject.getClass().getName());
    }

    public synchronized int count() {
        return this.set.size();
    }

    @Override
    public NSSet clone() {
        NSObject[] nSObjectArray = new NSObject[this.set.size()];
        int n = 0;
        for (NSObject nSObject : this.set) {
            nSObjectArray[n++] = nSObject != null ? nSObject.clone() : null;
        }
        return new NSSet(this.ordered, nSObjectArray);
    }

    @Override
    public Object toJavaObject() {
        AbstractSet abstractSet = this.ordered ? new TreeSet() : new LinkedHashSet(this.set.size());
        for (NSObject nSObject : this.set) {
            abstractSet.add(nSObject.toJavaObject());
        }
        return abstractSet;
    }

    @Override
    void toXML(StringBuilder stringBuilder, int n) {
        new NSArray(this.allObjects()).toXML(stringBuilder, n);
    }

    @Override
    void assignIDs(BinaryPropertyListWriter binaryPropertyListWriter) {
        super.assignIDs(binaryPropertyListWriter);
        for (NSObject nSObject : this.set) {
            nSObject.assignIDs(binaryPropertyListWriter);
        }
    }

    @Override
    void toBinary(BinaryPropertyListWriter binaryPropertyListWriter) throws IOException {
        if (this.ordered) {
            binaryPropertyListWriter.writeIntHeader(11, this.set.size());
        } else {
            binaryPropertyListWriter.writeIntHeader(12, this.set.size());
        }
        for (NSObject nSObject : this.set) {
            binaryPropertyListWriter.writeID(binaryPropertyListWriter.getID(nSObject));
        }
    }

    @Override
    protected void toASCII(StringBuilder stringBuilder, int n) {
        new NSArray(this.allObjects()).toASCII(stringBuilder, n);
    }

    @Override
    protected void toASCIIGnuStep(StringBuilder stringBuilder, int n) {
        new NSArray(this.allObjects()).toASCIIGnuStep(stringBuilder, n);
    }
}

