/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.BinaryPropertyListParser;
import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.NSObject;
import java.io.IOException;
import java.util.Objects;

public class NSNumber
extends NSObject {
    public static final int INTEGER = 0;
    public static final int REAL = 1;
    public static final int BOOLEAN = 2;
    private static final String NAN_SYMBOL = "nan";
    private static final String POSTIIVE_INFINITY_SYMBOL = "+infinity";
    private static final String NEGATIVE_INFINITY_SYMBOL = "-infinity";
    private static final String TRUE_SYMBOL = "true";
    private static final String YES_SYMBOL = "YES";
    private static final String FALSE_SYMBOL = "false";
    private static final String NO_SYMOBL = "NO";
    private int type;
    private long longValue;
    private double doubleValue;
    private boolean boolValue;

    public NSNumber(byte[] byArray, int n) {
        this(byArray, 0, byArray.length, n);
    }

    public NSNumber(byte[] byArray, int n, int n2, int n3) {
        switch (n3) {
            case 0: {
                this.longValue = BinaryPropertyListParser.parseLong(byArray, n, n2);
                this.doubleValue = this.longValue;
                break;
            }
            case 1: {
                this.doubleValue = BinaryPropertyListParser.parseDouble(byArray, n, n2);
                this.longValue = Math.round(this.doubleValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("Type argument is not valid.");
            }
        }
        this.type = n3;
    }

    public NSNumber(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The given string is null and cannot be parsed as number.");
        }
        if (string.equalsIgnoreCase(TRUE_SYMBOL) || string.equalsIgnoreCase(YES_SYMBOL)) {
            this.type = 2;
            this.boolValue = true;
            this.longValue = 1L;
            this.doubleValue = 1L;
        } else if (string.equalsIgnoreCase(FALSE_SYMBOL) || string.equalsIgnoreCase(NO_SYMOBL)) {
            this.type = 2;
            this.boolValue = false;
            this.longValue = 0L;
            this.doubleValue = 0L;
        } else if (string.equalsIgnoreCase(NAN_SYMBOL)) {
            this.doubleValue = Double.NaN;
            this.longValue = 0L;
            this.type = 1;
        } else if (string.equalsIgnoreCase(POSTIIVE_INFINITY_SYMBOL)) {
            this.doubleValue = Double.POSITIVE_INFINITY;
            this.longValue = 0L;
            this.type = 1;
        } else if (string.equalsIgnoreCase(NEGATIVE_INFINITY_SYMBOL)) {
            this.doubleValue = Double.NEGATIVE_INFINITY;
            this.longValue = 0L;
            this.type = 1;
        } else {
            try {
                long l = string.startsWith("0x") ? Long.parseLong(string.substring(2), 16) : Long.parseLong(string);
                this.longValue = l;
                this.doubleValue = this.longValue;
                this.type = 0;
            }
            catch (Exception exception) {
                try {
                    this.doubleValue = Double.parseDouble(string);
                    this.longValue = Math.round(this.doubleValue);
                    this.type = 1;
                }
                catch (Exception exception2) {
                    throw new IllegalArgumentException("The given string neither represents a double, an int nor a boolean value.");
                }
            }
        }
    }

    public NSNumber(int n) {
        this.longValue = n;
        this.doubleValue = this.longValue;
        this.type = 0;
    }

    public NSNumber(long l) {
        this.longValue = l;
        this.doubleValue = this.longValue;
        this.type = 0;
    }

    public NSNumber(double d) {
        this.doubleValue = d;
        this.longValue = (long)this.doubleValue;
        this.type = 1;
    }

    public NSNumber(boolean bl) {
        this.boolValue = bl;
        this.longValue = bl ? 1L : 0L;
        this.doubleValue = this.longValue;
        this.type = 2;
    }

    public int type() {
        return this.type;
    }

    public boolean isBoolean() {
        return this.type == 2;
    }

    public boolean isInteger() {
        return this.type == 0;
    }

    public boolean isReal() {
        return this.type == 1;
    }

    public boolean boolValue() {
        if (this.type == 2) {
            return this.boolValue;
        }
        return !Double.isNaN(this.doubleValue) && this.doubleValue != 0.0;
    }

    public long longValue() {
        this.throwIfIntegerValueNotAvailable();
        return this.longValue;
    }

    public int intValue() {
        this.throwIfIntegerValueNotAvailable();
        return (int)this.longValue;
    }

    public double doubleValue() {
        return this.doubleValue;
    }

    public float floatValue() {
        return (float)this.doubleValue;
    }

    public String stringValue() {
        switch (this.type) {
            case 0: {
                return String.valueOf(this.longValue);
            }
            case 1: {
                return this.getRealStringRepresentation();
            }
            case 2: {
                return String.valueOf(this.boolValue);
            }
        }
        throw new IllegalStateException("The NSNumber instance has an invalid type: " + this.type);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NSNumber nSNumber = (NSNumber)object;
        return this.type == nSNumber.type && this.longValue == nSNumber.longValue && this.doubleValue == nSNumber.doubleValue && this.boolValue == nSNumber.boolValue;
    }

    public int hashCode() {
        int n = this.type;
        n = 37 * n + (int)(this.longValue ^ this.longValue >>> 32);
        n = 37 * n + (int)(Double.doubleToLongBits(this.doubleValue) ^ Double.doubleToLongBits(this.doubleValue) >>> 32);
        n = 37 * n + (this.boolValue() ? 1 : 0);
        return n;
    }

    @Override
    public NSNumber clone() {
        switch (this.type) {
            case 0: {
                return new NSNumber(this.longValue);
            }
            case 1: {
                return new NSNumber(this.doubleValue);
            }
            case 2: {
                return new NSNumber(this.boolValue);
            }
        }
        throw new IllegalStateException("The NSNumber instance has an invalid type: " + this.type);
    }

    public String toString() {
        switch (this.type()) {
            case 0: {
                return String.valueOf(this.longValue);
            }
            case 1: {
                return this.getRealStringRepresentation();
            }
            case 2: {
                return String.valueOf(this.boolValue);
            }
        }
        return super.toString();
    }

    @Override
    public Object toJavaObject() {
        switch (this.type) {
            case 0: {
                long l = this.longValue();
                if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                    return l;
                }
                return this.intValue();
            }
            case 2: {
                return this.boolValue();
            }
        }
        return this.doubleValue();
    }

    @Override
    public int compareTo(NSObject nSObject) {
        Objects.requireNonNull(nSObject);
        if (nSObject == this) {
            return 0;
        }
        if (nSObject instanceof NSNumber) {
            NSNumber nSNumber = (NSNumber)nSObject;
            return Double.compare(this.doubleValue, nSNumber.doubleValue);
        }
        return this.getClass().getName().compareTo(nSObject.getClass().getName());
    }

    @Override
    void toXML(StringBuilder stringBuilder, int n) {
        this.indent(stringBuilder, n);
        switch (this.type()) {
            case 0: {
                stringBuilder.append("<integer>");
                stringBuilder.append(this.longValue);
                stringBuilder.append("</integer>");
                break;
            }
            case 1: {
                stringBuilder.append("<real>");
                stringBuilder.append(this.getRealStringRepresentation());
                stringBuilder.append("</real>");
                break;
            }
            case 2: {
                if (this.boolValue) {
                    stringBuilder.append("<true/>");
                    break;
                }
                stringBuilder.append("<false/>");
                break;
            }
            default: {
                throw new IllegalStateException("The NSNumber instance has an invalid type: " + this.type);
            }
        }
    }

    @Override
    void toBinary(BinaryPropertyListWriter binaryPropertyListWriter) throws IOException {
        switch (this.type()) {
            case 0: {
                if (this.longValue() < 0L) {
                    binaryPropertyListWriter.write(19);
                    binaryPropertyListWriter.writeBytes(this.longValue, 8);
                    break;
                }
                if (this.longValue <= 255L) {
                    binaryPropertyListWriter.write(16);
                    binaryPropertyListWriter.writeBytes(this.longValue(), 1);
                    break;
                }
                if (this.longValue <= 65535L) {
                    binaryPropertyListWriter.write(17);
                    binaryPropertyListWriter.writeBytes(this.longValue(), 2);
                    break;
                }
                if (this.longValue <= 0xFFFFFFFFL) {
                    binaryPropertyListWriter.write(18);
                    binaryPropertyListWriter.writeBytes(this.longValue, 4);
                    break;
                }
                binaryPropertyListWriter.write(19);
                binaryPropertyListWriter.writeBytes(this.longValue, 8);
                break;
            }
            case 1: {
                binaryPropertyListWriter.write(35);
                binaryPropertyListWriter.writeDouble(this.doubleValue);
                break;
            }
            case 2: {
                binaryPropertyListWriter.write(this.boolValue ? 9 : 8);
                break;
            }
            default: {
                throw new IllegalStateException("The NSNumber instance has an invalid type: " + this.type);
            }
        }
    }

    @Override
    protected void toASCII(StringBuilder stringBuilder, int n) {
        this.indent(stringBuilder, n);
        if (this.isBoolean()) {
            stringBuilder.append(this.boolValue ? YES_SYMBOL : NO_SYMOBL);
        } else {
            stringBuilder.append(this.stringValue());
        }
    }

    @Override
    protected void toASCIIGnuStep(StringBuilder stringBuilder, int n) {
        this.indent(stringBuilder, n);
        switch (this.type()) {
            case 0: {
                stringBuilder.append("<*I");
                stringBuilder.append(this.longValue);
                stringBuilder.append('>');
                break;
            }
            case 1: {
                stringBuilder.append("<*R");
                stringBuilder.append(this.getRealStringRepresentation());
                stringBuilder.append('>');
                break;
            }
            case 2: {
                if (this.boolValue()) {
                    stringBuilder.append("<*BY>");
                    break;
                }
                stringBuilder.append("<*BN>");
                break;
            }
            default: {
                throw new IllegalStateException("The NSNumber instance has an invalid type: " + this.type);
            }
        }
    }

    private void throwIfIntegerValueNotAvailable() {
        if (this.type == 1) {
            if (Double.isNaN(this.doubleValue)) {
                throw new IllegalStateException("The integer value is not available because the value of this NSNumber instance is NaN.");
            }
            if (this.doubleValue == Double.POSITIVE_INFINITY) {
                throw new IllegalStateException("The integer value is not available because the value of this NSNumber instance is positive infinity.");
            }
            if (this.doubleValue == Double.NEGATIVE_INFINITY) {
                throw new IllegalStateException("The integer value is not available because the value of this NSNumber instance is negative infinity.");
            }
        }
    }

    private String getRealStringRepresentation() {
        if (Double.isNaN(this.doubleValue)) {
            return NAN_SYMBOL;
        }
        if (this.doubleValue == Double.POSITIVE_INFINITY) {
            return POSTIIVE_INFINITY_SYMBOL;
        }
        if (this.doubleValue == Double.NEGATIVE_INFINITY) {
            return NEGATIVE_INFINITY_SYMBOL;
        }
        return String.valueOf(this.doubleValue);
    }
}

