/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.Base64;
import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.NSObject;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;

public class NSData
extends NSObject {
    private final byte[] bytes;

    public NSData(byte[] byArray) {
        this.bytes = byArray;
    }

    public NSData(String string) throws IOException {
        String string2 = string.replaceAll("\\s+", "");
        this.bytes = Base64.decode(string2, 4);
    }

    public NSData(File file) throws IOException {
        this.bytes = new byte[(int)file.length()];
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        randomAccessFile.read(this.bytes);
        randomAccessFile.close();
    }

    public byte[] bytes() {
        return this.bytes;
    }

    public int length() {
        return this.bytes.length;
    }

    public void getBytes(ByteBuffer byteBuffer, int n) {
        byteBuffer.put(this.bytes, 0, Math.min(this.bytes.length, n));
    }

    public void getBytes(ByteBuffer byteBuffer, int n, int n2) {
        byteBuffer.put(this.bytes, n, Math.min(this.bytes.length, n2));
    }

    public String getBase64EncodedData() {
        return Base64.encodeBytes(this.bytes);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return object.getClass().equals(this.getClass()) && Arrays.equals(((NSData)object).bytes, this.bytes);
    }

    public int hashCode() {
        int n = 5;
        n = 67 * n + Arrays.hashCode(this.bytes);
        return n;
    }

    @Override
    public NSData clone() {
        return new NSData((byte[])this.bytes.clone());
    }

    @Override
    public Object toJavaObject() {
        return this.bytes.clone();
    }

    @Override
    public int compareTo(NSObject nSObject) {
        Objects.requireNonNull(nSObject);
        if (nSObject == this) {
            return 0;
        }
        if (nSObject instanceof NSData) {
            NSData nSData = (NSData)nSObject;
            if (nSData.length() != this.length()) {
                return Integer.compare(this.length(), nSData.length());
            }
            for (int i = 0; i < this.bytes.length; ++i) {
                int n = Byte.compare(this.bytes[i], nSData.bytes[i]);
                if (n == 0) continue;
                return n;
            }
            return 0;
        }
        return this.getClass().getName().compareTo(nSObject.getClass().getName());
    }

    @Override
    void toXML(StringBuilder stringBuilder, int n) {
        this.indent(stringBuilder, n);
        stringBuilder.append("<data>");
        stringBuilder.append(NSObject.NEWLINE);
        String string = this.getBase64EncodedData();
        for (String string2 : string.split("\n")) {
            this.indent(stringBuilder, n + 1);
            stringBuilder.append(string2);
            stringBuilder.append(NSObject.NEWLINE);
        }
        this.indent(stringBuilder, n);
        stringBuilder.append("</data>");
    }

    @Override
    void toBinary(BinaryPropertyListWriter binaryPropertyListWriter) throws IOException {
        binaryPropertyListWriter.writeIntHeader(4, this.bytes.length);
        binaryPropertyListWriter.write(this.bytes);
    }

    @Override
    protected void toASCII(StringBuilder stringBuilder, int n) {
        this.indent(stringBuilder, n);
        stringBuilder.append('<');
        int n2 = stringBuilder.lastIndexOf(NEWLINE);
        for (int i = 0; i < this.bytes.length; ++i) {
            int n3 = this.bytes[i] & 0xFF;
            if (n3 < 16) {
                stringBuilder.append('0');
            }
            stringBuilder.append(Integer.toHexString(n3));
            if (stringBuilder.length() - n2 > 80) {
                stringBuilder.append(NEWLINE);
                n2 = stringBuilder.length();
                continue;
            }
            if ((i + 1) % 2 != 0 || i == this.bytes.length - 1) continue;
            stringBuilder.append(' ');
        }
        stringBuilder.append('>');
    }

    @Override
    protected void toASCIIGnuStep(StringBuilder stringBuilder, int n) {
        this.toASCII(stringBuilder, n);
    }
}

