/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.NSArray;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.NSSet;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class BinaryPropertyListWriter {
    private static final int VERSION_00 = 0;
    private static final int VERSION_10 = 10;
    private static final int VERSION_15 = 15;
    private static final int VERSION_20 = 20;
    private int version = 0;
    private final OutputStream out;
    private long count;
    private final Map<NSObject, Integer> idMap = new LinkedHashMap<NSObject, Integer>();
    private int idSizeInBytes;

    BinaryPropertyListWriter(OutputStream outputStream, int n) {
        this.version = n;
        this.out = new BufferedOutputStream(outputStream);
    }

    private static int getMinimumRequiredVersion(NSObject nSObject) {
        int n;
        block5: {
            block6: {
                block4: {
                    n = 0;
                    if (nSObject == null) {
                        n = 10;
                    }
                    if (!(nSObject instanceof NSDictionary)) break block4;
                    NSDictionary nSDictionary = (NSDictionary)nSObject;
                    for (NSObject nSObject2 : nSDictionary.getHashMap().values()) {
                        int n2 = BinaryPropertyListWriter.getMinimumRequiredVersion(nSObject2);
                        if (n2 <= n) continue;
                        n = n2;
                    }
                    break block5;
                }
                if (!(nSObject instanceof NSArray)) break block6;
                NSArray nSArray = (NSArray)nSObject;
                for (NSObject nSObject3 : nSArray.getArray()) {
                    int n3 = BinaryPropertyListWriter.getMinimumRequiredVersion(nSObject3);
                    if (n3 <= n) continue;
                    n = n3;
                }
                break block5;
            }
            if (!(nSObject instanceof NSSet)) break block5;
            n = 10;
            NSSet nSSet = (NSSet)nSObject;
            for (NSObject nSObject4 : nSSet.allObjects()) {
                int n4 = BinaryPropertyListWriter.getMinimumRequiredVersion(nSObject4);
                if (n4 <= n) continue;
                n = n4;
            }
        }
        return n;
    }

    @Deprecated
    public static void write(File file, NSObject nSObject) throws IOException {
        BinaryPropertyListWriter.write(nSObject, file.toPath());
    }

    public static void write(NSObject nSObject, File file) throws IOException {
        BinaryPropertyListWriter.write(nSObject, file.toPath());
    }

    public static void write(NSObject nSObject, File file, boolean bl) throws IOException {
        File file2;
        if (bl && !(file2 = file.getParentFile()).exists() && !file2.mkdirs()) {
            throw new IOException("The output directory does not exist and could not be created.");
        }
        BinaryPropertyListWriter.write(nSObject, file.toPath());
    }

    public static void write(NSObject nSObject, Path path) throws IOException {
        Objects.requireNonNull(nSObject, "The root object is null.");
        try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
            BinaryPropertyListWriter.write(outputStream, nSObject);
        }
    }

    @Deprecated
    public static void write(OutputStream outputStream, NSObject nSObject) throws IOException {
        BinaryPropertyListWriter.write(nSObject, outputStream);
    }

    public static void write(NSObject nSObject, OutputStream outputStream) throws IOException {
        Objects.requireNonNull(nSObject, "The root object is null.");
        Objects.requireNonNull(outputStream, "The output stream is null.");
        int n = BinaryPropertyListWriter.getMinimumRequiredVersion(nSObject);
        if (n > 0) {
            String string = n == 10 ? "v1.0" : (n == 15 ? "v1.5" : (n == 20 ? "v2.0" : "v0.0"));
            throw new IOException("The given property list structure cannot be saved. The required version of the binary format (" + string + ") is not yet supported.");
        }
        BinaryPropertyListWriter binaryPropertyListWriter = new BinaryPropertyListWriter(outputStream, n);
        binaryPropertyListWriter.write(nSObject);
    }

    public static byte[] writeToArray(NSObject nSObject) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BinaryPropertyListWriter.write(byteArrayOutputStream, nSObject);
        return byteArrayOutputStream.toByteArray();
    }

    void write(NSObject nSObject) throws IOException {
        this.write(new byte[]{98, 112, 108, 105, 115, 116});
        switch (this.version) {
            case 0: {
                this.write(new byte[]{48, 48});
                break;
            }
            case 10: {
                this.write(new byte[]{49, 48});
                break;
            }
            case 15: {
                this.write(new byte[]{49, 53});
                break;
            }
            case 20: {
                this.write(new byte[]{50, 48});
                break;
            }
        }
        nSObject.assignIDs(this);
        this.idSizeInBytes = BinaryPropertyListWriter.computeIdSizeInBytes(this.idMap.size());
        long[] lArray = new long[this.idMap.size()];
        for (Map.Entry<NSObject, Integer> entry : this.idMap.entrySet()) {
            NSObject nSObject2 = entry.getKey();
            int n = entry.getValue();
            lArray[n] = this.count;
            if (nSObject2 == null) {
                this.write(0);
                continue;
            }
            nSObject2.toBinary(this);
        }
        long l = this.count;
        int n = this.computeOffsetSizeInBytes(this.count);
        for (long l2 : lArray) {
            this.writeBytes(l2, n);
        }
        if (this.version != 15) {
            this.write(new byte[6]);
            this.write(n);
            this.write(this.idSizeInBytes);
            this.writeLong(this.idMap.size());
            this.writeLong(this.idMap.get(nSObject).intValue());
            this.writeLong(l);
        }
        this.out.flush();
    }

    void assignID(NSObject nSObject) {
        if (!this.idMap.containsKey(nSObject)) {
            this.idMap.put(nSObject, this.idMap.size());
        }
    }

    int getID(NSObject nSObject) {
        return this.idMap.get(nSObject);
    }

    private static int computeIdSizeInBytes(int n) {
        if (n < 256) {
            return 1;
        }
        if (n < 65536) {
            return 2;
        }
        return 4;
    }

    private int computeOffsetSizeInBytes(long l) {
        if (l < 256L) {
            return 1;
        }
        if (l < 65536L) {
            return 2;
        }
        if (l < 0x100000000L) {
            return 4;
        }
        return 8;
    }

    void writeIntHeader(int n, int n2) throws IOException {
        assert (n2 >= 0);
        if (n2 < 15) {
            this.write((n << 4) + n2);
        } else if (n2 < 256) {
            this.write((n << 4) + 15);
            this.write(16);
            this.writeBytes(n2, 1);
        } else if (n2 < 65536) {
            this.write((n << 4) + 15);
            this.write(17);
            this.writeBytes(n2, 2);
        } else {
            this.write((n << 4) + 15);
            this.write(18);
            this.writeBytes(n2, 4);
        }
    }

    void write(int n) throws IOException {
        this.out.write(n);
        ++this.count;
    }

    void write(byte[] byArray) throws IOException {
        this.out.write(byArray);
        this.count += (long)byArray.length;
    }

    void writeBytes(long l, int n) throws IOException {
        for (int i = n - 1; i >= 0; --i) {
            this.write((int)(l >> 8 * i));
        }
    }

    void writeID(int n) throws IOException {
        this.writeBytes(n, this.idSizeInBytes);
    }

    void writeLong(long l) throws IOException {
        this.writeBytes(l, 8);
    }

    void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToRawLongBits(d));
    }
}

