/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.NSArray;
import com.dd.plist.NSDictionary;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;

public final class ASCIIPropertyListWriter {
    private ASCIIPropertyListWriter() {
    }

    public static void write(NSDictionary nSDictionary, File file) throws IOException {
        File file2 = file.getParentFile();
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException("The output directory does not exist and could not be created.");
        }
        ASCIIPropertyListWriter.write(nSDictionary, file.toPath());
    }

    public static void write(NSDictionary nSDictionary, Path path) throws IOException {
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(Files.newOutputStream(path, new OpenOption[0]), StandardCharsets.US_ASCII);){
            outputStreamWriter.write(nSDictionary.toASCIIPropertyList());
        }
    }

    public static void write(NSArray nSArray, File file) throws IOException {
        Objects.requireNonNull(nSArray, "The root object is null.");
        File file2 = file.getParentFile();
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException("The output directory does not exist and could not be created.");
        }
        ASCIIPropertyListWriter.write(nSArray, file.toPath());
    }

    public static void write(NSArray nSArray, Path path) throws IOException {
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(Files.newOutputStream(path, new OpenOption[0]), StandardCharsets.US_ASCII);){
            outputStreamWriter.write(nSArray.toASCIIPropertyList());
        }
    }

    public static void writeGnuStep(NSDictionary nSDictionary, File file) throws IOException {
        Objects.requireNonNull(nSDictionary, "The root object is null.");
        File file2 = file.getParentFile();
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException("The output directory does not exist and could not be created.");
        }
        ASCIIPropertyListWriter.writeGnuStep(nSDictionary, file.toPath());
    }

    public static void writeGnuStep(NSDictionary nSDictionary, Path path) throws IOException {
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(Files.newOutputStream(path, new OpenOption[0]), StandardCharsets.US_ASCII);){
            outputStreamWriter.write(nSDictionary.toGnuStepASCIIPropertyList());
        }
    }

    public static void writeGnuStep(NSArray nSArray, File file) throws IOException {
        Objects.requireNonNull(nSArray, "The root object is null.");
        File file2 = file.getParentFile();
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException("The output directory does not exist and could not be created.");
        }
        ASCIIPropertyListWriter.writeGnuStep(nSArray, file.toPath());
    }

    public static void writeGnuStep(NSArray nSArray, Path path) throws IOException {
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(Files.newOutputStream(path, new OpenOption[0]), StandardCharsets.US_ASCII);){
            outputStreamWriter.write(nSArray.toGnuStepASCIIPropertyList());
        }
    }
}

