/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.quartz.collections;

import java.io.Serializable;
import java.util.Date;
import org.quartz.Trigger;
import org.quartz.TriggerKey;

public class TimeTrigger
implements Comparable<TimeTrigger>,
Serializable {
    private final TriggerKey triggerKey;
    private final Long nextFireTime;
    private final int priority;

    TimeTrigger(TriggerKey triggerKey, Date date, int n) {
        this.triggerKey = triggerKey;
        this.nextFireTime = date == null ? null : Long.valueOf(date.getTime());
        this.priority = n;
    }

    TriggerKey getTriggerKey() {
        return this.triggerKey;
    }

    int getPriority() {
        return this.priority;
    }

    Date getNextFireTime() {
        return this.nextFireTime == null ? null : new Date(this.nextFireTime);
    }

    public boolean equals(Object object) {
        if (object instanceof TimeTrigger) {
            TimeTrigger timeTrigger = (TimeTrigger)object;
            return this.triggerKey.equals(timeTrigger.triggerKey);
        }
        return false;
    }

    public int hashCode() {
        return this.triggerKey.hashCode();
    }

    public String toString() {
        return "TimeTrigger [triggerKey=" + this.triggerKey + ", nextFireTime=" + new Date(this.nextFireTime) + ", priority=" + this.priority + "]";
    }

    @Override
    public int compareTo(TimeTrigger timeTrigger) {
        TimeTrigger timeTrigger2 = this;
        return Trigger.TriggerTimeComparator.compare(timeTrigger2.getNextFireTime(), timeTrigger2.getPriority(), timeTrigger2.getTriggerKey(), timeTrigger.getNextFireTime(), timeTrigger.getPriority(), timeTrigger.getTriggerKey());
    }
}

