/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.quartz;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.quartz.Calendar;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.matchers.StringMatcher;
import org.quartz.impl.triggers.SimpleTriggerImpl;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.OperableTrigger;
import org.quartz.spi.SchedulerSignaler;
import org.quartz.spi.TriggerFiredBundle;
import org.quartz.spi.TriggerFiredResult;
import org.quartz.utils.DirtyFlagMap;
import org.quartz.utils.Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.quartz.ClusteredJobStore;
import org.terracotta.quartz.TransactionControllingLock;
import org.terracotta.quartz.collections.TimeTriggerSet;
import org.terracotta.quartz.collections.ToolkitDSHolder;
import org.terracotta.quartz.wrappers.DefaultWrapperFactory;
import org.terracotta.quartz.wrappers.FiredTrigger;
import org.terracotta.quartz.wrappers.JobFacade;
import org.terracotta.quartz.wrappers.JobWrapper;
import org.terracotta.quartz.wrappers.TriggerFacade;
import org.terracotta.quartz.wrappers.TriggerWrapper;
import org.terracotta.quartz.wrappers.WrapperFactory;
import org.terracotta.toolkit.Toolkit;
import org.terracotta.toolkit.atomic.ToolkitTransactionType;
import org.terracotta.toolkit.cluster.ClusterEvent;
import org.terracotta.toolkit.cluster.ClusterInfo;
import org.terracotta.toolkit.cluster.ClusterListener;
import org.terracotta.toolkit.concurrent.locks.ToolkitLock;
import org.terracotta.toolkit.internal.ToolkitInternal;
import org.terracotta.toolkit.internal.concurrent.locks.ToolkitLockTypeInternal;
import org.terracotta.toolkit.rejoin.RejoinException;
import org.terracotta.toolkit.store.ToolkitStore;

class DefaultClusteredJobStore
implements ClusteredJobStore {
    private final ToolkitDSHolder toolkitDSHolder;
    private final Toolkit toolkit;
    private final JobFacade jobFacade;
    private final TriggerFacade triggerFacade;
    private final TimeTriggerSet timeTriggers;
    private final ToolkitStore<String, Calendar> calendarsByName;
    private long misfireThreshold = 60000L;
    private final ToolkitLockTypeInternal lockType;
    private final transient ToolkitLock lock;
    private final ClusterInfo clusterInfo;
    private final WrapperFactory wrapperFactory;
    private long ftrCtr;
    private volatile SchedulerSignaler signaler;
    private final Logger logger;
    private volatile String terracottaClientId;
    private long estimatedTimeToReleaseAndAcquireTrigger = 15L;
    private volatile LocalLockState localStateLock;
    private volatile TriggerRemovedFromCandidateFiringListHandler triggerRemovedFromCandidateFiringListHandler;
    private volatile boolean toolkitShutdown;
    private long retryInterval;

    public DefaultClusteredJobStore(boolean bl, Toolkit toolkit, String string) {
        this(bl, toolkit, string, new ToolkitDSHolder(string, toolkit), new DefaultWrapperFactory());
    }

    public DefaultClusteredJobStore(boolean bl, Toolkit toolkit, String string, ToolkitDSHolder toolkitDSHolder, WrapperFactory wrapperFactory) {
        this.toolkit = toolkit;
        this.wrapperFactory = wrapperFactory;
        this.clusterInfo = toolkit.getClusterInfo();
        this.toolkitDSHolder = toolkitDSHolder;
        this.jobFacade = new JobFacade(toolkitDSHolder);
        this.triggerFacade = new TriggerFacade(toolkitDSHolder);
        this.timeTriggers = toolkitDSHolder.getOrCreateTimeTriggerSet();
        this.calendarsByName = toolkitDSHolder.getOrCreateCalendarWrapperMap();
        this.lockType = bl ? ToolkitLockTypeInternal.SYNCHRONOUS_WRITE : ToolkitLockTypeInternal.WRITE;
        ToolkitTransactionType toolkitTransactionType = bl ? ToolkitTransactionType.SYNC : ToolkitTransactionType.NORMAL;
        this.lock = new TransactionControllingLock((ToolkitInternal)toolkit, toolkitDSHolder.getLock(this.lockType), toolkitTransactionType);
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.getLog().info("Synchronous write locking is [" + bl + "]");
    }

    private Logger getLog() {
        return this.logger;
    }

    private void disable() {
        this.toolkitShutdown = true;
        try {
            this.getLocalLockState().disableLocking();
        }
        catch (InterruptedException interruptedException) {
            this.getLog().error("failed to disable the job store", interruptedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalLockState getLocalLockState() {
        LocalLockState localLockState = this.localStateLock;
        if (localLockState != null) {
            return localLockState;
        }
        Class<DefaultClusteredJobStore> clazz = DefaultClusteredJobStore.class;
        synchronized (DefaultClusteredJobStore.class) {
            if (this.localStateLock == null) {
                this.localStateLock = new LocalLockState();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.localStateLock;
        }
    }

    void lock() throws JobPersistenceException {
        this.getLocalLockState().attemptAcquireBegin();
        try {
            this.lock.lock();
        }
        catch (RejoinException rejoinException) {
            this.getLocalLockState().release();
            throw rejoinException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unlock() {
        try {
            this.lock.unlock();
        }
        finally {
            this.getLocalLockState().release();
        }
    }

    @Override
    public void initialize(ClassLoadHelper classLoadHelper, SchedulerSignaler schedulerSignaler) {
        this.terracottaClientId = this.clusterInfo.getCurrentNode().getId();
        this.ftrCtr = System.currentTimeMillis();
        this.signaler = schedulerSignaler;
        this.getLog().info(this.getClass().getSimpleName() + " initialized.");
        ((ToolkitInternal)this.toolkit).registerBeforeShutdownHook((Runnable)new ShutdownHook(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedulerStarted() throws SchedulerException {
        this.clusterInfo.addClusterListener((ClusterListener)this);
        Set set = this.clusterInfo.getNodes();
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object : set) {
            boolean bl = hashSet.add(object.getId());
            if (bl) continue;
            this.getLog().error("DUPLICATE node ID detected: " + object);
        }
        this.lock();
        try {
            TriggerWrapper triggerWrapper;
            Object object;
            ArrayList arrayList = new ArrayList();
            for (TriggerKey triggerKey : this.triggerFacade.allTriggerKeys()) {
                triggerWrapper = this.triggerFacade.get(triggerKey);
                String string = triggerWrapper.getLastTerracotaClientId();
                if (string == null || hashSet.contains(string) && triggerWrapper.getState() != TriggerWrapper.TriggerState.ERROR) continue;
                arrayList.add(triggerWrapper);
            }
            object = arrayList.iterator();
            while (object.hasNext()) {
                TriggerWrapper triggerWrapper2 = (TriggerWrapper)object.next();
                this.evalOrphanedTrigger(triggerWrapper2, true);
            }
            object = this.triggerFacade.allFiredTriggers().iterator();
            while (object.hasNext()) {
                FiredTrigger firedTrigger = (FiredTrigger)object.next();
                if (hashSet.contains(firedTrigger.getClientId())) continue;
                this.getLog().info("Found non-complete fired trigger: " + firedTrigger);
                object.remove();
                triggerWrapper = this.triggerFacade.get(firedTrigger.getTriggerKey());
                if (triggerWrapper == null) {
                    this.getLog().error("no trigger found for executing trigger: " + firedTrigger.getTriggerKey());
                    continue;
                }
                this.scheduleRecoveryIfNeeded(triggerWrapper, firedTrigger);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void schedulerPaused() {
    }

    @Override
    public void schedulerResumed() {
    }

    private void evalOrphanedTrigger(TriggerWrapper triggerWrapper, boolean bl) {
        this.getLog().info("Evaluating orphaned trigger " + triggerWrapper);
        JobWrapper jobWrapper = this.jobFacade.get(triggerWrapper.getJobKey());
        if (jobWrapper == null) {
            this.getLog().error("No job found for orphaned trigger: " + triggerWrapper);
            this.jobFacade.removeBlockedJob(triggerWrapper.getJobKey());
            return;
        }
        if (bl && triggerWrapper.getState() == TriggerWrapper.TriggerState.ERROR) {
            triggerWrapper.setState(TriggerWrapper.TriggerState.WAITING, this.terracottaClientId, this.triggerFacade);
            this.timeTriggers.add(triggerWrapper);
        }
        if (triggerWrapper.getState() == TriggerWrapper.TriggerState.BLOCKED) {
            triggerWrapper.setState(TriggerWrapper.TriggerState.WAITING, this.terracottaClientId, this.triggerFacade);
            this.timeTriggers.add(triggerWrapper);
        } else if (triggerWrapper.getState() == TriggerWrapper.TriggerState.PAUSED_BLOCKED) {
            triggerWrapper.setState(TriggerWrapper.TriggerState.PAUSED, this.terracottaClientId, this.triggerFacade);
        }
        if (triggerWrapper.getState() == TriggerWrapper.TriggerState.ACQUIRED) {
            triggerWrapper.setState(TriggerWrapper.TriggerState.WAITING, this.terracottaClientId, this.triggerFacade);
            this.timeTriggers.add(triggerWrapper);
        }
        if (!triggerWrapper.mayFireAgain() && !jobWrapper.requestsRecovery()) {
            try {
                this.removeTrigger(triggerWrapper.getKey());
            }
            catch (JobPersistenceException jobPersistenceException) {
                this.getLog().error("Can't remove completed trigger (and related job) " + triggerWrapper, jobPersistenceException);
            }
        }
        if (jobWrapper.isConcurrentExectionDisallowed()) {
            this.jobFacade.removeBlockedJob(jobWrapper.getKey());
            List<TriggerWrapper> list = this.triggerFacade.getTriggerWrappersForJob(jobWrapper.getKey());
            for (TriggerWrapper triggerWrapper2 : list) {
                if (triggerWrapper2.getState() == TriggerWrapper.TriggerState.BLOCKED) {
                    triggerWrapper2.setState(TriggerWrapper.TriggerState.WAITING, this.terracottaClientId, this.triggerFacade);
                    this.timeTriggers.add(triggerWrapper2);
                    continue;
                }
                if (triggerWrapper2.getState() != TriggerWrapper.TriggerState.PAUSED_BLOCKED) continue;
                triggerWrapper2.setState(TriggerWrapper.TriggerState.PAUSED, this.terracottaClientId, this.triggerFacade);
            }
        }
    }

    private void scheduleRecoveryIfNeeded(TriggerWrapper triggerWrapper, FiredTrigger firedTrigger) {
        JobWrapper jobWrapper = this.jobFacade.get(triggerWrapper.getJobKey());
        if (jobWrapper == null) {
            this.getLog().error("No job found for orphaned trigger: " + triggerWrapper);
            return;
        }
        if (jobWrapper.requestsRecovery()) {
            OperableTrigger operableTrigger = this.createRecoveryTrigger(triggerWrapper, jobWrapper, "recover_" + this.terracottaClientId + "_" + this.ftrCtr++, firedTrigger);
            JobDataMap jobDataMap = triggerWrapper.getTriggerClone().getJobDataMap();
            jobDataMap.put("QRTZ_FAILED_JOB_ORIG_TRIGGER_NAME", triggerWrapper.getKey().getName());
            jobDataMap.put("QRTZ_FAILED_JOB_ORIG_TRIGGER_GROUP", triggerWrapper.getKey().getGroup());
            jobDataMap.put("QRTZ_FAILED_JOB_ORIG_TRIGGER_FIRETIME_IN_MILLISECONDS_AS_STRING", String.valueOf(firedTrigger.getFireTime()));
            jobDataMap.put("QRTZ_FAILED_JOB_ORIG_TRIGGER_SCHEDULED_FIRETIME_IN_MILLISECONDS_AS_STRING", String.valueOf(firedTrigger.getScheduledFireTime()));
            operableTrigger.setJobDataMap(jobDataMap);
            operableTrigger.computeFirstFireTime(null);
            try {
                this.storeTrigger(operableTrigger, false);
                if (!triggerWrapper.mayFireAgain()) {
                    this.removeTrigger(triggerWrapper.getKey());
                }
                this.getLog().info("Recovered job " + jobWrapper + " for trigger " + triggerWrapper);
            }
            catch (JobPersistenceException jobPersistenceException) {
                this.getLog().error("Can't recover job " + jobWrapper + " for trigger " + triggerWrapper, jobPersistenceException);
            }
        }
    }

    protected OperableTrigger createRecoveryTrigger(TriggerWrapper triggerWrapper, JobWrapper jobWrapper, String string, FiredTrigger firedTrigger) {
        SimpleTriggerImpl simpleTriggerImpl = new SimpleTriggerImpl(string, "RECOVERING_JOBS", new Date(firedTrigger.getScheduledFireTime()));
        simpleTriggerImpl.setJobName(jobWrapper.getKey().getName());
        simpleTriggerImpl.setJobGroup(jobWrapper.getKey().getGroup());
        simpleTriggerImpl.setMisfireInstruction(-1);
        simpleTriggerImpl.setPriority(triggerWrapper.getPriority());
        return simpleTriggerImpl;
    }

    private long getMisfireThreshold() {
        return this.misfireThreshold;
    }

    @Override
    public void setMisfireThreshold(long l) {
        if (l < 1L) {
            throw new IllegalArgumentException("Misfirethreashold must be larger than 0");
        }
        this.misfireThreshold = l;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public boolean supportsPersistence() {
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeJobAndTrigger(JobDetail jobDetail, OperableTrigger operableTrigger) throws JobPersistenceException {
        this.lock();
        try {
            this.storeJob(jobDetail, false);
            this.storeTrigger(operableTrigger, false);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeJob(JobDetail jobDetail, boolean bl) throws ObjectAlreadyExistsException, JobPersistenceException {
        JobDetail jobDetail2 = (JobDetail)jobDetail.clone();
        this.lock();
        try {
            JobWrapper jobWrapper = this.wrapperFactory.createJobWrapper(jobDetail2);
            if (this.jobFacade.containsKey(jobWrapper.getKey())) {
                if (!bl) {
                    throw new ObjectAlreadyExistsException(jobDetail);
                }
            } else {
                Set<String> set = this.toolkitDSHolder.getOrCreateJobsGroupMap(jobDetail.getKey().getGroup());
                set.add(jobWrapper.getKey().getName());
                if (!this.jobFacade.hasGroup(jobWrapper.getKey().getGroup())) {
                    this.jobFacade.addGroup(jobWrapper.getKey().getGroup());
                }
            }
            this.jobFacade.put(jobWrapper.getKey(), jobWrapper);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeJob(JobKey jobKey) throws JobPersistenceException {
        boolean bl = false;
        this.lock();
        try {
            List<OperableTrigger> list = this.getTriggersForJob(jobKey);
            for (OperableTrigger operableTrigger : list) {
                this.removeTrigger(operableTrigger.getKey());
                bl = true;
            }
            bl = this.jobFacade.remove(jobKey) != null | bl;
            if (bl) {
                Set<String> set = this.toolkitDSHolder.getOrCreateJobsGroupMap(jobKey.getGroup());
                set.remove(jobKey.getName());
                if (set.isEmpty()) {
                    this.toolkitDSHolder.removeJobsGroupMap(jobKey.getGroup());
                    this.jobFacade.removeGroup(jobKey.getGroup());
                }
            }
        }
        finally {
            this.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeJobs(List<JobKey> list) throws JobPersistenceException {
        boolean bl = true;
        this.lock();
        try {
            for (JobKey jobKey : list) {
                bl = this.removeJob(jobKey) && bl;
            }
        }
        finally {
            this.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeTriggers(List<TriggerKey> list) throws JobPersistenceException {
        boolean bl = true;
        this.lock();
        try {
            for (TriggerKey triggerKey : list) {
                bl = this.removeTrigger(triggerKey) && bl;
            }
        }
        finally {
            this.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeJobsAndTriggers(Map<JobDetail, Set<? extends Trigger>> map, boolean bl) throws ObjectAlreadyExistsException, JobPersistenceException {
        this.lock();
        try {
            if (!bl) {
                for (JobDetail jobDetail : map.keySet()) {
                    if (this.checkExists(jobDetail.getKey())) {
                        throw new ObjectAlreadyExistsException(jobDetail);
                    }
                    for (Trigger trigger : map.get(jobDetail)) {
                        if (!this.checkExists(trigger.getKey())) continue;
                        throw new ObjectAlreadyExistsException(trigger);
                    }
                }
            }
            for (JobDetail jobDetail : map.keySet()) {
                this.storeJob(jobDetail, true);
                for (Trigger trigger : map.get(jobDetail)) {
                    this.storeTrigger((OperableTrigger)trigger, true);
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeTrigger(OperableTrigger operableTrigger, boolean bl) throws JobPersistenceException {
        OperableTrigger operableTrigger2 = (OperableTrigger)operableTrigger.clone();
        this.lock();
        try {
            JobDetail jobDetail = this.retrieveJob(operableTrigger.getJobKey());
            if (jobDetail == null) {
                throw new JobPersistenceException("The job (" + operableTrigger.getJobKey() + ") referenced by the trigger does not exist.");
            }
            TriggerWrapper triggerWrapper = this.wrapperFactory.createTriggerWrapper(operableTrigger2, jobDetail.isConcurrentExectionDisallowed());
            if (this.triggerFacade.containsKey(triggerWrapper.getKey())) {
                if (!bl) {
                    throw new ObjectAlreadyExistsException(operableTrigger);
                }
                this.removeTrigger(operableTrigger.getKey(), false);
            }
            Set<String> set = this.toolkitDSHolder.getOrCreateTriggersGroupMap(operableTrigger.getKey().getGroup());
            set.add(operableTrigger.getKey().getName());
            if (!this.triggerFacade.hasGroup(operableTrigger.getKey().getGroup())) {
                this.triggerFacade.addGroup(operableTrigger.getKey().getGroup());
            }
            if (this.triggerFacade.pausedGroupsContain(operableTrigger.getKey().getGroup()) || this.jobFacade.pausedGroupsContain(operableTrigger.getJobKey().getGroup())) {
                triggerWrapper.setState(TriggerWrapper.TriggerState.PAUSED, this.terracottaClientId, this.triggerFacade);
                if (this.jobFacade.blockedJobsContain(triggerWrapper.getJobKey())) {
                    triggerWrapper.setState(TriggerWrapper.TriggerState.PAUSED_BLOCKED, this.terracottaClientId, this.triggerFacade);
                }
            } else if (this.jobFacade.blockedJobsContain(triggerWrapper.getJobKey())) {
                triggerWrapper.setState(TriggerWrapper.TriggerState.BLOCKED, this.terracottaClientId, this.triggerFacade);
            } else {
                this.timeTriggers.add(triggerWrapper);
            }
            this.triggerFacade.put(triggerWrapper.getKey(), triggerWrapper);
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public boolean removeTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        return this.removeTrigger(triggerKey, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeTrigger(TriggerKey triggerKey, boolean bl) throws JobPersistenceException {
        this.lock();
        TriggerWrapper triggerWrapper = null;
        try {
            triggerWrapper = this.triggerFacade.remove(triggerKey);
            if (triggerWrapper != null) {
                Set<String> set = this.toolkitDSHolder.getOrCreateTriggersGroupMap(triggerKey.getGroup());
                set.remove(triggerKey.getName());
                if (set.size() == 0) {
                    this.toolkitDSHolder.removeTriggersGroupMap(triggerKey.getGroup());
                    this.triggerFacade.removeGroup(triggerKey.getGroup());
                }
                this.timeTriggers.remove(triggerWrapper);
                if (bl) {
                    JobKey jobKey;
                    JobWrapper jobWrapper = this.jobFacade.get(triggerWrapper.getJobKey());
                    List<OperableTrigger> list = this.getTriggersForJob(triggerWrapper.getJobKey());
                    if ((list == null || list.size() == 0) && !jobWrapper.isDurable() && this.removeJob(jobKey = triggerWrapper.getJobKey())) {
                        this.signaler.notifySchedulerListenersJobDeleted(jobKey);
                    }
                }
            }
        }
        finally {
            this.unlock();
        }
        return triggerWrapper != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replaceTrigger(TriggerKey triggerKey, OperableTrigger operableTrigger) throws JobPersistenceException {
        boolean bl;
        block7: {
            bl = false;
            this.lock();
            try {
                TriggerWrapper triggerWrapper = this.triggerFacade.remove(triggerKey);
                boolean bl2 = bl = triggerWrapper != null;
                if (triggerWrapper == null) break block7;
                if (!triggerWrapper.getJobKey().equals(operableTrigger.getJobKey())) {
                    throw new JobPersistenceException("New trigger is not related to the same job as the old trigger.");
                }
                Set<String> set = this.toolkitDSHolder.getOrCreateTriggersGroupMap(triggerKey.getGroup());
                set.remove(triggerKey.getName());
                if (set.size() == 0) {
                    this.toolkitDSHolder.removeTriggersGroupMap(triggerKey.getGroup());
                    this.triggerFacade.removeGroup(triggerKey.getGroup());
                }
                this.timeTriggers.remove(triggerWrapper);
                try {
                    this.storeTrigger(operableTrigger, false);
                }
                catch (JobPersistenceException jobPersistenceException) {
                    this.storeTrigger(triggerWrapper.getTriggerClone(), false);
                    throw jobPersistenceException;
                }
            }
            finally {
                this.unlock();
            }
        }
        return bl;
    }

    @Override
    public JobDetail retrieveJob(JobKey jobKey) throws JobPersistenceException {
        JobWrapper jobWrapper = this.getJob(jobKey);
        return jobWrapper == null ? null : jobWrapper.getJobDetailClone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JobWrapper getJob(JobKey jobKey) throws JobPersistenceException {
        this.lock();
        try {
            JobWrapper jobWrapper = this.jobFacade.get(jobKey);
            return jobWrapper;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperableTrigger retrieveTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        this.lock();
        try {
            TriggerWrapper triggerWrapper = this.triggerFacade.get(triggerKey);
            OperableTrigger operableTrigger = triggerWrapper != null ? triggerWrapper.getTriggerClone() : null;
            return operableTrigger;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public boolean checkExists(JobKey jobKey) {
        return this.jobFacade.containsKey(jobKey);
    }

    @Override
    public boolean checkExists(TriggerKey triggerKey) throws JobPersistenceException {
        return this.triggerFacade.containsKey(triggerKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAllSchedulingData() throws JobPersistenceException {
        this.lock();
        try {
            Set<Key> set;
            List<String> list = this.getTriggerGroupNames();
            for (String string : list) {
                set = this.getTriggerKeys(GroupMatcher.triggerGroupEquals(string));
                for (TriggerKey key : set) {
                    this.removeTrigger(key);
                }
            }
            list = this.getJobGroupNames();
            for (String string : list) {
                set = this.getJobKeys(GroupMatcher.jobGroupEquals(string));
                for (JobKey jobKey : set) {
                    this.removeJob(jobKey);
                }
            }
            list = this.getCalendarNames();
            for (String string : list) {
                this.removeCalendar(string);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Trigger.TriggerState getTriggerState(TriggerKey triggerKey) throws JobPersistenceException {
        TriggerWrapper triggerWrapper;
        this.lock();
        try {
            triggerWrapper = this.triggerFacade.get(triggerKey);
        }
        finally {
            this.unlock();
        }
        if (triggerWrapper == null) {
            return Trigger.TriggerState.NONE;
        }
        if (triggerWrapper.getState() == TriggerWrapper.TriggerState.COMPLETE) {
            return Trigger.TriggerState.COMPLETE;
        }
        if (triggerWrapper.getState() == TriggerWrapper.TriggerState.PAUSED) {
            return Trigger.TriggerState.PAUSED;
        }
        if (triggerWrapper.getState() == TriggerWrapper.TriggerState.PAUSED_BLOCKED) {
            return Trigger.TriggerState.PAUSED;
        }
        if (triggerWrapper.getState() == TriggerWrapper.TriggerState.BLOCKED) {
            return Trigger.TriggerState.BLOCKED;
        }
        if (triggerWrapper.getState() == TriggerWrapper.TriggerState.ERROR) {
            return Trigger.TriggerState.ERROR;
        }
        return Trigger.TriggerState.NORMAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeCalendar(String string, Calendar calendar, boolean bl, boolean bl2) throws ObjectAlreadyExistsException, JobPersistenceException {
        Calendar calendar2 = (Calendar)calendar.clone();
        this.lock();
        try {
            Calendar calendar3 = (Calendar)this.calendarsByName.get((Object)string);
            if (calendar3 != null && !bl) {
                throw new ObjectAlreadyExistsException("Calendar with name '" + string + "' already exists.");
            }
            if (calendar3 != null) {
                this.calendarsByName.remove((Object)string);
            }
            Calendar calendar4 = calendar2;
            this.calendarsByName.putNoReturn((Object)string, (Object)calendar4);
            if (calendar3 != null && bl2) {
                for (TriggerWrapper triggerWrapper : this.triggerFacade.getTriggerWrappersForCalendar(string)) {
                    boolean bl3 = this.timeTriggers.remove(triggerWrapper);
                    triggerWrapper.updateWithNewCalendar(calendar2, this.getMisfireThreshold(), this.triggerFacade);
                    if (!bl3) continue;
                    this.timeTriggers.add(triggerWrapper);
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeCalendar(String string) throws JobPersistenceException {
        int n = 0;
        this.lock();
        try {
            for (TriggerKey triggerKey : this.triggerFacade.allTriggerKeys()) {
                TriggerWrapper triggerWrapper = this.triggerFacade.get(triggerKey);
                if (triggerWrapper.getCalendarName() == null || !triggerWrapper.getCalendarName().equals(string)) continue;
                ++n;
            }
            if (n > 0) {
                throw new JobPersistenceException("Calender cannot be removed if it referenced by a Trigger!");
            }
            boolean bl = this.calendarsByName.remove((Object)string) != null;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Calendar retrieveCalendar(String string) throws JobPersistenceException {
        this.lock();
        try {
            Calendar calendar = (Calendar)this.calendarsByName.get((Object)string);
            Calendar calendar2 = (Calendar)(calendar == null ? null : calendar.clone());
            return calendar2;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfJobs() throws JobPersistenceException {
        this.lock();
        try {
            int n = this.jobFacade.numberOfJobs();
            return n;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfTriggers() throws JobPersistenceException {
        this.lock();
        try {
            int n = this.triggerFacade.numberOfTriggers();
            return n;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfCalendars() throws JobPersistenceException {
        this.lock();
        try {
            int n = this.calendarsByName.size();
            return n;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<JobKey> getJobKeys(GroupMatcher<JobKey> groupMatcher) throws JobPersistenceException {
        this.lock();
        try {
            HashSet<String> hashSet = new HashSet<String>();
            switch (groupMatcher.getCompareWithOperator()) {
                case EQUALS: {
                    hashSet.add(groupMatcher.getCompareToValue());
                    break;
                }
                default: {
                    for (String object2 : this.jobFacade.getAllGroupNames()) {
                        if (!groupMatcher.getCompareWithOperator().evaluate(object2, groupMatcher.getCompareToValue())) continue;
                        hashSet.add(object2);
                    }
                }
            }
            HashSet hashSet2 = new HashSet();
            for (String string : hashSet) {
                Set<String> set = this.toolkitDSHolder.getOrCreateJobsGroupMap(string);
                for (String string2 : set) {
                    JobKey jobKey = new JobKey(string2, string);
                    if (!this.jobFacade.containsKey(jobKey)) continue;
                    hashSet2.add(jobKey);
                }
            }
            HashSet hashSet3 = hashSet2;
            return hashSet3;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getCalendarNames() throws JobPersistenceException {
        this.lock();
        try {
            Set set = this.calendarsByName.keySet();
            ArrayList<String> arrayList = new ArrayList<String>(set);
            return arrayList;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<TriggerKey> getTriggerKeys(GroupMatcher<TriggerKey> groupMatcher) throws JobPersistenceException {
        this.lock();
        try {
            HashSet<String> hashSet = new HashSet<String>();
            switch (groupMatcher.getCompareWithOperator()) {
                case EQUALS: {
                    hashSet.add(groupMatcher.getCompareToValue());
                    break;
                }
                default: {
                    for (String object2 : this.triggerFacade.allTriggersGroupNames()) {
                        if (!groupMatcher.getCompareWithOperator().evaluate(object2, groupMatcher.getCompareToValue())) continue;
                        hashSet.add(object2);
                    }
                }
            }
            HashSet hashSet2 = new HashSet();
            for (String string : hashSet) {
                Set<String> set = this.toolkitDSHolder.getOrCreateTriggersGroupMap(string);
                for (String string2 : set) {
                    TriggerKey triggerKey = new TriggerKey(string2, string);
                    TriggerWrapper triggerWrapper = this.triggerFacade.get(triggerKey);
                    if (triggerWrapper == null) continue;
                    hashSet2.add(triggerKey);
                }
            }
            HashSet hashSet3 = hashSet2;
            return hashSet3;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getJobGroupNames() throws JobPersistenceException {
        this.lock();
        try {
            ArrayList<String> arrayList = new ArrayList<String>(this.jobFacade.getAllGroupNames());
            return arrayList;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getTriggerGroupNames() throws JobPersistenceException {
        this.lock();
        try {
            ArrayList<String> arrayList = new ArrayList<String>(this.triggerFacade.allTriggersGroupNames());
            return arrayList;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OperableTrigger> getTriggersForJob(JobKey jobKey) throws JobPersistenceException {
        ArrayList<OperableTrigger> arrayList = new ArrayList<OperableTrigger>();
        this.lock();
        try {
            for (TriggerKey triggerKey : this.triggerFacade.allTriggerKeys()) {
                TriggerWrapper triggerWrapper = this.triggerFacade.get(triggerKey);
                if (!triggerWrapper.getJobKey().equals(jobKey)) continue;
                arrayList.add(triggerWrapper.getTriggerClone());
            }
        }
        finally {
            this.unlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        this.lock();
        try {
            TriggerWrapper triggerWrapper = this.triggerFacade.get(triggerKey);
            if (triggerWrapper == null) {
                return;
            }
            if (triggerWrapper.getState() == TriggerWrapper.TriggerState.COMPLETE) {
                return;
            }
            if (triggerWrapper.getState() == TriggerWrapper.TriggerState.BLOCKED) {
                triggerWrapper.setState(TriggerWrapper.TriggerState.PAUSED_BLOCKED, this.terracottaClientId, this.triggerFacade);
            } else {
                triggerWrapper.setState(TriggerWrapper.TriggerState.PAUSED, this.terracottaClientId, this.triggerFacade);
            }
            this.timeTriggers.remove(triggerWrapper);
            if (this.triggerRemovedFromCandidateFiringListHandler != null) {
                this.triggerRemovedFromCandidateFiringListHandler.removeCandidateTrigger(triggerWrapper);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> pauseTriggers(GroupMatcher<TriggerKey> groupMatcher) throws JobPersistenceException {
        HashSet<String> hashSet = new HashSet<String>();
        this.lock();
        try {
            Set<TriggerKey> set = this.getTriggerKeys(groupMatcher);
            for (TriggerKey triggerKey : set) {
                this.triggerFacade.addPausedGroup(triggerKey.getGroup());
                hashSet.add(triggerKey.getGroup());
                this.pauseTrigger(triggerKey);
            }
            Object object = groupMatcher.getCompareWithOperator();
            if (((Enum)object).equals((Object)StringMatcher.StringOperatorName.EQUALS)) {
                this.triggerFacade.addPausedGroup(groupMatcher.getCompareToValue());
                hashSet.add(groupMatcher.getCompareToValue());
            }
        }
        finally {
            this.unlock();
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseJob(JobKey jobKey) throws JobPersistenceException {
        this.lock();
        try {
            for (OperableTrigger operableTrigger : this.getTriggersForJob(jobKey)) {
                this.pauseTrigger(operableTrigger.getKey());
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> pauseJobs(GroupMatcher<JobKey> groupMatcher) throws JobPersistenceException {
        HashSet<String> hashSet = new HashSet<String>();
        this.lock();
        try {
            Set<JobKey> set = this.getJobKeys(groupMatcher);
            for (JobKey jobKey : set) {
                for (OperableTrigger operableTrigger : this.getTriggersForJob(jobKey)) {
                    this.pauseTrigger(operableTrigger.getKey());
                }
                hashSet.add(jobKey.getGroup());
            }
            Object object = groupMatcher.getCompareWithOperator();
            if (((Enum)object).equals((Object)StringMatcher.StringOperatorName.EQUALS)) {
                this.jobFacade.addPausedGroup(groupMatcher.getCompareToValue());
                hashSet.add(groupMatcher.getCompareToValue());
            }
        }
        finally {
            this.unlock();
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        this.lock();
        try {
            TriggerWrapper triggerWrapper = this.triggerFacade.get(triggerKey);
            if (triggerWrapper == null) {
                return;
            }
            if (triggerWrapper.getState() != TriggerWrapper.TriggerState.PAUSED && triggerWrapper.getState() != TriggerWrapper.TriggerState.PAUSED_BLOCKED) {
                return;
            }
            if (this.jobFacade.blockedJobsContain(triggerWrapper.getJobKey())) {
                triggerWrapper.setState(TriggerWrapper.TriggerState.BLOCKED, this.terracottaClientId, this.triggerFacade);
            } else {
                triggerWrapper.setState(TriggerWrapper.TriggerState.WAITING, this.terracottaClientId, this.triggerFacade);
            }
            this.applyMisfire(triggerWrapper);
            if (triggerWrapper.getState() == TriggerWrapper.TriggerState.WAITING) {
                this.timeTriggers.add(triggerWrapper);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> resumeTriggers(GroupMatcher<TriggerKey> groupMatcher) throws JobPersistenceException {
        HashSet<String> hashSet = new HashSet<String>();
        this.lock();
        try {
            Set<TriggerKey> set = this.getTriggerKeys(groupMatcher);
            for (TriggerKey triggerKey : set) {
                TriggerWrapper triggerWrapper = this.triggerFacade.get(triggerKey);
                if (triggerWrapper != null) {
                    String string = triggerWrapper.getJobKey().getGroup();
                    if (this.jobFacade.pausedGroupsContain(string)) continue;
                    hashSet.add(triggerKey.getGroup());
                }
                this.resumeTrigger(triggerKey);
            }
            this.triggerFacade.removeAllPausedGroups(hashSet);
        }
        finally {
            this.unlock();
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeJob(JobKey jobKey) throws JobPersistenceException {
        this.lock();
        try {
            for (OperableTrigger operableTrigger : this.getTriggersForJob(jobKey)) {
                this.resumeTrigger(operableTrigger.getKey());
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> resumeJobs(GroupMatcher<JobKey> groupMatcher) throws JobPersistenceException {
        HashSet<String> hashSet = new HashSet<String>();
        this.lock();
        try {
            Set<JobKey> set = this.getJobKeys(groupMatcher);
            for (JobKey jobKey : set) {
                if (hashSet.add(jobKey.getGroup())) {
                    this.jobFacade.removePausedJobGroup(jobKey.getGroup());
                }
                for (OperableTrigger operableTrigger : this.getTriggersForJob(jobKey)) {
                    this.resumeTrigger(operableTrigger.getKey());
                }
            }
        }
        finally {
            this.unlock();
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseAll() throws JobPersistenceException {
        this.lock();
        try {
            List<String> list = this.getTriggerGroupNames();
            for (String string : list) {
                this.pauseTriggers(GroupMatcher.triggerGroupEquals(string));
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeAll() throws JobPersistenceException {
        this.lock();
        try {
            this.jobFacade.clearPausedJobGroups();
            List<String> list = this.getTriggerGroupNames();
            for (String string : list) {
                this.resumeTriggers(GroupMatcher.triggerGroupEquals(string));
            }
        }
        finally {
            this.unlock();
        }
    }

    boolean applyMisfire(TriggerWrapper triggerWrapper) throws JobPersistenceException {
        Date date;
        long l = System.currentTimeMillis();
        if (this.getMisfireThreshold() > 0L) {
            l -= this.getMisfireThreshold();
        }
        if ((date = triggerWrapper.getNextFireTime()) == null || date.getTime() > l || triggerWrapper.getMisfireInstruction() == -1) {
            return false;
        }
        Calendar calendar = null;
        if (triggerWrapper.getCalendarName() != null) {
            calendar = this.retrieveCalendar(triggerWrapper.getCalendarName());
        }
        this.signaler.notifyTriggerListenersMisfired(triggerWrapper.getTriggerClone());
        triggerWrapper.updateAfterMisfire(calendar, this.triggerFacade);
        if (triggerWrapper.getNextFireTime() == null) {
            triggerWrapper.setState(TriggerWrapper.TriggerState.COMPLETE, this.terracottaClientId, this.triggerFacade);
            this.signaler.notifySchedulerListenersFinalized(triggerWrapper.getTriggerClone());
            this.timeTriggers.remove(triggerWrapper);
        } else if (date.equals(triggerWrapper.getNextFireTime())) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OperableTrigger> acquireNextTriggers(long l, int n, long l2) throws JobPersistenceException {
        ArrayList<OperableTrigger> arrayList = new ArrayList<OperableTrigger>();
        this.lock();
        try {
            for (TriggerWrapper triggerWrapper : this.getNextTriggerWrappers(this.timeTriggers, l, n, l2)) {
                arrayList.add(this.markAndCloneTrigger(triggerWrapper));
            }
            ArrayList<OperableTrigger> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            block8: {
                try {
                    this.unlock();
                }
                catch (RejoinException rejoinException) {
                    if (this.validateAcquired(arrayList)) break block8;
                    throw rejoinException;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validateAcquired(List<OperableTrigger> list) {
        if (list.isEmpty()) {
            return false;
        }
        while (!this.toolkitShutdown) {
            try {
                this.lock();
                try {
                    for (OperableTrigger operableTrigger : list) {
                        TriggerWrapper triggerWrapper = this.triggerFacade.get(operableTrigger.getKey());
                        if (operableTrigger.getFireInstanceId().equals(triggerWrapper.getTriggerClone().getFireInstanceId()) && TriggerWrapper.TriggerState.ACQUIRED.equals((Object)triggerWrapper.getState())) continue;
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    this.unlock();
                }
            }
            catch (JobPersistenceException jobPersistenceException) {
                try {
                    Thread.sleep(this.retryInterval);
                }
                catch (InterruptedException interruptedException) {
                    throw new IllegalStateException("Received interrupted exception", interruptedException);
                }
            }
            catch (RejoinException rejoinException) {
                try {
                    Thread.sleep(this.retryInterval);
                }
                catch (InterruptedException interruptedException) {
                    throw new IllegalStateException("Received interrupted exception", interruptedException);
                }
            }
        }
        throw new IllegalStateException("Scheduler has been shutdown");
    }

    OperableTrigger markAndCloneTrigger(TriggerWrapper triggerWrapper) {
        triggerWrapper.setState(TriggerWrapper.TriggerState.ACQUIRED, this.terracottaClientId, this.triggerFacade);
        String string = this.terracottaClientId + "-" + String.valueOf(this.ftrCtr++);
        triggerWrapper.setFireInstanceId(string, this.triggerFacade);
        return triggerWrapper.getTriggerClone();
    }

    List<TriggerWrapper> getNextTriggerWrappers(long l, int n, long l2) throws JobPersistenceException {
        return this.getNextTriggerWrappers(this.timeTriggers, l, n, l2);
    }

    List<TriggerWrapper> getNextTriggerWrappers(TimeTriggerSet timeTriggerSet, long l, int n, long l2) throws JobPersistenceException {
        ArrayList<TriggerWrapper> arrayList = new ArrayList<TriggerWrapper>();
        HashSet<JobKey> hashSet = new HashSet<JobKey>();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        JobPersistenceException jobPersistenceException = null;
        long l3 = l;
        try {
            while (true) {
                Object object = null;
                try {
                    TriggerKey serializable = timeTriggerSet.removeFirst();
                    if (serializable != null) {
                        object = this.triggerFacade.get(serializable);
                    }
                    if (object == null) {
                    }
                }
                catch (NoSuchElementException noSuchElementException) {}
                break;
                if (((TriggerWrapper)object).getNextFireTime() == null) continue;
                if (this.applyMisfire((TriggerWrapper)object)) {
                    if (((TriggerWrapper)object).getNextFireTime() == null) continue;
                    timeTriggerSet.add((TriggerWrapper)object);
                    continue;
                }
                if (((TriggerWrapper)object).getNextFireTime().getTime() > l3) {
                    timeTriggerSet.add((TriggerWrapper)object);
                    break;
                }
                if (((TriggerWrapper)object).jobDisallowsConcurrence()) {
                    if (hashSet.contains(((TriggerWrapper)object).getJobKey())) {
                        hashSet2.add(object);
                        continue;
                    }
                    hashSet.add(((TriggerWrapper)object).getJobKey());
                }
                if (arrayList.isEmpty()) {
                    l3 = Math.max(((TriggerWrapper)object).getNextFireTime().getTime(), System.currentTimeMillis()) + l2;
                }
                arrayList.add((TriggerWrapper)object);
                if (arrayList.size() == n) break;
            }
        }
        catch (JobPersistenceException jobPersistenceException2) {
            jobPersistenceException = jobPersistenceException2;
        }
        if (hashSet2.size() > 0) {
            for (TriggerWrapper triggerWrapper : hashSet2) {
                timeTriggerSet.add(triggerWrapper);
            }
        }
        if (jobPersistenceException != null) {
            for (TriggerWrapper triggerWrapper : arrayList) {
                timeTriggerSet.add(triggerWrapper);
            }
            throw new JobPersistenceException("Exception encountered while trying to select triggers for firing.", jobPersistenceException);
        }
        return arrayList;
    }

    public void setTriggerRemovedFromCandidateFiringListHandler(TriggerRemovedFromCandidateFiringListHandler triggerRemovedFromCandidateFiringListHandler) {
        this.triggerRemovedFromCandidateFiringListHandler = triggerRemovedFromCandidateFiringListHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseAcquiredTrigger(OperableTrigger operableTrigger) {
        while (!this.toolkitShutdown) {
            try {
                this.lock();
                try {
                    TriggerWrapper triggerWrapper = this.triggerFacade.get(operableTrigger.getKey());
                    if (triggerWrapper != null && operableTrigger.getFireInstanceId().equals(triggerWrapper.getTriggerClone().getFireInstanceId()) && triggerWrapper.getState() == TriggerWrapper.TriggerState.ACQUIRED) {
                        triggerWrapper.setState(TriggerWrapper.TriggerState.WAITING, this.terracottaClientId, this.triggerFacade);
                        this.timeTriggers.add(triggerWrapper);
                    }
                    break;
                }
                finally {
                    this.unlock();
                }
            }
            catch (RejoinException rejoinException) {
                try {
                    Thread.sleep(this.retryInterval);
                }
                catch (InterruptedException interruptedException) {
                    throw new IllegalStateException("Received interrupted exception", interruptedException);
                }
            }
            catch (JobPersistenceException jobPersistenceException) {
                try {
                    Thread.sleep(this.retryInterval);
                }
                catch (InterruptedException interruptedException) {
                    throw new IllegalStateException("Received interrupted exception", interruptedException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TriggerFiredResult> triggersFired(List<OperableTrigger> list) throws JobPersistenceException {
        ArrayList<TriggerFiredResult> arrayList = new ArrayList<TriggerFiredResult>();
        this.lock();
        try {
            for (OperableTrigger operableTrigger : list) {
                TriggerWrapper triggerWrapper = this.triggerFacade.get(operableTrigger.getKey());
                if (triggerWrapper == null) {
                    arrayList.add(new TriggerFiredResult((TriggerFiredBundle)null));
                    continue;
                }
                if (triggerWrapper.getState() != TriggerWrapper.TriggerState.ACQUIRED) {
                    arrayList.add(new TriggerFiredResult((TriggerFiredBundle)null));
                    continue;
                }
                Calendar calendar = null;
                if (triggerWrapper.getCalendarName() != null && (calendar = this.retrieveCalendar(triggerWrapper.getCalendarName())) == null) {
                    arrayList.add(new TriggerFiredResult((TriggerFiredBundle)null));
                    continue;
                }
                Date date = operableTrigger.getPreviousFireTime();
                this.timeTriggers.remove(triggerWrapper);
                triggerWrapper.triggered(calendar, this.triggerFacade);
                operableTrigger.triggered(calendar);
                triggerWrapper.setState(TriggerWrapper.TriggerState.WAITING, this.terracottaClientId, this.triggerFacade);
                TriggerFiredBundle triggerFiredBundle = new TriggerFiredBundle(this.retrieveJob(operableTrigger.getJobKey()), operableTrigger, calendar, false, new Date(), operableTrigger.getPreviousFireTime(), date, operableTrigger.getNextFireTime());
                String string = operableTrigger.getFireInstanceId();
                FiredTrigger firedTrigger = this.triggerFacade.getFiredTrigger(string);
                this.triggerFacade.putFiredTrigger(string, new FiredTrigger(this.terracottaClientId, triggerWrapper.getKey(), operableTrigger.getPreviousFireTime().getTime()));
                this.getLog().trace("Tracking " + operableTrigger + " has fired on " + string);
                if (firedTrigger != null) {
                    throw new AssertionError((Object)("duplicate fireInstanceId detected (" + string + ") for " + operableTrigger + ", previous is " + firedTrigger));
                }
                JobDetail jobDetail = triggerFiredBundle.getJobDetail();
                if (jobDetail.isConcurrentExectionDisallowed()) {
                    List<TriggerWrapper> list2 = this.triggerFacade.getTriggerWrappersForJob(jobDetail.getKey());
                    for (TriggerWrapper triggerWrapper2 : list2) {
                        if (triggerWrapper2.getKey().equals(triggerWrapper.getKey())) continue;
                        if (triggerWrapper2.getState() == TriggerWrapper.TriggerState.WAITING) {
                            triggerWrapper2.setState(TriggerWrapper.TriggerState.BLOCKED, this.terracottaClientId, this.triggerFacade);
                        }
                        if (triggerWrapper2.getState() == TriggerWrapper.TriggerState.PAUSED) {
                            triggerWrapper2.setState(TriggerWrapper.TriggerState.PAUSED_BLOCKED, this.terracottaClientId, this.triggerFacade);
                        }
                        this.timeTriggers.remove(triggerWrapper2);
                        if (this.triggerRemovedFromCandidateFiringListHandler == null) continue;
                        this.triggerRemovedFromCandidateFiringListHandler.removeCandidateTrigger(triggerWrapper2);
                    }
                    this.jobFacade.addBlockedJob(jobDetail.getKey());
                } else if (triggerWrapper.getNextFireTime() != null) {
                    this.timeTriggers.add(triggerWrapper);
                }
                arrayList.add(new TriggerFiredResult(triggerFiredBundle));
            }
            ArrayList<TriggerFiredResult> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            block18: {
                try {
                    this.unlock();
                }
                catch (RejoinException rejoinException) {
                    if (this.validateFiring(arrayList)) break block18;
                    throw rejoinException;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validateFiring(List<TriggerFiredResult> list) {
        if (list.isEmpty()) {
            return false;
        }
        while (!this.toolkitShutdown) {
            try {
                this.lock();
                try {
                    for (TriggerFiredResult triggerFiredResult : list) {
                        TriggerFiredBundle triggerFiredBundle = triggerFiredResult.getTriggerFiredBundle();
                        if (triggerFiredBundle == null || this.triggerFacade.containsFiredTrigger(triggerFiredBundle.getTrigger().getFireInstanceId())) continue;
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    this.unlock();
                }
            }
            catch (JobPersistenceException jobPersistenceException) {
                try {
                    Thread.sleep(this.retryInterval);
                }
                catch (InterruptedException interruptedException) {
                    throw new IllegalStateException("Received interrupted exception", interruptedException);
                }
            }
            catch (RejoinException rejoinException) {
                try {
                    Thread.sleep(this.retryInterval);
                }
                catch (InterruptedException interruptedException) {
                    throw new IllegalStateException("Received interrupted exception", interruptedException);
                }
            }
        }
        throw new IllegalStateException("Scheduler has been shutdown");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void triggeredJobComplete(OperableTrigger operableTrigger, JobDetail jobDetail, Trigger.CompletedExecutionInstruction completedExecutionInstruction) {
        while (!this.toolkitShutdown) {
            try {
                this.lock();
                try {
                    String string = operableTrigger.getFireInstanceId();
                    FiredTrigger firedTrigger = this.triggerFacade.removeFiredTrigger(string);
                    if (firedTrigger == null) {
                        this.getLog().warn("No fired trigger record found for " + operableTrigger + " (" + string + ")");
                    } else {
                        JobKey jobKey = jobDetail.getKey();
                        JobWrapper jobWrapper = this.jobFacade.get(jobKey);
                        TriggerWrapper triggerWrapper = this.triggerFacade.get(operableTrigger.getKey());
                        if (jobWrapper != null) {
                            Object object;
                            if (jobWrapper.isPersistJobDataAfterExecution()) {
                                object = jobDetail.getJobDataMap();
                                if (object != null) {
                                    object = (JobDataMap)((DirtyFlagMap)object).clone();
                                    ((DirtyFlagMap)object).clearDirtyFlag();
                                }
                                jobWrapper.setJobDataMap((JobDataMap)object, this.jobFacade);
                            }
                            if (jobWrapper.isConcurrentExectionDisallowed()) {
                                this.jobFacade.removeBlockedJob(jobWrapper.getKey());
                                triggerWrapper.setState(TriggerWrapper.TriggerState.WAITING, this.terracottaClientId, this.triggerFacade);
                                this.timeTriggers.add(triggerWrapper);
                                object = this.triggerFacade.getTriggerWrappersForJob(jobWrapper.getKey());
                                Iterator iterator = object.iterator();
                                while (iterator.hasNext()) {
                                    TriggerWrapper triggerWrapper2 = (TriggerWrapper)iterator.next();
                                    if (triggerWrapper2.getState() == TriggerWrapper.TriggerState.BLOCKED) {
                                        triggerWrapper2.setState(TriggerWrapper.TriggerState.WAITING, this.terracottaClientId, this.triggerFacade);
                                        this.timeTriggers.add(triggerWrapper2);
                                    }
                                    if (triggerWrapper2.getState() != TriggerWrapper.TriggerState.PAUSED_BLOCKED) continue;
                                    triggerWrapper2.setState(TriggerWrapper.TriggerState.PAUSED, this.terracottaClientId, this.triggerFacade);
                                }
                                this.signaler.signalSchedulingChange(0L);
                            }
                        } else {
                            this.jobFacade.removeBlockedJob(jobKey);
                        }
                        if (triggerWrapper != null) {
                            if (completedExecutionInstruction == Trigger.CompletedExecutionInstruction.DELETE_TRIGGER) {
                                if (operableTrigger.getNextFireTime() == null) {
                                    if (triggerWrapper.getNextFireTime() == null) {
                                        this.removeTrigger(operableTrigger.getKey());
                                    }
                                } else {
                                    this.removeTrigger(operableTrigger.getKey());
                                    this.signaler.signalSchedulingChange(0L);
                                }
                            } else if (completedExecutionInstruction == Trigger.CompletedExecutionInstruction.SET_TRIGGER_COMPLETE) {
                                triggerWrapper.setState(TriggerWrapper.TriggerState.COMPLETE, this.terracottaClientId, this.triggerFacade);
                                this.timeTriggers.remove(triggerWrapper);
                                this.signaler.signalSchedulingChange(0L);
                            } else if (completedExecutionInstruction == Trigger.CompletedExecutionInstruction.SET_TRIGGER_ERROR) {
                                this.getLog().info("Trigger " + operableTrigger.getKey() + " set to ERROR state.");
                                triggerWrapper.setState(TriggerWrapper.TriggerState.ERROR, this.terracottaClientId, this.triggerFacade);
                                this.signaler.signalSchedulingChange(0L);
                            } else if (completedExecutionInstruction == Trigger.CompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_ERROR) {
                                this.getLog().info("All triggers of Job " + operableTrigger.getJobKey() + " set to ERROR state.");
                                this.setAllTriggersOfJobToState(operableTrigger.getJobKey(), TriggerWrapper.TriggerState.ERROR);
                                this.signaler.signalSchedulingChange(0L);
                            } else if (completedExecutionInstruction == Trigger.CompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_COMPLETE) {
                                this.setAllTriggersOfJobToState(operableTrigger.getJobKey(), TriggerWrapper.TriggerState.COMPLETE);
                                this.signaler.signalSchedulingChange(0L);
                            }
                        }
                    }
                    break;
                }
                finally {
                    this.unlock();
                }
            }
            catch (RejoinException rejoinException) {
                try {
                    Thread.sleep(this.retryInterval);
                }
                catch (InterruptedException interruptedException) {
                    throw new IllegalStateException("Received interrupted exception", interruptedException);
                }
            }
            catch (JobPersistenceException jobPersistenceException) {
                try {
                    Thread.sleep(this.retryInterval);
                }
                catch (InterruptedException interruptedException) {
                    throw new IllegalStateException("Received interrupted exception", interruptedException);
                }
            }
        }
    }

    private void setAllTriggersOfJobToState(JobKey jobKey, TriggerWrapper.TriggerState triggerState) {
        List<TriggerWrapper> list = this.triggerFacade.getTriggerWrappersForJob(jobKey);
        for (TriggerWrapper triggerWrapper : list) {
            triggerWrapper.setState(triggerState, this.terracottaClientId, this.triggerFacade);
            if (triggerState == TriggerWrapper.TriggerState.WAITING) continue;
            this.timeTriggers.remove(triggerWrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getPausedTriggerGroups() throws JobPersistenceException {
        this.lock();
        try {
            HashSet<String> hashSet = new HashSet<String>(this.triggerFacade.allPausedTriggersGroupNames());
            return hashSet;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void setInstanceId(String string) {
    }

    @Override
    public void setInstanceName(String string) {
    }

    @Override
    public void setTcRetryInterval(long l) {
        this.retryInterval = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeLeft(ClusterEvent clusterEvent) {
        String string = clusterEvent.getNode().getId();
        try {
            this.lock();
        }
        catch (JobPersistenceException jobPersistenceException) {
            this.getLog().info("Job store is already disabled, not processing nodeLeft() for " + string);
            return;
        }
        try {
            TriggerWrapper triggerWrapper;
            ArrayList<TriggerWrapper> arrayList = new ArrayList<TriggerWrapper>();
            for (TriggerKey serializable : this.triggerFacade.allTriggerKeys()) {
                triggerWrapper = this.triggerFacade.get(serializable);
                String string2 = triggerWrapper.getLastTerracotaClientId();
                if (string2 == null || !string2.equals(string)) continue;
                arrayList.add(triggerWrapper);
            }
            for (TriggerWrapper triggerWrapper2 : arrayList) {
                this.evalOrphanedTrigger(triggerWrapper2, false);
            }
            Iterator<Serializable> iterator = this.triggerFacade.allFiredTriggers().iterator();
            while (iterator.hasNext()) {
                FiredTrigger firedTrigger = (FiredTrigger)iterator.next();
                if (!string.equals(firedTrigger.getClientId())) continue;
                this.getLog().info("Found non-complete fired trigger: " + firedTrigger);
                iterator.remove();
                triggerWrapper = this.triggerFacade.get(firedTrigger.getTriggerKey());
                if (triggerWrapper == null) {
                    this.getLog().error("no trigger found for executing trigger: " + firedTrigger.getTriggerKey());
                    continue;
                }
                this.scheduleRecoveryIfNeeded(triggerWrapper, firedTrigger);
            }
        }
        finally {
            this.unlock();
        }
        this.signaler.signalSchedulingChange(0L);
    }

    @Override
    public long getEstimatedTimeToReleaseAndAcquireTrigger() {
        return this.estimatedTimeToReleaseAndAcquireTrigger;
    }

    @Override
    public void setEstimatedTimeToReleaseAndAcquireTrigger(long l) {
        this.estimatedTimeToReleaseAndAcquireTrigger = l;
    }

    @Override
    public void setThreadPoolSize(int n) {
    }

    @Override
    public boolean isClustered() {
        throw new AssertionError();
    }

    void injectTriggerWrapper(TriggerWrapper triggerWrapper) {
        this.timeTriggers.add(triggerWrapper);
    }

    ClusterInfo getDsoCluster() {
        return this.clusterInfo;
    }

    public void onClusterEvent(ClusterEvent clusterEvent) {
        switch (clusterEvent.getType()) {
            case NODE_JOINED: 
            case OPERATIONS_DISABLED: 
            case OPERATIONS_ENABLED: {
                break;
            }
            case NODE_LEFT: {
                this.getLog().info("Received node left notification for " + clusterEvent.getNode().getId());
                this.nodeLeft(clusterEvent);
                break;
            }
            case NODE_REJOINED: {
                this.getLog().info("Received rejoin notification " + this.terracottaClientId + " => " + clusterEvent.getNode().getId());
                this.terracottaClientId = clusterEvent.getNode().getId();
            }
        }
    }

    protected TriggerFacade getTriggersFacade() {
        return this.triggerFacade;
    }

    static interface TriggerRemovedFromCandidateFiringListHandler {
        public boolean removeCandidateTrigger(TriggerWrapper var1);
    }

    private static class LocalLockState {
        private int acquires = 0;
        private boolean disabled;

        private LocalLockState() {
        }

        synchronized void attemptAcquireBegin() throws JobPersistenceException {
            if (this.disabled) {
                throw new JobPersistenceException("org.terracotta.quartz.TerracottaJobStore is disabled");
            }
            ++this.acquires;
        }

        synchronized void release() {
            --this.acquires;
            this.notifyAll();
        }

        synchronized void disableLocking() throws InterruptedException {
            this.disabled = true;
            while (this.acquires > 0) {
                this.wait();
            }
        }
    }

    private static class ShutdownHook
    implements Runnable {
        private final DefaultClusteredJobStore store;

        ShutdownHook(DefaultClusteredJobStore defaultClusteredJobStore) {
            this.store = defaultClusteredJobStore;
        }

        @Override
        public void run() {
            this.store.disable();
        }
    }
}

