/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.jmx;

import com.google.common.base.Preconditions;
import org.squirrelframework.foundation.fsm.Converter;
import org.squirrelframework.foundation.fsm.ConverterProvider;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.StateMachineLogger;
import org.squirrelframework.foundation.fsm.StateMachinePerformanceModel;
import org.squirrelframework.foundation.fsm.StateMachinePerformanceMonitor;
import org.squirrelframework.foundation.fsm.impl.AbstractStateMachine;
import org.squirrelframework.foundation.fsm.jmx.StateMachineManagementMBean;

public class StateMachineManagement
implements StateMachineManagementMBean {
    private StateMachine<?, ?, ?, ?> stateMachine;
    private StateMachineLogger fsmLogger;
    private StateMachinePerformanceMonitor performanceMonitor;
    private long totalTransitionInvokedTimes = 0L;
    private long totalTransitionFailedTimes = 0L;
    private long totalTransitionDeclinedTimes = 0L;
    private float averageTranstionConsumedTime = 0.0f;
    private String perfStatDetails = "[Empty]";

    public StateMachineManagement(StateMachine<?, ?, ?, ?> stateMachine) {
        Preconditions.checkNotNull(stateMachine);
        this.stateMachine = stateMachine;
    }

    @Override
    public String getIdentifier() {
        return this.stateMachine.getIdentifier();
    }

    @Override
    public String getCurrentState() {
        return this.stateMachine.getCurrentState() != null ? this.stateMachine.getCurrentState().toString() : "[NULL]";
    }

    @Override
    public String getPerfStatDetails() {
        return this.perfStatDetails;
    }

    @Override
    public long getTotalTransitionInvokedTimes() {
        return this.totalTransitionInvokedTimes;
    }

    @Override
    public long getTotalTransitionFailedTimes() {
        return this.totalTransitionFailedTimes;
    }

    @Override
    public long getTotalTransitionDeclinedTimes() {
        return this.totalTransitionDeclinedTimes;
    }

    @Override
    public float getAverageTranstionConsumedTime() {
        return this.averageTranstionConsumedTime;
    }

    @Override
    public String getLastErrorMessage() {
        return this.stateMachine.getLastException() != null ? this.stateMachine.getLastException().getMessage() : "[NoException]";
    }

    @Override
    public String toggleLogging() {
        if (this.fsmLogger == null) {
            this.fsmLogger = new StateMachineLogger(this.stateMachine);
            this.fsmLogger.startLogging();
            return "Logging Started";
        }
        this.fsmLogger.stopLogging();
        this.fsmLogger = null;
        return "Logging Ended";
    }

    @Override
    public String togglePerfMon() {
        if (this.performanceMonitor == null) {
            this.perfStatDetails = "[Empty]";
            this.performanceMonitor = new StateMachinePerformanceMonitor("Performance-of-" + this.stateMachine.getIdentifier());
            this.stateMachine.addDeclarativeListener(this.performanceMonitor);
            if (this.stateMachine.isStarted()) {
                this.performanceMonitor.onStateMachineStart(this.stateMachine);
            }
            return "Performance Monitor Start";
        }
        StateMachinePerformanceModel stateMachinePerformanceModel = this.performanceMonitor.getPerfModel();
        this.totalTransitionInvokedTimes = stateMachinePerformanceModel.getTotalTransitionInvokedTimes();
        this.totalTransitionDeclinedTimes = stateMachinePerformanceModel.getTotalTransitionDeclinedTimes();
        this.totalTransitionFailedTimes = stateMachinePerformanceModel.getTotalTransitionFailedTimes();
        this.averageTranstionConsumedTime = stateMachinePerformanceModel.getAverageTranstionConsumedTime();
        this.perfStatDetails = stateMachinePerformanceModel.toString();
        this.stateMachine.removeDeclarativeListener(this.performanceMonitor);
        this.performanceMonitor = null;
        return "Performance Monitor End";
    }

    @Override
    public void fireEvent(String string, String string2) {
        Converter<?> converter = ConverterProvider.INSTANCE.getConverter(this.stateMachine.typeOfEvent());
        Converter<?> converter2 = ConverterProvider.INSTANCE.getConverter(this.stateMachine.typeOfContext());
        Object obj = converter.convertFromString(string);
        Object var6_6 = string2 != null && !string2.isEmpty() ? converter2.convertFromString(string2) : null;
        ((AbstractStateMachine)this.stateMachine).untypedFire(obj, var6_6);
    }
}

