/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.component;

import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.squirrelframework.foundation.component.SquirrelSingletonProvider;

public class SquirrelConfiguration {
    public static ExecutorService getExecutor() {
        ExecutorService executorService = SquirrelSingletonProvider.getInstance().get(ExecutorService.class);
        if (executorService == null) {
            executorService = SquirrelConfiguration.registerNewExecutorService(1, 120L, TimeUnit.SECONDS);
        }
        return executorService;
    }

    public static ExecutorService registerNewExecutorService(int n, long l, TimeUnit timeUnit) {
        ExecutorService executorService = Executors.newFixedThreadPool(n);
        MoreExecutors.addDelayedShutdownHook(executorService, l, timeUnit);
        SquirrelSingletonProvider.getInstance().register(ExecutorService.class, executorService);
        return executorService;
    }

    public static ScheduledExecutorService getScheduler() {
        ScheduledExecutorService scheduledExecutorService = SquirrelSingletonProvider.getInstance().get(ScheduledExecutorService.class);
        if (scheduledExecutorService == null) {
            scheduledExecutorService = SquirrelConfiguration.registerNewSchedulerService(1, 120L, TimeUnit.SECONDS);
        }
        return scheduledExecutorService;
    }

    public static ScheduledExecutorService registerNewSchedulerService(int n, long l, TimeUnit timeUnit) {
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(n);
        MoreExecutors.addDelayedShutdownHook(scheduledExecutorService, l, timeUnit);
        SquirrelSingletonProvider.getInstance().register(ScheduledExecutorService.class, scheduledExecutorService);
        return scheduledExecutorService;
    }
}

