/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.quartz.CalendarIntervalScheduleBuilder;
import org.quartz.CronScheduleBuilder;
import org.quartz.DateBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.MutableTrigger;
import org.quartz.xml.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLSchedulingDataProcessor
implements ErrorHandler {
    public static final String QUARTZ_NS = "http://www.quartz-scheduler.org/xml/JobSchedulingData";
    public static final String QUARTZ_SCHEMA_WEB_URL = "http://www.quartz-scheduler.org/xml/job_scheduling_data_2_0.xsd";
    public static final String QUARTZ_XSD_PATH_IN_JAR = "org/quartz/xml/job_scheduling_data_2_0.xsd";
    public static final String QUARTZ_XML_DEFAULT_FILE_NAME = "quartz_data.xml";
    public static final String QUARTZ_SYSTEM_ID_JAR_PREFIX = "jar:";
    protected List<String> jobGroupsToDelete = new LinkedList<String>();
    protected List<String> triggerGroupsToDelete = new LinkedList<String>();
    protected List<JobKey> jobsToDelete = new LinkedList<JobKey>();
    protected List<TriggerKey> triggersToDelete = new LinkedList<TriggerKey>();
    protected List<JobDetail> loadedJobs = new LinkedList<JobDetail>();
    protected List<MutableTrigger> loadedTriggers = new LinkedList<MutableTrigger>();
    private boolean overWriteExistingData = true;
    private boolean ignoreDuplicates = false;
    protected Collection<Exception> validationExceptions = new ArrayList<Exception>();
    protected ClassLoadHelper classLoadHelper;
    protected List<String> jobGroupsToNeverDelete = new LinkedList<String>();
    protected List<String> triggerGroupsToNeverDelete = new LinkedList<String>();
    private DocumentBuilder docBuilder = null;
    private XPath xpath = null;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public XMLSchedulingDataProcessor(ClassLoadHelper classLoadHelper) throws ParserConfigurationException {
        this.classLoadHelper = classLoadHelper;
        this.initDocumentParser();
    }

    protected void initDocumentParser() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(true);
        documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", this.resolveSchemaSource());
        this.docBuilder = documentBuilderFactory.newDocumentBuilder();
        this.docBuilder.setErrorHandler(this);
        NamespaceContext namespaceContext = new NamespaceContext(){

            @Override
            public String getNamespaceURI(String string) {
                if (string == null) {
                    throw new IllegalArgumentException("Null prefix");
                }
                if ("xml".equals(string)) {
                    return "http://www.w3.org/XML/1998/namespace";
                }
                if ("xmlns".equals(string)) {
                    return "http://www.w3.org/2000/xmlns/";
                }
                if ("q".equals(string)) {
                    return XMLSchedulingDataProcessor.QUARTZ_NS;
                }
                return "";
            }

            public Iterator<?> getPrefixes(String string) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getPrefix(String string) {
                throw new UnsupportedOperationException();
            }
        };
        this.xpath = XPathFactory.newInstance().newXPath();
        this.xpath.setNamespaceContext(namespaceContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object resolveSchemaSource() {
        InputSource inputSource;
        InputStream inputStream = null;
        try {
            inputStream = this.classLoadHelper.getResourceAsStream(QUARTZ_XSD_PATH_IN_JAR);
        }
        finally {
            if (inputStream == null) {
                this.log.info("Unable to load local schema packaged in quartz distribution jar. Utilizing schema online at http://www.quartz-scheduler.org/xml/job_scheduling_data_2_0.xsd");
                return QUARTZ_SCHEMA_WEB_URL;
            }
            inputSource = new InputSource(inputStream);
            inputSource.setSystemId(QUARTZ_SCHEMA_WEB_URL);
            this.log.debug("Utilizing schema packaged in local quartz distribution jar.");
        }
        return inputSource;
    }

    public boolean isOverWriteExistingData() {
        return this.overWriteExistingData;
    }

    protected void setOverWriteExistingData(boolean bl) {
        this.overWriteExistingData = bl;
    }

    public boolean isIgnoreDuplicates() {
        return this.ignoreDuplicates;
    }

    public void setIgnoreDuplicates(boolean bl) {
        this.ignoreDuplicates = bl;
    }

    public void addJobGroupToNeverDelete(String string) {
        if (string != null) {
            this.jobGroupsToNeverDelete.add(string);
        }
    }

    public boolean removeJobGroupToNeverDelete(String string) {
        return string != null && this.jobGroupsToNeverDelete.remove(string);
    }

    public List<String> getJobGroupsToNeverDelete() {
        return Collections.unmodifiableList(this.jobGroupsToDelete);
    }

    public void addTriggerGroupToNeverDelete(String string) {
        if (string != null) {
            this.triggerGroupsToNeverDelete.add(string);
        }
    }

    public boolean removeTriggerGroupToNeverDelete(String string) {
        if (string != null) {
            return this.triggerGroupsToNeverDelete.remove(string);
        }
        return false;
    }

    public List<String> getTriggerGroupsToNeverDelete() {
        return Collections.unmodifiableList(this.triggerGroupsToDelete);
    }

    protected void processFile() throws Exception {
        this.processFile(QUARTZ_XML_DEFAULT_FILE_NAME);
    }

    protected void processFile(String string) throws Exception {
        this.processFile(string, this.getSystemIdForFileName(string));
    }

    protected String getSystemIdForFileName(String string) {
        File file = new File(string);
        if (file.exists()) {
            try {
                new FileInputStream(file).close();
                return file.toURI().toString();
            }
            catch (IOException iOException) {
                return string;
            }
        }
        URL uRL = this.getURL(string);
        if (uRL == null) {
            return string;
        }
        try {
            uRL.openStream().close();
            return uRL.toString();
        }
        catch (IOException iOException) {
            return string;
        }
    }

    protected URL getURL(String string) {
        return this.classLoadHelper.getResource(string);
    }

    protected void prepForProcessing() {
        this.clearValidationExceptions();
        this.setOverWriteExistingData(true);
        this.setIgnoreDuplicates(false);
        this.jobGroupsToDelete.clear();
        this.jobsToDelete.clear();
        this.triggerGroupsToDelete.clear();
        this.triggersToDelete.clear();
        this.loadedJobs.clear();
        this.loadedTriggers.clear();
    }

    protected void processFile(String string, String string2) throws ValidationException, ParserConfigurationException, SAXException, IOException, SchedulerException, ClassNotFoundException, ParseException, XPathException {
        this.prepForProcessing();
        this.log.info("Parsing XML file: " + string + " with systemId: " + string2);
        InputSource inputSource = new InputSource(this.getInputStream(string));
        inputSource.setSystemId(string2);
        this.process(inputSource);
        this.maybeThrowValidationException();
    }

    public void processStreamAndScheduleJobs(InputStream inputStream, String string, Scheduler scheduler) throws ValidationException, ParserConfigurationException, SAXException, XPathException, IOException, SchedulerException, ClassNotFoundException, ParseException {
        this.prepForProcessing();
        this.log.info("Parsing XML from stream with systemId: " + string);
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string);
        this.process(inputSource);
        this.executePreProcessCommands(scheduler);
        this.scheduleJobs(scheduler);
        this.maybeThrowValidationException();
    }

    protected void process(InputSource inputSource) throws SAXException, IOException, ParseException, XPathException, ClassNotFoundException {
        Object object;
        String string;
        Object object2;
        Object object3;
        Object object4;
        String string2;
        String string3;
        String string4;
        String string5;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        Document document = this.docBuilder.parse(inputSource);
        NodeList nodeList = (NodeList)this.xpath.evaluate("/q:job-scheduling-data/q:pre-processing-commands/q:delete-jobs-in-group", document, XPathConstants.NODESET);
        this.log.debug("Found " + nodeList.getLength() + " delete job group commands.");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            object9 = node.getTextContent();
            if (object9 == null || ((String)(object9 = ((String)object9).trim())).length() == 0) continue;
            this.jobGroupsToDelete.add((String)object9);
        }
        NodeList nodeList2 = (NodeList)this.xpath.evaluate("/q:job-scheduling-data/q:pre-processing-commands/q:delete-triggers-in-group", document, XPathConstants.NODESET);
        this.log.debug("Found " + nodeList2.getLength() + " delete trigger group commands.");
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            object9 = nodeList2.item(i);
            object8 = object9.getTextContent();
            if (object8 == null || ((String)(object8 = ((String)object8).trim())).length() == 0) continue;
            this.triggerGroupsToDelete.add((String)object8);
        }
        NodeList nodeList3 = (NodeList)this.xpath.evaluate("/q:job-scheduling-data/q:pre-processing-commands/q:delete-job", document, XPathConstants.NODESET);
        this.log.debug("Found " + nodeList3.getLength() + " delete job commands.");
        for (int i = 0; i < nodeList3.getLength(); ++i) {
            object8 = nodeList3.item(i);
            object7 = this.getTrimmedToNullString(this.xpath, "q:name", (Node)object8);
            object6 = this.getTrimmedToNullString(this.xpath, "q:group", (Node)object8);
            if (object7 == null) {
                throw new ParseException("Encountered a 'delete-job' command without a name specified.", -1);
            }
            this.jobsToDelete.add(new JobKey((String)object7, (String)object6));
        }
        NodeList nodeList4 = (NodeList)this.xpath.evaluate("/q:job-scheduling-data/q:pre-processing-commands/q:delete-trigger", document, XPathConstants.NODESET);
        this.log.debug("Found " + nodeList4.getLength() + " delete trigger commands.");
        for (int i = 0; i < nodeList4.getLength(); ++i) {
            object7 = nodeList4.item(i);
            object6 = this.getTrimmedToNullString(this.xpath, "q:name", (Node)object7);
            String string6 = this.getTrimmedToNullString(this.xpath, "q:group", (Node)object7);
            if (object6 == null) {
                throw new ParseException("Encountered a 'delete-trigger' command without a name specified.", -1);
            }
            this.triggersToDelete.add(new TriggerKey((String)object6, string6));
        }
        Boolean bl = this.getBoolean(this.xpath, "/q:job-scheduling-data/q:processing-directives/q:overwrite-existing-data", document);
        if (bl == null) {
            this.log.debug("Directive 'overwrite-existing-data' not specified, defaulting to " + this.isOverWriteExistingData());
        } else {
            this.log.debug("Directive 'overwrite-existing-data' specified as: " + bl);
            this.setOverWriteExistingData(bl);
        }
        object7 = this.getBoolean(this.xpath, "/q:job-scheduling-data/q:processing-directives/q:ignore-duplicates", document);
        if (object7 == null) {
            this.log.debug("Directive 'ignore-duplicates' not specified, defaulting to " + this.isIgnoreDuplicates());
        } else {
            this.log.debug("Directive 'ignore-duplicates' specified as: " + object7);
            this.setIgnoreDuplicates((Boolean)object7);
        }
        object6 = (NodeList)this.xpath.evaluate("/q:job-scheduling-data/q:schedule/q:job", document, XPathConstants.NODESET);
        this.log.debug("Found " + object6.getLength() + " job definitions.");
        for (int i = 0; i < object6.getLength(); ++i) {
            Node node = object6.item(i);
            object5 = null;
            string5 = this.getTrimmedToNullString(this.xpath, "q:name", node);
            string4 = this.getTrimmedToNullString(this.xpath, "q:group", node);
            string3 = this.getTrimmedToNullString(this.xpath, "q:description", node);
            string2 = this.getTrimmedToNullString(this.xpath, "q:job-class", node);
            object5 = this.getTrimmedToNullString(this.xpath, "q:durability", node);
            boolean bl2 = object5 != null && ((String)object5).equals("true");
            object5 = this.getTrimmedToNullString(this.xpath, "q:recover", node);
            boolean bl3 = object5 != null && ((String)object5).equals("true");
            object4 = this.classLoadHelper.loadClass(string2, Job.class);
            object3 = JobBuilder.newJob(object4).withIdentity(string5, string4).withDescription(string3).storeDurably(bl2).requestRecovery(bl3).build();
            NodeList nodeList5 = (NodeList)this.xpath.evaluate("q:job-data-map/q:entry", node, XPathConstants.NODESET);
            for (int j = 0; j < nodeList5.getLength(); ++j) {
                object2 = nodeList5.item(j);
                string = this.getTrimmedToNullString(this.xpath, "q:key", (Node)object2);
                object = this.getTrimmedToNullString(this.xpath, "q:value", (Node)object2);
                object3.getJobDataMap().put(string, (String)object);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Parsed job definition: " + object3);
            }
            this.addJobToSchedule((JobDetail)object3);
        }
        NodeList nodeList6 = (NodeList)this.xpath.evaluate("/q:job-scheduling-data/q:schedule/q:trigger/*", document, XPathConstants.NODESET);
        this.log.debug("Found " + nodeList6.getLength() + " trigger definitions.");
        for (int i = 0; i < nodeList6.getLength(); ++i) {
            ScheduleBuilder scheduleBuilder;
            int n;
            Object object10;
            Object object11;
            object5 = nodeList6.item(i);
            string5 = this.getTrimmedToNullString(this.xpath, "q:name", (Node)object5);
            string4 = this.getTrimmedToNullString(this.xpath, "q:group", (Node)object5);
            string3 = this.getTrimmedToNullString(this.xpath, "q:description", (Node)object5);
            string2 = this.getTrimmedToNullString(this.xpath, "q:misfire-instruction", (Node)object5);
            String string7 = this.getTrimmedToNullString(this.xpath, "q:priority", (Node)object5);
            String string8 = this.getTrimmedToNullString(this.xpath, "q:calendar-name", (Node)object5);
            object4 = this.getTrimmedToNullString(this.xpath, "q:job-name", (Node)object5);
            object3 = this.getTrimmedToNullString(this.xpath, "q:job-group", (Node)object5);
            int n2 = 5;
            if (string7 != null) {
                n2 = Integer.valueOf(string7);
            }
            String string9 = this.getTrimmedToNullString(this.xpath, "q:start-time", (Node)object5);
            object2 = this.getTrimmedToNullString(this.xpath, "q:start-time-seconds-in-future", (Node)object5);
            string = this.getTrimmedToNullString(this.xpath, "q:end-time", (Node)object5);
            object = object2 != null ? new Date(System.currentTimeMillis() + Long.valueOf((String)object2) * 1000L) : (string9 == null || string9.length() == 0 ? new Date() : DatatypeConverter.parseDateTime((String)string9).getTime());
            Date date = string == null || string.length() == 0 ? null : DatatypeConverter.parseDateTime((String)string).getTime();
            TriggerKey triggerKey = TriggerKey.triggerKey(string5, string4);
            if (object5.getNodeName().equals("simple")) {
                object11 = this.getTrimmedToNullString(this.xpath, "q:repeat-count", (Node)object5);
                object10 = this.getTrimmedToNullString(this.xpath, "q:repeat-interval", (Node)object5);
                n = object11 == null ? 0 : Integer.parseInt((String)object11);
                long l = object10 == null ? 0L : Long.parseLong((String)object10);
                scheduleBuilder = SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(l).withRepeatCount(n);
                if (string2 != null && string2.length() != 0) {
                    if (string2.equals("MISFIRE_INSTRUCTION_FIRE_NOW")) {
                        ((SimpleScheduleBuilder)scheduleBuilder).withMisfireHandlingInstructionFireNow();
                    } else if (string2.equals("MISFIRE_INSTRUCTION_RESCHEDULE_NEXT_WITH_EXISTING_COUNT")) {
                        ((SimpleScheduleBuilder)scheduleBuilder).withMisfireHandlingInstructionNextWithExistingCount();
                    } else if (string2.equals("MISFIRE_INSTRUCTION_RESCHEDULE_NEXT_WITH_REMAINING_COUNT")) {
                        ((SimpleScheduleBuilder)scheduleBuilder).withMisfireHandlingInstructionNextWithRemainingCount();
                    } else if (string2.equals("MISFIRE_INSTRUCTION_RESCHEDULE_NOW_WITH_EXISTING_REPEAT_COUNT")) {
                        ((SimpleScheduleBuilder)scheduleBuilder).withMisfireHandlingInstructionNowWithExistingCount();
                    } else if (string2.equals("MISFIRE_INSTRUCTION_RESCHEDULE_NOW_WITH_REMAINING_REPEAT_COUNT")) {
                        ((SimpleScheduleBuilder)scheduleBuilder).withMisfireHandlingInstructionNowWithRemainingCount();
                    } else if (!string2.equals("MISFIRE_INSTRUCTION_SMART_POLICY")) {
                        throw new ParseException("Unexpected/Unhandlable Misfire Instruction encountered '" + string2 + "', for trigger: " + triggerKey, -1);
                    }
                }
            } else if (object5.getNodeName().equals("cron")) {
                object11 = this.getTrimmedToNullString(this.xpath, "q:cron-expression", (Node)object5);
                object10 = this.getTrimmedToNullString(this.xpath, "q:time-zone", (Node)object5);
                TimeZone timeZone = object10 == null ? null : TimeZone.getTimeZone((String)object10);
                scheduleBuilder = CronScheduleBuilder.cronSchedule((String)object11).inTimeZone(timeZone);
                if (string2 != null && string2.length() != 0) {
                    if (string2.equals("MISFIRE_INSTRUCTION_DO_NOTHING")) {
                        ((CronScheduleBuilder)scheduleBuilder).withMisfireHandlingInstructionDoNothing();
                    } else if (string2.equals("MISFIRE_INSTRUCTION_FIRE_ONCE_NOW")) {
                        ((CronScheduleBuilder)scheduleBuilder).withMisfireHandlingInstructionFireAndProceed();
                    } else if (!string2.equals("MISFIRE_INSTRUCTION_SMART_POLICY")) {
                        throw new ParseException("Unexpected/Unhandlable Misfire Instruction encountered '" + string2 + "', for trigger: " + triggerKey, -1);
                    }
                }
            } else if (object5.getNodeName().equals("calendar-interval")) {
                object11 = this.getTrimmedToNullString(this.xpath, "q:repeat-interval", (Node)object5);
                object10 = this.getTrimmedToNullString(this.xpath, "q:repeat-interval-unit", (Node)object5);
                n = Integer.parseInt((String)object11);
                DateBuilder.IntervalUnit intervalUnit = DateBuilder.IntervalUnit.valueOf((String)object10);
                scheduleBuilder = CalendarIntervalScheduleBuilder.calendarIntervalSchedule().withInterval(n, intervalUnit);
                if (string2 != null && string2.length() != 0) {
                    if (string2.equals("MISFIRE_INSTRUCTION_DO_NOTHING")) {
                        ((CalendarIntervalScheduleBuilder)scheduleBuilder).withMisfireHandlingInstructionDoNothing();
                    } else if (string2.equals("MISFIRE_INSTRUCTION_FIRE_ONCE_NOW")) {
                        ((CalendarIntervalScheduleBuilder)scheduleBuilder).withMisfireHandlingInstructionFireAndProceed();
                    } else if (!string2.equals("MISFIRE_INSTRUCTION_SMART_POLICY")) {
                        throw new ParseException("Unexpected/Unhandlable Misfire Instruction encountered '" + string2 + "', for trigger: " + triggerKey, -1);
                    }
                }
            } else {
                throw new ParseException("Unknown trigger type: " + object5.getNodeName(), -1);
            }
            object11 = (MutableTrigger)TriggerBuilder.newTrigger().withIdentity(string5, string4).withDescription(string3).forJob((String)object4, (String)object3).startAt((Date)object).endAt(date).withPriority(n2).modifiedByCalendar(string8).withSchedule(scheduleBuilder).build();
            object10 = (NodeList)this.xpath.evaluate("q:job-data-map/q:entry", object5, XPathConstants.NODESET);
            for (n = 0; n < object10.getLength(); ++n) {
                Node node = object10.item(n);
                String string10 = this.getTrimmedToNullString(this.xpath, "q:key", node);
                String string11 = this.getTrimmedToNullString(this.xpath, "q:value", node);
                object11.getJobDataMap().put(string10, string11);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Parsed trigger definition: " + object11);
            }
            this.addTriggerToSchedule((MutableTrigger)object11);
        }
    }

    protected String getTrimmedToNullString(XPath xPath, String string, Node node) throws XPathExpressionException {
        String string2 = (String)xPath.evaluate(string, node, XPathConstants.STRING);
        if (string2 != null) {
            string2 = string2.trim();
        }
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        return string2;
    }

    protected Boolean getBoolean(XPath xPath, String string, Document document) throws XPathExpressionException {
        Node node = (Node)xPath.evaluate(string, document, XPathConstants.NODE);
        if (node == null || node.getTextContent() == null) {
            return null;
        }
        String string2 = node.getTextContent();
        if (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("yes") || string2.equalsIgnoreCase("y")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void processFileAndScheduleJobs(Scheduler scheduler, boolean bl) throws Exception {
        String string = QUARTZ_XML_DEFAULT_FILE_NAME;
        this.processFile(string, this.getSystemIdForFileName(string));
        this.setOverWriteExistingData(bl);
        this.executePreProcessCommands(scheduler);
        this.scheduleJobs(scheduler);
    }

    public void processFileAndScheduleJobs(String string, Scheduler scheduler) throws Exception {
        this.processFileAndScheduleJobs(string, this.getSystemIdForFileName(string), scheduler);
    }

    public void processFileAndScheduleJobs(String string, String string2, Scheduler scheduler) throws Exception {
        this.processFile(string, string2);
        this.executePreProcessCommands(scheduler);
        this.scheduleJobs(scheduler);
    }

    protected List<JobDetail> getLoadedJobs() {
        return Collections.unmodifiableList(this.loadedJobs);
    }

    protected List<MutableTrigger> getLoadedTriggers() {
        return Collections.unmodifiableList(this.loadedTriggers);
    }

    protected InputStream getInputStream(String string) {
        return this.classLoadHelper.getResourceAsStream(string);
    }

    protected void addJobToSchedule(JobDetail jobDetail) {
        this.loadedJobs.add(jobDetail);
    }

    protected void addTriggerToSchedule(MutableTrigger mutableTrigger) {
        this.loadedTriggers.add(mutableTrigger);
    }

    private Map<JobKey, List<MutableTrigger>> buildTriggersByFQJobNameMap(List<MutableTrigger> list) {
        HashMap<JobKey, List<MutableTrigger>> hashMap = new HashMap<JobKey, List<MutableTrigger>>();
        for (MutableTrigger mutableTrigger : list) {
            LinkedList<MutableTrigger> linkedList = (LinkedList<MutableTrigger>)hashMap.get(mutableTrigger.getJobKey());
            if (linkedList == null) {
                linkedList = new LinkedList<MutableTrigger>();
                hashMap.put(mutableTrigger.getJobKey(), linkedList);
            }
            linkedList.add(mutableTrigger);
        }
        return hashMap;
    }

    protected void executePreProcessCommands(Scheduler scheduler) throws SchedulerException {
        for (String object : this.jobGroupsToDelete) {
            if (object.equals("*")) {
                this.log.info("Deleting all jobs in ALL groups.");
                for (String string : scheduler.getJobGroupNames()) {
                    if (this.jobGroupsToNeverDelete.contains(string)) continue;
                    for (JobKey jobKey : scheduler.getJobKeys(GroupMatcher.jobGroupEquals(string))) {
                        scheduler.deleteJob(jobKey);
                    }
                }
                continue;
            }
            if (this.jobGroupsToNeverDelete.contains(object)) continue;
            this.log.info("Deleting all jobs in group: {}", (Object)object);
            for (JobKey jobKey : scheduler.getJobKeys(GroupMatcher.jobGroupEquals(object))) {
                scheduler.deleteJob(jobKey);
            }
        }
        for (String string : this.triggerGroupsToDelete) {
            if (string.equals("*")) {
                this.log.info("Deleting all triggers in ALL groups.");
                for (String string2 : scheduler.getTriggerGroupNames()) {
                    if (this.triggerGroupsToNeverDelete.contains(string2)) continue;
                    for (TriggerKey triggerKey : scheduler.getTriggerKeys(GroupMatcher.triggerGroupEquals(string2))) {
                        scheduler.unscheduleJob(triggerKey);
                    }
                }
                continue;
            }
            if (this.triggerGroupsToNeverDelete.contains(string)) continue;
            this.log.info("Deleting all triggers in group: {}", (Object)string);
            for (TriggerKey triggerKey : scheduler.getTriggerKeys(GroupMatcher.triggerGroupEquals(string))) {
                scheduler.unscheduleJob(triggerKey);
            }
        }
        for (JobKey jobKey : this.jobsToDelete) {
            if (this.jobGroupsToNeverDelete.contains(jobKey.getGroup())) continue;
            this.log.info("Deleting job: {}", (Object)jobKey);
            scheduler.deleteJob(jobKey);
        }
        for (TriggerKey triggerKey : this.triggersToDelete) {
            if (this.triggerGroupsToNeverDelete.contains(triggerKey.getGroup())) continue;
            this.log.info("Deleting trigger: {}", (Object)triggerKey);
            scheduler.unscheduleJob(triggerKey);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void scheduleJobs(Scheduler scheduler) throws SchedulerException {
        Object object;
        LinkedList<JobDetail> linkedList = new LinkedList<JobDetail>(this.getLoadedJobs());
        LinkedList<MutableTrigger> linkedList2 = new LinkedList<MutableTrigger>(this.getLoadedTriggers());
        this.log.info("Adding " + linkedList.size() + " jobs, " + linkedList2.size() + " triggers.");
        Map<JobKey, List<MutableTrigger>> map = this.buildTriggersByFQJobNameMap(linkedList2);
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            void cloneable;
            JobDetail jobDetail = (JobDetail)iterator.next();
            iterator.remove();
            Object var7_8 = null;
            try {
                JobDetail jobDetail2 = scheduler.getJobDetail(jobDetail.getKey());
            }
            catch (JobPersistenceException jobPersistenceException) {
                if (jobPersistenceException.getCause() instanceof ClassNotFoundException && this.isOverWriteExistingData()) {
                    this.log.info("Removing job: " + jobDetail.getKey());
                    scheduler.deleteJob(jobDetail.getKey());
                }
                throw jobPersistenceException;
            }
            if (cloneable != null) {
                if (!this.isOverWriteExistingData() && this.isIgnoreDuplicates()) {
                    this.log.info("Not overwriting existing job: " + cloneable.getKey());
                    continue;
                }
                if (!this.isOverWriteExistingData() && !this.isIgnoreDuplicates()) {
                    throw new ObjectAlreadyExistsException(jobDetail);
                }
            }
            if (cloneable != null) {
                this.log.info("Replacing job: " + jobDetail.getKey());
            } else {
                this.log.info("Adding job: " + jobDetail.getKey());
            }
            object = map.get(jobDetail.getKey());
            if (!(jobDetail.isDurable() || object != null && object.size() != 0)) {
                if (cloneable == null) {
                    throw new SchedulerException("A new job defined without any triggers must be durable: " + jobDetail.getKey());
                }
                if (cloneable.isDurable() && scheduler.getTriggersOfJob(jobDetail.getKey()).size() == 0) {
                    throw new SchedulerException("Can't change existing durable job without triggers to non-durable: " + jobDetail.getKey());
                }
            }
            if (cloneable != null || jobDetail.isDurable()) {
                if (object != null && object.size() > 0) {
                    scheduler.addJob(jobDetail, true, true);
                    continue;
                }
                scheduler.addJob(jobDetail, true, false);
                continue;
            }
            boolean bl = true;
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                Trigger trigger;
                MutableTrigger mutableTrigger = (MutableTrigger)iterator2.next();
                linkedList2.remove(mutableTrigger);
                if (mutableTrigger.getStartTime() == null) {
                    mutableTrigger.setStartTime(new Date());
                }
                if ((trigger = scheduler.getTrigger(mutableTrigger.getKey())) != null) {
                    if (this.isOverWriteExistingData()) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Rescheduling job: " + mutableTrigger.getJobKey() + " with updated trigger: " + mutableTrigger.getKey());
                        }
                    } else {
                        if (this.isIgnoreDuplicates()) {
                            this.log.info("Not overwriting existing trigger: " + trigger.getKey());
                            continue;
                        }
                        throw new ObjectAlreadyExistsException(mutableTrigger);
                    }
                    if (!trigger.getJobKey().equals(mutableTrigger.getJobKey())) {
                        this.log.warn("Possibly duplicately named ({}) triggers in jobs xml file! ", (Object)mutableTrigger.getKey());
                    }
                    scheduler.rescheduleJob(mutableTrigger.getKey(), mutableTrigger);
                    continue;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Scheduling job: " + mutableTrigger.getJobKey() + " with trigger: " + mutableTrigger.getKey());
                }
                try {
                    if (bl) {
                        scheduler.scheduleJob(jobDetail, mutableTrigger);
                        bl = false;
                        continue;
                    }
                    scheduler.scheduleJob(mutableTrigger);
                }
                catch (ObjectAlreadyExistsException objectAlreadyExistsException) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Adding trigger: " + mutableTrigger.getKey() + " for job: " + jobDetail.getKey() + " failed because the trigger already existed.  " + "This is likely due to a race condition between multiple instances " + "in the cluster.  Will try to reschedule instead.");
                    }
                    scheduler.rescheduleJob(mutableTrigger.getKey(), mutableTrigger);
                }
            }
        }
        for (MutableTrigger mutableTrigger : linkedList2) {
            if (mutableTrigger.getStartTime() == null) {
                mutableTrigger.setStartTime(new Date());
            }
            if ((object = scheduler.getTrigger(mutableTrigger.getKey())) != null) {
                if (this.isOverWriteExistingData()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Rescheduling job: " + mutableTrigger.getJobKey() + " with updated trigger: " + mutableTrigger.getKey());
                    }
                } else {
                    if (this.isIgnoreDuplicates()) {
                        this.log.info("Not overwriting existing trigger: " + object.getKey());
                        continue;
                    }
                    throw new ObjectAlreadyExistsException(mutableTrigger);
                }
                if (!object.getJobKey().equals(mutableTrigger.getJobKey())) {
                    this.log.warn("Possibly duplicately named ({}) triggers in jobs xml file! ", (Object)mutableTrigger.getKey());
                }
                scheduler.rescheduleJob(mutableTrigger.getKey(), mutableTrigger);
                continue;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Scheduling job: " + mutableTrigger.getJobKey() + " with trigger: " + mutableTrigger.getKey());
            }
            try {
                scheduler.scheduleJob(mutableTrigger);
            }
            catch (ObjectAlreadyExistsException objectAlreadyExistsException) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Adding trigger: " + mutableTrigger.getKey() + " for job: " + mutableTrigger.getJobKey() + " failed because the trigger already existed.  " + "This is likely due to a race condition between multiple instances " + "in the cluster.  Will try to reschedule instead.");
                }
                scheduler.rescheduleJob(mutableTrigger.getKey(), mutableTrigger);
            }
        }
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.addValidationException(sAXParseException);
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        this.addValidationException(sAXParseException);
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.addValidationException(sAXParseException);
    }

    protected void addValidationException(SAXException sAXException) {
        this.validationExceptions.add(sAXException);
    }

    protected void clearValidationExceptions() {
        this.validationExceptions.clear();
    }

    protected void maybeThrowValidationException() throws ValidationException {
        if (this.validationExceptions.size() > 0) {
            throw new ValidationException("Encountered " + this.validationExceptions.size() + " validation exceptions.", this.validationExceptions);
        }
    }
}

