/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.plugins.management;

import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.SchedulerPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownHookPlugin
implements SchedulerPlugin {
    private boolean cleanShutdown = true;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public boolean isCleanShutdown() {
        return this.cleanShutdown;
    }

    public void setCleanShutdown(boolean bl) {
        this.cleanShutdown = bl;
    }

    protected Logger getLog() {
        return this.log;
    }

    @Override
    public void initialize(String string, final Scheduler scheduler, ClassLoadHelper classLoadHelper) throws SchedulerException {
        this.getLog().info("Registering Quartz shutdown hook.");
        Thread thread = new Thread("Quartz Shutdown-Hook " + scheduler.getSchedulerName()){

            @Override
            public void run() {
                ShutdownHookPlugin.this.getLog().info("Shutting down Quartz...");
                try {
                    scheduler.shutdown(ShutdownHookPlugin.this.isCleanShutdown());
                }
                catch (SchedulerException schedulerException) {
                    ShutdownHookPlugin.this.getLog().info("Error shutting down Quartz: " + schedulerException.getMessage(), schedulerException);
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(thread);
    }

    @Override
    public void start() {
    }

    @Override
    public void shutdown() {
    }
}

