/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.util.TimeZone;
import org.quartz.CalendarIntervalScheduleBuilder;
import org.quartz.DateBuilder;
import org.quartz.impl.jdbcjobstore.SimplePropertiesTriggerPersistenceDelegateSupport;
import org.quartz.impl.jdbcjobstore.SimplePropertiesTriggerProperties;
import org.quartz.impl.jdbcjobstore.TriggerPersistenceDelegate;
import org.quartz.impl.triggers.CalendarIntervalTriggerImpl;
import org.quartz.spi.OperableTrigger;

public class CalendarIntervalTriggerPersistenceDelegate
extends SimplePropertiesTriggerPersistenceDelegateSupport {
    @Override
    public boolean canHandleTriggerType(OperableTrigger operableTrigger) {
        return operableTrigger instanceof CalendarIntervalTriggerImpl && !((CalendarIntervalTriggerImpl)operableTrigger).hasAdditionalProperties();
    }

    @Override
    public String getHandledTriggerTypeDiscriminator() {
        return "CAL_INT";
    }

    @Override
    protected SimplePropertiesTriggerProperties getTriggerProperties(OperableTrigger operableTrigger) {
        CalendarIntervalTriggerImpl calendarIntervalTriggerImpl = (CalendarIntervalTriggerImpl)operableTrigger;
        SimplePropertiesTriggerProperties simplePropertiesTriggerProperties = new SimplePropertiesTriggerProperties();
        simplePropertiesTriggerProperties.setInt1(calendarIntervalTriggerImpl.getRepeatInterval());
        simplePropertiesTriggerProperties.setString1(calendarIntervalTriggerImpl.getRepeatIntervalUnit().name());
        simplePropertiesTriggerProperties.setInt2(calendarIntervalTriggerImpl.getTimesTriggered());
        simplePropertiesTriggerProperties.setString2(calendarIntervalTriggerImpl.getTimeZone().getID());
        simplePropertiesTriggerProperties.setBoolean1(calendarIntervalTriggerImpl.isPreserveHourOfDayAcrossDaylightSavings());
        simplePropertiesTriggerProperties.setBoolean2(calendarIntervalTriggerImpl.isSkipDayIfHourDoesNotExist());
        return simplePropertiesTriggerProperties;
    }

    @Override
    protected TriggerPersistenceDelegate.TriggerPropertyBundle getTriggerPropertyBundle(SimplePropertiesTriggerProperties simplePropertiesTriggerProperties) {
        TimeZone timeZone = null;
        String string = simplePropertiesTriggerProperties.getString2();
        if (string != null && string.trim().length() != 0) {
            timeZone = TimeZone.getTimeZone(string);
        }
        CalendarIntervalScheduleBuilder calendarIntervalScheduleBuilder = CalendarIntervalScheduleBuilder.calendarIntervalSchedule().withInterval(simplePropertiesTriggerProperties.getInt1(), DateBuilder.IntervalUnit.valueOf(simplePropertiesTriggerProperties.getString1())).inTimeZone(timeZone).preserveHourOfDayAcrossDaylightSavings(simplePropertiesTriggerProperties.isBoolean1()).skipDayIfHourDoesNotExist(simplePropertiesTriggerProperties.isBoolean2());
        int n = simplePropertiesTriggerProperties.getInt2();
        String[] stringArray = new String[]{"timesTriggered"};
        Object[] objectArray = new Object[]{n};
        return new TriggerPersistenceDelegate.TriggerPropertyBundle(calendarIntervalScheduleBuilder, stringArray, objectArray);
    }
}

