/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import com.mchange.v2.c3p0.C3P0ProxyConnection;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.quartz.impl.jdbcjobstore.StdJDBCDelegate;

public class CUBRIDDelegate
extends StdJDBCDelegate {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object getObjectFromBlob(ResultSet resultSet, String string) throws ClassNotFoundException, IOException, SQLException {
        Object object = null;
        Blob blob = resultSet.getBlob(string);
        byte[] byArray = blob.getBytes(1L, (int)blob.length());
        if (byArray != null && byArray.length != 0) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            try {
                object = objectInputStream.readObject();
            }
            finally {
                objectInputStream.close();
            }
        }
        return object;
    }

    @Override
    protected Object getJobDataFromBlob(ResultSet resultSet, String string) throws ClassNotFoundException, IOException, SQLException {
        if (this.canUseProperties()) {
            Blob blob = resultSet.getBlob(string);
            byte[] byArray = blob.getBytes(1L, (int)blob.length());
            if (byArray == null || byArray.length == 0) {
                return null;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            return byteArrayInputStream;
        }
        return this.getObjectFromBlob(resultSet, string);
    }

    @Override
    protected void setBytes(PreparedStatement preparedStatement, int n, ByteArrayOutputStream byteArrayOutputStream) throws SQLException {
        byte[] byArray = byteArrayOutputStream == null ? new byte[]{} : byteArrayOutputStream.toByteArray();
        Connection connection = preparedStatement.getConnection();
        if (connection instanceof C3P0ProxyConnection) {
            try {
                C3P0ProxyConnection c3P0ProxyConnection = (C3P0ProxyConnection)connection;
                Method method = Connection.class.getMethod("createBlob", new Class[0]);
                Object[] objectArray = new Object[]{};
                Blob blob = (Blob)c3P0ProxyConnection.rawConnectionOperation(method, C3P0ProxyConnection.RAW_CONNECTION, objectArray);
                blob.setBytes(1L, byArray);
                preparedStatement.setBlob(n, blob);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            Blob blob = preparedStatement.getConnection().createBlob();
            blob.setBytes(1L, byArray);
            preparedStatement.setBlob(n, blob);
        }
    }
}

