/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl;

import java.util.Collection;
import java.util.Map;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.core.QuartzScheduler;
import org.quartz.core.QuartzSchedulerResources;
import org.quartz.impl.DefaultThreadExecutor;
import org.quartz.impl.RemoteScheduler;
import org.quartz.impl.SchedulerDetailsSetter;
import org.quartz.impl.SchedulerRepository;
import org.quartz.impl.StdJobRunShellFactory;
import org.quartz.impl.StdScheduler;
import org.quartz.simpl.CascadingClassLoadHelper;
import org.quartz.simpl.RAMJobStore;
import org.quartz.simpl.SimpleThreadPool;
import org.quartz.spi.JobStore;
import org.quartz.spi.SchedulerPlugin;
import org.quartz.spi.ThreadExecutor;
import org.quartz.spi.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectSchedulerFactory
implements SchedulerFactory {
    public static final String DEFAULT_INSTANCE_ID = "SIMPLE_NON_CLUSTERED";
    public static final String DEFAULT_SCHEDULER_NAME = "SimpleQuartzScheduler";
    private static final boolean DEFAULT_JMX_EXPORT = false;
    private static final String DEFAULT_JMX_OBJECTNAME = null;
    private static final DefaultThreadExecutor DEFAULT_THREAD_EXECUTOR = new DefaultThreadExecutor();
    private static final int DEFAULT_BATCH_MAX_SIZE = 1;
    private static final long DEFAULT_BATCH_TIME_WINDOW = 0L;
    private boolean initialized = false;
    private static DirectSchedulerFactory instance = new DirectSchedulerFactory();
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    protected Logger getLog() {
        return this.log;
    }

    protected DirectSchedulerFactory() {
    }

    public static DirectSchedulerFactory getInstance() {
        return instance;
    }

    public void createVolatileScheduler(int n) throws SchedulerException {
        SimpleThreadPool simpleThreadPool = new SimpleThreadPool(n, 5);
        simpleThreadPool.initialize();
        RAMJobStore rAMJobStore = new RAMJobStore();
        this.createScheduler(simpleThreadPool, rAMJobStore);
    }

    public void createRemoteScheduler(String string, int n) throws SchedulerException {
        this.createRemoteScheduler(DEFAULT_SCHEDULER_NAME, DEFAULT_INSTANCE_ID, string, n);
    }

    public void createRemoteScheduler(String string, String string2, String string3, int n) throws SchedulerException {
        this.createRemoteScheduler(string, string2, null, string3, n);
    }

    public void createRemoteScheduler(String string, String string2, String string3, String string4, int n) throws SchedulerException {
        String string5 = string3 != null ? string3 : QuartzSchedulerResources.getUniqueIdentifier(string, string2);
        RemoteScheduler remoteScheduler = new RemoteScheduler(string5, string4, n);
        SchedulerRepository schedulerRepository = SchedulerRepository.getInstance();
        schedulerRepository.bind(remoteScheduler);
        this.initialized = true;
    }

    public void createScheduler(ThreadPool threadPool, JobStore jobStore) throws SchedulerException {
        this.createScheduler(DEFAULT_SCHEDULER_NAME, DEFAULT_INSTANCE_ID, threadPool, jobStore);
    }

    public void createScheduler(String string, String string2, ThreadPool threadPool, JobStore jobStore) throws SchedulerException {
        this.createScheduler(string, string2, threadPool, jobStore, null, 0, -1L, -1L);
    }

    public void createScheduler(String string, String string2, ThreadPool threadPool, JobStore jobStore, String string3, int n, long l, long l2) throws SchedulerException {
        this.createScheduler(string, string2, threadPool, jobStore, null, string3, n, l, l2, false, DEFAULT_JMX_OBJECTNAME);
    }

    public void createScheduler(String string, String string2, ThreadPool threadPool, JobStore jobStore, Map<String, SchedulerPlugin> map, String string3, int n, long l, long l2, boolean bl, String string4) throws SchedulerException {
        this.createScheduler(string, string2, threadPool, DEFAULT_THREAD_EXECUTOR, jobStore, map, string3, n, l, l2, bl, string4);
    }

    public void createScheduler(String string, String string2, ThreadPool threadPool, ThreadExecutor threadExecutor, JobStore jobStore, Map<String, SchedulerPlugin> map, String string3, int n, long l, long l2, boolean bl, String string4) throws SchedulerException {
        this.createScheduler(string, string2, threadPool, DEFAULT_THREAD_EXECUTOR, jobStore, map, string3, n, l, l2, bl, string4, 1, 0L);
    }

    public void createScheduler(String string, String string2, ThreadPool threadPool, ThreadExecutor threadExecutor, JobStore jobStore, Map<String, SchedulerPlugin> map, String string3, int n, long l, long l2, boolean bl, String string4, int n2, long l3) throws SchedulerException {
        Object object;
        StdJobRunShellFactory stdJobRunShellFactory = new StdJobRunShellFactory();
        threadPool.initialize();
        QuartzSchedulerResources quartzSchedulerResources = new QuartzSchedulerResources();
        quartzSchedulerResources.setName(string);
        quartzSchedulerResources.setInstanceId(string2);
        SchedulerDetailsSetter.setDetails(threadPool, string, string2);
        quartzSchedulerResources.setJobRunShellFactory(stdJobRunShellFactory);
        quartzSchedulerResources.setThreadPool(threadPool);
        quartzSchedulerResources.setThreadExecutor(threadExecutor);
        quartzSchedulerResources.setJobStore(jobStore);
        quartzSchedulerResources.setMaxBatchSize(n2);
        quartzSchedulerResources.setBatchTimeWindow(l3);
        quartzSchedulerResources.setRMIRegistryHost(string3);
        quartzSchedulerResources.setRMIRegistryPort(n);
        quartzSchedulerResources.setJMXExport(bl);
        if (string4 != null) {
            quartzSchedulerResources.setJMXObjectName(string4);
        }
        if (map != null) {
            object = map.values().iterator();
            while (object.hasNext()) {
                quartzSchedulerResources.addSchedulerPlugin((SchedulerPlugin)object.next());
            }
        }
        object = new QuartzScheduler(quartzSchedulerResources, l, l2);
        CascadingClassLoadHelper cascadingClassLoadHelper = new CascadingClassLoadHelper();
        cascadingClassLoadHelper.initialize();
        SchedulerDetailsSetter.setDetails(jobStore, string, string2);
        jobStore.initialize(cascadingClassLoadHelper, ((QuartzScheduler)object).getSchedulerSignaler());
        StdScheduler stdScheduler = new StdScheduler((QuartzScheduler)object);
        stdJobRunShellFactory.initialize(stdScheduler);
        ((QuartzScheduler)object).initialize();
        if (map != null) {
            for (Map.Entry<String, SchedulerPlugin> entry : map.entrySet()) {
                entry.getValue().initialize(entry.getKey(), stdScheduler, cascadingClassLoadHelper);
            }
        }
        this.getLog().info("Quartz scheduler '" + stdScheduler.getSchedulerName());
        this.getLog().info("Quartz scheduler version: " + ((QuartzScheduler)object).getVersion());
        SchedulerRepository schedulerRepository = SchedulerRepository.getInstance();
        ((QuartzScheduler)object).addNoGCObject(schedulerRepository);
        schedulerRepository.bind(stdScheduler);
        this.initialized = true;
    }

    @Override
    public Scheduler getScheduler() throws SchedulerException {
        if (!this.initialized) {
            throw new SchedulerException("you must call createRemoteScheduler or createScheduler methods before calling getScheduler()");
        }
        return this.getScheduler(DEFAULT_SCHEDULER_NAME);
    }

    @Override
    public Scheduler getScheduler(String string) throws SchedulerException {
        SchedulerRepository schedulerRepository = SchedulerRepository.getInstance();
        return schedulerRepository.lookup(string);
    }

    @Override
    public Collection<Scheduler> getAllSchedulers() throws SchedulerException {
        return SchedulerRepository.getInstance().lookupAll();
    }
}

