/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.ee.servlet;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;

public class QuartzInitializerServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String QUARTZ_FACTORY_KEY = "org.quartz.impl.StdSchedulerFactory.KEY";
    private boolean performShutdown = true;
    private boolean waitOnShutdown = false;
    private transient Scheduler scheduler = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.log("Quartz Initializer Servlet loaded, initializing Scheduler...");
        try {
            String string = servletConfig.getInitParameter("config-file");
            String string2 = servletConfig.getInitParameter("shutdown-on-unload");
            if (string2 != null) {
                this.performShutdown = Boolean.valueOf(string2);
            }
            String string3 = servletConfig.getInitParameter("wait-on-shutdown");
            if (string2 != null) {
                this.waitOnShutdown = Boolean.valueOf(string3);
            }
            StdSchedulerFactory stdSchedulerFactory = this.getSchedulerFactory(string);
            this.scheduler = stdSchedulerFactory.getScheduler();
            String string4 = servletConfig.getInitParameter("start-scheduler-on-load");
            int n = 0;
            String string5 = servletConfig.getInitParameter("start-delay-seconds");
            try {
                if (string5 != null && string5.trim().length() > 0) {
                    n = Integer.parseInt(string5);
                }
            }
            catch (Exception exception) {
                this.log("Cannot parse value of 'start-delay-seconds' to an integer: " + string5 + ", defaulting to 5 seconds.", exception);
                n = 5;
            }
            if (string4 == null || Boolean.valueOf(string4).booleanValue()) {
                if (n <= 0) {
                    this.scheduler.start();
                    this.log("Scheduler has been started...");
                } else {
                    this.scheduler.startDelayed(n);
                    this.log("Scheduler will start in " + n + " seconds.");
                }
            } else {
                this.log("Scheduler has not been started. Use scheduler.start()");
            }
            String string6 = servletConfig.getInitParameter("servlet-context-factory-key");
            if (string6 == null) {
                string6 = QUARTZ_FACTORY_KEY;
            }
            this.log("Storing the Quartz Scheduler Factory in the servlet context at key: " + string6);
            servletConfig.getServletContext().setAttribute(string6, (Object)stdSchedulerFactory);
            String string7 = servletConfig.getInitParameter("scheduler-context-servlet-context-key");
            if (string7 != null) {
                this.log("Storing the ServletContext in the scheduler context at key: " + string7);
                this.scheduler.getContext().put(string7, (Object)servletConfig.getServletContext());
            }
        }
        catch (Exception exception) {
            this.log("Quartz Scheduler failed to initialize: " + exception.toString());
            throw new ServletException((Throwable)exception);
        }
    }

    protected StdSchedulerFactory getSchedulerFactory(String string) throws SchedulerException {
        StdSchedulerFactory stdSchedulerFactory = string != null ? new StdSchedulerFactory(string) : new StdSchedulerFactory();
        return stdSchedulerFactory;
    }

    public void destroy() {
        if (!this.performShutdown) {
            return;
        }
        try {
            if (this.scheduler != null) {
                this.scheduler.shutdown(this.waitOnShutdown);
            }
        }
        catch (Exception exception) {
            this.log("Quartz Scheduler failed to shutdown cleanly: " + exception.toString());
            exception.printStackTrace();
        }
        this.log("Quartz Scheduler successful shutdown.");
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.sendError(403);
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.sendError(403);
    }
}

