/*
 * Decompiled with CFR 0.152.
 */
package org.quartz;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.quartz.Calendar;
import org.quartz.spi.OperableTrigger;

public class TriggerUtils {
    private TriggerUtils() {
    }

    public static List<Date> computeFireTimes(OperableTrigger operableTrigger, Calendar calendar, int n) {
        Date date;
        LinkedList<Date> linkedList = new LinkedList<Date>();
        OperableTrigger operableTrigger2 = (OperableTrigger)operableTrigger.clone();
        if (operableTrigger2.getNextFireTime() == null) {
            operableTrigger2.computeFirstFireTime(calendar);
        }
        for (int i = 0; i < n && (date = operableTrigger2.getNextFireTime()) != null; ++i) {
            linkedList.add(date);
            operableTrigger2.triggered(calendar);
        }
        return Collections.unmodifiableList(linkedList);
    }

    public static Date computeEndTimeToAllowParticularNumberOfFirings(OperableTrigger operableTrigger, Calendar calendar, int n) {
        Date date;
        OperableTrigger operableTrigger2 = (OperableTrigger)operableTrigger.clone();
        if (operableTrigger2.getNextFireTime() == null) {
            operableTrigger2.computeFirstFireTime(calendar);
        }
        int n2 = 0;
        Date date2 = null;
        for (int i = 0; i < n && (date = operableTrigger2.getNextFireTime()) != null; ++i) {
            operableTrigger2.triggered(calendar);
            if (++n2 != n) continue;
            date2 = date;
        }
        if (date2 == null) {
            return null;
        }
        date2 = new Date(date2.getTime() + 1000L);
        return date2;
    }

    public static List<Date> computeFireTimesBetween(OperableTrigger operableTrigger, Calendar calendar, Date date, Date date2) {
        Date date3;
        LinkedList<Date> linkedList = new LinkedList<Date>();
        OperableTrigger operableTrigger2 = (OperableTrigger)operableTrigger.clone();
        if (operableTrigger2.getNextFireTime() == null) {
            operableTrigger2.setStartTime(date);
            operableTrigger2.setEndTime(date2);
            operableTrigger2.computeFirstFireTime(calendar);
        }
        while ((date3 = operableTrigger2.getNextFireTime()) != null) {
            if (date3.before(date)) {
                operableTrigger2.triggered(calendar);
                continue;
            }
            if (date3.after(date2)) break;
            linkedList.add(date3);
            operableTrigger2.triggered(calendar);
        }
        return Collections.unmodifiableList(linkedList);
    }
}

