/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.annotations.common.reflection.java;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.annotations.common.reflection.java.JavaXType;
import org.hibernate.annotations.common.reflection.java.generics.TypeEnvironment;
import org.hibernate.annotations.common.reflection.java.generics.TypeSwitch;
import org.hibernate.annotations.common.reflection.java.generics.TypeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JavaXCollectionType
extends JavaXType {
    public JavaXCollectionType(Type type, TypeEnvironment typeEnvironment, JavaReflectionManager javaReflectionManager) {
        super(type, typeEnvironment, javaReflectionManager);
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public XClass getElementClass() {
        return (XClass)new TypeSwitch<XClass>(){

            @Override
            public XClass caseParameterizedType(ParameterizedType parameterizedType) {
                Type[] typeArray = parameterizedType.getActualTypeArguments();
                Class<? extends Collection> clazz = JavaXCollectionType.this.getCollectionClass();
                Type type = Map.class.isAssignableFrom(clazz) || SortedMap.class.isAssignableFrom(clazz) ? typeArray[1] : typeArray[0];
                return JavaXCollectionType.this.toXClass(type);
            }
        }.doSwitch(this.approximate());
    }

    @Override
    public XClass getMapKey() {
        return (XClass)new TypeSwitch<XClass>(){

            @Override
            public XClass caseParameterizedType(ParameterizedType parameterizedType) {
                if (Map.class.isAssignableFrom(JavaXCollectionType.this.getCollectionClass())) {
                    return JavaXCollectionType.this.toXClass(parameterizedType.getActualTypeArguments()[0]);
                }
                return null;
            }
        }.doSwitch(this.approximate());
    }

    @Override
    public XClass getClassOrElementClass() {
        return this.toXClass(this.approximate());
    }

    @Override
    public Class<? extends Collection> getCollectionClass() {
        return TypeUtils.getCollectionClass(this.approximate());
    }

    @Override
    public XClass getType() {
        return this.toXClass(this.approximate());
    }
}

