/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.type.VersionType;

public abstract class ReplicationMode
implements Serializable {
    private final String name;
    private static final Map INSTANCES = new HashMap();
    public static final ReplicationMode EXCEPTION = new ReplicationMode("EXCEPTION"){

        public boolean shouldOverwriteCurrentVersion(Object object, Object object2, Object object3, VersionType versionType) {
            throw new AssertionFailure("should not be called");
        }
    };
    public static final ReplicationMode IGNORE = new ReplicationMode("IGNORE"){

        public boolean shouldOverwriteCurrentVersion(Object object, Object object2, Object object3, VersionType versionType) {
            return false;
        }
    };
    public static final ReplicationMode OVERWRITE = new ReplicationMode("OVERWRITE"){

        public boolean shouldOverwriteCurrentVersion(Object object, Object object2, Object object3, VersionType versionType) {
            return true;
        }
    };
    public static final ReplicationMode LATEST_VERSION = new ReplicationMode("LATEST_VERSION"){

        public boolean shouldOverwriteCurrentVersion(Object object, Object object2, Object object3, VersionType versionType) {
            if (versionType == null) {
                return true;
            }
            return versionType.getComparator().compare(object2, object3) <= 0;
        }
    };

    public ReplicationMode(String string) {
        this.name = string;
    }

    public String toString() {
        return this.name;
    }

    public abstract boolean shouldOverwriteCurrentVersion(Object var1, Object var2, Object var3, VersionType var4);

    private Object readResolve() {
        return INSTANCES.get(this.name);
    }

    static {
        INSTANCES.put(ReplicationMode.LATEST_VERSION.name, LATEST_VERSION);
        INSTANCES.put(ReplicationMode.IGNORE.name, IGNORE);
        INSTANCES.put(ReplicationMode.OVERWRITE.name, OVERWRITE);
        INSTANCES.put(ReplicationMode.EXCEPTION.name, EXCEPTION);
    }
}

