/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.io.payload;

import java.nio.ByteBuffer;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.io.payload.PayloadProcessor;

public class DeMaskProcessor
implements PayloadProcessor {
    private byte[] maskBytes;
    private int maskInt;
    private int maskOffset;

    @Override
    public void process(ByteBuffer byteBuffer) {
        int n;
        if (this.maskBytes == null) {
            return;
        }
        int n2 = this.maskInt;
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.limit();
        int n5 = this.maskOffset;
        while ((n = n4 - n3) > 0) {
            if (n >= 4 && (n5 & 3) == 0) {
                byteBuffer.putInt(n3, byteBuffer.getInt(n3) ^ n2);
                n3 += 4;
                n5 += 4;
                continue;
            }
            byteBuffer.put(n3, (byte)(byteBuffer.get(n3) ^ this.maskBytes[n5 & 3]));
            ++n3;
            ++n5;
        }
        this.maskOffset = n5;
    }

    public void reset(byte[] byArray) {
        this.maskBytes = byArray;
        int n = 0;
        if (byArray != null) {
            for (byte by : byArray) {
                n = (n << 8) + (by & 0xFF);
            }
        }
        this.maskInt = n;
        this.maskOffset = 0;
    }

    @Override
    public void reset(Frame frame) {
        this.reset(frame.getMask());
    }
}

