/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.io;

import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.LongAdder;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.Generator;
import org.eclipse.jetty.websocket.common.frames.BinaryFrame;

public class FrameFlusher
extends IteratingCallback {
    public static final BinaryFrame FLUSH_FRAME = new BinaryFrame();
    private static final Logger LOG = Log.getLogger(FrameFlusher.class);
    private final ByteBufferPool bufferPool;
    private final EndPoint endPoint;
    private final int bufferSize;
    private final Generator generator;
    private final int maxGather;
    private final Deque<FrameEntry> queue = new ArrayDeque<FrameEntry>();
    private final List<FrameEntry> entries;
    private final List<ByteBuffer> buffers;
    private final LongAdder messagesOut = new LongAdder();
    private final LongAdder bytesOut = new LongAdder();
    private boolean closed;
    private boolean canEnqueue = true;
    private Throwable terminated;
    private ByteBuffer aggregate;
    private BatchMode batchMode;

    public FrameFlusher(ByteBufferPool byteBufferPool, Generator generator, EndPoint endPoint, int n, int n2) {
        this.bufferPool = byteBufferPool;
        this.endPoint = endPoint;
        this.bufferSize = n;
        this.generator = Objects.requireNonNull(generator);
        this.maxGather = n2;
        this.entries = new ArrayList<FrameEntry>(n2);
        this.buffers = new ArrayList<ByteBuffer>(n2 * 2 + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enqueue(Frame frame, WriteCallback writeCallback, BatchMode batchMode) {
        Throwable throwable;
        FrameEntry frameEntry = new FrameEntry(frame, writeCallback, batchMode);
        FrameFlusher frameFlusher = this;
        synchronized (frameFlusher) {
            if (this.canEnqueue) {
                throwable = this.terminated;
                if (throwable == null) {
                    byte by = frame.getOpCode();
                    if (by == 9 || by == 10) {
                        this.queue.offerFirst(frameEntry);
                    } else {
                        this.queue.offerLast(frameEntry);
                    }
                    if (by == 8) {
                        this.canEnqueue = false;
                    }
                }
            } else {
                throwable = new ClosedChannelException();
            }
        }
        if (throwable == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Enqueued {} to {}", frameEntry, this);
            }
            return true;
        }
        this.notifyCallbackFailure(writeCallback, throwable);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IteratingCallback.Action process() throws Throwable {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Flushing {}", this);
        }
        int n = this.aggregate == null ? this.bufferSize : BufferUtil.space(this.aggregate);
        BatchMode batchMode = BatchMode.AUTO;
        FrameFlusher frameFlusher = this;
        synchronized (frameFlusher) {
            if (this.closed) {
                return IteratingCallback.Action.SUCCEEDED;
            }
            if (this.terminated != null) {
                throw this.terminated;
            }
            while (!this.queue.isEmpty() && this.entries.size() < this.maxGather) {
                int n2;
                int n3;
                FrameEntry frameEntry = this.queue.poll();
                batchMode = BatchMode.max(batchMode, frameEntry.batchMode);
                this.messagesOut.increment();
                if (frameEntry.frame == FLUSH_FRAME) {
                    batchMode = BatchMode.OFF;
                }
                if ((n3 = 28 + (n2 = BufferUtil.length(frameEntry.frame.getPayload()))) > this.bufferSize >> 2) {
                    batchMode = BatchMode.OFF;
                }
                if ((n -= n3) <= 0) {
                    batchMode = BatchMode.OFF;
                }
                this.entries.add(frameEntry);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} processing {} entries: {}", this, this.entries.size(), this.entries);
        }
        if (this.entries.isEmpty()) {
            if (this.batchMode != BatchMode.AUTO) {
                this.releaseAggregate();
                return IteratingCallback.Action.IDLE;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} auto flushing", this);
            }
            return this.flush();
        }
        this.batchMode = batchMode;
        return batchMode == BatchMode.OFF ? this.flush() : this.batch();
    }

    private IteratingCallback.Action batch() {
        if (this.aggregate == null) {
            this.aggregate = this.bufferPool.acquire(this.bufferSize, true);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} acquired aggregate buffer {}", this, this.aggregate);
            }
        }
        for (FrameEntry frameEntry : this.entries) {
            frameEntry.generateHeaderBytes(this.aggregate);
            ByteBuffer byteBuffer = frameEntry.frame.getPayload();
            if (!BufferUtil.hasContent(byteBuffer)) continue;
            BufferUtil.append(this.aggregate, byteBuffer);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} aggregated {} frames: {}", this, this.entries.size(), this.entries);
        }
        this.succeeded();
        return IteratingCallback.Action.SCHEDULED;
    }

    private IteratingCallback.Action flush() {
        Object object;
        if (!BufferUtil.isEmpty(this.aggregate)) {
            this.buffers.add(this.aggregate);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} flushing aggregate {}", this, this.aggregate);
            }
        }
        for (FrameEntry frameEntry : this.entries) {
            if (frameEntry.frame == FLUSH_FRAME) continue;
            this.buffers.add(frameEntry.generateHeaderBytes());
            object = frameEntry.frame.getPayload();
            if (!BufferUtil.hasContent((ByteBuffer)object)) continue;
            this.buffers.add((ByteBuffer)object);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} flushing {} frames: {}", this, this.entries.size(), this.entries);
        }
        if (this.buffers.isEmpty()) {
            this.releaseAggregate();
            this.succeedEntries();
            return IteratingCallback.Action.IDLE;
        }
        int n = 0;
        int n2 = 0;
        object = new ByteBuffer[this.buffers.size()];
        for (ByteBuffer byteBuffer : this.buffers) {
            n2 += byteBuffer.limit() - byteBuffer.position();
            object[n++] = byteBuffer;
        }
        this.bytesOut.add(n2);
        this.endPoint.write(this, this.buffers.toArray(new ByteBuffer[this.buffers.size()]));
        this.buffers.clear();
        return IteratingCallback.Action.SCHEDULED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getQueueSize() {
        FrameFlusher frameFlusher = this;
        synchronized (frameFlusher) {
            return this.queue.size();
        }
    }

    @Override
    public void succeeded() {
        this.succeedEntries();
        super.succeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void succeedEntries() {
        for (FrameEntry frameEntry : this.entries) {
            this.notifyCallbackSuccess(frameEntry.callback);
            frameEntry.release();
            if (frameEntry.frame.getOpCode() != 8) continue;
            FrameFlusher frameFlusher = this;
            synchronized (frameFlusher) {
                this.closed = true;
            }
            this.endPoint.shutdownOutput();
        }
        this.entries.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCompleteFailure(Throwable throwable) {
        this.releaseAggregate();
        FrameFlusher frameFlusher = this;
        synchronized (frameFlusher) {
            if (this.terminated == null) {
                this.terminated = throwable;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Write flush failure", throwable);
                }
            }
            this.entries.addAll(this.queue);
            this.queue.clear();
        }
        for (FrameEntry frameEntry : this.entries) {
            this.notifyCallbackFailure(frameEntry.callback, throwable);
            frameEntry.release();
        }
        this.entries.clear();
    }

    private void releaseAggregate() {
        if (BufferUtil.isEmpty(this.aggregate)) {
            this.bufferPool.release(this.aggregate);
            this.aggregate = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminate(Throwable throwable) {
        Throwable throwable2;
        FrameFlusher frameFlusher = this;
        synchronized (frameFlusher) {
            throwable2 = this.terminated;
            if (throwable2 == null) {
                this.terminated = throwable;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} {}", throwable2 == null ? "Terminating" : "Terminated", this);
        }
        if (throwable2 == null) {
            this.iterate();
        }
    }

    protected void notifyCallbackSuccess(WriteCallback writeCallback) {
        block3: {
            try {
                if (writeCallback != null) {
                    writeCallback.writeSuccess();
                }
            }
            catch (Throwable throwable) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("Exception while notifying success of callback " + writeCallback, throwable);
            }
        }
    }

    protected void notifyCallbackFailure(WriteCallback writeCallback, Throwable throwable) {
        block3: {
            try {
                if (writeCallback != null) {
                    writeCallback.writeFailed(throwable);
                }
            }
            catch (Throwable throwable2) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("Exception while notifying failure of callback " + writeCallback, throwable2);
            }
        }
    }

    public long getMessagesOut() {
        return this.messagesOut.longValue();
    }

    public long getBytesOut() {
        return this.bytesOut.longValue();
    }

    @Override
    public String toString() {
        int n = -1;
        ByteBuffer byteBuffer = this.aggregate;
        if (byteBuffer != null) {
            n = byteBuffer.position();
        }
        return String.format("%s[queueSize=%d,aggregateSize=%d,terminated=%s]", super.toString(), this.getQueueSize(), n, this.terminated);
    }

    private class FrameEntry {
        private final Frame frame;
        private final WriteCallback callback;
        private final BatchMode batchMode;
        private ByteBuffer headerBuffer;

        private FrameEntry(Frame frame, WriteCallback writeCallback, BatchMode batchMode) {
            this.frame = Objects.requireNonNull(frame);
            this.callback = writeCallback;
            this.batchMode = batchMode;
        }

        private ByteBuffer generateHeaderBytes() {
            this.headerBuffer = FrameFlusher.this.generator.generateHeaderBytes(this.frame);
            return this.headerBuffer;
        }

        private void generateHeaderBytes(ByteBuffer byteBuffer) {
            FrameFlusher.this.generator.generateHeaderBytes(this.frame, byteBuffer);
        }

        private void release() {
            if (this.headerBuffer != null) {
                FrameFlusher.this.generator.getBufferPool().release(this.headerBuffer);
                this.headerBuffer = null;
            }
        }

        public String toString() {
            return String.format("%s[%s,%s,%s,%s]", new Object[]{this.getClass().getSimpleName(), this.frame, this.callback, this.batchMode, FrameFlusher.this.terminated});
        }
    }
}

