/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.eclipse.jetty.util.log.Log;

public class SerializedExecutor
implements Executor {
    private final AtomicReference<Link> _tail = new AtomicReference();

    @Override
    public void execute(Runnable runnable) {
        Link link = new Link(runnable);
        Link link2 = this._tail.getAndSet(link);
        if (link2 == null) {
            this.run(link);
        } else {
            link2._next.lazySet(link);
        }
    }

    protected void onError(Runnable runnable, Throwable throwable) {
        if (runnable instanceof ErrorHandlingTask) {
            ((ErrorHandlingTask)runnable).accept(throwable);
        }
        Log.getLogger(runnable.getClass()).warn(throwable);
    }

    private void run(Link link) {
        while (link != null) {
            try {
                link._task.run();
            }
            catch (Throwable throwable) {
                this.onError(link._task, throwable);
            }
            finally {
                if (this._tail.compareAndSet(link, null)) {
                    link = null;
                    continue;
                }
                Link link2 = (Link)link._next.get();
                while (link2 == null) {
                    Thread.yield();
                    link2 = (Link)link._next.get();
                }
                link = link2;
            }
        }
    }

    public static interface ErrorHandlingTask
    extends Runnable,
    Consumer<Throwable> {
    }

    private class Link {
        private final Runnable _task;
        private final AtomicReference<Link> _next = new AtomicReference();

        public Link(Runnable runnable) {
            this._task = runnable;
        }
    }
}

