/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.ssl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jetty.util.component.Dumpable;

class SslSelectionDump
implements Dumpable {
    final String type;
    final CaptionedList enabled = new CaptionedList("Enabled");
    final CaptionedList disabled = new CaptionedList("Disabled");

    public SslSelectionDump(String string2, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4) {
        this.type = string2;
        List<String> list = Arrays.asList(stringArray2);
        List list2 = Arrays.stream(stringArray3).map(string -> Pattern.compile(string)).collect(Collectors.toList());
        List list3 = Arrays.stream(stringArray4).map(string -> Pattern.compile(string)).collect(Collectors.toList());
        Arrays.stream(stringArray).sorted(Comparator.naturalOrder()).forEach(string -> {
            boolean bl = true;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append((String)string);
            for (Object object : list2) {
                Object object2 = ((Pattern)object).matcher((CharSequence)string);
                if (!((Matcher)object2).matches()) continue;
                if (bl) {
                    stringBuilder.append(" -");
                    bl = false;
                } else {
                    stringBuilder.append(",");
                }
                stringBuilder.append(" ConfigExcluded:'").append(((Pattern)object).pattern()).append('\'');
            }
            boolean bl2 = false;
            if (!list3.isEmpty()) {
                for (Object object2 : list3) {
                    Matcher matcher = ((Pattern)object2).matcher((CharSequence)string);
                    if (!matcher.matches()) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    if (bl) {
                        stringBuilder.append(" -");
                        bl = false;
                    } else {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(" ConfigIncluded:NotSelected");
                }
            }
            if (!bl2 && !list.contains(string)) {
                if (bl) {
                    stringBuilder.append(" -");
                    bl = false;
                }
                stringBuilder.append(" JVM:disabled");
            }
            if (bl) {
                this.enabled.add(stringBuilder.toString());
            } else {
                this.disabled.add(stringBuilder.toString());
            }
        });
    }

    @Override
    public String dump() {
        return Dumpable.dump(this);
    }

    @Override
    public void dump(Appendable appendable, String string) throws IOException {
        Dumpable.dumpObjects(appendable, string, this, this.enabled, this.disabled);
    }

    public String toString() {
        return String.format("%s Selections", this.type);
    }

    static class CaptionedList
    extends ArrayList<String>
    implements Dumpable {
        private final String caption;

        public CaptionedList(String string) {
            this.caption = string;
        }

        @Override
        public String dump() {
            return Dumpable.dump(this);
        }

        @Override
        public void dump(Appendable appendable, String string) throws IOException {
            Object[] objectArray = this.toArray();
            Dumpable.dumpObjects(appendable, string, this.caption + " size=" + objectArray.length, objectArray);
        }
    }
}

