/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.security;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ServiceLoader;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.security.CredentialProvider;
import org.eclipse.jetty.util.security.Password;
import org.eclipse.jetty.util.security.UnixCrypt;

public abstract class Credential
implements Serializable {
    private static final long serialVersionUID = -7760551052768181572L;
    private static final Logger LOG = Log.getLogger(Credential.class);
    private static final ServiceLoader<CredentialProvider> CREDENTIAL_PROVIDER_LOADER = ServiceLoader.load(CredentialProvider.class);

    public abstract boolean check(Object var1);

    public static Credential getCredential(String string) {
        if (string.startsWith("CRYPT:")) {
            return new Crypt(string);
        }
        if (string.startsWith("MD5:")) {
            return new MD5(string);
        }
        for (CredentialProvider credentialProvider : CREDENTIAL_PROVIDER_LOADER) {
            Credential credential;
            if (!string.startsWith(credentialProvider.getPrefix()) || (credential = credentialProvider.getCredential(string)) == null) continue;
            return credential;
        }
        return new Password(string);
    }

    protected static boolean stringEquals(String string, String string2) {
        boolean bl;
        boolean bl2 = bl = string == string2;
        if (bl) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        boolean bl3 = true;
        int n = string.length();
        int n2 = string2.length();
        for (int i = 0; i < n2; ++i) {
            bl3 &= (n == 0 ? string2.charAt(n2 - i - 1) : string.charAt(i % n)) == string2.charAt(i);
        }
        return bl3 && n == n2;
    }

    protected static boolean byteEquals(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        boolean bl = true;
        int n = byArray.length;
        int n2 = byArray2.length;
        for (int i = 0; i < n2; ++i) {
            bl &= (n == 0 ? byArray2[n2 - i - 1] : byArray[i % n]) == byArray2[i];
        }
        return bl && n == n2;
    }

    public static class MD5
    extends Credential {
        private static final long serialVersionUID = 5533846540822684240L;
        private static final String __TYPE = "MD5:";
        private static final Object __md5Lock = new Object();
        private static MessageDigest __md;
        private final byte[] _digest;

        MD5(String string) {
            string = string.startsWith(__TYPE) ? string.substring(__TYPE.length()) : string;
            this._digest = TypeUtil.parseBytes(string, 16);
        }

        public byte[] getDigest() {
            return this._digest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean check(Object object) {
            try {
                if (object instanceof char[]) {
                    object = new String((char[])object);
                }
                if (object instanceof Password || object instanceof String) {
                    byte[] byArray;
                    Object object2 = __md5Lock;
                    synchronized (object2) {
                        if (__md == null) {
                            __md = MessageDigest.getInstance("MD5");
                        }
                        __md.reset();
                        __md.update(object.toString().getBytes(StandardCharsets.ISO_8859_1));
                        byArray = __md.digest();
                    }
                    return MD5.byteEquals(this._digest, byArray);
                }
                if (object instanceof MD5) {
                    return this.equals(object);
                }
                if (object instanceof Credential) {
                    return ((Credential)object).check(this);
                }
                LOG.warn("Can't check " + object.getClass() + " against MD5", new Object[0]);
                return false;
            }
            catch (Exception exception) {
                LOG.warn(exception);
                return false;
            }
        }

        public boolean equals(Object object) {
            if (object instanceof MD5) {
                return MD5.byteEquals(this._digest, ((MD5)object)._digest);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String digest(String string) {
            try {
                byte[] byArray;
                Object object = __md5Lock;
                synchronized (object) {
                    if (__md == null) {
                        try {
                            __md = MessageDigest.getInstance("MD5");
                        }
                        catch (Exception exception) {
                            LOG.warn(exception);
                            return null;
                        }
                    }
                    __md.reset();
                    __md.update(string.getBytes(StandardCharsets.ISO_8859_1));
                    byArray = __md.digest();
                }
                return __TYPE + TypeUtil.toString(byArray, 16);
            }
            catch (Exception exception) {
                LOG.warn(exception);
                return null;
            }
        }
    }

    public static class Crypt
    extends Credential {
        private static final long serialVersionUID = -2027792997664744210L;
        private static final String __TYPE = "CRYPT:";
        private final String _cooked;

        Crypt(String string) {
            this._cooked = string.startsWith(__TYPE) ? string.substring(__TYPE.length()) : string;
        }

        @Override
        public boolean check(Object object) {
            if (object instanceof char[]) {
                object = new String((char[])object);
            }
            if (!(object instanceof String) && !(object instanceof Password)) {
                LOG.warn("Can't check " + object.getClass() + " against CRYPT", new Object[0]);
            }
            return Crypt.stringEquals(this._cooked, UnixCrypt.crypt(object.toString(), this._cooked));
        }

        public boolean equals(Object object) {
            if (!(object instanceof Crypt)) {
                return false;
            }
            Crypt crypt = (Crypt)object;
            return Crypt.stringEquals(this._cooked, crypt._cooked);
        }

        public static String crypt(String string, String string2) {
            return __TYPE + UnixCrypt.crypt(string2, string);
        }
    }
}

