/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.security;

import java.io.Serializable;
import java.util.Arrays;

public class Constraint
implements Cloneable,
Serializable {
    public static final String __BASIC_AUTH = "BASIC";
    public static final String __FORM_AUTH = "FORM";
    public static final String __DIGEST_AUTH = "DIGEST";
    public static final String __CERT_AUTH = "CLIENT_CERT";
    public static final String __CERT_AUTH2 = "CLIENT-CERT";
    public static final String __SPNEGO_AUTH = "SPNEGO";
    public static final String __NEGOTIATE_AUTH = "NEGOTIATE";
    public static final String __OPENID_AUTH = "OPENID";
    public static final int DC_UNSET = -1;
    public static final int DC_NONE = 0;
    public static final int DC_INTEGRAL = 1;
    public static final int DC_CONFIDENTIAL = 2;
    public static final int DC_FORBIDDEN = 3;
    public static final String NONE = "NONE";
    public static final String ANY_ROLE = "*";
    public static final String ANY_AUTH = "**";
    private String _name;
    private String[] _roles;
    private int _dataConstraint = -1;
    private boolean _anyRole = false;
    private boolean _anyAuth = false;
    private boolean _authenticate = false;

    public static boolean validateMethod(String string) {
        if (string == null) {
            return false;
        }
        return (string = string.trim()).equals(__FORM_AUTH) || string.equals(__BASIC_AUTH) || string.equals(__DIGEST_AUTH) || string.equals(__CERT_AUTH) || string.equals(__CERT_AUTH2) || string.equals(__SPNEGO_AUTH) || string.equals(__NEGOTIATE_AUTH) || string.equals(__OPENID_AUTH);
    }

    public Constraint() {
    }

    public Constraint(String string, String string2) {
        this.setName(string);
        this.setRoles(new String[]{string2});
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getName() {
        return this._name;
    }

    public void setRoles(String[] stringArray) {
        this._roles = stringArray;
        this._anyRole = false;
        this._anyAuth = false;
        if (stringArray != null) {
            int n = stringArray.length;
            while (n-- > 0) {
                this._anyRole |= ANY_ROLE.equals(stringArray[n]);
                this._anyAuth |= ANY_AUTH.equals(stringArray[n]);
            }
        }
    }

    public boolean isAnyRole() {
        return this._anyRole;
    }

    public boolean isAnyAuth() {
        return this._anyAuth;
    }

    public String[] getRoles() {
        return this._roles;
    }

    public boolean hasRole(String string) {
        if (this._anyRole) {
            return true;
        }
        if (this._roles != null) {
            int n = this._roles.length;
            while (n-- > 0) {
                if (!string.equals(this._roles[n])) continue;
                return true;
            }
        }
        return false;
    }

    public void setAuthenticate(boolean bl) {
        this._authenticate = bl;
    }

    public boolean getAuthenticate() {
        return this._authenticate;
    }

    public boolean isForbidden() {
        return this._authenticate && !this._anyRole && (this._roles == null || this._roles.length == 0);
    }

    public void setDataConstraint(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("Constraint out of range");
        }
        this._dataConstraint = n;
    }

    public int getDataConstraint() {
        return this._dataConstraint;
    }

    public boolean hasDataConstraint() {
        return this._dataConstraint >= 0;
    }

    public String toString() {
        return "SC{" + this._name + "," + (this._anyRole ? ANY_ROLE : (this._roles == null ? "-" : Arrays.asList(this._roles).toString())) + "," + (this._dataConstraint == -1 ? "DC_UNSET}" : (this._dataConstraint == 0 ? "NONE}" : (this._dataConstraint == 1 ? "INTEGRAL}" : "CONFIDENTIAL}")));
    }
}

