/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.UrlEncoded;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.BadResource;
import org.eclipse.jetty.util.resource.JarFileResource;
import org.eclipse.jetty.util.resource.JarResource;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.ResourceCollators;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.resource.URLResource;

public abstract class Resource
implements ResourceFactory,
Closeable {
    private static final Logger LOG = Log.getLogger(Resource.class);
    public static boolean __defaultUseCaches = true;
    volatile Object _associate;

    public static void setDefaultUseCaches(boolean bl) {
        __defaultUseCaches = bl;
    }

    public static boolean getDefaultUseCaches() {
        return __defaultUseCaches;
    }

    public static Resource newResource(URI uRI) throws MalformedURLException {
        return Resource.newResource(uRI.toURL());
    }

    public static Resource newResource(URL uRL) {
        return Resource.newResource(uRL, __defaultUseCaches);
    }

    static Resource newResource(URL uRL, boolean bl) {
        if (uRL == null) {
            return null;
        }
        String string = uRL.toExternalForm();
        if (string.startsWith("file:")) {
            try {
                return new PathResource(uRL);
            }
            catch (Exception exception) {
                LOG.warn(exception.toString(), new Object[0]);
                LOG.debug("EXCEPTION ", exception);
                return new BadResource(uRL, exception.toString());
            }
        }
        if (string.startsWith("jar:file:")) {
            return new JarFileResource(uRL, bl);
        }
        if (string.startsWith("jar:")) {
            return new JarResource(uRL, bl);
        }
        return new URLResource(uRL, null, bl);
    }

    public static Resource newResource(String string) throws IOException {
        return Resource.newResource(string, __defaultUseCaches);
    }

    public static Resource newResource(String string, boolean bl) throws IOException {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            if (!(string.startsWith("ftp:") || string.startsWith("file:") || string.startsWith("jar:"))) {
                return new PathResource(Paths.get(string, new String[0]));
            }
            LOG.warn("Bad Resource: " + string, new Object[0]);
            throw malformedURLException;
        }
        return Resource.newResource(uRL, bl);
    }

    public static Resource newResource(File file) {
        return new PathResource(file.toPath());
    }

    public static Resource newResource(Path path) {
        return new PathResource(path);
    }

    public static Resource newSystemResource(String string) throws IOException {
        URL uRL = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            try {
                uRL = classLoader.getResource(string);
                if (uRL == null && string.startsWith("/")) {
                    uRL = classLoader.getResource(string.substring(1));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOG.ignore(illegalArgumentException);
                uRL = null;
            }
        }
        if (uRL == null && (classLoader = Resource.class.getClassLoader()) != null && (uRL = classLoader.getResource(string)) == null && string.startsWith("/")) {
            uRL = classLoader.getResource(string.substring(1));
        }
        if (uRL == null && (uRL = ClassLoader.getSystemResource(string)) == null && string.startsWith("/")) {
            uRL = ClassLoader.getSystemResource(string.substring(1));
        }
        if (uRL == null) {
            return null;
        }
        return Resource.newResource(uRL);
    }

    public static Resource newClassPathResource(String string) {
        return Resource.newClassPathResource(string, true, false);
    }

    public static Resource newClassPathResource(String string, boolean bl, boolean bl2) {
        URL uRL = Resource.class.getResource(string);
        if (uRL == null) {
            uRL = Loader.getResource(string);
        }
        if (uRL == null) {
            return null;
        }
        return Resource.newResource(uRL, bl);
    }

    public static boolean isContainedIn(Resource resource, Resource resource2) throws MalformedURLException {
        return resource.isContainedIn(resource2);
    }

    protected void finalize() {
        this.close();
    }

    public abstract boolean isContainedIn(Resource var1) throws MalformedURLException;

    public boolean isSame(Resource resource) {
        return this.equals(resource);
    }

    public final void release() {
        this.close();
    }

    @Override
    public abstract void close();

    public abstract boolean exists();

    public abstract boolean isDirectory();

    public abstract long lastModified();

    public abstract long length();

    @Deprecated
    public abstract URL getURL();

    public URI getURI() {
        try {
            return this.getURL().toURI();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public abstract File getFile() throws IOException;

    public abstract String getName();

    public abstract InputStream getInputStream() throws IOException;

    public abstract ReadableByteChannel getReadableByteChannel() throws IOException;

    public abstract boolean delete() throws SecurityException;

    public abstract boolean renameTo(Resource var1) throws SecurityException;

    public abstract String[] list();

    public abstract Resource addPath(String var1) throws IOException, MalformedURLException;

    @Override
    public Resource getResource(String string) {
        try {
            return this.addPath(string);
        }
        catch (Exception exception) {
            LOG.debug(exception);
            return null;
        }
    }

    @Deprecated
    public String encode(String string) {
        return null;
    }

    public Object getAssociate() {
        return this._associate;
    }

    public void setAssociate(Object object) {
        this._associate = object;
    }

    public boolean isAlias() {
        return this.getAlias() != null;
    }

    public URI getAlias() {
        return null;
    }

    @Deprecated
    public String getListHTML(String string, boolean bl) throws IOException {
        return this.getListHTML(string, bl, null);
    }

    public String getListHTML(String string, boolean bl, String string2) throws IOException {
        Object object;
        String string32;
        Object object2;
        MultiMap<String> multiMap;
        if ((string = URIUtil.canonicalPath(string)) == null || !this.isDirectory()) {
            return null;
        }
        String[] stringArray = this.list();
        if (stringArray == null) {
            return null;
        }
        boolean bl2 = true;
        String string4 = "N";
        if (string2 != null) {
            multiMap = new MultiMap();
            UrlEncoded.decodeUtf8To(string2, 0, string2.length(), multiMap);
            object2 = multiMap.getString("O");
            String string5 = multiMap.getString("C");
            if (StringUtil.isNotBlank((String)object2)) {
                if (((String)object2).equals("A")) {
                    bl2 = true;
                } else if (((String)object2).equals("D")) {
                    bl2 = false;
                }
            }
            if (StringUtil.isNotBlank(string5) && (string5.equals("N") || string5.equals("M") || string5.equals("S"))) {
                string4 = string5;
            }
        }
        multiMap = new ArrayList();
        for (String string32 : stringArray) {
            object = this.addPath(string32);
            multiMap.add((Resource)object);
        }
        if (string4.equals("M")) {
            Collections.sort(multiMap, ResourceCollators.byLastModified(bl2));
        } else if (string4.equals("S")) {
            Collections.sort(multiMap, ResourceCollators.bySize(bl2));
        } else {
            Collections.sort(multiMap, ResourceCollators.byName(bl2));
        }
        object2 = URIUtil.decodePath(string);
        String string6 = "Directory: " + Resource.deTag((String)object2);
        StringBuilder stringBuilder = new StringBuilder(4096);
        stringBuilder.append("<!DOCTYPE html>\n");
        stringBuilder.append("<html lang=\"en\">\n");
        stringBuilder.append("<head>\n");
        stringBuilder.append("<meta charset=\"utf-8\">\n");
        stringBuilder.append("<link href=\"jetty-dir.css\" rel=\"stylesheet\" />\n");
        stringBuilder.append("<title>");
        stringBuilder.append(string6);
        stringBuilder.append("</title>\n");
        stringBuilder.append("</head>\n");
        stringBuilder.append("<body>\n");
        stringBuilder.append("<h1 class=\"title\">").append(string6).append("</h1>\n");
        string32 = "&nbsp; &#8681;";
        object = "&nbsp; &#8679;";
        stringBuilder.append("<table class=\"listing\">\n");
        stringBuilder.append("<thead>\n");
        String string7 = "";
        String string8 = "A";
        if (string4.equals("N")) {
            if (bl2) {
                string8 = "D";
                string7 = "&nbsp; &#8679;";
            } else {
                string8 = "A";
                string7 = "&nbsp; &#8681;";
            }
        }
        stringBuilder.append("<tr><th class=\"name\"><a href=\"?C=N&O=").append(string8).append("\">");
        stringBuilder.append("Name").append(string7);
        stringBuilder.append("</a></th>");
        string7 = "";
        string8 = "A";
        if (string4.equals("M")) {
            if (bl2) {
                string8 = "D";
                string7 = "&nbsp; &#8679;";
            } else {
                string8 = "A";
                string7 = "&nbsp; &#8681;";
            }
        }
        stringBuilder.append("<th class=\"lastmodified\"><a href=\"?C=M&O=").append(string8).append("\">");
        stringBuilder.append("Last Modified").append(string7);
        stringBuilder.append("</a></th>");
        string7 = "";
        string8 = "A";
        if (string4.equals("S")) {
            if (bl2) {
                string8 = "D";
                string7 = "&nbsp; &#8679;";
            } else {
                string8 = "A";
                string7 = "&nbsp; &#8681;";
            }
        }
        stringBuilder.append("<th class=\"size\"><a href=\"?C=S&O=").append(string8).append("\">");
        stringBuilder.append("Size").append(string7);
        stringBuilder.append("</a></th></tr>\n");
        stringBuilder.append("</thead>\n");
        stringBuilder.append("<tbody>\n");
        String string9 = Resource.hrefEncodeURI(string);
        if (bl) {
            stringBuilder.append("<tr><td class=\"name\"><a href=\"");
            stringBuilder.append(URIUtil.addPaths(string9, "../"));
            stringBuilder.append("\">Parent Directory</a></td>");
            stringBuilder.append("<td class=\"lastmodified\">-</td>");
            stringBuilder.append("<td>-</td>");
            stringBuilder.append("</tr>\n");
        }
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
        Iterator iterator = multiMap.iterator();
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            String string10 = resource.getFileName();
            if (StringUtil.isBlank(string10)) continue;
            if (resource.isDirectory() && !string10.endsWith("/")) {
                string10 = string10 + "/";
            }
            stringBuilder.append("<tr><td class=\"name\"><a href=\"");
            String string11 = URIUtil.addEncodedPaths(string9, URIUtil.encodePath(string10));
            stringBuilder.append(string11);
            stringBuilder.append("\">");
            stringBuilder.append(Resource.deTag(string10));
            stringBuilder.append("&nbsp;");
            stringBuilder.append("</a></td>");
            stringBuilder.append("<td class=\"lastmodified\">");
            long l = resource.lastModified();
            if (l > 0L) {
                stringBuilder.append(dateFormat.format(new Date(resource.lastModified())));
            }
            stringBuilder.append("&nbsp;</td>");
            stringBuilder.append("<td class=\"size\">");
            long l2 = resource.length();
            if (l2 >= 0L) {
                stringBuilder.append(String.format("%,d bytes", resource.length()));
            }
            stringBuilder.append("&nbsp;</td></tr>\n");
        }
        stringBuilder.append("</tbody>\n");
        stringBuilder.append("</table>\n");
        stringBuilder.append("</body></html>\n");
        return stringBuilder.toString();
    }

    private String getFileName() {
        Object object;
        try {
            object = this.getFile();
            if (object != null) {
                return ((File)object).getName();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            object = this.getName();
            int n = ((String)object).lastIndexOf(47);
            if (n == ((String)object).length() - 1) {
                n = ((String)object).lastIndexOf(47, n - 1);
            }
            Object object2 = n >= 0 ? ((String)object).substring(n + 1) : object;
            return UrlEncoded.decodeString((String)object2, 0, ((String)object2).length(), StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static String hrefEncodeURI(String string) {
        char c;
        int n;
        StringBuffer stringBuffer = null;
        block9: for (n = 0; n < string.length(); ++n) {
            c = string.charAt(n);
            switch (c) {
                case '\"': 
                case '\'': 
                case '<': 
                case '>': {
                    stringBuffer = new StringBuffer(string.length() << 1);
                    break block9;
                }
                default: {
                    continue block9;
                }
            }
        }
        if (stringBuffer == null) {
            return string;
        }
        block10: for (n = 0; n < string.length(); ++n) {
            c = string.charAt(n);
            switch (c) {
                case '\"': {
                    stringBuffer.append("%22");
                    continue block10;
                }
                case '\'': {
                    stringBuffer.append("%27");
                    continue block10;
                }
                case '<': {
                    stringBuffer.append("%3C");
                    continue block10;
                }
                case '>': {
                    stringBuffer.append("%3E");
                    continue block10;
                }
                default: {
                    stringBuffer.append(c);
                    continue block10;
                }
            }
        }
        return stringBuffer.toString();
    }

    private static String deTag(String string) {
        return StringUtil.sanitizeXmlString(string);
    }

    public void writeTo(OutputStream outputStream, long l, long l2) throws IOException {
        try (InputStream inputStream = this.getInputStream();){
            inputStream.skip(l);
            if (l2 < 0L) {
                IO.copy(inputStream, outputStream);
            } else {
                IO.copy(inputStream, outputStream, l2);
            }
        }
    }

    public void copyTo(File file) throws IOException {
        if (file.exists()) {
            throw new IllegalArgumentException(file + " exists");
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            this.writeTo(fileOutputStream, 0L, -1L);
        }
    }

    public String getWeakETag() {
        return this.getWeakETag("");
    }

    public String getWeakETag(String string) {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append("W/\"");
        String string2 = this.getName();
        int n = string2.length();
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            l = 31L * l + (long)string2.charAt(i);
        }
        Base64.Encoder encoder = Base64.getEncoder().withoutPadding();
        stringBuilder.append(encoder.encodeToString(Resource.longToBytes(this.lastModified() ^ l)));
        stringBuilder.append(encoder.encodeToString(Resource.longToBytes(this.length() ^ l)));
        stringBuilder.append(string);
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }

    private static byte[] longToBytes(long l) {
        byte[] byArray = new byte[8];
        for (int i = 7; i >= 0; --i) {
            byArray[i] = (byte)(l & 0xFFL);
            l >>= 8;
        }
        return byArray;
    }

    public Collection<Resource> getAllResources() {
        try {
            ArrayList<Resource> arrayList = new ArrayList<Resource>();
            String[] stringArray = this.list();
            if (stringArray != null) {
                for (String string : stringArray) {
                    Resource resource = this.addPath(string);
                    if (resource.isDirectory()) {
                        arrayList.addAll(resource.getAllResources());
                        continue;
                    }
                    arrayList.add(resource);
                }
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    public static URL toURL(File file) throws MalformedURLException {
        return file.toURI().toURL();
    }
}

