/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.util.HostPort;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.Utf8Appendable;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class URIUtil
implements Cloneable {
    private static final Logger LOG = Log.getLogger(URIUtil.class);
    public static final String SLASH = "/";
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final Charset __CHARSET = StandardCharsets.UTF_8;

    private URIUtil() {
    }

    public static String encodePath(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuilder stringBuilder = URIUtil.encodePath(null, string, 0);
        return stringBuilder == null ? string : stringBuilder.toString();
    }

    public static StringBuilder encodePath(StringBuilder stringBuilder, String string) {
        return URIUtil.encodePath(stringBuilder, string, 0);
    }

    private static StringBuilder encodePath(StringBuilder stringBuilder, String string, int n) {
        int n2;
        byte[] byArray = null;
        if (stringBuilder == null) {
            block41: for (n2 = n; n2 < string.length(); ++n2) {
                char by = string.charAt(n2);
                switch (by) {
                    case ' ': 
                    case '\"': 
                    case '#': 
                    case '%': 
                    case '\'': 
                    case ';': 
                    case '<': 
                    case '>': 
                    case '?': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '^': 
                    case '`': 
                    case '{': 
                    case '|': 
                    case '}': {
                        stringBuilder = new StringBuilder(string.length() * 2);
                        break block41;
                    }
                    default: {
                        if (by >= ' ' && by < '\u007f') continue block41;
                        byArray = string.getBytes(__CHARSET);
                        stringBuilder = new StringBuilder(string.length() * 2);
                        break block41;
                    }
                }
            }
            if (stringBuilder == null) {
                return null;
            }
        }
        block42: for (n2 = n; n2 < string.length(); ++n2) {
            char c = string.charAt(n2);
            switch (c) {
                case '%': {
                    stringBuilder.append("%25");
                    continue block42;
                }
                case '?': {
                    stringBuilder.append("%3F");
                    continue block42;
                }
                case ';': {
                    stringBuilder.append("%3B");
                    continue block42;
                }
                case '#': {
                    stringBuilder.append("%23");
                    continue block42;
                }
                case '\"': {
                    stringBuilder.append("%22");
                    continue block42;
                }
                case '\'': {
                    stringBuilder.append("%27");
                    continue block42;
                }
                case '<': {
                    stringBuilder.append("%3C");
                    continue block42;
                }
                case '>': {
                    stringBuilder.append("%3E");
                    continue block42;
                }
                case ' ': {
                    stringBuilder.append("%20");
                    continue block42;
                }
                case '[': {
                    stringBuilder.append("%5B");
                    continue block42;
                }
                case '\\': {
                    stringBuilder.append("%5C");
                    continue block42;
                }
                case ']': {
                    stringBuilder.append("%5D");
                    continue block42;
                }
                case '^': {
                    stringBuilder.append("%5E");
                    continue block42;
                }
                case '`': {
                    stringBuilder.append("%60");
                    continue block42;
                }
                case '{': {
                    stringBuilder.append("%7B");
                    continue block42;
                }
                case '|': {
                    stringBuilder.append("%7C");
                    continue block42;
                }
                case '}': {
                    stringBuilder.append("%7D");
                    continue block42;
                }
                default: {
                    if (c < ' ' || c >= '\u007f') {
                        byArray = string.getBytes(__CHARSET);
                        break block42;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        if (byArray != null) {
            while (n2 < byArray.length) {
                void var5_7 = byArray[n2];
                switch (var5_7) {
                    case 37: {
                        stringBuilder.append("%25");
                        break;
                    }
                    case 63: {
                        stringBuilder.append("%3F");
                        break;
                    }
                    case 59: {
                        stringBuilder.append("%3B");
                        break;
                    }
                    case 35: {
                        stringBuilder.append("%23");
                        break;
                    }
                    case 34: {
                        stringBuilder.append("%22");
                        break;
                    }
                    case 39: {
                        stringBuilder.append("%27");
                        break;
                    }
                    case 60: {
                        stringBuilder.append("%3C");
                        break;
                    }
                    case 62: {
                        stringBuilder.append("%3E");
                        break;
                    }
                    case 32: {
                        stringBuilder.append("%20");
                        break;
                    }
                    case 91: {
                        stringBuilder.append("%5B");
                        break;
                    }
                    case 92: {
                        stringBuilder.append("%5C");
                        break;
                    }
                    case 93: {
                        stringBuilder.append("%5D");
                        break;
                    }
                    case 94: {
                        stringBuilder.append("%5E");
                        break;
                    }
                    case 96: {
                        stringBuilder.append("%60");
                        break;
                    }
                    case 123: {
                        stringBuilder.append("%7B");
                        break;
                    }
                    case 124: {
                        stringBuilder.append("%7C");
                        break;
                    }
                    case 125: {
                        stringBuilder.append("%7D");
                        break;
                    }
                    default: {
                        if (var5_7 < 32 || var5_7 >= 127) {
                            stringBuilder.append('%');
                            TypeUtil.toHex((byte)var5_7, (Appendable)stringBuilder);
                            break;
                        }
                        stringBuilder.append((char)var5_7);
                    }
                }
                ++n2;
            }
        }
        return stringBuilder;
    }

    public static String encodeSpaces(String string) {
        return StringUtil.replace(string, " ", "%20");
    }

    public static String encodeSpecific(String string, String string2) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        char[] cArray = string2.toCharArray();
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder((int)((double)n * 0.2));
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            boolean bl = false;
            for (char c2 : cArray) {
                if (c != c2) continue;
                bl = true;
                stringBuilder.append('%');
                int n2 = 0xF & (0xF0 & c) >> 4;
                stringBuilder.append((char)((n2 > 9 ? 55 : 48) + n2));
                n2 = 0xF & c;
                stringBuilder.append((char)((n2 > 9 ? 55 : 48) + n2));
                break;
            }
            if (bl) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String decodeSpecific(String string, String string2) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        int n = string.indexOf(37);
        if (n == -1) {
            return string;
        }
        char[] cArray = string2.toCharArray();
        int n2 = string.length();
        Utf8StringBuilder utf8StringBuilder = new Utf8StringBuilder(n2);
        utf8StringBuilder.append(string, 0, n);
        block3: for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '%': {
                    if (i + 2 < n2) {
                        char c2 = string.charAt(i + 1);
                        char c3 = string.charAt(i + 2);
                        char c4 = (char)(0xFF & TypeUtil.convertHexDigit(c2) * 16 + TypeUtil.convertHexDigit(c3));
                        boolean bl = false;
                        for (char c5 : cArray) {
                            if (c5 != c4) continue;
                            utf8StringBuilder.append(c4);
                            bl = true;
                            break;
                        }
                        if (bl) {
                            i += 2;
                            continue block3;
                        }
                        utf8StringBuilder.append(c);
                        continue block3;
                    }
                    throw new IllegalArgumentException("Bad URI % encoding");
                }
                default: {
                    utf8StringBuilder.append(c);
                }
            }
        }
        return utf8StringBuilder.toString();
    }

    public static StringBuilder encodeString(StringBuilder stringBuilder, String string, String string2) {
        char c;
        int n;
        if (stringBuilder == null) {
            for (n = 0; n < string.length(); ++n) {
                c = string.charAt(n);
                if (c != '%' && string2.indexOf(c) < 0) continue;
                stringBuilder = new StringBuilder(string.length() << 1);
                break;
            }
            if (stringBuilder == null) {
                return null;
            }
        }
        for (n = 0; n < string.length(); ++n) {
            c = string.charAt(n);
            if (c == '%' || string2.indexOf(c) >= 0) {
                stringBuilder.append('%');
                StringUtil.append(stringBuilder, (byte)(0xFF & c), 16);
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder;
    }

    public static String decodePath(String string) {
        return URIUtil.decodePath(string, 0, string.length());
    }

    public static String decodePath(String string, int n, int n2) {
        try {
            Utf8StringBuilder utf8StringBuilder = null;
            int n3 = n + n2;
            block8: for (int i = n; i < n3; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '%': {
                        if (utf8StringBuilder == null) {
                            utf8StringBuilder = new Utf8StringBuilder(string.length());
                            utf8StringBuilder.append(string, n, i - n);
                        }
                        if (i + 2 < n3) {
                            char c2 = string.charAt(i + 1);
                            if (c2 == 'u') {
                                utf8StringBuilder.append((char)(0xFFFF & TypeUtil.parseInt(string, i + 2, 4, 16)));
                                i += 5;
                                continue block8;
                            }
                            utf8StringBuilder.append((byte)(0xFF & TypeUtil.convertHexDigit(c2) * 16 + TypeUtil.convertHexDigit(string.charAt(i + 2))));
                            i += 2;
                            continue block8;
                        }
                        throw new IllegalArgumentException("Bad URI % encoding");
                    }
                    case ';': {
                        if (utf8StringBuilder == null) {
                            utf8StringBuilder = new Utf8StringBuilder(string.length());
                            utf8StringBuilder.append(string, n, i - n);
                        }
                        while (++i < n3) {
                            if (string.charAt(i) != '/') continue;
                            utf8StringBuilder.append('/');
                            continue block8;
                        }
                        continue block8;
                    }
                    default: {
                        if (utf8StringBuilder == null) continue block8;
                        utf8StringBuilder.append(c);
                    }
                }
            }
            if (utf8StringBuilder != null) {
                return utf8StringBuilder.toString();
            }
            if (n == 0 && n2 == string.length()) {
                return string;
            }
            return string.substring(n, n3);
        }
        catch (Utf8Appendable.NotUtf8Exception notUtf8Exception) {
            LOG.debug(string.substring(n, n + n2) + " " + notUtf8Exception, new Object[0]);
            return URIUtil.decodeISO88591Path(string, n, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("cannot decode URI", exception);
        }
    }

    private static String decodeISO88591Path(String string, int n, int n2) {
        StringBuilder stringBuilder = null;
        int n3 = n + n2;
        block4: for (int i = n; i < n3; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '%': {
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder(string.length());
                        stringBuilder.append(string, n, i - n);
                    }
                    if (i + 2 < n3) {
                        char c2 = string.charAt(i + 1);
                        if (c2 == 'u') {
                            stringBuilder.append((char)(0xFFFF & TypeUtil.parseInt(string, i + 2, 4, 16)));
                            i += 5;
                            continue block4;
                        }
                        stringBuilder.append((char)(0xFF & TypeUtil.convertHexDigit(c2) * 16 + TypeUtil.convertHexDigit(string.charAt(i + 2))));
                        i += 2;
                        continue block4;
                    }
                    throw new IllegalArgumentException();
                }
                case ';': {
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder(string.length());
                        stringBuilder.append(string, n, i - n);
                    }
                    while (++i < n3) {
                        if (string.charAt(i) != '/') continue;
                        stringBuilder.append('/');
                        continue block4;
                    }
                    continue block4;
                }
                default: {
                    if (stringBuilder == null) continue block4;
                    stringBuilder.append(c);
                }
            }
        }
        if (stringBuilder != null) {
            return stringBuilder.toString();
        }
        if (n == 0 && n2 == string.length()) {
            return string;
        }
        return string.substring(n, n3);
    }

    public static String addEncodedPaths(String string, String string2) {
        if (string == null || string.length() == 0) {
            if (string != null && string2 == null) {
                return string;
            }
            return string2;
        }
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        int n = string.indexOf(59);
        if (n < 0) {
            n = string.indexOf(63);
        }
        if (n == 0) {
            return string2 + string;
        }
        if (n < 0) {
            n = string.length();
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + string2.length() + 2);
        stringBuilder.append(string);
        if (stringBuilder.charAt(n - 1) == '/') {
            if (string2.startsWith(SLASH)) {
                stringBuilder.deleteCharAt(n - 1);
                stringBuilder.insert(n - 1, string2);
            } else {
                stringBuilder.insert(n, string2);
            }
        } else if (string2.startsWith(SLASH)) {
            stringBuilder.insert(n, string2);
        } else {
            stringBuilder.insert(n, '/');
            stringBuilder.insert(n + 1, string2);
        }
        return stringBuilder.toString();
    }

    public static String addPaths(String string, String string2) {
        if (string == null || string.length() == 0) {
            if (string != null && string2 == null) {
                return string;
            }
            return string2;
        }
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        boolean bl = string.endsWith(SLASH);
        boolean bl2 = string2.startsWith(SLASH);
        if (bl && bl2) {
            if (string2.length() == 1) {
                return string;
            }
            if (string.length() == 1) {
                return string2;
            }
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + string2.length() + 2);
        stringBuilder.append(string);
        if (string.endsWith(SLASH)) {
            if (string2.startsWith(SLASH)) {
                stringBuilder.setLength(stringBuilder.length() - 1);
            }
        } else if (!string2.startsWith(SLASH)) {
            stringBuilder.append(SLASH);
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    public static String addPathQuery(String string, String string2) {
        if (string2 == null) {
            return string;
        }
        if (string.indexOf(63) >= 0) {
            return string + '&' + string2;
        }
        return string + '?' + string2;
    }

    public static String getUriLastPathSegment(URI uRI) {
        String string = uRI.getSchemeSpecificPart();
        int n = string.indexOf("!/");
        if (n != -1) {
            string = string.substring(0, n);
        }
        if (string.endsWith(SLASH)) {
            string = string.substring(0, string.length() - 1);
        }
        if ((n = string.lastIndexOf(47)) != -1) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public static String parentPath(String string) {
        if (string == null || SLASH.equals(string)) {
            return null;
        }
        int n = string.lastIndexOf(47, string.length() - 2);
        if (n >= 0) {
            return string.substring(0, n + 1);
        }
        return null;
    }

    public static String canonicalURI(String string) {
        int n;
        if (string == null || string.isEmpty()) {
            return string;
        }
        boolean bl = true;
        int n2 = string.length();
        block10: for (n = 0; n < n2; ++n) {
            char c = string.charAt(n);
            switch (c) {
                case '/': {
                    bl = true;
                    continue block10;
                }
                case '.': {
                    if (bl) break block10;
                    bl = false;
                    continue block10;
                }
                case '#': 
                case '?': {
                    return string;
                }
                default: {
                    bl = false;
                }
            }
        }
        if (n == n2) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        stringBuilder.append(string, 0, n);
        int n3 = 1;
        ++n;
        block11: while (n < n2) {
            char c = string.charAt(n);
            switch (c) {
                case '/': {
                    if (URIUtil.doDotsSlash(stringBuilder, n3)) {
                        return null;
                    }
                    bl = true;
                    n3 = 0;
                    break;
                }
                case '#': 
                case '?': {
                    break block11;
                }
                case '.': {
                    if (n3 > 0) {
                        ++n3;
                    } else if (bl) {
                        n3 = 1;
                    } else {
                        stringBuilder.append('.');
                    }
                    bl = false;
                    break;
                }
                default: {
                    while (n3-- > 0) {
                        stringBuilder.append('.');
                    }
                    stringBuilder.append(c);
                    n3 = 0;
                    bl = false;
                }
            }
            ++n;
        }
        if (URIUtil.doDots(stringBuilder, n3)) {
            return null;
        }
        if (n < n2) {
            stringBuilder.append(string, n, n2);
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public static String canonicalEncodedPath(String string) {
        return URIUtil.canonicalURI(string);
    }

    public static String canonicalPath(String string) {
        int n;
        if (string == null || string.isEmpty()) {
            return string;
        }
        boolean bl = true;
        int n2 = string.length();
        block8: for (n = 0; n < n2; ++n) {
            char c = string.charAt(n);
            switch (c) {
                case '/': {
                    bl = true;
                    continue block8;
                }
                case '.': {
                    if (bl) break block8;
                    bl = false;
                    continue block8;
                }
                default: {
                    bl = false;
                }
            }
        }
        if (n == n2) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        stringBuilder.append(string, 0, n);
        int n3 = 1;
        ++n;
        while (n < n2) {
            char c = string.charAt(n);
            switch (c) {
                case '/': {
                    if (URIUtil.doDotsSlash(stringBuilder, n3)) {
                        return null;
                    }
                    bl = true;
                    n3 = 0;
                    break;
                }
                case '.': {
                    if (n3 > 0) {
                        ++n3;
                    } else if (bl) {
                        n3 = 1;
                    } else {
                        stringBuilder.append('.');
                    }
                    bl = false;
                    break;
                }
                default: {
                    while (n3-- > 0) {
                        stringBuilder.append('.');
                    }
                    stringBuilder.append(c);
                    n3 = 0;
                    bl = false;
                }
            }
            ++n;
        }
        if (URIUtil.doDots(stringBuilder, n3)) {
            return null;
        }
        return stringBuilder.toString();
    }

    private static boolean doDots(StringBuilder stringBuilder, int n) {
        switch (n) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                if (stringBuilder.length() < 2) {
                    return true;
                }
                stringBuilder.setLength(stringBuilder.length() - 1);
                stringBuilder.setLength(stringBuilder.lastIndexOf(SLASH) + 1);
                break;
            }
            default: {
                while (n-- > 0) {
                    stringBuilder.append('.');
                }
                break block0;
            }
        }
        return false;
    }

    private static boolean doDotsSlash(StringBuilder stringBuilder, int n) {
        switch (n) {
            case 0: {
                stringBuilder.append('/');
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (stringBuilder.length() < 2) {
                    return true;
                }
                stringBuilder.setLength(stringBuilder.length() - 1);
                stringBuilder.setLength(stringBuilder.lastIndexOf(SLASH) + 1);
                break;
            }
            default: {
                while (n-- > 0) {
                    stringBuilder.append('.');
                }
                stringBuilder.append('/');
            }
        }
        return false;
    }

    public static String compactPath(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return string;
        }
        int n2 = 0;
        int n3 = string.length();
        block8: for (n = 0; n < n3; ++n) {
            char c = string.charAt(n);
            switch (c) {
                case '?': {
                    return string;
                }
                case '/': {
                    if (++n2 != 2) continue block8;
                    break block8;
                }
                default: {
                    n2 = 0;
                }
            }
        }
        if (n2 < 2) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        stringBuilder.append(string, 0, n);
        block9: while (n < n3) {
            char c = string.charAt(n);
            switch (c) {
                case '?': {
                    stringBuilder.append(string, n, n3);
                    break block9;
                }
                case '/': {
                    if (n2++ != 0) break;
                    stringBuilder.append(c);
                    break;
                }
                default: {
                    n2 = 0;
                    stringBuilder.append(c);
                }
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    public static boolean hasScheme(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ':') {
                return true;
            }
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || i > 0 && (c >= '0' && c <= '9' || c == '.' || c == '+' || c == '-'))) break;
        }
        return false;
    }

    public static String newURI(String string, String string2, int n, String string3, String string4) {
        StringBuilder stringBuilder = URIUtil.newURIBuilder(string, string2, n);
        stringBuilder.append(string3);
        if (string4 != null && string4.length() > 0) {
            stringBuilder.append('?').append(string4);
        }
        return stringBuilder.toString();
    }

    public static StringBuilder newURIBuilder(String string, String string2, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        URIUtil.appendSchemeHostPort(stringBuilder, string, string2, n);
        return stringBuilder;
    }

    public static void appendSchemeHostPort(StringBuilder stringBuilder, String string, String string2, int n) {
        stringBuilder.append(string).append("://").append(HostPort.normalizeHost(string2));
        if (n > 0) {
            switch (string) {
                case "http": {
                    if (n == 80) break;
                    stringBuilder.append(':').append(n);
                    break;
                }
                case "https": {
                    if (n == 443) break;
                    stringBuilder.append(':').append(n);
                    break;
                }
                default: {
                    stringBuilder.append(':').append(n);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendSchemeHostPort(StringBuffer stringBuffer, String string, String string2, int n) {
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            stringBuffer.append(string).append("://").append(HostPort.normalizeHost(string2));
            if (n > 0) {
                switch (string) {
                    case "http": {
                        if (n == 80) break;
                        stringBuffer.append(':').append(n);
                        break;
                    }
                    case "https": {
                        if (n == 443) break;
                        stringBuffer.append(':').append(n);
                        break;
                    }
                    default: {
                        stringBuffer.append(':').append(n);
                    }
                }
            }
        }
    }

    public static boolean equalsIgnoreEncodings(String string, String string2) {
        int n = string.length();
        int n2 = string2.length();
        int n3 = 0;
        int n4 = 0;
        while (n3 < n && n4 < n2) {
            int n5;
            int n6;
            int n7;
            int n8;
            if ((n8 = (n7 = string.charAt(n3++))) == 37) {
                n8 = URIUtil.lenientPercentDecode(string, n3);
                if (n8 == -1) {
                    n8 = 37;
                } else {
                    n3 += 2;
                }
            }
            if ((n6 = (n5 = string2.charAt(n4++))) == 37) {
                n6 = URIUtil.lenientPercentDecode(string2, n4);
                if (n6 == -1) {
                    n6 = 37;
                } else {
                    n4 += 2;
                }
            }
            if (n8 == 47 && n7 != n5) {
                return false;
            }
            if (n8 == n6) continue;
            return false;
        }
        return n3 == n && n4 == n2;
    }

    private static int lenientPercentDecode(String string, int n) {
        if (n >= string.length()) {
            return -1;
        }
        if (StringUtil.isHex(string, n, 2)) {
            return TypeUtil.parseInt(string, n, 2, 16);
        }
        return -1;
    }

    public static boolean equalsIgnoreEncodings(URI uRI, URI uRI2) {
        if (uRI.equals(uRI2)) {
            return true;
        }
        if (uRI.getScheme() == null ? uRI2.getScheme() != null : !uRI.getScheme().equalsIgnoreCase(uRI2.getScheme())) {
            return false;
        }
        if ("jar".equalsIgnoreCase(uRI.getScheme())) {
            URI uRI3 = URI.create(uRI.getSchemeSpecificPart());
            URI uRI4 = URI.create(uRI2.getSchemeSpecificPart());
            return URIUtil.equalsIgnoreEncodings(uRI3, uRI4);
        }
        if (uRI.getAuthority() == null ? uRI2.getAuthority() != null : !uRI.getAuthority().equals(uRI2.getAuthority())) {
            return false;
        }
        return URIUtil.equalsIgnoreEncodings(uRI.getPath(), uRI2.getPath());
    }

    public static URI addPath(URI uRI, String string) {
        String string2 = uRI.toASCIIString();
        StringBuilder stringBuilder = new StringBuilder(string2.length() + string.length() * 3);
        stringBuilder.append(string2);
        if (stringBuilder.charAt(string2.length() - 1) != '/') {
            stringBuilder.append('/');
        }
        int n = string.charAt(0) == '/' ? 1 : 0;
        URIUtil.encodePath(stringBuilder, string, n);
        return URI.create(stringBuilder.toString());
    }

    public static String addQueries(String string, String string2) {
        if (StringUtil.isEmpty(string)) {
            return string2;
        }
        if (StringUtil.isEmpty(string2)) {
            return string;
        }
        return string + '&' + string2;
    }

    public static URI getJarSource(URI uRI) {
        try {
            if (!"jar".equals(uRI.getScheme())) {
                return uRI;
            }
            String string = uRI.getRawSchemeSpecificPart();
            int n = string.indexOf("!/");
            if (n >= 0) {
                string = string.substring(0, n);
            }
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
    }

    public static String getJarSource(String string) {
        if (!string.startsWith("jar:")) {
            return string;
        }
        int n = string.indexOf("!/");
        return n >= 0 ? string.substring(4, n) : string.substring(4);
    }
}

