/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Predicate;
import org.eclipse.jetty.util.IncludeExcludeSet;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class Scanner
extends AbstractLifeCycle {
    public static final int DEFAULT_SCAN_DEPTH = 1;
    public static final int MAX_SCAN_DEPTH = Integer.MAX_VALUE;
    private static final Logger LOG = Log.getLogger(Scanner.class);
    private static int __scannerId = 0;
    private int _scanInterval;
    private int _scanCount = 0;
    private final List<Listener> _listeners = new ArrayList<Listener>();
    private final Map<String, TimeNSize> _prevScan = new HashMap<String, TimeNSize>();
    private final Map<String, TimeNSize> _currentScan = new HashMap<String, TimeNSize>();
    private FilenameFilter _filter;
    private final Map<Path, IncludeExcludeSet<PathMatcher, Path>> _scannables = new HashMap<Path, IncludeExcludeSet<PathMatcher, Path>>();
    private volatile boolean _running = false;
    private boolean _reportExisting = true;
    private boolean _reportDirs = true;
    private Timer _timer;
    private TimerTask _task;
    private int _scanDepth = 1;
    private final Map<String, Notification> _notifications = new HashMap<String, Notification>();

    public synchronized int getScanInterval() {
        return this._scanInterval;
    }

    public synchronized void setScanInterval(int n) {
        this._scanInterval = n;
        this.schedule();
    }

    public void setScanDirs(List<File> list) {
        this._scannables.clear();
        if (list == null) {
            return;
        }
        for (File file : list) {
            this.addScanDir(file);
        }
    }

    @Deprecated
    public synchronized void addScanDir(File file) {
        if (file == null) {
            return;
        }
        try {
            if (file.isDirectory()) {
                this.addDirectory(file.toPath());
            } else {
                this.addFile(file.toPath());
            }
        }
        catch (Exception exception) {
            LOG.warn(exception);
        }
    }

    public synchronized void addFile(Path path) throws IOException {
        if (path == null) {
            throw new IllegalStateException("Null path");
        }
        File file = path.toFile();
        if (!file.exists() || file.isDirectory()) {
            throw new IllegalStateException("Not file or doesn't exist: " + file.getCanonicalPath());
        }
        this._scannables.put(path, null);
    }

    public synchronized IncludeExcludeSet<PathMatcher, Path> addDirectory(Path path) throws IOException {
        if (path == null) {
            throw new IllegalStateException("Null path");
        }
        File file = path.toFile();
        if (!file.exists() || !file.isDirectory()) {
            throw new IllegalStateException("Not directory or doesn't exist: " + file.getCanonicalPath());
        }
        IncludeExcludeSet<PathMatcher, Path> includeExcludeSet = this._scannables.get(path);
        if (includeExcludeSet == null) {
            includeExcludeSet = new IncludeExcludeSet(PathMatcherSet.class);
            this._scannables.put(path.toRealPath(new LinkOption[0]), includeExcludeSet);
        }
        return includeExcludeSet;
    }

    @Deprecated
    public List<File> getScanDirs() {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (Path path : this._scannables.keySet()) {
            arrayList.add(path.toFile());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Set<Path> getScannables() {
        return this._scannables.keySet();
    }

    @Deprecated
    public void setRecursive(boolean bl) {
        this._scanDepth = bl ? Integer.MAX_VALUE : 1;
    }

    @Deprecated
    public boolean getRecursive() {
        return this._scanDepth > 1;
    }

    public int getScanDepth() {
        return this._scanDepth;
    }

    public void setScanDepth(int n) {
        this._scanDepth = n;
    }

    @Deprecated
    public void setFilenameFilter(FilenameFilter filenameFilter) {
        this._filter = filenameFilter;
    }

    @Deprecated
    public FilenameFilter getFilenameFilter() {
        return this._filter;
    }

    public void setReportExistingFilesOnStartup(boolean bl) {
        this._reportExisting = bl;
    }

    public boolean getReportExistingFilesOnStartup() {
        return this._reportExisting;
    }

    public void setReportDirs(boolean bl) {
        this._reportDirs = bl;
    }

    public boolean getReportDirs() {
        return this._reportDirs;
    }

    public synchronized void addListener(Listener listener) {
        if (listener == null) {
            return;
        }
        this._listeners.add(listener);
    }

    public synchronized void removeListener(Listener listener) {
        if (listener == null) {
            return;
        }
        this._listeners.remove(listener);
    }

    @Override
    public synchronized void doStart() {
        if (this._running) {
            return;
        }
        this._running = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scanner start: rprtExists={}, depth={}, rprtDirs={}, interval={}, filter={}, scannables={}", this._reportExisting, this._scanDepth, this._reportDirs, this._scanInterval, this._filter, this._scannables);
        }
        if (this._reportExisting) {
            this.scan();
            this.scan();
        } else {
            this.scanFiles();
            this._prevScan.putAll(this._currentScan);
        }
        this.schedule();
    }

    public TimerTask newTimerTask() {
        return new TimerTask(){

            @Override
            public void run() {
                Scanner.this.scan();
            }
        };
    }

    public Timer newTimer() {
        return new Timer("Scanner-" + __scannerId++, true);
    }

    public void schedule() {
        if (this._running) {
            if (this._timer != null) {
                this._timer.cancel();
            }
            if (this._task != null) {
                this._task.cancel();
            }
            if (this.getScanInterval() > 0) {
                this._timer = this.newTimer();
                this._task = this.newTimerTask();
                this._timer.schedule(this._task, 1010L * (long)this.getScanInterval(), 1010L * (long)this.getScanInterval());
            }
        }
    }

    @Override
    public synchronized void doStop() {
        if (this._running) {
            this._running = false;
            if (this._timer != null) {
                this._timer.cancel();
            }
            if (this._task != null) {
                this._task.cancel();
            }
            this._task = null;
            this._timer = null;
        }
    }

    public void reset() {
        if (!this.isStopped()) {
            throw new IllegalStateException("Not stopped");
        }
        this._scannables.clear();
        this._currentScan.clear();
        this._prevScan.clear();
    }

    public boolean exists(String string) {
        for (Path path : this._scannables.keySet()) {
            if (!path.resolve(string).toFile().exists()) continue;
            return true;
        }
        return false;
    }

    public synchronized void scan() {
        this.reportScanStart(++this._scanCount);
        this.scanFiles();
        this.reportDifferences(this._currentScan, this._prevScan);
        this._prevScan.clear();
        this._prevScan.putAll(this._currentScan);
        this.reportScanEnd(this._scanCount);
        for (Listener listener : this._listeners) {
            try {
                if (!(listener instanceof ScanListener)) continue;
                ((ScanListener)listener).scan();
            }
            catch (Throwable throwable) {
                LOG.warn(throwable);
            }
        }
    }

    public synchronized void scanFiles() {
        this._currentScan.clear();
        for (Map.Entry<Path, IncludeExcludeSet<PathMatcher, Path>> entry : this._scannables.entrySet()) {
            Path path = entry.getKey();
            try {
                Files.walkFileTree(path, EnumSet.allOf(FileVisitOption.class), this._scanDepth, new Visitor(path, entry.getValue(), this._currentScan));
            }
            catch (IOException iOException) {
                LOG.warn("Error scanning files.", iOException);
            }
        }
    }

    private synchronized void reportDifferences(Map<String, TimeNSize> map, Map<String, TimeNSize> map2) {
        Object object;
        Object object2;
        HashSet<String> hashSet = new HashSet<String>(map2.keySet());
        for (Map.Entry<String, TimeNSize> object32 : map.entrySet()) {
            object2 = object32.getKey();
            if (!hashSet.contains(object2)) {
                object = this._notifications.put((String)object2, Notification.ADDED);
                if (object == null) continue;
                switch (object) {
                    case REMOVED: 
                    case CHANGED: {
                        this._notifications.put((String)object2, Notification.CHANGED);
                    }
                }
                continue;
            }
            if (map2.get(object2).equals(map.get(object2)) || (object = this._notifications.put((String)object2, Notification.CHANGED)) != Notification.ADDED) continue;
            this._notifications.put((String)object2, Notification.ADDED);
        }
        for (String string : map2.keySet()) {
            if (map.containsKey(string) || (object2 = this._notifications.put(string, Notification.REMOVED)) != Notification.ADDED) continue;
            this._notifications.remove(string);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("scanned " + this._scannables.keySet() + ": " + this._notifications, new Object[0]);
        }
        ArrayList arrayList = new ArrayList();
        Iterator<Map.Entry<String, Notification>> iterator = this._notifications.entrySet().iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            object = (String)object2.getKey();
            if (map2.containsKey(object) ? !map2.get(object).equals(map.get(object)) : map.containsKey(object)) continue;
            Notification notification = (Notification)((Object)object2.getValue());
            iterator.remove();
            arrayList.add(object);
            switch (notification) {
                case ADDED: {
                    this.reportAddition((String)object);
                    break;
                }
                case CHANGED: {
                    this.reportChange((String)object);
                    break;
                }
                case REMOVED: {
                    this.reportRemoval((String)object);
                }
            }
        }
        if (!arrayList.isEmpty()) {
            this.reportBulkChanges(arrayList);
        }
    }

    private void warn(Object object, String string, Throwable throwable) {
        LOG.warn(object + " failed on '" + string, throwable);
    }

    private void reportAddition(String string) {
        for (Listener listener : this._listeners) {
            try {
                if (!(listener instanceof DiscreteListener)) continue;
                ((DiscreteListener)listener).fileAdded(string);
            }
            catch (Throwable throwable) {
                this.warn(listener, string, throwable);
            }
        }
    }

    private void reportRemoval(String string) {
        for (Listener listener : this._listeners) {
            try {
                if (!(listener instanceof DiscreteListener)) continue;
                ((DiscreteListener)listener).fileRemoved(string);
            }
            catch (Throwable throwable) {
                this.warn(listener, string, throwable);
            }
        }
    }

    private void reportChange(String string) {
        for (Listener listener : this._listeners) {
            try {
                if (!(listener instanceof DiscreteListener)) continue;
                ((DiscreteListener)listener).fileChanged(string);
            }
            catch (Throwable throwable) {
                this.warn(listener, string, throwable);
            }
        }
    }

    private void reportBulkChanges(List<String> list) {
        for (Listener listener : this._listeners) {
            try {
                if (!(listener instanceof BulkListener)) continue;
                ((BulkListener)listener).filesChanged(list);
            }
            catch (Throwable throwable) {
                this.warn(listener, list.toString(), throwable);
            }
        }
    }

    private void reportScanStart(int n) {
        for (Listener listener : this._listeners) {
            try {
                if (!(listener instanceof ScanCycleListener)) continue;
                ((ScanCycleListener)listener).scanStarted(n);
            }
            catch (Exception exception) {
                LOG.warn(listener + " failed on scan start for cycle " + n, exception);
            }
        }
    }

    private void reportScanEnd(int n) {
        for (Listener listener : this._listeners) {
            try {
                if (!(listener instanceof ScanCycleListener)) continue;
                ((ScanCycleListener)listener).scanEnded(n);
            }
            catch (Exception exception) {
                LOG.warn(listener + " failed on scan end for cycle " + n, exception);
            }
        }
    }

    public static interface ScanCycleListener
    extends Listener {
        public void scanStarted(int var1) throws Exception;

        public void scanEnded(int var1) throws Exception;
    }

    public static interface BulkListener
    extends Listener {
        public void filesChanged(List<String> var1) throws Exception;
    }

    public static interface DiscreteListener
    extends Listener {
        public void fileChanged(String var1) throws Exception;

        public void fileAdded(String var1) throws Exception;

        public void fileRemoved(String var1) throws Exception;
    }

    public static interface ScanListener
    extends Listener {
        public void scan();
    }

    public static interface Listener {
    }

    class Visitor
    implements FileVisitor<Path> {
        Map<String, TimeNSize> scanInfoMap;
        IncludeExcludeSet<PathMatcher, Path> rootIncludesExcludes;
        Path root;

        public Visitor(Path path, IncludeExcludeSet<PathMatcher, Path> includeExcludeSet, Map<String, TimeNSize> map) {
            this.root = path;
            this.rootIncludesExcludes = includeExcludeSet;
            this.scanInfoMap = map;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
            if (!Files.exists(path, new LinkOption[0])) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            File file = path.toFile();
            if (Scanner.this._reportDirs && !this.scanInfoMap.containsKey(file.getCanonicalPath())) {
                boolean bl = false;
                if (this.rootIncludesExcludes != null && !this.rootIncludesExcludes.isEmpty()) {
                    boolean bl2 = this.rootIncludesExcludes.test(path);
                    if (bl2) {
                        bl = true;
                    }
                } else if (Scanner.this._filter == null || Scanner.this._filter.accept(file.getParentFile(), file.getName())) {
                    bl = true;
                }
                if (bl) {
                    this.scanInfoMap.put(file.getCanonicalPath(), new TimeNSize(file.lastModified(), file.isDirectory() ? 0L : file.length()));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("scan accepted dir {} mod={}", file, file.lastModified());
                    }
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
            if (!Files.exists(path, new LinkOption[0])) {
                return FileVisitResult.CONTINUE;
            }
            File file = path.toFile();
            boolean bl = false;
            if (file.isFile() || file.isDirectory() && Scanner.this._reportDirs && !this.scanInfoMap.containsKey(file.getCanonicalPath())) {
                if (this.rootIncludesExcludes != null && !this.rootIncludesExcludes.isEmpty()) {
                    boolean bl2 = this.rootIncludesExcludes.test(path);
                    if (bl2) {
                        bl = true;
                    }
                } else if (Scanner.this._filter == null || Scanner.this._filter.accept(file.getParentFile(), file.getName())) {
                    bl = true;
                }
            }
            if (bl) {
                this.scanInfoMap.put(file.getCanonicalPath(), new TimeNSize(file.lastModified(), file.isDirectory() ? 0L : file.length()));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("scan accepted {} mod={}", file, file.lastModified());
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path path, IOException iOException) throws IOException {
            LOG.warn(iOException);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
            return FileVisitResult.CONTINUE;
        }
    }

    static class TimeNSize {
        final long _lastModified;
        final long _size;

        public TimeNSize(long l, long l2) {
            this._lastModified = l;
            this._size = l2;
        }

        public int hashCode() {
            return (int)this._lastModified ^ (int)this._size;
        }

        public boolean equals(Object object) {
            if (object instanceof TimeNSize) {
                TimeNSize timeNSize = (TimeNSize)object;
                return timeNSize._lastModified == this._lastModified && timeNSize._size == this._size;
            }
            return false;
        }

        public String toString() {
            return "[lm=" + this._lastModified + ",s=" + this._size + "]";
        }
    }

    static class PathMatcherSet
    extends HashSet<PathMatcher>
    implements Predicate<Path> {
        PathMatcherSet() {
        }

        @Override
        public boolean test(Path path) {
            for (PathMatcher pathMatcher : this) {
                if (!pathMatcher.matches(path)) continue;
                return true;
            }
            return false;
        }
    }

    public static enum Notification {
        ADDED,
        CHANGED,
        REMOVED;

    }
}

