/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Loader {
    public static URL getResource(String string) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader == null ? ClassLoader.getSystemResource(string) : classLoader.getResource(string);
    }

    public static Class loadClass(String string) throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader == null ? Class.forName(string) : classLoader.loadClass(string);
    }

    public static Class loadClass(Class clazz, String string) throws ClassNotFoundException {
        if (clazz != null && clazz.getClassLoader() != null) {
            return clazz.getClassLoader().loadClass(string);
        }
        return Loader.loadClass(string);
    }

    public static ResourceBundle getResourceBundle(String string, boolean bl, Locale locale) throws MissingResourceException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader == null ? ResourceBundle.getBundle(string, locale) : ResourceBundle.getBundle(string, locale, classLoader);
    }
}

